/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access;

import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BValidationInfo;
import com.tridiumx.accessDriver.enums.BReaderTypeEnum;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BAccessZone;
import com.tridiumx.entsec.access.BMappedReaderExt;
import com.tridiumx.entsec.access.history.BBadgeSwipeRecord;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.util.dbCache.data.BAccessRightData;
import com.tridiumx.entsec.access.util.dbCache.data.BPersonData;
import com.tridiumx.entsec.orionTools.MappingSupport;
import java.util.HashMap;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="doorHandle", type="String", defaultValue="", flags=4), @NiagaraProperty(name="record", type="BBadgeSwipeRecord", defaultValue="new BBadgeSwipeRecord()", flags=4), @NiagaraProperty(name="personData", type="BPersonData", defaultValue="new BPersonData()", flags=4), @NiagaraProperty(name="accessRightData", type="BAccessRightData", defaultValue="new BAccessRightData()", flags=4), @NiagaraProperty(name="accessZoneRec", type="BAccessZoneRec", defaultValue="new BAccessZoneRec()", flags=4), @NiagaraProperty(name="readerUuid", type="BUuid", defaultValue="BUuid.DEFAULT", flags=4), @NiagaraProperty(name="readerParentTypeSpec", type="BTypeSpec", defaultValue="BTypeSpec.DEFAULT", flags=4), @NiagaraProperty(name="readerParentDisplayPath", type="String", defaultValue="", flags=4), @NiagaraProperty(name="badgeIsHex", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="requiresPinValidation", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="remoteIntegrationId", type="int", defaultValue="0", flags=4), @NiagaraProperty(name="validationTimeout", type="BRelTime", defaultValue="BRelTime.makeSeconds(10)"), @NiagaraProperty(name="badgeId", type="String", defaultValue="", flags=4)})
public class BAccessValidationInfo
extends BValidationInfo {
    public static final Property doorHandle = BAccessValidationInfo.newProperty((int)4, (String)"", null);
    public static final Property record = BAccessValidationInfo.newProperty((int)4, (BValue)new BBadgeSwipeRecord(), null);
    public static final Property personData = BAccessValidationInfo.newProperty((int)4, (BValue)new BPersonData(), null);
    public static final Property accessRightData = BAccessValidationInfo.newProperty((int)4, (BValue)new BAccessRightData(), null);
    public static final Property accessZoneRec = BAccessValidationInfo.newProperty((int)4, (BValue)new BAccessZoneRec(), null);
    public static final Property readerUuid = BAccessValidationInfo.newProperty((int)4, (BValue)BUuid.DEFAULT, null);
    public static final Property readerParentTypeSpec = BAccessValidationInfo.newProperty((int)4, (BValue)BTypeSpec.DEFAULT, null);
    public static final Property readerParentDisplayPath = BAccessValidationInfo.newProperty((int)4, (String)"", null);
    public static final Property badgeIsHex = BAccessValidationInfo.newProperty((int)4, (boolean)true, null);
    public static final Property requiresPinValidation = BAccessValidationInfo.newProperty((int)4, (boolean)false, null);
    public static final Property remoteIntegrationId = BAccessValidationInfo.newProperty((int)4, (int)0, null);
    public static final Property validationTimeout = BAccessValidationInfo.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), null);
    public static final Property badgeId = BAccessValidationInfo.newProperty((int)4, (String)"", null);
    public static final Type TYPE = Sys.loadType(BAccessValidationInfo.class);
    public static final String ENTRY_ZONE_RECS = "entryZoneRecs";
    public static final String EXIT_ZONE_RECS = "exitZoneRecs";
    public HashMap<BUuid, BAccessZone> entryZones;
    public HashMap<BUuid, BAccessZone> exitZones;
    public BAccReaderRec readerRec;
    public boolean hasExitAccessZone = false;
    public boolean validatedRemotely = false;
    public BAccessControlService service;
    public BAbsTime time;
    public Array<BUuid> elevatorAccessRightUuids;
    public boolean activationBadge = false;

    public String getDoorHandle() {
        return this.getString(doorHandle);
    }

    public void setDoorHandle(String v) {
        this.setString(doorHandle, v, null);
    }

    public BBadgeSwipeRecord getRecord() {
        return (BBadgeSwipeRecord)this.get(record);
    }

    public void setRecord(BBadgeSwipeRecord v) {
        this.set(record, (BValue)v, null);
    }

    public BPersonData getPersonData() {
        return (BPersonData)this.get(personData);
    }

    public void setPersonData(BPersonData v) {
        this.set(personData, (BValue)v, null);
    }

    public BAccessRightData getAccessRightData() {
        return (BAccessRightData)this.get(accessRightData);
    }

    public void setAccessRightData(BAccessRightData v) {
        this.set(accessRightData, (BValue)v, null);
    }

    public BAccessZoneRec getAccessZoneRec() {
        return (BAccessZoneRec)this.get(accessZoneRec);
    }

    public void setAccessZoneRec(BAccessZoneRec v) {
        this.set(accessZoneRec, (BValue)v, null);
    }

    public BUuid getReaderUuid() {
        return (BUuid)this.get(readerUuid);
    }

    public void setReaderUuid(BUuid v) {
        this.set(readerUuid, (BValue)v, null);
    }

    public BTypeSpec getReaderParentTypeSpec() {
        return (BTypeSpec)this.get(readerParentTypeSpec);
    }

    public void setReaderParentTypeSpec(BTypeSpec v) {
        this.set(readerParentTypeSpec, (BValue)v, null);
    }

    public String getReaderParentDisplayPath() {
        return this.getString(readerParentDisplayPath);
    }

    public void setReaderParentDisplayPath(String v) {
        this.setString(readerParentDisplayPath, v, null);
    }

    public boolean getBadgeIsHex() {
        return this.getBoolean(badgeIsHex);
    }

    public void setBadgeIsHex(boolean v) {
        this.setBoolean(badgeIsHex, v, null);
    }

    public boolean getRequiresPinValidation() {
        return this.getBoolean(requiresPinValidation);
    }

    public void setRequiresPinValidation(boolean v) {
        this.setBoolean(requiresPinValidation, v, null);
    }

    public int getRemoteIntegrationId() {
        return this.getInt(remoteIntegrationId);
    }

    public void setRemoteIntegrationId(int v) {
        this.setInt(remoteIntegrationId, v, null);
    }

    public BRelTime getValidationTimeout() {
        return (BRelTime)this.get(validationTimeout);
    }

    public void setValidationTimeout(BRelTime v) {
        this.set(validationTimeout, (BValue)v, null);
    }

    public String getBadgeId() {
        return this.getString(badgeId);
    }

    public void setBadgeId(String v) {
        this.setString(badgeId, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAccessValidationInfo(BValidationInfo info, BAccessControlService service) {
        this.setStartTicks(info.getStartTicks());
        BAccessNetwork accessNetwork = (BAccessNetwork)Sys.getService((Type)BAccessNetwork.TYPE);
        this.setValidationTimeout(accessNetwork.getValidationTimeout());
        this.time = BAbsTime.now();
        this.service = service;
        this.setAccessReader(info.getAccessReader());
        this.setReaderType(info.getReaderType());
        BComponent readerParent = (BComponent)this.getAccessReader().getParent();
        this.setReaderParentTypeSpec(readerParent.getType().getTypeSpec());
        this.setReaderParentDisplayPath(MappingSupport.getDisplayPath((BObject)readerParent));
        this.setReaderUuid(((BMappedReaderExt)this.getAccessReader().getMixIn(BMappedReaderExt.TYPE)).getUuid());
        this.getRecord().setTimestamp(this.time);
        this.getRecord().setReader((BComponent)this.getAccessReader());
        if (this.getReaderType() == BReaderTypeEnum.readerOrKeypad && info.getPin().length() > 0) {
            this.setCredential(info.getPin());
            this.getRecord().setBadge(info.getPin());
            this.setBadgeIsHex(false);
        } else {
            this.setCredential(info.getCredential());
            this.getRecord().setBadge(info.getCredential());
        }
        this.setPin(info.getPin());
        if (this.getReaderType() == BReaderTypeEnum.readerPlusKeypad) {
            this.setRequiresPinValidation(true);
        }
        this.setReaderHandle(this.getAccessReader().getHandle().toString());
        this.setDoorHandle(Sys.getStation().getStationName() + readerParent.getHandle().toString());
    }

    public BAccessValidationInfo() {
    }

    public String toString(Context cx) {
        StringBuffer b = new StringBuffer();
        b.append("" + this.getRecord().getActivity());
        b.append(" | " + this.getRecord().getOwner());
        b.append(" | " + this.time);
        return b.toString();
    }

    public boolean hasEntryAccessZoneRecs() {
        return this.getProperty(ENTRY_ZONE_RECS) != null;
    }

    public boolean hasExitAccessZoneRecs() {
        return this.getProperty(EXIT_ZONE_RECS) != null;
    }

    public BAccessZoneRec[] getEntryZoneRecs() {
        if (!this.hasEntryAccessZoneRecs()) {
            return new BAccessZoneRec[0];
        }
        BVector vector = (BVector)this.get(ENTRY_ZONE_RECS);
        return (BAccessZoneRec[])vector.getChildren(BAccessZoneRec.class);
    }

    public BAccessZoneRec[] getExitZoneRecs() {
        if (!this.hasExitAccessZoneRecs()) {
            return new BAccessZoneRec[0];
        }
        BVector vector = (BVector)this.get(EXIT_ZONE_RECS);
        return (BAccessZoneRec[])vector.getChildren(BAccessZoneRec.class);
    }

    public void addEntryZoneRecs(BAccessZoneRec[] recs) {
        if (recs.length == 0) {
            return;
        }
        BVector vector = new BVector();
        for (int i = 0; i < recs.length; ++i) {
            vector.add(null, (BValue)recs[i]);
        }
        this.add(ENTRY_ZONE_RECS, (BValue)vector);
    }

    public void addExitZoneRecs(BAccessZoneRec[] recs) {
        if (recs.length == 0) {
            return;
        }
        BVector vector = new BVector();
        for (int i = 0; i < recs.length; ++i) {
            vector.add(null, (BValue)recs[i]);
        }
        this.add(EXIT_ZONE_RECS, (BValue)vector);
    }

    public void addEntryZone(BAccessZone zone, BAccessZoneRec rec) {
        if (this.entryZones == null) {
            this.entryZones = new HashMap();
        }
        this.entryZones.put(rec.getUuid(), zone);
    }

    public void addExitZone(BAccessZone zone, BAccessZoneRec rec) {
        if (this.exitZones == null) {
            this.exitZones = new HashMap();
        }
        this.exitZones.put(rec.getUuid(), zone);
    }
}

