/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access;

import com.tridiumx.entsec.access.BackgroundWorker;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BWorker;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperty(name="maxQueueSize", type="int", defaultValue="1000", facets={@Facet(value="BFacets.makeInt(null, 1, Integer.MAX_VALUE)")})
public class BAccessControlWorker
extends BWorker {
    public static final Property maxQueueSize = BAccessControlWorker.newProperty((int)0, (int)1000, (BFacets)BFacets.makeInt(null, (int)1, (int)Integer.MAX_VALUE));
    public static final Type TYPE = Sys.loadType(BAccessControlWorker.class);
    Queue queue;
    Worker worker;

    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    public void setMaxQueueSize(int v) {
        this.setInt(maxQueueSize, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public IFuture postAsync(Runnable r) {
        if (!this.isRunning() || this.queue == null) {
            throw new NotRunningException();
        }
        this.queue.enqueue((Object)r);
        return null;
    }

    public Worker getWorker() {
        if (this.worker == null) {
            this.queue = new Queue(this.getMaxQueueSize());
            this.worker = new BackgroundWorker((Worker.ITodo)this.queue);
        }
        return this.worker;
    }

    protected String getWorkerThreadName() {
        return "AccessControlWorker:" + this.getParent().getName();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && property.equals(maxQueueSize) && this.queue != null) {
            this.stopWorker();
            this.queue = null;
            this.worker = null;
            this.getWorker();
            this.startWorker();
        }
    }
}

