/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec;

import com.tridium.alarm.BStationRecipient;
import com.tridium.bql.cursor.BogCursor;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.history.audit.BAuditRecord;
import com.tridium.history.log.BLogRecord;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.user.BNiagaraUserDeviceExt;
import com.tridium.orion.BAbstractOrionApp;
import com.tridium.orion.BIMappable;
import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionType;
import com.tridium.orion.BRef;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionAppSchemaManager;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.priv.model.DynamicOrionProperty;
import com.tridium.orion.priv.model.DynamicOrionType;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.platPower.BNpmDualBatteryPlatformService;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.aes.BRdbSecuritySettings;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.sys.Nre;
import com.tridium.util.ObjectUtil;
import com.tridiumx.accessDriver.BAccessWorker;
import com.tridiumx.accessDriver.BOffAlarmClass;
import com.tridiumx.entsec.BEndUserLicenseAgreement;
import com.tridiumx.entsec.BEntsecUserPermissionsInfo;
import com.tridiumx.entsec.BThirdPartyLicenses;
import com.tridiumx.entsec.BrandingManager;
import com.tridiumx.entsec.LicenseChecker;
import com.tridiumx.entsec.LicenseCounter;
import com.tridiumx.entsec.UserPermissionsCodec;
import com.tridiumx.entsec.access.history.BLDAPAuditRecord;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.util.dbCache.PersonCache;
import com.tridiumx.entsec.access.util.dbCache.data.PersonCacheData;
import com.tridiumx.entsec.app.EntsecAppUtil;
import com.tridiumx.entsec.backup.BRemoteBackupChannel;
import com.tridiumx.entsec.backup.BSystemBackups;
import com.tridiumx.entsec.intrusion.orion.BIntrusionPin;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneGroup;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneRec;
import com.tridiumx.entsec.ldap.BLdapJoinDeviceExt;
import com.tridiumx.entsec.ldap.BLdapMappedAttribute;
import com.tridiumx.entsec.ldap.importconfig.BLdapImportConfig;
import com.tridiumx.entsec.nav.BEntsecNavFile;
import com.tridiumx.entsec.nav.EntsecNavManager;
import com.tridiumx.entsec.nav.EntsecNavTree;
import com.tridiumx.entsec.orionTools.BAppTable;
import com.tridiumx.entsec.orionTools.BEnumScheduleRec;
import com.tridiumx.entsec.orionTools.BIMappingService;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.BIPresettableUuid;
import com.tridiumx.entsec.orionTools.BMappedEnumScheduleExt;
import com.tridiumx.entsec.orionTools.BMappedExt;
import com.tridiumx.entsec.orionTools.BMappedScheduleExt;
import com.tridiumx.entsec.orionTools.BRefList;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.entsec.orionTools.BScheduleRecs;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.BTenants;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.MergeSupport;
import com.tridiumx.entsec.orionTools.OrionSessionCleaner;
import com.tridiumx.entsec.orionTools.OrionTypeRegistrator;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.orionTools.history.BAuditOrionRec;
import com.tridiumx.entsec.orionTools.history.BLogOrionRec;
import com.tridiumx.entsec.orionTools.history.BOrionNiagaraHistoryTypeExport;
import com.tridiumx.entsec.orionTools.replicate.BDeletion;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.roles.BEntsecRoleQuery;
import com.tridiumx.entsec.schema.Upgrade_1_0_to_1_1;
import com.tridiumx.entsec.schema.Upgrade_1_1_to_1_2;
import com.tridiumx.entsec.securityUtil.BActivityMonitor;
import com.tridiumx.entsec.securityUtil.BChangePasskey;
import com.tridiumx.entsec.securityUtil.BIAsyncStationStarted;
import com.tridiumx.entsec.securityUtil.BImageFileTable;
import com.tridiumx.entsec.securityUtil.BPlatformSetup;
import com.tridiumx.entsec.securityUtil.alarm.BAlarmClassEvent;
import com.tridiumx.entsec.securityUtil.alarm.BAlarmClassSyncChannel;
import com.tridiumx.entsec.securityUtil.alarm.BNiagaraAlarmClassDeviceExt;
import com.tridiumx.entsec.securityUtil.alarm.BSecurityAlarmConsoleOptions;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDef;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDefEvent;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDefSecurity;
import com.tridiumx.entsec.securityUtil.orion.BSecurityHistoryConsolidator;
import com.tridiumx.entsec.securityUtil.query.BAlarmClassRelayLinks;
import com.tridiumx.entsec.securityUtil.query.BAlarmClasses;
import com.tridiumx.entsec.securityUtil.query.BAlarmConsoles;
import com.tridiumx.entsec.securityUtil.query.BAlarmExtInstructions;
import com.tridiumx.entsec.securityUtil.query.BAlarmHistory;
import com.tridiumx.entsec.securityUtil.query.BAlarmSourceExts;
import com.tridiumx.entsec.securityUtil.query.BBacnetPoints;
import com.tridiumx.entsec.securityUtil.query.BCalendarSchedules;
import com.tridiumx.entsec.securityUtil.query.BEmailRecipients;
import com.tridiumx.entsec.securityUtil.query.BEntsecNavGroupQuery;
import com.tridiumx.entsec.securityUtil.query.BNiagaraStationQuery;
import com.tridiumx.entsec.securityUtil.query.BPdfStyles;
import com.tridiumx.entsec.securityUtil.query.BPxGraphics;
import com.tridiumx.entsec.securityUtil.query.BStationRecipients;
import com.tridiumx.entsec.securityUtil.query.consolidated.BConsolidatedDataChannel;
import com.tridiumx.entsec.securityUtil.video.BVideoSubsystem;
import com.tridiumx.entsec.threat.BMappedThreatLevelGroupExt;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import com.tridiumx.entsec.threat.BThreatLevelGroupRecs;
import com.tridiumx.entsec.threat.BThreatLevelSetup;
import com.tridiumx.entsec.threat.BThreatLevelStationJoin;
import com.tridiumx.entsec.user.BEntsecUserConfig;
import com.tridiumx.entsec.user.BUserQuery;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmClassFolder;
import javax.baja.backup.BBackupService;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.BDevice;
import javax.baja.driver.util.BDescriptor;
import javax.baja.email.BEmailService;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.history.BHistoryId;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.UnresolvedException;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.SysDefSession;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Predicates;
import javax.baja.security.BIProtected;
import javax.baja.security.BPassword;
import javax.baja.security.BPermissionsMap;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserPrototypes;
import javax.baja.user.BUserService;
import javax.baja.user.PermissionsManager;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="monitorSysDefSecurity", type="BMonitorSysDefSecurity", defaultValue="new BMonitorSysDefSecurity()"), @NiagaraProperty(name="monitorSysDef", type="BMonitorSysDef", defaultValue="new BMonitorSysDef()", flags=4), @NiagaraProperty(name="activityMonitor", type="BActivityMonitor", defaultValue="new BActivityMonitor()", flags=8), @NiagaraProperty(name="alarmClasses", type="BAlarmClasses", defaultValue="new BAlarmClasses()", flags=8), @NiagaraProperty(name="alarmConsoles", type="BAlarmConsoles", defaultValue="new BAlarmConsoles()", flags=8), @NiagaraProperty(name="emailRecipients", type="BEmailRecipients", defaultValue="new BEmailRecipients()", flags=8), @NiagaraProperty(name="stationRecipients", type="BStationRecipients", defaultValue="new BStationRecipients()", flags=8), @NiagaraProperty(name="alarmHistory", type="BAlarmHistory", defaultValue="new BAlarmHistory()", flags=8), @NiagaraProperty(name="alarmSourceExts", type="BAlarmSourceExts", defaultValue="new BAlarmSourceExts()", flags=8), @NiagaraProperty(name="alarmInstructions", type="BAlarmExtInstructions", defaultValue="new BAlarmExtInstructions()", flags=8), @NiagaraProperty(name="alarmRelays", type="BAlarmClassRelayLinks", defaultValue="new BAlarmClassRelayLinks()", flags=8), @NiagaraProperty(name="pdfStyles", type="BPdfStyles", defaultValue="new BPdfStyles()", flags=8), @NiagaraProperty(name="bacnetPoints", type="BBacnetPoints", defaultValue="new BBacnetPoints()", flags=8), @NiagaraProperty(name="stationsQuery", type="BNiagaraStationQuery", defaultValue="new BNiagaraStationQuery()", flags=1), @NiagaraProperty(name="auditHistory", type="BSecurityHistoryConsolidator", defaultValue="new BSecurityHistoryConsolidator(BHistoryId.make(\"^\", \"AuditHistory\"), BAuditRecord.TYPE.getTypeSpec(), true)", flags=8), @NiagaraProperty(name="logHistory", type="BSecurityHistoryConsolidator", defaultValue="new BSecurityHistoryConsolidator(BHistoryId.make(\"^\", \"LogHistory\"), BLogRecord.TYPE.getTypeSpec(), true, true)", flags=8), @NiagaraProperty(name="ldapAuditHistory", type="BSecurityHistoryConsolidator", defaultValue="new BSecurityHistoryConsolidator(BHistoryId.make(\"^\", \"LDAPAuditRecord\"), BLDAPAuditRecord.TYPE.getTypeSpec(), true, true)", flags=8), @NiagaraProperty(name="schedules", type="BScheduleRecs", defaultValue="new BScheduleRecs()", flags=8), @NiagaraProperty(name="calendarSchedules", type="BCalendarSchedules", defaultValue="new BCalendarSchedules()", flags=8), @NiagaraProperty(name="tenants", type="BTenants", defaultValue="new BTenants()", flags=8), @NiagaraProperty(name="threatLevelGroups", type="BThreatLevelGroupRecs", defaultValue="new BThreatLevelGroupRecs()", flags=8), @NiagaraProperty(name="threatLevelSetup", type="BThreatLevelSetup", defaultValue="new BThreatLevelSetup()", flags=8), @NiagaraProperty(name="images", type="BImageFileTable", defaultValue="new BImageFileTable()", flags=8), @NiagaraProperty(name="graphics", type="BPxGraphics", defaultValue="new BPxGraphics()", flags=8), @NiagaraProperty(name="navigationGroups", type="BEntsecNavGroupQuery", defaultValue="new BEntsecNavGroupQuery()", flags=8), @NiagaraProperty(name="changePasskey", type="BChangePasskey", defaultValue="new BChangePasskey()", flags=8), @NiagaraProperty(name="users", type="BUserQuery", defaultValue="new BUserQuery()", flags=8), @NiagaraProperty(name="roles", type="BEntsecRoleQuery", defaultValue="new BEntsecRoleQuery()", flags=8), @NiagaraProperty(name="systemBackups", type="BSystemBackups", defaultValue="new BSystemBackups()", flags=8), @NiagaraProperty(name="platformSetup", type="BPlatformSetup", defaultValue="new BPlatformSetup()", flags=8), @NiagaraProperty(name="videoSubsystem", type="BVideoSubsystem", defaultValue="new BVideoSubsystem()", flags=8), @NiagaraProperty(name="endUserLicenseAgreement", type="BEndUserLicenseAgreement", defaultValue="new BEndUserLicenseAgreement()"), @NiagaraProperty(name="thirdPartyLicenses", type="BThirdPartyLicenses", defaultValue="new BThirdPartyLicenses()"), @NiagaraProperty(name="initRequired", type="boolean", defaultValue="true"), @NiagaraProperty(name="requireDefaultUserPermissions", type="boolean", defaultValue="true"), @NiagaraProperty(name="showNavBar", type="boolean", defaultValue="true"), @NiagaraProperty(name="showGuidedTour", type="boolean", defaultValue="false"), @NiagaraProperty(name="popUpGuidedTour", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="queryOutdatedStations", type="boolean", defaultValue="true", flags=4, facets={@Facet(name="BFacets.TRUE_TEXT", value="\"%lexicon(entsec:queryOutdatedStations.true)%\""), @Facet(name="BFacets.FALSE_TEXT", value="\"%lexicon(entsec:queryOutdatedStations.false)%\"")}), @NiagaraProperty(name="unlicensedVisibility", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="modifiedPassKey", type="BPassword", defaultValue="BPassword.DEFAULT", flags=5), @NiagaraProperty(name="accessWorker", type="BAccessWorker", defaultValue="new BAccessWorker()", flags=5), @NiagaraProperty(name="moduleDependenciesFacets", type="BFacets", defaultValue="BFacets.DEFAULT", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="rebuildDefaultNav", flags=16), @NiagaraAction(name="saveDefaultNav", flags=16), @NiagaraAction(name="regenerateMappedUuids", flags=148), @NiagaraAction(name="regenerateAllUuids", flags=148), @NiagaraAction(name="cleanupOrphanedMappables", flags=148), @NiagaraAction(name="cleanupOrphanedMappablesSpecific", parameterType="BString", defaultValue="BString.DEFAULT", flags=148), @NiagaraAction(name="resetUiTableColumns", flags=144), @NiagaraAction(name="handleSysDefEvent", parameterType="BMonitorSysDefEvent", defaultValue="new BMonitorSysDefEvent()", flags=5), @NiagaraAction(name="clearUserPermissions", parameterType="BEntsecUserPermissionsInfo", defaultValue="BEntsecUserPermissionsInfo.makeClear()", flags=16), @NiagaraAction(name="saveUserPermissions", parameterType="BEntsecUserPermissionsInfo", defaultValue="BEntsecUserPermissionsInfo.makeSave()", flags=16), @NiagaraAction(name="loadUserPermissions", parameterType="BEntsecUserPermissionsInfo", defaultValue="BEntsecUserPermissionsInfo.makeLoad()", flags=16), @NiagaraAction(name="restoreDefaultUserPermissions", parameterType="BEntsecUserPermissionsInfo", defaultValue="new BEntsecUserPermissionsInfo()", flags=16), @NiagaraAction(name="cleanupOrphanedUserTenants", parameterType="BRef", defaultValue="BRef.make(BTenant.TYPE.getTypeSpec())", flags=20, facets={@Facet(name="BFacets.ALLOW_NULL", value="true")}), @NiagaraAction(name="removeMapping", flags=20), @NiagaraAction(name="remoteOrionRead", parameterType="BOrionObject", defaultValue="new BTenant()", returnType="BOrionObject", flags=4), @NiagaraAction(name="asyncStationStartedAction", parameterType="BValue", defaultValue="new BComponent()", flags=20), @NiagaraAction(name="changeOfPasskey", parameterType="BPassword", defaultValue="BPassword.DEFAULT", flags=4)})
@NiagaraTopic(name="alarmClassEvent", eventType="BAlarmClassEvent")
public class BEnterpriseSecurityService
extends BAbstractOrionApp
implements BIMappingService,
PermissionsManager,
BIAsyncStationStarted {
    public static final Property monitorSysDefSecurity = BEnterpriseSecurityService.newProperty((int)0, (BValue)new BMonitorSysDefSecurity(), null);
    public static final Property monitorSysDef = BEnterpriseSecurityService.newProperty((int)4, (BValue)new BMonitorSysDef(), null);
    public static final Property activityMonitor = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BActivityMonitor(), null);
    public static final Property alarmClasses = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BAlarmClasses(), null);
    public static final Property alarmConsoles = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BAlarmConsoles(), null);
    public static final Property emailRecipients = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BEmailRecipients(), null);
    public static final Property stationRecipients = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BStationRecipients(), null);
    public static final Property alarmHistory = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BAlarmHistory(), null);
    public static final Property alarmSourceExts = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BAlarmSourceExts(), null);
    public static final Property alarmInstructions = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BAlarmExtInstructions(), null);
    public static final Property alarmRelays = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BAlarmClassRelayLinks(), null);
    public static final Property pdfStyles = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BPdfStyles(), null);
    public static final Property bacnetPoints = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BBacnetPoints(), null);
    public static final Property stationsQuery = BEnterpriseSecurityService.newProperty((int)1, (BValue)new BNiagaraStationQuery(), null);
    public static final Property auditHistory = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BSecurityHistoryConsolidator(BHistoryId.make((String)"^", (String)"AuditHistory"), BAuditRecord.TYPE.getTypeSpec(), true), null);
    public static final Property logHistory = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BSecurityHistoryConsolidator(BHistoryId.make((String)"^", (String)"LogHistory"), BLogRecord.TYPE.getTypeSpec(), true, true), null);
    public static final Property ldapAuditHistory = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BSecurityHistoryConsolidator(BHistoryId.make((String)"^", (String)"LDAPAuditRecord"), BLDAPAuditRecord.TYPE.getTypeSpec(), true, true), null);
    public static final Property schedules = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BScheduleRecs(), null);
    public static final Property calendarSchedules = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BCalendarSchedules(), null);
    public static final Property tenants = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BTenants(), null);
    public static final Property threatLevelGroups = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BThreatLevelGroupRecs(), null);
    public static final Property threatLevelSetup = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BThreatLevelSetup(), null);
    public static final Property images = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BImageFileTable(), null);
    public static final Property graphics = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BPxGraphics(), null);
    public static final Property navigationGroups = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BEntsecNavGroupQuery(), null);
    public static final Property changePasskey = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BChangePasskey(), null);
    public static final Property users = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BUserQuery(), null);
    public static final Property roles = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BEntsecRoleQuery(), null);
    public static final Property systemBackups = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BSystemBackups(), null);
    public static final Property platformSetup = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BPlatformSetup(), null);
    public static final Property videoSubsystem = BEnterpriseSecurityService.newProperty((int)8, (BValue)new BVideoSubsystem(), null);
    public static final Property endUserLicenseAgreement = BEnterpriseSecurityService.newProperty((int)0, (BValue)new BEndUserLicenseAgreement(), null);
    public static final Property thirdPartyLicenses = BEnterpriseSecurityService.newProperty((int)0, (BValue)new BThirdPartyLicenses(), null);
    public static final Property initRequired = BEnterpriseSecurityService.newProperty((int)0, (boolean)true, null);
    public static final Property requireDefaultUserPermissions = BEnterpriseSecurityService.newProperty((int)0, (boolean)true, null);
    public static final Property showNavBar = BEnterpriseSecurityService.newProperty((int)0, (boolean)true, null);
    public static final Property showGuidedTour = BEnterpriseSecurityService.newProperty((int)0, (boolean)false, null);
    public static final Property popUpGuidedTour = BEnterpriseSecurityService.newProperty((int)4, (boolean)false, null);
    public static final Property queryOutdatedStations = BEnterpriseSecurityService.newProperty((int)4, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"%lexicon(entsec:queryOutdatedStations.true)%"), (BFacets)BFacets.make((String)"falseText", (String)"%lexicon(entsec:queryOutdatedStations.false)%")));
    public static final Property unlicensedVisibility = BEnterpriseSecurityService.newProperty((int)4, (boolean)false, null);
    public static final Property modifiedPassKey = BEnterpriseSecurityService.newProperty((int)5, (BValue)BPassword.DEFAULT, null);
    public static final Property accessWorker = BEnterpriseSecurityService.newProperty((int)5, (BValue)new BAccessWorker(), null);
    public static final Property moduleDependenciesFacets = BEnterpriseSecurityService.newProperty((int)5, (BValue)BFacets.DEFAULT, null);
    public static final Action rebuildDefaultNav = BEnterpriseSecurityService.newAction((int)16, null);
    public static final Action saveDefaultNav = BEnterpriseSecurityService.newAction((int)16, null);
    public static final Action regenerateMappedUuids = BEnterpriseSecurityService.newAction((int)148, null);
    public static final Action regenerateAllUuids = BEnterpriseSecurityService.newAction((int)148, null);
    public static final Action cleanupOrphanedMappables = BEnterpriseSecurityService.newAction((int)148, null);
    public static final Action cleanupOrphanedMappablesSpecific = BEnterpriseSecurityService.newAction((int)148, (BValue)BString.DEFAULT, null);
    public static final Action resetUiTableColumns = BEnterpriseSecurityService.newAction((int)144, null);
    public static final Action handleSysDefEvent = BEnterpriseSecurityService.newAction((int)5, (BValue)new BMonitorSysDefEvent(), null);
    public static final Action clearUserPermissions = BEnterpriseSecurityService.newAction((int)16, (BValue)BEntsecUserPermissionsInfo.makeClear(), null);
    public static final Action saveUserPermissions = BEnterpriseSecurityService.newAction((int)16, (BValue)BEntsecUserPermissionsInfo.makeSave(), null);
    public static final Action loadUserPermissions = BEnterpriseSecurityService.newAction((int)16, (BValue)BEntsecUserPermissionsInfo.makeLoad(), null);
    public static final Action restoreDefaultUserPermissions = BEnterpriseSecurityService.newAction((int)16, (BValue)new BEntsecUserPermissionsInfo(), null);
    public static final Action cleanupOrphanedUserTenants = BEnterpriseSecurityService.newAction((int)20, (BValue)BRef.make((BTypeSpec)BTenant.TYPE.getTypeSpec()), (BFacets)BFacets.make((String)"allowNull", (boolean)true));
    public static final Action removeMapping = BEnterpriseSecurityService.newAction((int)20, null);
    public static final Action remoteOrionRead = BEnterpriseSecurityService.newAction((int)4, (BValue)new BTenant(), null);
    public static final Action asyncStationStartedAction = BEnterpriseSecurityService.newAction((int)20, (BValue)new BComponent(), null);
    public static final Action changeOfPasskey = BEnterpriseSecurityService.newAction((int)4, (BValue)BPassword.DEFAULT, null);
    public static final Topic alarmClassEvent = BEnterpriseSecurityService.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BEnterpriseSecurityService.class);
    private static Type[] serviceTypes = new Type[]{TYPE, BIMappingService.TYPE};
    public OrionType[] registeredOrionTypes;
    public static final OrionType[] orionTypes = new OrionType[]{BDeletion.ORION_TYPE, BAuditOrionRec.ORION_TYPE, BLogOrionRec.ORION_TYPE, BScheduleRec.ORION_TYPE, BEnumScheduleRec.ORION_TYPE, BTenant.ORION_TYPE, BThreatLevelGroupRec.ORION_TYPE, BThreatLevelStationJoin.ORION_TYPE};
    static BTypeSpec[] historyTypesToExport = new BTypeSpec[]{BAuditRecord.TYPE.getTypeSpec(), BLogRecord.TYPE.getTypeSpec()};
    private static final BIcon icon = BIcon.std((String)"lock.png");
    private AlarmClassFolderSubscriber subscriber = new AlarmClassFolderSubscriber(this);
    public static final BSchemaVersion VERSION_1_2;
    public static final BSchemaVersion VERSION_1_1;
    public static final BSchemaVersion VERSION_1_0;
    public static final BSchemaVersion CURRENT_VERSION;
    protected OrionAppSchemaManager schemaManager = new OrionAppSchemaManager((BIOrionApp)this, new ISchemaUpgrader[]{new Upgrade_1_0_to_1_1(), new Upgrade_1_1_to_1_2()});
    private static final BSchemaVersion VERSION;
    public static final Logger LOG;
    public static final Lexicon lex;
    public static final BOrd TEMP_DIR;
    private boolean orionReady = false;
    private MappingSupport mappingSupport = new MappingSupport(this);
    private EntsecNavManager nav = new EntsecNavManager();
    private BrandingManager brandingManager;
    public BOrdList newlyInstalledApps = BOrdList.DEFAULT;
    public static final String VENDOR = "tridium";
    public static final String EMAIL_FEATURE = "email";
    public static final String ENTSEC_FEATURE = "entSecurity";
    public static final String THREAT_ATTRIBUTE = "threatGroup.limit";
    public static final String VIDEO_FEATURE = "videoDriver";
    public static final String REMOTE_BACKUP_CHANNEL = "remoteBackup";
    private boolean isInvalidPinsJobCancelled = false;
    private boolean isReEncryptJobCancelled = false;
    private Map<String, ArrayList<BValue>> invalidPinMap = null;
    private List<String> modules = Arrays.asList("ensecHx", "videoHx");

    public BMonitorSysDefSecurity getMonitorSysDefSecurity() {
        return (BMonitorSysDefSecurity)this.get(monitorSysDefSecurity);
    }

    public void setMonitorSysDefSecurity(BMonitorSysDefSecurity v) {
        this.set(monitorSysDefSecurity, (BValue)v, null);
    }

    public BMonitorSysDef getMonitorSysDef() {
        return (BMonitorSysDef)this.get(monitorSysDef);
    }

    public void setMonitorSysDef(BMonitorSysDef v) {
        this.set(monitorSysDef, (BValue)v, null);
    }

    public BActivityMonitor getActivityMonitor() {
        return (BActivityMonitor)this.get(activityMonitor);
    }

    public void setActivityMonitor(BActivityMonitor v) {
        this.set(activityMonitor, (BValue)v, null);
    }

    public BAlarmClasses getAlarmClasses() {
        return (BAlarmClasses)this.get(alarmClasses);
    }

    public void setAlarmClasses(BAlarmClasses v) {
        this.set(alarmClasses, (BValue)v, null);
    }

    public BAlarmConsoles getAlarmConsoles() {
        return (BAlarmConsoles)this.get(alarmConsoles);
    }

    public void setAlarmConsoles(BAlarmConsoles v) {
        this.set(alarmConsoles, (BValue)v, null);
    }

    public BEmailRecipients getEmailRecipients() {
        return (BEmailRecipients)this.get(emailRecipients);
    }

    public void setEmailRecipients(BEmailRecipients v) {
        this.set(emailRecipients, (BValue)v, null);
    }

    public BStationRecipients getStationRecipients() {
        return (BStationRecipients)this.get(stationRecipients);
    }

    public void setStationRecipients(BStationRecipients v) {
        this.set(stationRecipients, (BValue)v, null);
    }

    public BAlarmHistory getAlarmHistory() {
        return (BAlarmHistory)this.get(alarmHistory);
    }

    public void setAlarmHistory(BAlarmHistory v) {
        this.set(alarmHistory, (BValue)v, null);
    }

    public BAlarmSourceExts getAlarmSourceExts() {
        return (BAlarmSourceExts)this.get(alarmSourceExts);
    }

    public void setAlarmSourceExts(BAlarmSourceExts v) {
        this.set(alarmSourceExts, (BValue)v, null);
    }

    public BAlarmExtInstructions getAlarmInstructions() {
        return (BAlarmExtInstructions)this.get(alarmInstructions);
    }

    public void setAlarmInstructions(BAlarmExtInstructions v) {
        this.set(alarmInstructions, (BValue)v, null);
    }

    public BAlarmClassRelayLinks getAlarmRelays() {
        return (BAlarmClassRelayLinks)this.get(alarmRelays);
    }

    public void setAlarmRelays(BAlarmClassRelayLinks v) {
        this.set(alarmRelays, (BValue)v, null);
    }

    public BPdfStyles getPdfStyles() {
        return (BPdfStyles)this.get(pdfStyles);
    }

    public void setPdfStyles(BPdfStyles v) {
        this.set(pdfStyles, (BValue)v, null);
    }

    public BBacnetPoints getBacnetPoints() {
        return (BBacnetPoints)this.get(bacnetPoints);
    }

    public void setBacnetPoints(BBacnetPoints v) {
        this.set(bacnetPoints, (BValue)v, null);
    }

    public BNiagaraStationQuery getStationsQuery() {
        return (BNiagaraStationQuery)this.get(stationsQuery);
    }

    public void setStationsQuery(BNiagaraStationQuery v) {
        this.set(stationsQuery, (BValue)v, null);
    }

    public BSecurityHistoryConsolidator getAuditHistory() {
        return (BSecurityHistoryConsolidator)this.get(auditHistory);
    }

    public void setAuditHistory(BSecurityHistoryConsolidator v) {
        this.set(auditHistory, (BValue)v, null);
    }

    public BSecurityHistoryConsolidator getLogHistory() {
        return (BSecurityHistoryConsolidator)this.get(logHistory);
    }

    public void setLogHistory(BSecurityHistoryConsolidator v) {
        this.set(logHistory, (BValue)v, null);
    }

    public BSecurityHistoryConsolidator getLdapAuditHistory() {
        return (BSecurityHistoryConsolidator)this.get(ldapAuditHistory);
    }

    public void setLdapAuditHistory(BSecurityHistoryConsolidator v) {
        this.set(ldapAuditHistory, (BValue)v, null);
    }

    public BScheduleRecs getSchedules() {
        return (BScheduleRecs)this.get(schedules);
    }

    public void setSchedules(BScheduleRecs v) {
        this.set(schedules, (BValue)v, null);
    }

    public BCalendarSchedules getCalendarSchedules() {
        return (BCalendarSchedules)this.get(calendarSchedules);
    }

    public void setCalendarSchedules(BCalendarSchedules v) {
        this.set(calendarSchedules, (BValue)v, null);
    }

    public BTenants getTenants() {
        return (BTenants)this.get(tenants);
    }

    public void setTenants(BTenants v) {
        this.set(tenants, (BValue)v, null);
    }

    public BThreatLevelGroupRecs getThreatLevelGroups() {
        return (BThreatLevelGroupRecs)this.get(threatLevelGroups);
    }

    public void setThreatLevelGroups(BThreatLevelGroupRecs v) {
        this.set(threatLevelGroups, (BValue)v, null);
    }

    public BThreatLevelSetup getThreatLevelSetup() {
        return (BThreatLevelSetup)this.get(threatLevelSetup);
    }

    public void setThreatLevelSetup(BThreatLevelSetup v) {
        this.set(threatLevelSetup, (BValue)v, null);
    }

    public BImageFileTable getImages() {
        return (BImageFileTable)this.get(images);
    }

    public void setImages(BImageFileTable v) {
        this.set(images, (BValue)v, null);
    }

    public BPxGraphics getGraphics() {
        return (BPxGraphics)this.get(graphics);
    }

    public void setGraphics(BPxGraphics v) {
        this.set(graphics, (BValue)v, null);
    }

    public BEntsecNavGroupQuery getNavigationGroups() {
        return (BEntsecNavGroupQuery)this.get(navigationGroups);
    }

    public void setNavigationGroups(BEntsecNavGroupQuery v) {
        this.set(navigationGroups, (BValue)v, null);
    }

    public BChangePasskey getChangePasskey() {
        return (BChangePasskey)this.get(changePasskey);
    }

    public void setChangePasskey(BChangePasskey v) {
        this.set(changePasskey, (BValue)v, null);
    }

    public BUserQuery getUsers() {
        return (BUserQuery)this.get(users);
    }

    public void setUsers(BUserQuery v) {
        this.set(users, (BValue)v, null);
    }

    public BEntsecRoleQuery getRoles() {
        return (BEntsecRoleQuery)this.get(roles);
    }

    public void setRoles(BEntsecRoleQuery v) {
        this.set(roles, (BValue)v, null);
    }

    public BSystemBackups getSystemBackups() {
        return (BSystemBackups)this.get(systemBackups);
    }

    public void setSystemBackups(BSystemBackups v) {
        this.set(systemBackups, (BValue)v, null);
    }

    public BPlatformSetup getPlatformSetup() {
        return (BPlatformSetup)this.get(platformSetup);
    }

    public void setPlatformSetup(BPlatformSetup v) {
        this.set(platformSetup, (BValue)v, null);
    }

    public BVideoSubsystem getVideoSubsystem() {
        return (BVideoSubsystem)this.get(videoSubsystem);
    }

    public void setVideoSubsystem(BVideoSubsystem v) {
        this.set(videoSubsystem, (BValue)v, null);
    }

    public BEndUserLicenseAgreement getEndUserLicenseAgreement() {
        return (BEndUserLicenseAgreement)this.get(endUserLicenseAgreement);
    }

    public void setEndUserLicenseAgreement(BEndUserLicenseAgreement v) {
        this.set(endUserLicenseAgreement, (BValue)v, null);
    }

    public BThirdPartyLicenses getThirdPartyLicenses() {
        return (BThirdPartyLicenses)this.get(thirdPartyLicenses);
    }

    public void setThirdPartyLicenses(BThirdPartyLicenses v) {
        this.set(thirdPartyLicenses, (BValue)v, null);
    }

    public boolean getInitRequired() {
        return this.getBoolean(initRequired);
    }

    public void setInitRequired(boolean v) {
        this.setBoolean(initRequired, v, null);
    }

    public boolean getRequireDefaultUserPermissions() {
        return this.getBoolean(requireDefaultUserPermissions);
    }

    public void setRequireDefaultUserPermissions(boolean v) {
        this.setBoolean(requireDefaultUserPermissions, v, null);
    }

    public boolean getShowNavBar() {
        return this.getBoolean(showNavBar);
    }

    public void setShowNavBar(boolean v) {
        this.setBoolean(showNavBar, v, null);
    }

    public boolean getShowGuidedTour() {
        return this.getBoolean(showGuidedTour);
    }

    public void setShowGuidedTour(boolean v) {
        this.setBoolean(showGuidedTour, v, null);
    }

    public boolean getPopUpGuidedTour() {
        return this.getBoolean(popUpGuidedTour);
    }

    public void setPopUpGuidedTour(boolean v) {
        this.setBoolean(popUpGuidedTour, v, null);
    }

    public boolean getQueryOutdatedStations() {
        return this.getBoolean(queryOutdatedStations);
    }

    public void setQueryOutdatedStations(boolean v) {
        this.setBoolean(queryOutdatedStations, v, null);
    }

    public boolean getUnlicensedVisibility() {
        return this.getBoolean(unlicensedVisibility);
    }

    public void setUnlicensedVisibility(boolean v) {
        this.setBoolean(unlicensedVisibility, v, null);
    }

    public BPassword getModifiedPassKey() {
        return (BPassword)this.get(modifiedPassKey);
    }

    public void setModifiedPassKey(BPassword v) {
        this.set(modifiedPassKey, (BValue)v, null);
    }

    public BAccessWorker getAccessWorker() {
        return (BAccessWorker)this.get(accessWorker);
    }

    public void setAccessWorker(BAccessWorker v) {
        this.set(accessWorker, (BValue)v, null);
    }

    public BFacets getModuleDependenciesFacets() {
        return (BFacets)this.get(moduleDependenciesFacets);
    }

    public void setModuleDependenciesFacets(BFacets v) {
        this.set(moduleDependenciesFacets, (BValue)v, null);
    }

    public void rebuildDefaultNav() {
        this.invoke(rebuildDefaultNav, null, null);
    }

    public void saveDefaultNav() {
        this.invoke(saveDefaultNav, null, null);
    }

    public void regenerateMappedUuids() {
        this.invoke(regenerateMappedUuids, null, null);
    }

    public void regenerateAllUuids() {
        this.invoke(regenerateAllUuids, null, null);
    }

    public void cleanupOrphanedMappables() {
        this.invoke(cleanupOrphanedMappables, null, null);
    }

    public void cleanupOrphanedMappablesSpecific(BString parameter) {
        this.invoke(cleanupOrphanedMappablesSpecific, (BValue)parameter, null);
    }

    public void resetUiTableColumns() {
        this.invoke(resetUiTableColumns, null, null);
    }

    public void handleSysDefEvent(BMonitorSysDefEvent parameter) {
        this.invoke(handleSysDefEvent, (BValue)parameter, null);
    }

    public void clearUserPermissions(BEntsecUserPermissionsInfo parameter) {
        this.invoke(clearUserPermissions, (BValue)parameter, null);
    }

    public void saveUserPermissions(BEntsecUserPermissionsInfo parameter) {
        this.invoke(saveUserPermissions, (BValue)parameter, null);
    }

    public void loadUserPermissions(BEntsecUserPermissionsInfo parameter) {
        this.invoke(loadUserPermissions, (BValue)parameter, null);
    }

    public void restoreDefaultUserPermissions(BEntsecUserPermissionsInfo parameter) {
        this.invoke(restoreDefaultUserPermissions, (BValue)parameter, null);
    }

    public void cleanupOrphanedUserTenants(BRef parameter) {
        this.invoke(cleanupOrphanedUserTenants, (BValue)parameter, null);
    }

    public void removeMapping() {
        this.invoke(removeMapping, null, null);
    }

    public BOrionObject remoteOrionRead(BOrionObject parameter) {
        return (BOrionObject)this.invoke(remoteOrionRead, (BValue)parameter, null);
    }

    public void asyncStationStartedAction(BValue parameter) {
        this.invoke(asyncStationStartedAction, parameter, null);
    }

    public void changeOfPasskey(BPassword parameter) {
        this.invoke(changeOfPasskey, (BValue)parameter, null);
    }

    public void fireAlarmClassEvent(BAlarmClassEvent event) {
        this.fire(alarmClassEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void changed(Property property, Context cx) {
        LicenseChecker licenseChecker = LicenseChecker.getChecker();
        if (property == unlicensedVisibility) {
            if (this.getUnlicensedVisibility()) {
                licenseChecker.override();
            } else {
                licenseChecker.check();
            }
        }
        super.changed(property, cx);
    }

    public void serviceStopped() throws Exception {
        this.getComponentSpace().disableMixIn(BOffAlarmClass.TYPE);
        this.getComponentSpace().disableMixIn(BSecurityAlarmConsoleOptions.TYPE);
        this.getComponentSpace().disableMixIn(BMappedScheduleExt.TYPE);
        this.getComponentSpace().disableMixIn(BMappedEnumScheduleExt.TYPE);
        this.getComponentSpace().disableMixIn(BMappedThreatLevelGroupExt.TYPE);
        this.cleanupSubscriptions();
        this.unlinkFromMonitorSysDef();
    }

    public final void started() throws Exception {
        LicenseCounter.checkLicense(this.getLicenseFeature(), (BAbstractService)this);
        super.started();
        if (this.getStationsQuery().get("standaloneStationsQuery") == null) {
            this.getStationsQuery().add("standaloneStationsQuery", (BValue)new BNiagaraStationQuery());
        }
        this.getLogHistory().setConsolidationDisabled(true);
        this.mappingSupport.orionReadyAndStarted();
        this.getComponentSpace().enableMixIn(BMappedScheduleExt.TYPE);
        this.getComponentSpace().enableMixIn(BMappedEnumScheduleExt.TYPE);
        this.getComponentSpace().enableMixIn(BMappedThreatLevelGroupExt.TYPE);
        this.getComponentSpace().enableMixIn(BLdapMappedAttribute.TYPE);
        this.getComponentSpace().enableMixIn(BLdapJoinDeviceExt.TYPE);
        this.getComponentSpace().enableMixIn(BLdapImportConfig.TYPE);
        this.nav.buildDefaultNav();
        this.setSqlServerExtraConnectionParameters();
        this.checkLicensing();
    }

    private void checkReEncryption() {
        if (!this.getModifiedPassKey().isDefault()) {
            try {
                LOG.info("Passkey was changed");
                LOG.info("******** Re-Encryption Started **********");
                this.reEncryptPinNumbers(this.getSession().getSessionContext(), AccessController.doPrivileged(() -> ((BPassword)this.getModifiedPassKey()).getValue()));
                LOG.info("******** Re-Encryption Completed  **********");
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Re-Encryption of pin numbers failed", e);
            }
        }
    }

    private void checkLicensing() {
        LicenseChecker licenseChecker = LicenseChecker.getChecker();
        licenseChecker.register((BComplex)this, (Slot)emailRecipients, VENDOR, EMAIL_FEATURE, true).register((BComplex)this, (Slot)threatLevelGroups, VENDOR, ENTSEC_FEATURE, THREAT_ATTRIBUTE, "", false).register((BComplex)this, (Slot)threatLevelSetup, VENDOR, ENTSEC_FEATURE, THREAT_ATTRIBUTE, "", true).register((BComplex)this, (Slot)videoSubsystem, VENDOR, VIDEO_FEATURE, true).register(this.getParent(), (Slot)this.getPropertyInParent(), VENDOR, ENTSEC_FEATURE, true);
        try {
            licenseChecker.register(this.getParent(), (Slot)Sys.getService((Type)BEmailService.TYPE).getPropertyInParent(), VENDOR, EMAIL_FEATURE, true);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature(VENDOR, ENTSEC_FEATURE);
    }

    public void serviceStarted() {
        super.serviceStarted();
        String foxChannelId = REMOTE_BACKUP_CHANNEL;
        if (BFoxChannelRegistry.getPrototype().get(foxChannelId) == null) {
            BFoxChannelRegistry.getPrototype().add(foxChannelId, (BValue)new BRemoteBackupChannel());
        } else {
            LOG.log(Level.FINE, "The Fox {} channel exists.", foxChannelId);
        }
        try {
            EntsecAppUtil.installApps();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.getComponentSpace().enableMixIn(BNiagaraAlarmClassDeviceExt.TYPE);
            this.subscribeToAlarmClassFolders();
            this.getComponentSpace().enableMixIn(BOffAlarmClass.TYPE);
            this.getComponentSpace().enableMixIn(BSecurityAlarmConsoleOptions.TYPE);
            this.linkToMonitorSysDef();
            this.brandingManager = new BrandingManager(this);
            this.linkToChangePassKey();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateModuleDependencies();
        this.setupUserManagement();
        this.setFlags((Slot)systemBackups, this.getFlags((Slot)systemBackups) & 0xFFFFFFFB);
    }

    public void stationStarted() throws Exception {
        this.checkReEncryption();
        super.stationStarted();
        BEnterpriseSecurityService.postAsyncStationStarted(this);
    }

    @Override
    public void asyncStationStarted() throws Exception {
        Property changePassword = this.getProperty("changePassword");
        if (changePassword != null) {
            this.remove(changePassword);
        }
        if (this.getInitRequired() && this.getRequireDefaultUserPermissions()) {
            BEntsecUserPermissionsInfo info = new BEntsecUserPermissionsInfo();
            info.setFileName("");
            info.setCategorizations(true);
            info.setCategories(true);
            info.setRoles(true);
            this.doRestoreDefaultUserPermissions(info, null);
        } else if (this.getRequireDefaultUserPermissions()) {
            this.restoreDefaultUserPermissions(BEntsecUserPermissionsInfo.makeAutoLoad());
        }
        if (BEnterpriseSecurityService.isWorkstation()) {
            if (this.getInitRequired()) {
                this.setShowGuidedTour(true);
                this.setPopUpGuidedTour(true);
            }
            this.setInitRequired(false);
        }
        try {
            int i;
            BBackupService service = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
            BOrdList list = service.getExcludeDirectories();
            BOrd[] excludeDirs = list.toArray();
            boolean found = false;
            for (i = 0; i < excludeDirs.length && !found; ++i) {
                if (!excludeDirs[i].equals((Object)TEMP_DIR)) continue;
                found = true;
            }
            if (!found) {
                list = BOrdList.add((BOrdList)list, (BOrd)TEMP_DIR);
                service.setExcludeDirectories(list);
            }
            found = false;
            list = service.getOfflineExcludeDirectories();
            excludeDirs = list.toArray();
            for (i = 0; i < excludeDirs.length && !found; ++i) {
                if (!excludeDirs[i].equals((Object)TEMP_DIR)) continue;
                found = true;
            }
            if (!found) {
                list = BOrdList.add((BOrdList)list, (BOrd)TEMP_DIR);
                service.setOfflineExcludeDirectories(list);
            }
        }
        catch (ServiceNotFoundException service) {
            // empty catch block
        }
        LicenseChecker licenseChecker = LicenseChecker.getChecker();
        if (this.getUnlicensedVisibility()) {
            licenseChecker.override();
        } else {
            licenseChecker.check();
        }
    }

    public void atSteadyState() throws Exception {
        this.fixShutdownDelay();
        super.atSteadyState();
    }

    protected void fixShutdownDelay() throws Exception {
        if (Nre.getHostModel().equals("Workstation")) {
            return;
        }
        try {
            BNpmDualBatteryPlatformService powerService = (BNpmDualBatteryPlatformService)Sys.getService((Type)BNpmDualBatteryPlatformService.TYPE);
            if (!powerService.getSlaBatteryPresent()) {
                powerService.setSlaBatteryPresent(true);
                powerService.setShutdownDelay(BRelTime.makeHours((int)24));
                LOG.warning("Invalid Shutdown Delay detected for entsec, setting to entsec default of 24 hours.");
                ((BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE)).savePlatformServiceProperties();
            }
        }
        catch (ServiceNotFoundException powerService) {
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Cannot check for invalid shutdown delay", e);
        }
    }

    public void stopped() throws Exception {
        LicenseChecker checker = LicenseChecker.getChecker();
        checker.deregister(this.getParent());
        checker.deregister((BComplex)this);
        super.stopped();
    }

    protected void setupUserManagement() {
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUserPrototypes prototypes = userService.getUserPrototypes();
        BUser protoUser = prototypes.getDefaultPrototype();
        if (protoUser.getNavFile().isNull()) {
            protoUser.setNavFile(BOrd.make((String)"module://entsec/rc/entsecHome.nav"));
        }
        if (Flags.isUserDefined1((BComplex)protoUser, (Slot)BUser.navFile) && !Flags.isUserDefined4((BComplex)protoUser, (Slot)BUser.navFile)) {
            protoUser.setFlags((Slot)BUser.navFile, protoUser.getFlags((Slot)BUser.navFile) & 0xEFFFFFFF);
        }
        if (Flags.isUserDefined1((BComplex)protoUser, (Slot)BUser.roles) && !Flags.isUserDefined4((BComplex)protoUser, (Slot)BUser.roles)) {
            protoUser.setFlags((Slot)BUser.roles, protoUser.getFlags((Slot)BUser.roles) & 0xEFFFFFFF);
        }
        this.getComponentSpace().enableMixIn(BEntsecUserConfig.TYPE);
    }

    public BSchemaVersion getSchemaVersion() {
        return CURRENT_VERSION;
    }

    public void performSchemaUpgrade(BLocalOrionDatabase orionDatabase, BSchemaVersion oldVersion) throws Exception {
        this.schemaManager.performSchemaUpgrade(orionDatabase, oldVersion);
    }

    public void orionReady(BOrionDatabase db) {
        this.orionReady = true;
        this.mappingSupport.orionReadyAndStarted();
        SlotCursor c = this.getProperties();
        while (c.next(BAppTable.class)) {
            ((BAppTable)c.get()).validateOrionApp(this);
        }
    }

    public OrionSession createManagedSession(Context cx) {
        OrionSession session = this.createSession(cx);
        OrionSessionCleaner.manage(session);
        return session;
    }

    public OrionType[] getOrionTypes() {
        if (!this.orionReady || this.registeredOrionTypes == null) {
            this.registeredOrionTypes = OrionTypeRegistrator.getDistictOrionTypes(this, orionTypes, this.registeredOrionTypes);
        }
        return this.registeredOrionTypes;
    }

    @Override
    public boolean isOrionReady() {
        return this.orionReady;
    }

    @Override
    public void mappedRemoved(BComponent c) {
        this.mappingSupport.mappedRemoved(c);
    }

    @Override
    public void mappedAdded(BComponent c) {
        this.mappingSupport.mappedAdded(c);
    }

    @Override
    public void mappedUpdate(BComponent c) {
        this.mappingSupport.mappedUpdate(c);
    }

    @Override
    public void mappedPersist(BComponent c) {
        this.mappingSupport.mappedPersist(c);
    }

    public void doAsyncStationStartedAction(BValue val) throws Exception {
        if (val instanceof BIAsyncStationStarted) {
            ((BIAsyncStationStarted)val).asyncStationStarted();
        }
    }

    public static void postAsyncStationStarted(final BIAsyncStationStarted started) throws Exception {
        try {
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)TYPE);
            service.asyncStationStartedAction((BValue)started);
        }
        catch (Exception e) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        started.asyncStationStarted();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    private void updateModuleDependencies() {
        String moduleName;
        ArrayList<String> moduleList = new ArrayList<String>(this.modules);
        if (this.getBrandingManager() != null && (moduleName = this.getBrandingManager().getBrandedModuleName()) != null) {
            moduleList.add(moduleName);
        }
        BFacets facets = BFacets.NULL;
        facets = ObjectUtil.appendModuleDependencyFacets((BFacets)facets, moduleList.stream());
        this.setModuleDependenciesFacets(facets);
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        this.getAccessWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        return null;
    }

    public void doResetUiTableColumns(Context cx) {
        BogCursor c = new BogCursor((BComplex)Sys.getStation(), 99, new Type[]{BQuery.TYPE, BDynamicTable.TYPE}, true, null);
        while (c.next()) {
            BComponent query = (BComponent)c.get();
            if (query instanceof BDynamicTable) {
                BDynamicTable dt = (BDynamicTable)query;
                dt.setColumns(dt.getDefaultColumns());
                continue;
            }
            if (!(query instanceof BQuery)) continue;
            BQuery q = (BQuery)query;
            if (q.hasProjection()) {
                q.remove((BComplex)q.getProjection());
            }
            if (q.hasPredicate()) {
                q.remove((BComplex)q.getPredicate());
            }
            if (q.hasGrouping()) {
                q.remove((BComplex)q.getGrouping());
            }
            if (q.hasHaving()) {
                q.remove((BComplex)q.getHaving());
            }
            if (!q.hasOrdering()) continue;
            q.remove((BComplex)q.getOrdering());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrionObject doRemoteOrionRead(BOrionObject c, Context cx) throws Exception {
        OrionSession session = null;
        try {
            session = this.createSession(cx);
            BOrionObject bOrionObject = (BOrionObject)session.read((BIOrionObject)c);
            return bOrionObject;
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveMapping(Context cx) {
        BogCursor c = new BogCursor((BComplex)Sys.getStation(), 99, new Type[]{BMappedExt.TYPE}, true, null);
        OrionSession session = null;
        try {
            session = this.createSession(null);
            while (c.next()) {
                BMappedExt ext = (BMappedExt)c.get();
                BComponent parent = ext.getParent().asComponent();
                BIOrionObject mapped = null;
                if (session != null) {
                    mapped = session.mappedRead((BObject)parent);
                    MergeSupport.setReferencesToNull(mapped, session);
                }
                parent.remove(ext.getName());
                if (session == null || mapped == null) continue;
                session.delete(mapped);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRegenerateMappedUuids(Context cx) {
        BogCursor c = new BogCursor((BComplex)Sys.getStation(), 99, new Type[]{BMappedExt.TYPE}, true, null);
        OrionSession session = null;
        try {
            session = this.createSession(null);
            while (c.next()) {
                BMappedExt ext = (BMappedExt)c.get();
                BComponent parent = ext.getParent().asComponent();
                if (Flags.isReadonly((BComplex)parent.getParent(), (Slot)parent.getPropertyInParent())) continue;
                BUuid newUuid = BUuid.make();
                MergeSupport.changeUuidForComponent(newUuid, parent, session);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRegenerateAllUuids(Context cx) {
        BogCursor c = new BogCursor((BComplex)Sys.getStation(), 99, new Type[]{BMappedExt.TYPE}, true, null);
        OrionSession session = null;
        try {
            session = this.createSession(null);
            while (c.next()) {
                BMappedExt ext = (BMappedExt)c.get();
                BComponent parent = ext.getParent().asComponent();
                if (Flags.isReadonly((BComplex)parent.getParent(), (Slot)parent.getPropertyInParent())) continue;
                BUuid newUuid = BUuid.make();
                MergeSupport.changeUuidForComponent(newUuid, parent, session);
            }
            BOrionDatabase db = session.getOrionDatabase();
            BOrionType[] orionTypes = db.getTypes();
            for (int i = 0; i < orionTypes.length; ++i) {
                OrionType orionType = orionTypes[i].getOrionType();
                if (orionType.isAssociation() || orionType.is(BIMappable.TYPE)) continue;
                Property[] keys = orionType.getKey();
                Property[] props = orionType.getProperties();
                Array uuidKeys = new Array(Property.class);
                for (int j = 0; j < keys.length; ++j) {
                    if (!keys[j].getType().equals(BUuid.TYPE)) continue;
                    uuidKeys.add((Object)keys[j]);
                }
                if (uuidKeys.size() == 0) continue;
                if (uuidKeys.size() > 1) {
                    throw new IllegalStateException("Non-Associated Orion Objects should only have 1 Uuid key, " + orionType + " has " + uuidKeys.size() + ".");
                }
                OrionCursor cursor = session.scan(orionType);
                while (cursor.next()) {
                    int j;
                    BOrionObject o = (BOrionObject)cursor.get();
                    if (o instanceof BIPresettableUuid && ((BIPresettableUuid)o).isDefault()) continue;
                    BOrionObject copy = (BOrionObject)o.getType().getInstance();
                    BUuid newUuid = BUuid.make();
                    copy.set((Property)uuidKeys.get(0), (BValue)newUuid);
                    for (j = 0; j < props.length; ++j) {
                        if (BOrionObject.isKey((Property)props[j]) || BOrionObject.isUnique((Property)props[j])) continue;
                        copy.set(props[j], o.get(props[j]));
                    }
                    session.insert((BIOrionObject)copy);
                    MergeSupport.mergeRecords((BIOrionObject)copy, (BIOrionObject)o, session);
                    for (j = 0; j < props.length; ++j) {
                        if (BOrionObject.isKey((Property)props[j]) || !BOrionObject.isUnique((Property)props[j]) || copy.get(props[j]).equals((Object)o.get(props[j]))) continue;
                        copy.set(props[j], o.get(props[j]));
                    }
                    session.update((BIOrionObject)copy);
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanupOrphanedUserTenants(BRef tenant) {
        BogCursor c = new BogCursor((BComplex)Sys.getService((Type)BUserService.TYPE), 99, new Type[]{BUser.TYPE}, true, null);
        if (tenant.isBound()) {
            while (c.next()) {
                BUser user = (BUser)c.get();
                BEntsecUserConfig config = (BEntsecUserConfig)user.getMixIn(BEntsecUserConfig.TYPE);
                BRefList tenantList = config.getTenants();
                if (!tenantList.contains(tenant)) continue;
                config.setTenants(BRefList.makeRemove(tenantList, new BSimple[]{tenant.getId()}));
            }
        } else {
            OrionSession session = null;
            try {
                session = this.createSession(null);
                BTenant[] tenants = (BTenant[])session.scan(BTenant.ORION_TYPE).toArray();
                while (c.next()) {
                    BUser user = (BUser)c.get();
                    BEntsecUserConfig config = (BEntsecUserConfig)user.getMixIn(BEntsecUserConfig.TYPE);
                    BRefList tenantList = config.getTenants();
                    config.setTenants(tenantList.trim(session));
                }
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
    }

    public void doCleanupOrphanedMappables() {
        this.doCleanupOrphanedMappables(null, null);
    }

    public void doCleanupOrphanedMappables(BJob job) {
        this.doCleanupOrphanedMappables(job, null);
    }

    public Map<String, ArrayList<BValue>> getCorruptedPins(BJob job, Context cx) {
        Array<Property> intPinArray = this.getDynamicOrionTypeArray(BIntrusionPin.class);
        Array<Property> persPinArray = this.getDynamicOrionTypeArray(BPerson.class);
        job.progress(5);
        this.isInvalidPinsJobCancelled = this.isJobCanceled(job);
        if (!this.isInvalidPinsJobCancelled) {
            BEnterpriseSecurityService.log("Fetching Invalid Intrusion Pins", 10, job);
            this.invalidPinMap = this.getPins(intPinArray, BIntrusionPin.class, cx);
            List countList = this.invalidPinMap.get(this.getOrionDatabase().getTableName(BIntrusionPin.ORION_TYPE));
            BEnterpriseSecurityService.log((countList == null ? 0 : countList.size()) + " invalid Intrusion Pin(s) found", 20, job);
            this.isInvalidPinsJobCancelled = this.isJobCanceled(job);
            if (!this.isInvalidPinsJobCancelled) {
                job.progress(2);
                BEnterpriseSecurityService.log("Fetching Invalid Person Pins", 20, job);
                this.invalidPinMap.putAll(this.getPins(persPinArray, BPerson.class, cx));
                countList = this.invalidPinMap.get(this.getOrionDatabase().getTableName(BPerson.ORION_TYPE));
                BEnterpriseSecurityService.log((countList == null ? 0 : countList.size()) + " invalid Person Pin(s) found", 30, job);
                job.progress(100);
            } else {
                BEnterpriseSecurityService.log("Get Invalid Pins Job Canceled", 0, job);
                this.invalidPinMap = null;
            }
        } else {
            BEnterpriseSecurityService.log("Get Invalid Pins Job Canceled", 0, job);
            this.invalidPinMap = null;
        }
        return this.invalidPinMap;
    }

    public Array<Property> getDynamicOrionTypeArray(Class<?> clazz) {
        Property[] persPinDynamicProperties = new Property[]{};
        Array persPinArray = new Array(Property.class);
        if (clazz.equals(BPerson.class)) {
            persPinDynamicProperties = BPerson.ORION_TYPE.getPersistentProperties();
        } else if (clazz.equals(BIntrusionPin.class)) {
            persPinDynamicProperties = BIntrusionPin.ORION_TYPE.getPersistentProperties();
        }
        for (int i = 0; i < persPinDynamicProperties.length; ++i) {
            if ("pinNumber".equals(persPinDynamicProperties[i].getName())) {
                persPinArray.add((Object)new DynamicOrionProperty(persPinDynamicProperties[i].getName(), BString.TYPE, (BValue)BString.DEFAULT, persPinDynamicProperties[i].getFacets(), persPinDynamicProperties[i].getDefaultFlags()));
                continue;
            }
            persPinArray.add((Object)new DynamicOrionProperty(persPinDynamicProperties[i]));
        }
        return persPinArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array<Property> getSpecificTypeArray(Class<?> clazz, Context cx) {
        Property[] persPinDynamicProperties = new Property[]{};
        Array persPinArray = new Array(Property.class);
        String primaryKey = null;
        String piNumber = null;
        OrionSession session = null;
        try {
            session = this.createSession(cx);
            if (clazz.equals(BPerson.class)) {
                persPinDynamicProperties = BPerson.ORION_TYPE.getPersistentProperties();
                primaryKey = session.getOrionDatabase().getColumnName(BPerson.ORION_TYPE, BPerson.personId);
                piNumber = session.getOrionDatabase().getColumnName(BPerson.ORION_TYPE, BPerson.pinNumber);
            } else if (clazz.equals(BIntrusionPin.class)) {
                persPinDynamicProperties = BIntrusionPin.ORION_TYPE.getPersistentProperties();
                primaryKey = session.getOrionDatabase().getColumnName(BIntrusionPin.ORION_TYPE, BIntrusionPin.intrusionPinId);
                piNumber = session.getOrionDatabase().getColumnName(BIntrusionPin.ORION_TYPE, BIntrusionPin.pinNumber);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        for (int i = 0; i < persPinDynamicProperties.length; ++i) {
            if (piNumber.equals(persPinDynamicProperties[i].getName())) {
                persPinArray.add((Object)new DynamicOrionProperty(persPinDynamicProperties[i].getName(), BString.TYPE, (BValue)BString.DEFAULT, persPinDynamicProperties[i].getFacets(), persPinDynamicProperties[i].getDefaultFlags()));
                continue;
            }
            if (!primaryKey.equals(persPinDynamicProperties[i].getName())) continue;
            persPinArray.add((Object)new DynamicOrionProperty(persPinDynamicProperties[i]));
        }
        return persPinArray;
    }

    public Map<String, ArrayList<BValue>> getInvalidPinMap() {
        return this.invalidPinMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ArrayList<BValue>> getPins(Array<Property> array, Class<?> clazz, Context cx) {
        String primaryKey = null;
        String tableName = null;
        String pinNumColName = null;
        HashMap<String, ArrayList<BValue>> mainMap = new HashMap<String, ArrayList<BValue>>();
        OrionSession session = null;
        try {
            session = this.createSession(cx);
            String moduleName = null;
            if (BIntrusionPin.class.equals(clazz)) {
                primaryKey = session.getOrionDatabase().getColumnName(BIntrusionPin.ORION_TYPE, BIntrusionPin.intrusionPinId);
                tableName = session.getOrionDatabase().getTableName(BIntrusionPin.ORION_TYPE);
                pinNumColName = session.getOrionDatabase().getColumnName(BIntrusionPin.ORION_TYPE, BIntrusionPin.pinNumber);
                moduleName = BIntrusionPin.TYPE.getModule().getModuleName();
            } else if (BPerson.class.equals(clazz)) {
                primaryKey = session.getOrionDatabase().getColumnName(BPerson.ORION_TYPE, BPerson.personId);
                tableName = session.getOrionDatabase().getTableName(BPerson.ORION_TYPE);
                pinNumColName = session.getOrionDatabase().getColumnName(BPerson.ORION_TYPE, BPerson.pinNumber);
                moduleName = BPerson.TYPE.getModule().getModuleName();
            }
            String selectQuery = "select * from " + tableName + " where " + pinNumColName + " IS NOT NULL";
            OrionCursor cursor = session.select((OrionType)DynamicOrionType.makeTemporary((Property[])((Property[])array.trim())), selectQuery);
            AesSysKeyEncoder encoder = this.getOrionDatabase().getRdbms().getEncoder();
            while (cursor.next()) {
                BDynamicOrionObject obj = (BDynamicOrionObject)cursor.get();
                Property[] prop = obj.getOrionType().getProperties();
                HashMap<String, BValue> map = new HashMap<String, BValue>();
                for (int j = 0; j < prop.length; ++j) {
                    DynamicOrionProperty property = (DynamicOrionProperty)prop[j];
                    map.put(property.getName(), obj.get((Property)property).asValue());
                    if (j != prop.length - 1) continue;
                    try {
                        String decryptedText;
                        String encryptedPin = ((BValue)map.get(pinNumColName)).toString();
                        if (encryptedPin != null && encryptedPin.startsWith(moduleName)) {
                            encryptedPin = encryptedPin.substring(moduleName.length() + 1);
                        }
                        if ((decryptedText = encoder.decrypt(encryptedPin)).isEmpty()) continue;
                        Integer.parseInt(decryptedText);
                        continue;
                    }
                    catch (Exception e) {
                        mainMap.computeIfAbsent(tableName, k -> new ArrayList());
                        ((ArrayList)mainMap.get(tableName)).add(map.get(primaryKey));
                    }
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        return mainMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCorruptedPins(BJob job, Map<String, ArrayList<BValue>> invalidPinMap, Context cx) {
        String updateQuery = null;
        BValue primaryKey = null;
        ArrayList iterableList = null;
        String tableName = null;
        String defaultValue = null;
        String pinNumColName = null;
        String primaryKeyColName = null;
        String logMsg = null;
        invalidPinMap = invalidPinMap == null ? new HashMap() : invalidPinMap;
        Iterator entrySetIterator = invalidPinMap.entrySet().iterator();
        AesSysKeyEncoder encoder = this.getOrionDatabase().getRdbms().getEncoder();
        OrionSession session = null;
        try {
            session = this.createSession(cx);
            session.setAutoCommit(false);
            while (entrySetIterator.hasNext() && !(this.isInvalidPinsJobCancelled = this.isJobCanceled(job))) {
                Map.Entry entry = entrySetIterator.next();
                tableName = (String)entry.getKey();
                if (session.getOrionDatabase().getTableName(BIntrusionPin.ORION_TYPE).equals(tableName)) {
                    pinNumColName = session.getOrionDatabase().getColumnName(BIntrusionPin.ORION_TYPE, BIntrusionPin.pinNumber);
                    primaryKeyColName = session.getOrionDatabase().getColumnName(BIntrusionPin.ORION_TYPE, BIntrusionPin.intrusionPinId);
                    defaultValue = "0";
                    logMsg = "Intrusion Pin(s)";
                } else if (session.getOrionDatabase().getTableName(BPerson.ORION_TYPE).equals(tableName)) {
                    pinNumColName = session.getOrionDatabase().getColumnName(BPerson.ORION_TYPE, BPerson.pinNumber);
                    primaryKeyColName = session.getOrionDatabase().getColumnName(BPerson.ORION_TYPE, BPerson.personId);
                    defaultValue = "";
                    logMsg = "Person Pin(s)";
                }
                iterableList = (ArrayList)entry.getValue();
                BEnterpriseSecurityService.log("Updating " + iterableList.size() + " invalid " + logMsg, 10, job);
                updateQuery = "update " + tableName + " set " + pinNumColName + "=? where " + primaryKeyColName + "=?";
                for (int i = 0; i < iterableList.size(); ++i) {
                    primaryKey = (BValue)iterableList.get(i);
                    if (primaryKey == null) continue;
                    session.update(updateQuery, new BSimple[]{BString.make((String)encoder.encrypt(defaultValue)), BUuid.make((String)primaryKey.toString())});
                }
            }
            this.isInvalidPinsJobCancelled = this.isJobCanceled(job);
            if (!this.isInvalidPinsJobCancelled) {
                session.commit();
            } else {
                session.rollback();
                BEnterpriseSecurityService.log("Update invalid Pins Job was Canceled", 0, job);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Exception occurred while Update Pin Numbers job.", e);
            session.rollback();
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        job.progress(100);
    }

    public void doCleanupOrphanedMappablesSpecific(BString station) {
        if (station.toString().length() == 0) {
            throw new IllegalStateException("station name must be provided");
        }
        this.doCleanupOrphanedMappables(null, new String[]{station.toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanupOrphanedMappables(BJob job, String[] specificStations) {
        if (specificStations == null) {
            BEnterpriseSecurityService.log("Updating Db Counts for all local stations and subordinates", 1, job);
        } else {
            BEnterpriseSecurityService.log("Updating Db Counts for a specifics station(s): " + TextUtil.join((String[])specificStations, (char)';'), 1, job);
        }
        HashMap<String, BFoxSession> foxSessions = new HashMap<String, BFoxSession>();
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] devices = network.getDevices();
        String interest = "CleanupOrphanedMappables" + BUuid.make().toString();
        for (int i = 0; i < devices.length; ++i) {
            foxSessions.put(devices[i].getName(), RemoteUtil.getFoxSession((BNiagaraStation)devices[i]));
        }
        BEnterpriseSecurityService.log("Connections Setup", 10, job);
        OrionSession session = null;
        try {
            session = this.createSession(null);
            BOrionDatabase db = this.getOrionDatabase();
            BOrionType[] orionTypes = db.getTypes();
            boolean canceled = false;
            block4: for (int i = 0; i < orionTypes.length; ++i) {
                OrionType orionType;
                if (job != null) {
                    if (canceled) {
                        break;
                    }
                    canceled = this.isJobCanceled(job);
                    if (canceled) {
                        BEnterpriseSecurityService.log("Update Reader Count Job Canceled", 0, job);
                        break;
                    }
                    job.progress((int)(100.0 * (double)(i + 1) / (double)orionTypes.length));
                }
                if (!(orionType = orionTypes[i].getOrionType()).is(BIOrdMappable.TYPE) && !orionType.is(BIntrusionZoneGroup.TYPE)) continue;
                BEnterpriseSecurityService.log("Checking " + HxTabUtil.getPluralDisplayName((Type)orionType, null), 0, job);
                OrionCursor c = null;
                if (specificStations == null) {
                    c = session.scan(orionType);
                } else {
                    BSqlQuery query = BSqlQuery.make((OrionType)orionType);
                    ExpressionBuilder b = new ExpressionBuilder();
                    for (int j = 0; j < specificStations.length; ++j) {
                        BSqlField field = new BSqlField(orionType, orionType.getProperty("stationName"));
                        b.or(Predicates.eq((BExpression)field.newExprCopy(), (BSimple)BString.make((String)specificStations[j])));
                    }
                    query.where(b.getExpression());
                    c = session.select((BQuery)query);
                }
                while (c.next()) {
                    if (job != null && (canceled = this.isJobCanceled(job))) {
                        BEnterpriseSecurityService.log("Update Reader Count Job Canceled", 0, job);
                        continue block4;
                    }
                    BOrionObject orionObject = (BOrionObject)c.get();
                    if (orionObject instanceof BIOrdMappable) {
                        BIOrdMappable o = (BIOrdMappable)orionObject;
                        String stationName = o.getStationName();
                        this.checkMappable(o, stationName, session, foxSessions, job, interest);
                        continue;
                    }
                    if (!(orionObject instanceof BIntrusionZoneGroup) || !(orionObject instanceof BIntrusionZoneGroup)) continue;
                    this.checkForOrphanedIntrusionZones((BIntrusionZoneGroup)orionObject, session, foxSessions, job, interest);
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
            Object[] values = foxSessions.values().toArray();
            for (int i = 0; i < values.length; ++i) {
                BFoxSession foxSession = (BFoxSession)values[i];
                foxSession.disengage(interest);
            }
        }
    }

    private void checkMappable(BIOrdMappable o, String stationName, OrionSession session, HashMap<String, BFoxSession> foxSessions, BJob job, String interest) {
        this.checkMappable(o, (BIOrionObject)o, stationName, session, foxSessions, job, interest);
    }

    private void checkMappable(BIOrdMappable o, BIOrionObject deleteObject, String stationName, OrionSession session, HashMap<String, BFoxSession> foxSessions, BJob job, String interest) {
        if (stationName.equals(Sys.getStation().getStationName())) {
            try {
                BComponent mappedComponent = (BComponent)o.getMappedOrd().get();
                BUuid mappedUuid = MappingSupport.getMappedUuid(mappedComponent);
                BOrionObject orionObject = (BOrionObject)o;
                try {
                    BUuid orionUuid = (BUuid)orionObject.get("uuid");
                    if (orionUuid != null && !orionUuid.equals((Object)mappedUuid)) {
                        BEnterpriseSecurityService.failed("Conflicting Uuids for " + stationName + ", " + o.getMappedOrd() + ",  uuid != db uuid (" + mappedUuid + " != " + orionUuid + ")", 0, job, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            catch (UnresolvedException e) {
                BEnterpriseSecurityService.log("Removing db record of " + o.getType().getDisplayName(null) + ", " + stationName + ", " + ((BIOrionObject)o).toDisplayString(null), 0, job);
                session.delete(deleteObject);
            }
        } else {
            BFoxSession foxSession = foxSessions.get(stationName);
            if (foxSession == null) {
                BEnterpriseSecurityService.log("Removing db record of " + o.getType().getDisplayName(null) + ", " + stationName + ", " + ((BIOrionObject)o).toDisplayString(null), 0, job);
                session.delete(deleteObject);
                return;
            }
            try {
                foxSession.engageNoRetry(interest);
            }
            catch (Exception e) {
                return;
            }
            BComponent mapped = RemoteUtil.getRemoteComponent(foxSession, o.getMappedOrd().toString());
            if (mapped == null) {
                if (!this.isJobCanceled(job)) {
                    BEnterpriseSecurityService.log("Removing db record '" + ((BIOrionObject)o).toDisplayString(null) + "' on station '" + stationName + "'", 0, job);
                    session.delete(deleteObject);
                }
            } else {
                BUuid mappedUuid = MappingSupport.getMappedUuidRemotely(mapped);
                BOrionObject orionObject = (BOrionObject)o;
                try {
                    BUuid orionUuid = (BUuid)orionObject.get("uuid");
                    if (orionUuid != null && !orionUuid.equals((Object)mappedUuid)) {
                        BEnterpriseSecurityService.failed("Conflicting Uuids for " + stationName + ", " + o.getMappedOrd() + ", uuid != db uuid (" + mappedUuid + " != " + orionUuid + ")", 0, job, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
    }

    private void checkForOrphanedIntrusionZones(BIntrusionZoneGroup group, OrionSession session, HashMap<String, BFoxSession> foxSessions, BJob job, String interest) {
        String intrusionZoneDisplayName = group.getIntrusionZone().getId().toString();
        try {
            if (group.getStationName().equals(Sys.getStation().getStationName())) {
                return;
            }
            BIntrusionZoneRec rec = group.resolveIntrusionZone(session);
            if (rec == null) {
                BEnterpriseSecurityService.log("Problem checking for old Intrusion Zone with uuid = '" + group.getIntrusionZone().getId() + "' originally referenced on '" + group.getStationName() + "'", 0, job);
                return;
            }
            intrusionZoneDisplayName = rec.getIntrusionZoneName();
            this.checkMappable(rec, (BIOrionObject)group, group.getStationName(), session, foxSessions, job, interest);
        }
        catch (Exception e) {
            BEnterpriseSecurityService.failed("Check for Intrusion Zone Group failed:" + intrusionZoneDisplayName, 0, job, e);
        }
    }

    private boolean isJobCanceled(BJob job) {
        if (job == null) {
            return false;
        }
        BJobState state = job.getJobState();
        return state.equals((Object)BJobState.canceled) || state.equals((Object)BJobState.canceling);
    }

    private static void failed(String message, int progress, BJob job, Exception e) {
        if (e == null) {
            e = new Exception(message);
        }
        BEnterpriseSecurityService.log(message, progress, job, e);
    }

    private static void log(String message, int progress, BJob job) {
        BEnterpriseSecurityService.log(message, progress, job, null);
    }

    private static void log(String message, int progress, BJob job, Exception e) {
        if (job == null) {
            if (e != null) {
                LOG.log(Level.SEVERE, message, e);
            } else {
                LOG.fine(message);
            }
        } else {
            if (e != null) {
                job.log().failed(message, (Throwable)e);
            } else {
                job.log().message(message);
            }
            if (progress > 0 && progress > job.getProgress()) {
                job.progress(progress);
            }
        }
    }

    private void linkToMonitorSysDef() {
        if (this.get("sysDefLink") != null) {
            return;
        }
        this.linkTo("sysDefLink", this.getMonitorSysDef(), (Slot)BMonitorSysDef.monitorSysDefEvent, (Slot)handleSysDefEvent);
    }

    private void linkToChangePassKey() {
        this.linkTo("changePassKeyEvent", (BComponent)this.getOrionDatabase().getRdbms().getRdbSecuritySettings(), (Slot)BRdbSecuritySettings.changeOfPassKey, (Slot)changeOfPasskey);
    }

    private void unlinkFromMonitorSysDef() {
        Property p = this.getProperty("sysDefLink");
        if (p != null) {
            this.remove(p);
        }
    }

    private void subscribeToAlarmClassFolders() {
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        this.subscriber.subscribe((BComponent)alarmService, 10);
    }

    private void cleanupSubscriptions() {
        BComponent[] subs = this.subscriber.getSubscriptions();
        for (int i = 0; i < subs.length; ++i) {
            BComplex parent;
            if (!(subs[i] instanceof BUser) || (parent = subs[i].getParent()) != null) continue;
            this.subscriber.unsubscribeTree(subs[i]);
        }
    }

    public void doHandleSysDefEvent(BMonitorSysDefEvent event) throws Exception {
        String stationName = event.getStationName();
        int role = event.getRole();
        int eventType = event.getId();
        if (BMonitorSysDefEvent.isInsert(eventType)) {
            BNiagaraUserDeviceExt userDeviceExt;
            BNiagaraAlarmClassDeviceExt alarmClassExt;
            BNiagaraNetwork ntwk = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            BNiagaraStation niagaraSupervisorStation = (BNiagaraStation)ntwk.getNiagaraStation(stationName);
            if (BMonitorSysDefEvent.isSupervisor(role)) {
                try {
                    this.configureHistoryExports(niagaraSupervisorStation, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                boolean stationRecipConfigured = false;
                BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                BStationRecipient[] recips = (BStationRecipient[])alarmService.getChildren(BStationRecipient.class);
                BOrd ord = BOrd.make((BOrd)alarmService.getSlotPathOrd(), (String)"bql:select * from alarm:StationRecipient");
                BITable result = (BITable)ord.resolve((BObject)alarmService).get();
                TableCursor recs = result.cursor();
                while (recs.next()) {
                    BStationRecipient recip = (BStationRecipient)recs.get();
                    if (!recip.getRemoteStation().equals(stationName)) continue;
                    stationRecipConfigured = true;
                }
                if (!stationRecipConfigured) {
                    BStationRecipient newRecip = new BStationRecipient();
                    newRecip.setRemoteStation(stationName);
                    alarmService.add("SecuritySupervisor?", (BValue)newRecip);
                    BAlarmClass[] alarmClasses = alarmService.getAlarmClasses();
                    for (int i = 0; i < alarmClasses.length; ++i) {
                        BAlarmClass alarmClass = alarmClasses[i];
                        if (alarmClass instanceof BOffAlarmClass) continue;
                        BLink link = newRecip.makeLink((BComponent)alarmClass, (Slot)BAlarmClass.alarm, (Slot)BAlarmRecipient.routeAlarm, null);
                        newRecip.add(null, (BValue)link);
                    }
                }
            }
            if ((alarmClassExt = BNiagaraAlarmClassDeviceExt.getForStation(niagaraSupervisorStation)) != null) {
                alarmClassExt.checkConfig();
                if (BMonitorSysDefEvent.isSupervisor(role)) {
                    alarmClassExt.setSyncOutEnabled(true);
                    alarmClassExt.scheduleSyncSoon();
                } else {
                    alarmClassExt.setSyncInEnabled(true);
                }
            }
            if ((userDeviceExt = BNiagaraUserDeviceExt.getForStation((BNiagaraStation)niagaraSupervisorStation)) != null) {
                if (BMonitorSysDefEvent.isSupervisor(role)) {
                    userDeviceExt.setSyncOutEnabled(true);
                    userDeviceExt.setSyncInEnabled(false);
                } else if (BMonitorSysDefEvent.isSubordinate(role)) {
                    userDeviceExt.setSyncInEnabled(true);
                    userDeviceExt.setSyncOutEnabled(false);
                } else {
                    userDeviceExt.setSyncInEnabled(false);
                    userDeviceExt.setSyncOutEnabled(false);
                }
            }
        } else if (BMonitorSysDefEvent.isDelete(eventType) && BMonitorSysDefEvent.isSupervisor(role)) {
            try {
                BNiagaraNetwork ntwk = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                BNiagaraStation niagaraSupervisorStation = (BNiagaraStation)ntwk.getNiagaraStation(stationName);
                if (niagaraSupervisorStation == null) {
                    LOG.warning("Cannot find supervisor station " + stationName + " for SysDefEvent: " + (Object)((Object)event));
                } else {
                    this.configureHistoryExports(niagaraSupervisorStation, false);
                }
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.SEVERE, "Unhandled SysDefEvent: " + (Object)((Object)event), e);
                }
                LOG.severe("Unhandled SysDefEvent: " + (Object)((Object)event) + ": " + e.getMessage());
            }
            BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            BStationRecipient[] recips = (BStationRecipient[])alarmService.getChildren(BStationRecipient.class);
            BOrd ord = BOrd.make((BOrd)alarmService.getSlotPathOrd(), (String)"bql:select * from alarm:StationRecipient");
            BITable result = (BITable)ord.resolve((BObject)alarmService).get();
            TableCursor recs = result.cursor();
            while (recs.next()) {
                BStationRecipient recip = (BStationRecipient)recs.get();
                if (!recip.getRemoteStation().equals(stationName)) continue;
                BComponent parent = (BComponent)recip.getParent();
                parent.remove((BComplex)recip);
            }
        }
    }

    private void configureHistoryExports(BNiagaraStation station, boolean enable) {
        BDescriptor[] descriptors = station.getHistories().getDescriptors();
        for (int j = 0; j < historyTypesToExport.length; ++j) {
            BTypeSpec recType = historyTypesToExport[j];
            boolean foundExisting = false;
            for (int i = 0; i < descriptors.length; ++i) {
                BDescriptor descriptor = descriptors[i];
                if (!(descriptor instanceof BOrionNiagaraHistoryTypeExport) || !((BOrionNiagaraHistoryTypeExport)descriptor).getRecordType().equals((Object)recType)) continue;
                foundExisting = true;
                if (enable && !recType.equals((Object)BLogRecord.TYPE.getTypeSpec())) {
                    ((BOrionNiagaraHistoryTypeExport)descriptor).setMinExecuteTime(BRelTime.makeMinutes((int)30));
                    ((BOrionNiagaraHistoryTypeExport)descriptor).setExecuteOnAppend(true);
                    descriptor.setEnabled(true);
                    descriptor.setFlags((Slot)BOrionNiagaraHistoryTypeExport.executeOnAppend, descriptor.getFlags((Slot)BOrionNiagaraHistoryTypeExport.executeOnAppend) | 0x40000000);
                    descriptor.setFlags((Slot)BOrionNiagaraHistoryTypeExport.minExecuteTime, descriptor.getFlags((Slot)BOrionNiagaraHistoryTypeExport.minExecuteTime) | 0x40000000);
                    break;
                }
                BComponent parent = (BComponent)descriptor.getParent();
                parent.remove((BComplex)descriptor);
                break;
            }
            if (foundExisting || !enable || recType.equals((Object)BLogRecord.TYPE.getTypeSpec())) continue;
            BOrionNiagaraHistoryTypeExport descriptor = new BOrionNiagaraHistoryTypeExport();
            descriptor.setRecordType(recType);
            descriptor.setMinExecuteTime(BRelTime.makeMinutes((int)30));
            descriptor.setExecuteOnAppend(true);
            descriptor.setExecutionTime(new BTimeTrigger((BTriggerMode)BDailyTriggerMode.make((BTime)BTime.make((int)2, (int)0, (int)0), (BDaysOfWeekBits)BDaysOfWeekBits.DEFAULT, (BRelTime)BRelTime.makeMinutes((int)15))));
            descriptor.setEnabled(true);
            descriptor.setFlags((Slot)BOrionNiagaraHistoryTypeExport.executeOnAppend, descriptor.getFlags((Slot)BOrionNiagaraHistoryTypeExport.executeOnAppend) | 0x40000000);
            descriptor.setFlags((Slot)BOrionNiagaraHistoryTypeExport.minExecuteTime, descriptor.getFlags((Slot)BOrionNiagaraHistoryTypeExport.minExecuteTime) | 0x40000000);
            StringBuffer sb = new StringBuffer();
            sb.append(recType.toString());
            sb.append(" Type Export");
            station.getHistories().add(sb.toString() + "?", (BValue)descriptor);
        }
    }

    public static boolean isVideoDriverAvailable() {
        try {
            Sys.getLicenseManager().checkFeature(VENDOR, VIDEO_FEATURE);
            Sys.loadModule((String)VIDEO_FEATURE);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isThreatAvailable() {
        return BEnterpriseSecurityService.isThreatAvailable(null);
    }

    public static boolean isThreatAvailable(Context cx) {
        try {
            String limit = Sys.getLicenseManager().checkFeature(VENDOR, ENTSEC_FEATURE).get(THREAT_ATTRIBUTE);
            if (limit == null) {
                return false;
            }
            if (cx != null) {
                BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)TYPE);
                return service.getThreatLevelGroups().getPermissions(cx).hasAdminRead();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isPhotoIDAvailable() {
        return BEnterpriseSecurityService.isPhotoIDAvailable(null);
    }

    public static boolean isPhotoIDAvailable(Context cx) {
        try {
            if (!BPhotoIDNetwork.isOrionAvailable()) {
                return false;
            }
            if (cx != null) {
                BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
                network.getLicenseFeature().check();
                return network.getPermissions(cx).hasAdminRead();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void threatReplicationRequired() {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)TYPE);
        service.getThreatLevelSetup().setThreatReplicationRequired(true);
    }

    public static BString format(BObject target, BString propertyNameInTarget) {
        if (propertyNameInTarget.toString().indexOf(".") == -1) {
            return BString.make((String)BFormat.format((String)target.asComplex().get(propertyNameInTarget.toString()).toString(), (Object)target));
        }
        String[] split = TextUtil.split((String)propertyNameInTarget.toString(), (char)'.');
        BObject parent = target;
        BValue value = null;
        for (int i = 0; i < split.length; ++i) {
            value = parent instanceof BComplex ? parent.asComplex().get(split[i]) : (BValue)((BFacets)parent).get(split[i]);
            if (!(value instanceof BComplex) && !(value instanceof BFacets)) continue;
            parent = value;
        }
        return BString.make((String)BFormat.format((String)value.toString(), (Object)target));
    }

    public BIcon getIcon() {
        return icon;
    }

    public String getDisplayName(Slot slot, Context cx) {
        String displayName = super.getDisplayName(slot, cx);
        if (slot == stationsQuery) {
            Lexicon lex = Lexicon.make((String)TYPE.getModule().getModuleName(), (Context)cx);
            return lex.get("stationView.title", displayName);
        }
        return displayName;
    }

    public BPermissionsMap getPermissionsMap(BUser user, BIProtected target) {
        return null;
    }

    public void doRebuildDefaultNav() {
        this.nav.buildDefaultNav();
    }

    public void doSaveDefaultNav() {
        try {
            BEntsecNavFile.create(new FilePath("^nav/defaultNav.enav"), this.nav.getDefaultNavTree());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public EntsecNavTree getNavTree(BUser user) throws Exception {
        return this.nav.getDefaultNavTree();
    }

    public String getStationDisplayName(Context cx) {
        BStation station = Sys.getStation();
        BValue nameFormat = station.get("displayName");
        if (nameFormat == null || !(nameFormat instanceof BFormat)) {
            return station.getStationName();
        }
        String displayName = ((BFormat)nameFormat).format((Object)station, cx);
        if (displayName.length() == 0) {
            return station.getStationName();
        }
        return displayName;
    }

    public String getSystemName(Context cx) {
        Property sysNameProp = this.getProperty("systemName");
        if (sysNameProp == null) {
            return "";
        }
        return ((BFormat)this.get(sysNameProp)).format((Object)this, cx);
    }

    public BrandingManager getBrandingManager() {
        return this.brandingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BINiagaraStation getSupervisor() {
        BTypeSpec serviceType = this.getType().getTypeSpec();
        BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BINiagaraStation mySuper = null;
        try (SysDefSession sysDef = nn.createSysDefSession(null);){
            BINiagaraStation me = sysDef.getLocalStation();
            BINiagaraStation[] supers = sysDef.getSupervisors(me);
            for (int i = 0; i < supers.length; ++i) {
                BINiagaraStation asuper = supers[i];
                Array services = sysDef.getServices(asuper);
                if (!services.contains((Object)serviceType)) continue;
                mySuper = asuper;
                break;
            }
        }
        return mySuper;
    }

    public String getSupervisorUrl() {
        BProviderStation supervisor = (BProviderStation)this.getSupervisor();
        if (supervisor == null) {
            return null;
        }
        StringBuffer url = new StringBuffer(128);
        url.append("http://").append(supervisor.getAddress());
        if (supervisor.getHttpPort() != 80) {
            url.append(":").append(supervisor.getHttpPort());
        }
        url.append("/ord?entsecnav:/");
        return url.toString();
    }

    public BValue getActionParameterDefault(Action action) {
        if (action == restoreDefaultUserPermissions) {
            return BEntsecUserPermissionsInfo.makeAutoLoad(this.getSession());
        }
        return super.getActionParameterDefault(action);
    }

    public void doClearUserPermissions(BEntsecUserPermissionsInfo info, Context cx) {
        try {
            UserPermissionsCodec codec = new UserPermissionsCodec(info);
            codec.clear(cx);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
    }

    public void doSaveUserPermissions(BEntsecUserPermissionsInfo info, Context cx) {
        OutputStream out = null;
        try {
            String fileName = info.getFileName();
            BIFile outFile = BFileSystem.INSTANCE.makeFile(new FilePath("^" + fileName));
            out = outFile.getOutputStream();
            UserPermissionsCodec codec = new UserPermissionsCodec(info);
            codec.save(out);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BajaRuntimeException((Throwable)ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadUserPermissions(BEntsecUserPermissionsInfo info, Context cx) {
        InputStream in = null;
        try {
            String fileName = info.getFileName();
            BIFile inFile = BFileSystem.INSTANCE.makeFile(new FilePath("^" + fileName));
            in = inFile.getInputStream();
            UserPermissionsCodec codec = new UserPermissionsCodec(info);
            codec.load(in, cx);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void doRestoreDefaultUserPermissions(BEntsecUserPermissionsInfo info, Context cx) {
        LOG.info("Restoring Default User Permissions:" + info.getSummary(cx));
        Object in = null;
        try {
            UserPermissionsCodec codec = new UserPermissionsCodec(info);
            codec.load(this.brandingManager.getDefaultUserPermissionsOrdList(), cx);
            LOG.fine("Restoring Default User Permissions complete.");
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Problem Restoring Default User Permissions:", ex);
        }
    }

    public static boolean isWorkstation() {
        if (Sys.getStation() == null) {
            return Nre.getHostModel().equals("Workstation");
        }
        return Nre.getHostModel().equals("Workstation") && !Boolean.getBoolean("entsec.simulateController." + Sys.getStation().getStationName());
    }

    public void setSqlServerExtraConnectionParameters() {
        BObject o = null;
        try {
            o = BOrd.make((String)("station:|" + this.getDbOrd())).get();
        }
        catch (Exception e) {
            return;
        }
        try {
            if (o.getType().getTypeSpec().equals((Object)BTypeSpec.make((String)"rdbSqlServer:SqlServerDatabase"))) {
                BString extra = (BString)o.asComponent().get("extraConnectionProperties");
                String[] split = TextUtil.split((String)extra.toString(), (char)';');
                boolean autoReconnectFound = false;
                boolean stringIndex = false;
                for (int i = 0; i < split.length; ++i) {
                    if (split[i].length() == 0) continue;
                    String key = TextUtil.split((String)split[i], (char)'=')[0];
                    if (key.equals("autoreconnect")) {
                        autoReconnectFound = true;
                        continue;
                    }
                    if (!key.equals("sendStringParametersAsUnicode")) continue;
                    stringIndex = true;
                }
                if (!autoReconnectFound || !stringIndex) {
                    StringBuffer b = new StringBuffer(extra.toString());
                    if (!autoReconnectFound) {
                        if (b.length() > 0 && !b.substring(b.length() - 1).equals(";")) {
                            b.append(";");
                        }
                        b.append("autoreconnect=true");
                    }
                    if (!stringIndex) {
                        if (b.length() > 0 && !b.substring(b.length() - 1).equals(";")) {
                            b.append(";");
                        }
                        b.append("sendStringParametersAsUnicode=false");
                    }
                    o.asComponent().set("extraConnectionProperties", (BValue)BString.make((String)b.toString()));
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Cannot set SqlServerExtraConnectionParameters", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAndUpdatePinNumbers(Class<?> clazz, Context cx) {
        String selectQuery = null;
        String updateQuery = null;
        String updateQueryToSetNull = null;
        String tableName = null;
        String pinNumberColName = null;
        String primaryKeyColName = null;
        HashMap map = new HashMap();
        Array<Property> array = null;
        boolean isException = false;
        OrionSession session = null;
        try {
            session = this.createSession(cx);
            session.setAutoCommit(false);
            if (clazz.equals(BIntrusionPin.class)) {
                tableName = session.getOrionDatabase().getTableName(BIntrusionPin.ORION_TYPE);
                pinNumberColName = session.getOrionDatabase().getColumnName(BIntrusionPin.ORION_TYPE, BIntrusionPin.pinNumber);
                primaryKeyColName = session.getOrionDatabase().getColumnName(BIntrusionPin.ORION_TYPE, BIntrusionPin.intrusionPinId);
                array = this.getSpecificTypeArray(BIntrusionPin.class, cx);
            } else if (clazz.equals(BPerson.class)) {
                tableName = session.getOrionDatabase().getTableName(BPerson.ORION_TYPE);
                pinNumberColName = session.getOrionDatabase().getColumnName(BPerson.ORION_TYPE, BPerson.pinNumber);
                primaryKeyColName = session.getOrionDatabase().getColumnName(BPerson.ORION_TYPE, BPerson.personId);
                array = this.getSpecificTypeArray(BPerson.class, cx);
            }
            updateQuery = "update " + tableName + " set " + pinNumberColName + "=? where " + primaryKeyColName + "=?";
            updateQueryToSetNull = "update " + tableName + " set " + pinNumberColName + "=NULL where " + primaryKeyColName + "=?";
            String[] strArray = null;
            selectQuery = "select " + primaryKeyColName + "," + pinNumberColName + " from " + tableName + " where " + pinNumberColName + " IS NOT NULL";
            OrionCursor cursor = session.select((OrionType)DynamicOrionType.makeTemporary((Property[])((Property[])array.trim())), selectQuery);
            while (cursor.next()) {
                BDynamicOrionObject obj = (BDynamicOrionObject)cursor.get();
                Property[] prop = obj.getOrionType().getProperties();
                strArray = new String[2];
                for (int j = 0; j < prop.length; ++j) {
                    DynamicOrionProperty property = (DynamicOrionProperty)prop[j];
                    if (primaryKeyColName.equals(property.getName())) {
                        strArray[0] = obj.get((Property)property).asValue().toString();
                    } else if (pinNumberColName.equals(property.getName())) {
                        strArray[1] = obj.get((Property)property).asValue().toString();
                    }
                    if (j != prop.length - 1) continue;
                    if (map.get(tableName) == null) {
                        map.put(tableName, new ArrayList());
                    }
                    ((List)map.get(tableName)).add(strArray);
                }
            }
            List updList = (List)map.get(tableName);
            if (updList != null) {
                AesSysKeyEncoder encoder = this.getOrionDatabase().getRdbms().getEncoder();
                for (int i = 0; i < updList.size(); ++i) {
                    strArray = (String[])updList.get(i);
                    try {
                        if (strArray[1].indexOf(58) != -1) {
                            LOG.log(Level.FINE, "The pin number is already encrypted. ");
                            continue;
                        }
                        if (strArray[1].length() == 0 && clazz.equals(BPerson.class)) {
                            session.update(updateQueryToSetNull, new BSimple[]{BUuid.make((String)strArray[0])});
                            continue;
                        }
                        if (strArray[1].length() == 0 && clazz.equals(BIntrusionPin.class)) {
                            session.update(updateQuery, new BSimple[]{BString.make((String)encoder.encrypt("0")), BUuid.make((String)strArray[0])});
                            continue;
                        }
                        session.update(updateQuery, new BSimple[]{BString.make((String)encoder.encrypt(strArray[1])), BUuid.make((String)strArray[0])});
                        continue;
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Encryption failed. ", e);
                        isException = true;
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Encryption failed. ", e);
            isException = true;
        }
        finally {
            if (isException) {
                session.rollback();
            } else {
                session.commit();
            }
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    private Map<String, List<String[]>> getAllPins(Class<?> clazz, OrionSession session, OrionType type, Property pinNumber, Property primaryKey) throws Exception {
        HashMap<String, List<String[]>> mainMap = new HashMap<String, List<String[]>>();
        String primaryKeyColName = session.getOrionDatabase().getColumnName(type, primaryKey);
        String tableName = session.getOrionDatabase().getTableName(type);
        String pinNumberColName = session.getOrionDatabase().getColumnName(type, pinNumber);
        String moduleName = type.getModule().getModuleName();
        AesSysKeyEncoder aes = this.getOrionDatabase().getRdbms().getEncoder();
        String[] strArray = null;
        LinkedHashMap<BUuid, PersonCacheData> personMap = new LinkedHashMap<BUuid, PersonCacheData>();
        if (!BEnterpriseSecurityService.isWorkstation() && clazz.equals(BPerson.class)) {
            personMap.putAll(PersonCache.getPersonsMap());
            for (Map.Entry entry : personMap.entrySet()) {
                BUuid personUuid = (BUuid)entry.getKey();
                PersonCacheData data = (PersonCacheData)entry.getValue();
                String pinNumberText = data.getPinNumberAsText();
                if ("".equals(pinNumberText)) continue;
                strArray = new String[]{personUuid.encodeToString(), pinNumberText};
                if (mainMap.get(tableName) == null) {
                    mainMap.put(tableName, new ArrayList());
                }
                ((List)mainMap.get(tableName)).add(strArray);
            }
            personMap.clear();
        } else {
            Array<Property> array = this.getSpecificTypeArray(clazz, (Context)session);
            String selectQuery = "select " + primaryKeyColName + "," + pinNumberColName + " from " + tableName + " where " + pinNumberColName + " IS NOT NULL";
            OrionCursor cursor = session.select((OrionType)DynamicOrionType.makeTemporary((Property[])((Property[])array.trim())), selectQuery);
            while (cursor.next()) {
                BDynamicOrionObject obj = (BDynamicOrionObject)cursor.get();
                Property[] prop = obj.getOrionType().getProperties();
                strArray = new String[2];
                for (int j = 0; j < prop.length; ++j) {
                    DynamicOrionProperty property = (DynamicOrionProperty)prop[j];
                    if (!property.getName().equals(pinNumberColName) && !property.getName().equals(primaryKeyColName)) continue;
                    if (property.getName().equals(pinNumberColName)) {
                        String encryptedPin = obj.get((Property)property).asValue().toString();
                        strArray[1] = encryptedPin != null && encryptedPin.startsWith(moduleName) ? aes.decrypt(encryptedPin.substring(moduleName.length() + 1)) : aes.decrypt(encryptedPin);
                    } else {
                        strArray[0] = ((BUuid)obj.get((Property)property)).encodeToString();
                    }
                    if (j != prop.length - 1) continue;
                    if (mainMap.get(tableName) == null) {
                        mainMap.put(tableName, new ArrayList());
                    }
                    ((List)mainMap.get(tableName)).add(strArray);
                }
            }
        }
        return mainMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reEncryptPinNumbers(Context cx, String newPassKey) throws Exception {
        boolean isException = false;
        OrionSession session = null;
        try {
            session = this.createSession(cx);
            session.setAutoCommit(false);
            Map<String, List<String[]>> pinMap = this.getAllPins(BIntrusionPin.class, session, BIntrusionPin.ORION_TYPE, BIntrusionPin.pinNumber, BIntrusionPin.intrusionPinId);
            pinMap.putAll(this.getAllPins(BPerson.class, session, BPerson.ORION_TYPE, BPerson.pinNumber, BPerson.personId));
            List<String[]> intList = null;
            Class[] classArray = new Class[]{BPerson.class, BIntrusionPin.class};
            String pinNumColName = null;
            String primaryKeyColName = null;
            String tableName = null;
            AesSysKeyEncoder aes = session.getOrionDatabase().getRdbms().getEncoder();
            BPassword newPasskey1 = BPassword.make((String)newPassKey);
            session.getOrionDatabase().getRdbms().getRdbSecuritySettings().changeSecretKey(newPasskey1);
            for (int classIndex = 0; classIndex < classArray.length; ++classIndex) {
                if (classArray[classIndex].equals(BPerson.class)) {
                    primaryKeyColName = session.getOrionDatabase().getColumnName(BPerson.ORION_TYPE, BPerson.personId);
                    pinNumColName = session.getOrionDatabase().getColumnName(BPerson.ORION_TYPE, BPerson.pinNumber);
                    tableName = session.getOrionDatabase().getTableName(BPerson.ORION_TYPE);
                } else if (classArray[classIndex].equals(BIntrusionPin.class)) {
                    primaryKeyColName = session.getOrionDatabase().getColumnName(BIntrusionPin.ORION_TYPE, BIntrusionPin.intrusionPinId);
                    pinNumColName = session.getOrionDatabase().getColumnName(BIntrusionPin.ORION_TYPE, BIntrusionPin.pinNumber);
                    tableName = session.getOrionDatabase().getTableName(BIntrusionPin.ORION_TYPE);
                }
                intList = pinMap.get(tableName);
                String updateQuery = "update " + tableName + " set " + pinNumColName + "=? where " + primaryKeyColName + "=?";
                if (intList == null) continue;
                String[] strArray = null;
                for (int i = 0; i < intList.size(); ++i) {
                    strArray = intList.get(i);
                    session.update(updateQuery, new BSimple[]{BString.make((String)aes.encrypt(strArray[1])), BUuid.make((String)strArray[0])});
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error while re-encryption", e);
            isException = true;
        }
        finally {
            if (isException) {
                this.getOrionDatabase().getRdbms().getRdbSecuritySettings().changeSecretKey(this.getOrionDatabase().getRdbms().getRdbSecuritySettings().getPasskey());
                session.rollback();
            } else {
                this.getOrionDatabase().getRdbms().getRdbSecuritySettings().setPasskey(BPassword.make((String)newPassKey));
                this.setModifiedPassKey(BPassword.DEFAULT);
                session.commit();
            }
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public void doChangeOfPasskey(BPassword passKey) {
        this.setModifiedPassKey(passKey);
        ((BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE)).restartStation();
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 501: {
                return LicenseCounter.checkLicenseLimit(this.getLicenseFeature(), (String)a);
            }
            case 503: {
                return new Integer(LicenseCounter.getLicenseCount(this.getLicenseFeature(), (String)a));
            }
        }
        return super.fw(x, a, b, c, d);
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        LicenseCounter.spy(out);
    }

    public boolean isInvalidPinsJobCancelled() {
        return this.isInvalidPinsJobCancelled;
    }

    public boolean isReEncryptJobCancelled() {
        return this.isReEncryptJobCancelled;
    }

    static {
        BFoxChannelRegistry.getPrototype().add("alarmClassSync", (BValue)new BAlarmClassSyncChannel());
        BFoxChannelRegistry.getPrototype().add("consolidatedData", (BValue)new BConsolidatedDataChannel());
        VERSION_1_2 = BSchemaVersion.make((String)"1.2");
        VERSION_1_1 = BSchemaVersion.make((String)"1.1");
        VERSION_1_0 = BSchemaVersion.make((String)"1.0");
        CURRENT_VERSION = VERSION_1_2;
        VERSION = BSchemaVersion.make((String)"1.0");
        LOG = Logger.getLogger("entsec");
        lex = Lexicon.make((String)"entsec");
        TEMP_DIR = BOrd.make((String)"file:^temp");
    }

    private class AlarmClassFolderSubscriber
    extends Subscriber {
        private BEnterpriseSecurityService service;

        public AlarmClassFolderSubscriber(BEnterpriseSecurityService service) {
            this.service = service;
        }

        public void event(BComponentEvent event) {
            int eid = event.getId();
            BIAlarmClassFolder alarmClassFolder = this.getAlarmClassFolder(event);
            if (alarmClassFolder == null) {
                return;
            }
            try {
                switch (eid) {
                    case 3: {
                        if (!(event.getSourceComponent().get(event.getSlotName()) instanceof BAlarmClass)) break;
                        BAlarmClass alarmClass = (BAlarmClass)event.getSourceComponent().get(event.getSlotName());
                        String oldName = event.getValue().toString();
                        BEnterpriseSecurityService.this.fireAlarmClassEvent(BAlarmClassEvent.makeRenamed(alarmClass, oldName));
                        break;
                    }
                    case 1: {
                        if (!(event.getValue() instanceof BAlarmClass)) break;
                        BAlarmClass alarmClass = (BAlarmClass)((BComponent)alarmClassFolder).get(event.getSlotName());
                        BEnterpriseSecurityService.this.fireAlarmClassEvent(BAlarmClassEvent.makeAdded(alarmClass));
                        break;
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        private BIAlarmClassFolder getAlarmClassFolder(BComponentEvent event) {
            BComponent src = event.getSourceComponent();
            if (src instanceof BIAlarmClassFolder) {
                return (BIAlarmClassFolder)src;
            }
            return null;
        }

        public void unsubscribeTree(BComponent root) {
            this.unsubscribe(root);
            SlotCursor c = root.getProperties();
            while (c.nextComponent()) {
                this.unsubscribeTree((BComponent)c.get());
            }
        }
    }
}

