/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.report;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraStation;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.fox.BFoxProxySession;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.report.BReport;
import javax.baja.report.BReportSource;
import javax.baja.security.BIUserCredentials;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

public class BRemoteBqlReport
extends BReportSource {
    public static final Property reportName = BRemoteBqlReport.newProperty((int)256, (BValue)BFormat.make((String)"%componentSpace.rootComponent.stationName%_%name%"), null);
    public static final Property reportHeader = BRemoteBqlReport.newProperty((int)256, (BValue)BFormat.make((String)"Report from %componentSpace.rootComponent.stationName%\n%time()%"), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property stationQuery = BRemoteBqlReport.newProperty((int)256, (BValue)BOrd.make((String)"station:|slot:/Drivers/NiagaraNetwork|bql:select * from niagaraDriver:NiagaraStation"), null);
    public static final Property remoteQuery = BRemoteBqlReport.newProperty((int)256, (BValue)BOrd.make((String)"station:|slot:/|bql:select name as 'Point',valueWithFacets as 'Value' from control:ControlPoint"), null);
    public static final Property lastExecutionTime = BRemoteBqlReport.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property faultCause = BRemoteBqlReport.newProperty((int)1, (String)"", null);
    public static final Property status = BRemoteBqlReport.newProperty((int)1, (BValue)BStatus.ok, null);
    public static final Type TYPE = Sys.loadType(BRemoteBqlReport.class);
    private ByteArrayOutputStream byteStream;
    private PrintStream out;
    private boolean first = true;
    private BNiagaraStation[] stations = null;
    private HashMap failed = new HashMap();
    private BITable result = null;
    private TableCursor c = null;
    Context[] colCx = null;
    boolean[] quote = null;
    int bqlColCount = -1;
    Column[] bqlCols = null;
    String[] bqlColNames = null;
    String[] bqlColLabels = null;

    public BFormat getReportName() {
        return (BFormat)this.get(reportName);
    }

    public void setReportName(BFormat v) {
        this.set(reportName, (BValue)v, null);
    }

    public BFormat getReportHeader() {
        return (BFormat)this.get(reportHeader);
    }

    public void setReportHeader(BFormat v) {
        this.set(reportHeader, (BValue)v, null);
    }

    public BOrd getStationQuery() {
        return (BOrd)this.get(stationQuery);
    }

    public void setStationQuery(BOrd v) {
        this.set(stationQuery, (BValue)v, null);
    }

    public BOrd getRemoteQuery() {
        return (BOrd)this.get(remoteQuery);
    }

    public void setRemoteQuery(BOrd v) {
        this.set(remoteQuery, (BValue)v, null);
    }

    public BAbsTime getLastExecutionTime() {
        return (BAbsTime)this.get(lastExecutionTime);
    }

    public void setLastExecutionTime(BAbsTime v) {
        this.set(lastExecutionTime, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BReport handleGenerate() throws Exception {
        if (!this.isRunning()) {
            return null;
        }
        this.failed.clear();
        this.first = true;
        StringBuffer sb = new StringBuffer();
        this.setLastExecutionTime(Clock.time());
        try {
            this.byteStream = new ByteArrayOutputStream();
            this.out = new PrintStream(this.byteStream);
            String[] headers = TextUtil.splitAndTrim((String)this.getReportHeader().toString(), (char)'\n');
            for (int i = 0; i < headers.length; ++i) {
                BFormat p = BFormat.make((String)headers[i]);
                String s = SlotPath.unescape((String)SlotPath.escape((String)SlotPath.unescape((String)p.format((Object)this))));
                this.out.println(s);
            }
            this.out.println("");
            BNiagaraStation station = null;
            BITable stationList = (BITable)this.getStationQuery().resolve().get();
            TableCursor cursor = stationList.cursor();
            while (cursor.next()) {
                station = (BNiagaraStation)cursor.get();
                if (!station.getStatus().isDisabled() && !station.getStatus().isDown()) {
                    BFoxClientConnection clientConnection = station.getClientConnection();
                    BFoxProxySession session = BFoxProxySession.make((BHost)station.getRemoteHost(), (int)clientConnection.getPort(), (boolean)clientConnection.getUseFoxs(), (BIUserCredentials)clientConnection.getCredentials());
                    String interest = "int" + Clock.time().getMillis();
                    if (session == null) continue;
                    try {
                        session.engageNoRetry(interest);
                        this.result = (BITable)this.getRemoteQuery().resolve((BObject)session).get();
                        if (this.result != null) {
                            int j;
                            this.bqlColCount = this.result.getColumns().size();
                            this.bqlCols = new Column[this.bqlColCount];
                            for (j = 0; j < this.bqlColCount; ++j) {
                                this.bqlCols[j] = this.result.getColumns().get(j);
                            }
                            this.colCx = new Context[this.bqlColCount];
                            this.bqlColNames = new String[this.bqlColCount];
                            this.bqlColLabels = new String[this.bqlColCount];
                            this.quote = new boolean[this.bqlColCount];
                            for (j = 0; j < this.bqlColCount; ++j) {
                                this.colCx[j] = new BasicContext((Context)Sys.getStation().getSysInfo(), this.bqlCols[j].getFacets());
                                Type type = this.bqlCols[j].getType();
                                this.quote[j] = !type.is(BNumber.TYPE) && !type.is(BBoolean.TYPE) && !type.is(BRelTime.TYPE) && !type.is(BAbsTime.TYPE);
                                this.bqlColNames[j] = this.bqlCols[j].getName();
                                this.bqlColLabels[j] = this.bqlCols[j].getDisplayName(null);
                            }
                            if (this.first) {
                                this.first = false;
                                this.out.print("station");
                                for (j = 0; j < this.bqlColCount; ++j) {
                                    String name = this.bqlColLabels[j].trim();
                                    name = name.replace(',', '_');
                                    name = name.replace('\"', '\'');
                                    this.out.print(",");
                                    this.out.print(name);
                                }
                                this.out.print(",fault cause");
                                this.out.print("\n");
                                if (this.failed.size() > 0) {
                                    for (Object key : this.failed.keySet()) {
                                        Object value = this.failed.get(key);
                                        this.out.print(key.toString());
                                        for (int k = 0; k <= this.bqlColCount; ++k) {
                                            this.out.print(",");
                                        }
                                        this.out.print('\"');
                                        this.out.print(value.toString());
                                        this.out.print('\"');
                                        this.out.print('\n');
                                    }
                                }
                            }
                            this.c = this.result.cursor();
                            while (this.c.next()) {
                                this.out.print(station.getStationName());
                                for (int j2 = 0; j2 < this.bqlColCount; ++j2) {
                                    BObject cell = (BObject)this.c.cell(this.bqlCols[j2]);
                                    Type type = cell.getType();
                                    String text = cell.isSimple() && type != BAbsTime.TYPE && !type.is(BNumber.TYPE) && !type.is(BStatus.TYPE) && !type.is(BRelTime.TYPE) ? ((BSimple)cell).encodeToString() : cell.toString((Context)new BasicContext(this.colCx[j2], BFacets.make((String)"showUnits", (BIDataValue)BBoolean.FALSE)));
                                    this.out.print(',');
                                    if (this.quote[j2]) {
                                        this.out.print('\"');
                                        this.out.print(TextUtil.replace((String)text, (String)"\"", (String)"\"\""));
                                        this.out.print('\"');
                                        continue;
                                    }
                                    this.out.print(text);
                                }
                                this.out.print("\n");
                            }
                            continue;
                        }
                        this.out.print(station.getStationName());
                        for (int j = 0; j <= this.bqlColCount; ++j) {
                            this.out.print(",");
                        }
                        this.out.print("bql query didn't return any results for this station");
                        this.out.print('\n');
                        sb.append("bql query didn't return any results\n");
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println(this.getSlotPath());
                        e.printStackTrace();
                        if (this.first) {
                            this.failed.put(station.getStationName(), e);
                            continue;
                        }
                        this.out.print(station.getStationName());
                        for (int j = 0; j <= this.bqlColCount; ++j) {
                            this.out.print(",");
                        }
                        this.out.print(e);
                        this.out.print('\n');
                        continue;
                    }
                    finally {
                        session.close();
                        continue;
                    }
                }
                if (this.first) {
                    this.failed.put(station.getStationName(), "station status is " + station.getStatus());
                    continue;
                }
                this.out.print(station.getStationName());
                for (int j = 0; j <= this.bqlColCount; ++j) {
                    this.out.print(",");
                }
                this.out.print('\"');
                this.out.print("station status is " + station.getStatus());
                this.out.print('\"');
                this.out.print('\n');
            }
        }
        catch (Exception e) {
            System.out.println(this.getSlotPath());
            e.printStackTrace();
        }
        finally {
            if (this.first && this.failed.size() > 0) {
                this.out.print("station,fault");
                this.out.print('\n');
                for (Object key : this.failed.keySet()) {
                    Object value = this.failed.get(key);
                    this.out.print(key.toString());
                    this.out.print(",");
                    this.out.print('\"');
                    this.out.print(value.toString());
                    this.out.print('\"');
                    this.out.print('\n');
                }
            }
            this.out.close();
        }
        String faults = sb.toString();
        if (faults.length() > 0) {
            this.setFaultCause(faults);
            this.setStatus(BStatus.fault);
        } else {
            this.setFaultCause("");
            this.setStatus(BStatus.ok);
        }
        String fileName = this.resolveReportName();
        return new BReport(fileName, fileName + ".csv", "text/csv", this.byteStream.toByteArray());
    }

    private String resolveReportName() {
        BFormat pattern = this.getReportName();
        String s = SlotPath.escape((String)SlotPath.unescape((String)pattern.format((Object)this)));
        return s.trim();
    }
}

