/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.report;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.report.BReport;
import javax.baja.report.BReportSource;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFormat;
import javax.baja.util.BUuid;

public class BAlarmQueryToCsv
extends BReportSource {
    public static final Property reportName = BAlarmQueryToCsv.newProperty((int)256, (BValue)BFormat.make((String)"%componentSpace.rootComponent.stationName%_%parent.name%"), null);
    public static final Property reportHeader = BAlarmQueryToCsv.newProperty((int)256, (BValue)BFormat.make((String)"Alarm report from %componentSpace.rootComponent.stationName%\n%time()%"), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property alarmQuery = BAlarmQueryToCsv.newProperty((int)256, (String)"select timestamp,alarmData.msgText where timestamp in bqltime.weektodate", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE, (String)"fieldWidth", (BIDataValue)BInteger.make((int)120)));
    public static final Property lastExecutionTime = BAlarmQueryToCsv.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property faultCause = BAlarmQueryToCsv.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE, (String)"fieldWidth", (BIDataValue)BInteger.make((int)120)));
    public static final Property status = BAlarmQueryToCsv.newProperty((int)1, (BValue)BStatus.ok, null);
    public static final Type TYPE = Sys.loadType(BAlarmQueryToCsv.class);
    private ByteArrayOutputStream byteStream;
    private PrintStream out;
    private boolean stripUuid = false;
    private boolean firstCol = true;
    private BITable result = null;
    private TableCursor c = null;
    Context[] colCx = null;
    boolean[] quote = null;
    int bqlColCount = -1;
    int uuidCol = -1;
    Column[] bqlCols = null;
    String[] bqlColNames = null;
    String[] bqlColLabels = null;

    public BFormat getReportName() {
        return (BFormat)this.get(reportName);
    }

    public void setReportName(BFormat v) {
        this.set(reportName, (BValue)v, null);
    }

    public BFormat getReportHeader() {
        return (BFormat)this.get(reportHeader);
    }

    public void setReportHeader(BFormat v) {
        this.set(reportHeader, (BValue)v, null);
    }

    public String getAlarmQuery() {
        return this.getString(alarmQuery);
    }

    public void setAlarmQuery(String v) {
        this.setString(alarmQuery, v, null);
    }

    public BAbsTime getLastExecutionTime() {
        return (BAbsTime)this.get(lastExecutionTime);
    }

    public void setLastExecutionTime(BAbsTime v) {
        this.set(lastExecutionTime, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BReport handleGenerate() throws Exception {
        if (!this.isRunning()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        this.setLastExecutionTime(Clock.time());
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        try (AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);){
            int j;
            this.byteStream = new ByteArrayOutputStream();
            this.out = new PrintStream(this.byteStream);
            this.out.write(239);
            this.out.write(187);
            this.out.write(191);
            this.out.print('\n');
            String[] headers = TextUtil.splitAndTrim((String)this.getReportHeader().toString(), (char)'\n');
            for (int i = 0; i < headers.length; ++i) {
                BFormat p = BFormat.make((String)headers[i]);
                String s = SlotPath.unescape((String)SlotPath.escape((String)SlotPath.unescape((String)p.format((Object)this))));
                this.out.println(s);
            }
            this.out.println("");
            String select = this.getAlarmQuery();
            select = select.replace('\n', ' ');
            String selectTest = select.toLowerCase();
            if (!selectTest.startsWith("select *")) {
                if (selectTest.toLowerCase().startsWith("select")) {
                    if (selectTest.toLowerCase().indexOf("uuid") <= -1) {
                        select = "select uuid," + select.substring(select.indexOf("select") + 6);
                        this.stripUuid = true;
                    }
                } else {
                    sb.append("enter a properly formatted select statement");
                }
            }
            StringBuffer q = new StringBuffer();
            q.append("alarm:/|bql:");
            q.append(select.toString());
            BOrd aqOrd = BOrd.make((String)q.toString());
            this.result = (BITable)aqOrd.resolve((BObject)this).get();
            this.bqlColCount = this.result.getColumns().size();
            this.bqlCols = new Column[this.bqlColCount];
            for (j = 0; j < this.bqlColCount; ++j) {
                this.bqlCols[j] = this.result.getColumns().get(j);
            }
            this.colCx = new Context[this.bqlColCount];
            this.bqlColNames = new String[this.bqlColCount];
            this.bqlColLabels = new String[this.bqlColCount];
            this.quote = new boolean[this.bqlColCount];
            this.firstCol = true;
            for (j = 0; j < this.bqlColCount; ++j) {
                String dname;
                this.colCx[j] = new BasicContext((Context)Sys.getStation().getSysInfo(), this.bqlCols[j].getFacets());
                Type type = this.bqlCols[j].getType();
                this.quote[j] = !type.is(BNumber.TYPE) && !type.is(BBoolean.TYPE) && !type.is(BRelTime.TYPE) && !type.is(BAbsTime.TYPE);
                this.bqlColNames[j] = this.bqlCols[j].getName();
                this.bqlColLabels[j] = dname = this.bqlCols[j].getDisplayName(null);
                if (dname.equalsIgnoreCase("uuid")) {
                    this.uuidCol = j;
                }
                if (this.stripUuid && dname.equalsIgnoreCase("uuid")) continue;
                dname = dname.replace(',', '_');
                dname = dname.replace('\"', '\'');
                if (this.firstCol) {
                    this.firstCol = false;
                } else {
                    this.out.print(",");
                }
                this.out.print(dname);
            }
            this.out.print('\n');
            this.c = this.result.cursor();
            if (this.c.next()) {
                do {
                    boolean firstDataCol = true;
                    for (int j2 = 0; j2 < this.bqlColCount; ++j2) {
                        String text;
                        if (this.stripUuid && j2 == this.uuidCol) continue;
                        BObject cell = (BObject)this.c.cell(this.bqlCols[j2]);
                        if (cell instanceof BAbsTime) {
                            text = ((BAbsTime)cell).toString((Context)BFacets.make((String)"TimeZone", (BIDataValue)BTimeZone.getLocal()));
                        } else {
                            text = cell.toString((Context)new BasicContext(this.colCx[j2], BFacets.make((String)"showUnits", (BIDataValue)BBoolean.FALSE)));
                            if (text.indexOf("%") > -1) {
                                BUuid alarmId = (BUuid)BUuid.DEFAULT.decodeFromString(this.c.cell(this.bqlCols[this.uuidCol]).toString());
                                BAlarmRecord rec = conn.getRecord(alarmId);
                                String test = BFormat.make((String)SlotPath.unescape((String)cell.toString())).format((Object)rec).replace('\n', ' ');
                                if (!test.startsWith("ERROR")) {
                                    text = test;
                                }
                            }
                        }
                        if (firstDataCol) {
                            firstDataCol = false;
                        } else {
                            this.out.print(',');
                        }
                        if (this.quote[j2]) {
                            this.out.print('\"');
                            this.out.print(TextUtil.replace((String)text, (String)"\"", (String)"\"\""));
                            this.out.print('\"');
                            continue;
                        }
                        this.out.print(text);
                    }
                    this.out.print("\n");
                } while (this.c.next());
            } else {
                this.out.println("select statement did not return any results");
                sb.append("select statement did not return any results");
            }
        }
        catch (Exception e) {
            System.out.println(this.getSlotPath() + " , failed to generate report");
            e.printStackTrace();
            sb.append("failed to generate report");
        }
        finally {
            this.out.close();
            this.c.close();
        }
        String faults = sb.toString();
        if (faults.length() > 0) {
            this.setFaultCause(faults);
            this.setStatus(BStatus.fault);
        } else {
            this.setFaultCause("");
            this.setStatus(BStatus.ok);
        }
        String fileName = this.resolveReportName();
        return new BReport(fileName, fileName + ".csv", "text/csv", this.byteStream.toByteArray());
    }

    private String resolveReportName() {
        BFormat pattern = this.getReportName();
        String s = SlotPath.escape((String)SlotPath.unescape((String)pattern.format((Object)this)));
        return s.trim();
    }
}

