/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.history;

import com.tridium.bql.util.BDynamicTimeRange;
import com.vykon.vykonPro.util.BTimeOfDay;
import com.vykon.vykonPro.util.BVykonProService;
import java.io.IOException;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendFlags;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTimeRange;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BNumericHistoryCalc
extends BComponent {
    public static final Property status = BNumericHistoryCalc.newProperty((int)65, (BValue)BStatus.ok, null);
    public static final Property faultCause = BNumericHistoryCalc.newProperty((int)65, (String)"", null);
    public static final Property historyName = BNumericHistoryCalc.newProperty((int)256, (BValue)BFormat.make((String)"%componentSpace.rootComponent.stationName%/%parent.name%"), null);
    public static final Property history = BNumericHistoryCalc.newProperty((int)1, (BValue)BOrd.make((String)"history:/"), null);
    public static final Property deltaLogged = BNumericHistoryCalc.newProperty((int)320, (boolean)true, null);
    public static final Property useTimestamp = BNumericHistoryCalc.newProperty((int)320, (boolean)true, (BFacets)BFacets.makeBoolean((String)"first", (String)"last"));
    public static final Property excludeInvalidValues = BNumericHistoryCalc.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"exclude", (String)"include"));
    public static final Property excludeHiddenValues = BNumericHistoryCalc.newProperty((int)0, (boolean)true, (BFacets)BFacets.makeBoolean((String)"exclude", (String)"include"));
    public static final Property includeTimeOfDay = BNumericHistoryCalc.newProperty((int)256, (BValue)new BTimeOfDay(), null);
    public static final Property timeRange = BNumericHistoryCalc.newProperty((int)256, (BValue)BDynamicTimeRange.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:DynamicTimeRangeFE"));
    public static final Property facets = BNumericHistoryCalc.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    public static final Property total = BNumericHistoryCalc.newProperty((int)73, (BValue)new BStatusNumeric(), null);
    public static final Property average = BNumericHistoryCalc.newProperty((int)73, (BValue)new BStatusNumeric(), null);
    public static final Property maximum = BNumericHistoryCalc.newProperty((int)65, (BValue)new BStatusNumeric(), null);
    public static final Property maxTimestamp = BNumericHistoryCalc.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property minimum = BNumericHistoryCalc.newProperty((int)65, (BValue)new BStatusNumeric(), null);
    public static final Property minTimestamp = BNumericHistoryCalc.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property count = BNumericHistoryCalc.newProperty((int)65, (int)0, null);
    public static final Property calculating = BNumericHistoryCalc.newProperty((int)1, (boolean)false, null);
    public static final Property lastUpdateTime = BNumericHistoryCalc.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Action calculate = BNumericHistoryCalc.newAction((int)16, null);
    public static final Action reset = BNumericHistoryCalc.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BNumericHistoryCalc.class);
    private static final BIcon icon = BIcon.std((String)"historyDatabase.png");
    String deltaSyntax;
    String timeQuery;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BFormat getHistoryName() {
        return (BFormat)this.get(historyName);
    }

    public void setHistoryName(BFormat v) {
        this.set(historyName, (BValue)v, null);
    }

    public BOrd getHistory() {
        return (BOrd)this.get(history);
    }

    public void setHistory(BOrd v) {
        this.set(history, (BValue)v, null);
    }

    public boolean getDeltaLogged() {
        return this.getBoolean(deltaLogged);
    }

    public void setDeltaLogged(boolean v) {
        this.setBoolean(deltaLogged, v, null);
    }

    public boolean getUseTimestamp() {
        return this.getBoolean(useTimestamp);
    }

    public void setUseTimestamp(boolean v) {
        this.setBoolean(useTimestamp, v, null);
    }

    public boolean getExcludeInvalidValues() {
        return this.getBoolean(excludeInvalidValues);
    }

    public void setExcludeInvalidValues(boolean v) {
        this.setBoolean(excludeInvalidValues, v, null);
    }

    public boolean getExcludeHiddenValues() {
        return this.getBoolean(excludeHiddenValues);
    }

    public void setExcludeHiddenValues(boolean v) {
        this.setBoolean(excludeHiddenValues, v, null);
    }

    public BTimeOfDay getIncludeTimeOfDay() {
        return (BTimeOfDay)this.get(includeTimeOfDay);
    }

    public void setIncludeTimeOfDay(BTimeOfDay v) {
        this.set(includeTimeOfDay, (BValue)v, null);
    }

    public BDynamicTimeRange getTimeRange() {
        return (BDynamicTimeRange)this.get(timeRange);
    }

    public void setTimeRange(BDynamicTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BStatusNumeric getTotal() {
        return (BStatusNumeric)this.get(total);
    }

    public void setTotal(BStatusNumeric v) {
        this.set(total, (BValue)v, null);
    }

    public BStatusNumeric getAverage() {
        return (BStatusNumeric)this.get(average);
    }

    public void setAverage(BStatusNumeric v) {
        this.set(average, (BValue)v, null);
    }

    public BStatusNumeric getMaximum() {
        return (BStatusNumeric)this.get(maximum);
    }

    public void setMaximum(BStatusNumeric v) {
        this.set(maximum, (BValue)v, null);
    }

    public BAbsTime getMaxTimestamp() {
        return (BAbsTime)this.get(maxTimestamp);
    }

    public void setMaxTimestamp(BAbsTime v) {
        this.set(maxTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getMinimum() {
        return (BStatusNumeric)this.get(minimum);
    }

    public void setMinimum(BStatusNumeric v) {
        this.set(minimum, (BValue)v, null);
    }

    public BAbsTime getMinTimestamp() {
        return (BAbsTime)this.get(minTimestamp);
    }

    public void setMinTimestamp(BAbsTime v) {
        this.set(minTimestamp, (BValue)v, null);
    }

    public int getCount() {
        return this.getInt(count);
    }

    public void setCount(int v) {
        this.setInt(count, v, null);
    }

    public boolean getCalculating() {
        return this.getBoolean(calculating);
    }

    public void setCalculating(boolean v) {
        this.setBoolean(calculating, v, null);
    }

    public BAbsTime getLastUpdateTime() {
        return (BAbsTime)this.get(lastUpdateTime);
    }

    public void setLastUpdateTime(BAbsTime v) {
        this.set(lastUpdateTime, (BValue)v, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.checkForService();
    }

    private final void checkForService() {
        if (BVykonProService.getInstance() == null) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("This component requires the VykonPro service in the station");
        } else if (BVykonProService.getInstance().isDisabled()) {
            this.setStatus(BStatus.fault);
            this.setFaultCause("The vykonPro service is disabled");
        } else {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals(historyName) || property.equals(timeRange)) {
            this.reset();
            this.calculate();
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action == calculate) {
            return BVykonProService.getInstance().getWorker().post((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return super.post(action, arg, cx);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)maximum) || slot.equals((Object)minimum) || slot.equals((Object)average) || slot.equals((Object)total)) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void doCalculate() {
        if (!this.isRunning()) {
            return;
        }
        try {
            BOrd hord = BOrd.make((String)("history:/" + this.resolveHistoryName()));
            this.setHistory(hord);
            BIHistory history = (BIHistory)hord.resolve((BObject)this).get();
            BHistoryConfig config = history.getConfig();
            if (!(config.makeRecord() instanceof BINumeric)) {
                this.setStatus(BStatus.fault);
                this.setFaultCause("Must specify a valid numeric type history.");
                this.reset();
                return;
            }
            this.deltaSyntax = this.getDeltaLogged() ? ";delta=false;" : ";delta=true;";
            this.timeQuery = this.getTimeRange().toOrdParams();
            BOrd qord = BOrd.make((String)(hord + "?" + this.timeQuery + this.deltaSyntax + "|bql:select timestamp, trendFlags, status, value"));
            BITable result = (BITable)qord.resolve((BObject)this).get();
            this.setCalculating(true);
            ColumnList columns = result.getColumns();
            Column valueColumn = columns.get(3);
            Column statusColumn = columns.get(2);
            Column trendColumn = columns.get(1);
            Column tsColumn = columns.get(0);
            boolean useTimestamp = this.getUseTimestamp();
            boolean excInvalid = this.getExcludeInvalidValues();
            boolean excHidden = this.getExcludeHiddenValues();
            BAbsTime ts = BAbsTime.NULL;
            BStatus status = BStatus.nullStatus;
            BTrendFlags flags = null;
            BTimeRange tr = this.getIncludeTimeOfDay().getTimeRange();
            BAbsTime tsMin = BAbsTime.NULL;
            BAbsTime tsMax = BAbsTime.NULL;
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            double total = 0.0;
            int cnt = 0;
            double value = 0.0;
            try (TableCursor c = result.cursor();){
                while (c.next()) {
                    BDouble checkValue;
                    ts = (BAbsTime)c.cell(tsColumn);
                    value = ((BINumeric)c.cell(valueColumn)).getNumeric();
                    status = ((BStatus)c.cell(statusColumn)).getStatus();
                    flags = (BTrendFlags)c.cell(trendColumn);
                    if (excInvalid & !status.isValid() || excHidden & flags.getBit("hidden") || (checkValue = BDouble.make((double)value)) == BDouble.NaN || checkValue == BDouble.NEGATIVE_INFINITY || checkValue == BDouble.POSITIVE_INFINITY || !tr.includes(ts)) continue;
                    if (value < min || value == min && !useTimestamp) {
                        min = value;
                        tsMin = ts;
                    }
                    if (value > max || value == max && !useTimestamp) {
                        max = value;
                        tsMax = ts;
                    }
                    total += value;
                    ++cnt;
                }
            }
            if (cnt > 0) {
                this.getMinimum().setValue(min);
                this.setMinTimestamp(tsMin);
                this.getMaximum().setValue(max);
                this.setMaxTimestamp(tsMax);
                this.getTotal().setValue(total);
                this.getAverage().setValue(total / (double)cnt);
                this.setCount(cnt);
                this.setCalculating(false);
                this.setLastUpdateTime(Clock.time());
                this.setStatus(BStatus.ok);
                this.setFaultCause("");
            } else {
                this.reset();
                this.setCalculating(false);
                this.setStatus(BStatus.fault);
                this.setFaultCause("No records found for " + this.getHistory() + " for the configured timeOfDay");
            }
        }
        catch (Exception e) {
            this.reset();
            System.out.println(this.getSlotPath() + " - " + e);
            this.setCalculating(false);
            this.setStatus(BStatus.fault);
            this.setFaultCause("Failed to calcualte values. " + e.getMessage());
        }
    }

    public void doReset() {
        this.getMinimum().setValue(Double.POSITIVE_INFINITY);
        this.setMinTimestamp(BAbsTime.NULL);
        this.getMaximum().setValue(Double.NEGATIVE_INFINITY);
        this.setMaxTimestamp(BAbsTime.NULL);
        this.getTotal().setValue(Double.NaN);
        this.getAverage().setValue(Double.NaN);
        this.setCount(0);
    }

    private String resolveHistoryName() {
        BFormat pattern = this.getHistoryName();
        try {
            String p = pattern.encodeToString();
            if (p.indexOf("/") > -1) {
                int firstSlash = p.indexOf("/");
                BFormat station = BFormat.make((String)p.substring(0, firstSlash));
                BFormat history = BFormat.make((String)p.substring(firstSlash + 1));
                String s = SlotPath.escape((String)SlotPath.unescape((String)station.format((Object)this)));
                String h = SlotPath.escape((String)SlotPath.unescape((String)history.format((Object)this)));
                return s + "/" + h;
            }
            return p;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "couldn't resolve the historyName";
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

