/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.history;

import com.vykon.vykonPro.history.BBypassTimeRecord;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.history.ext.BActivePeriod;
import javax.baja.history.ext.BBasicActivePeriod;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;

public class BBypassLogger
extends BComponent {
    public static final Property status = BBypassLogger.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BBypassLogger.newProperty((int)3, (String)"", null);
    public static final Property enabled = BBypassLogger.newProperty((int)64, (boolean)false, null);
    public static final Property activePeriod = BBypassLogger.newProperty((int)0, (BValue)new BBasicActivePeriod(), null);
    public static final Property active = BBypassLogger.newProperty((int)3, (boolean)false, null);
    public static final Property historyName = BBypassLogger.newProperty((int)0, (BValue)BFormat.make((String)"%name%"), null);
    public static final Property historyConfig = BBypassLogger.newProperty((int)64, (BValue)new BHistoryConfig(), null);
    public static final Property elapsedTimeFacets = BBypassLogger.newProperty((int)64, (BValue)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE), null);
    public static final Property timestampFacets = BBypassLogger.newProperty((int)64, (BValue)BFacets.NULL, null);
    public static final Property bypassInput = BBypassLogger.newProperty((int)8, (BValue)new BStatusBoolean(), null);
    public static final Property lastInput = BBypassLogger.newProperty((int)5, (BValue)new BStatusBoolean(), null);
    public static final Property startTime = BBypassLogger.newProperty((int)5, (BValue)BAbsTime.NULL, null);
    public static final Property timestamp = BBypassLogger.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property timestampEnd = BBypassLogger.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property elapsedTime = BBypassLogger.newProperty((int)1, (BValue)BRelTime.make((long)0L), null);
    public static final Action appendRecord = BBypassLogger.newAction((int)4, null);
    public static final Action syncConfig = BBypassLogger.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BBypassLogger.class);
    long elapsedMillis;
    BRelTime elapTime;
    private static final String ELAPSED_TIME_FACETS = "elapsedTimeFacets";
    private static final String TIMESTAMP_END_FACETS = "timestampEndFacets";
    private static final String TIMESTAMP_FACETS = "timestampFacets";

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BActivePeriod getActivePeriod() {
        return (BActivePeriod)this.get(activePeriod);
    }

    public void setActivePeriod(BActivePeriod v) {
        this.set(activePeriod, (BValue)v, null);
    }

    public boolean getActive() {
        return this.getBoolean(active);
    }

    public void setActive(boolean v) {
        this.setBoolean(active, v, null);
    }

    public BFormat getHistoryName() {
        return (BFormat)this.get(historyName);
    }

    public void setHistoryName(BFormat v) {
        this.set(historyName, (BValue)v, null);
    }

    public BHistoryConfig getHistoryConfig() {
        return (BHistoryConfig)this.get(historyConfig);
    }

    public void setHistoryConfig(BHistoryConfig v) {
        this.set(historyConfig, (BValue)v, null);
    }

    public BFacets getElapsedTimeFacets() {
        return (BFacets)this.get(elapsedTimeFacets);
    }

    public void setElapsedTimeFacets(BFacets v) {
        this.set(elapsedTimeFacets, (BValue)v, null);
    }

    public BFacets getTimestampFacets() {
        return (BFacets)this.get(timestampFacets);
    }

    public void setTimestampFacets(BFacets v) {
        this.set(timestampFacets, (BValue)v, null);
    }

    public BStatusBoolean getBypassInput() {
        return (BStatusBoolean)this.get(bypassInput);
    }

    public void setBypassInput(BStatusBoolean v) {
        this.set(bypassInput, (BValue)v, null);
    }

    public BStatusBoolean getLastInput() {
        return (BStatusBoolean)this.get(lastInput);
    }

    public void setLastInput(BStatusBoolean v) {
        this.set(lastInput, (BValue)v, null);
    }

    public BAbsTime getStartTime() {
        return (BAbsTime)this.get(startTime);
    }

    public void setStartTime(BAbsTime v) {
        this.set(startTime, (BValue)v, null);
    }

    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    public void setTimestamp(BAbsTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    public BAbsTime getTimestampEnd() {
        return (BAbsTime)this.get(timestampEnd);
    }

    public void setTimestampEnd(BAbsTime v) {
        this.set(timestampEnd, (BValue)v, null);
    }

    public BRelTime getElapsedTime() {
        return (BRelTime)this.get(elapsedTime);
    }

    public void setElapsedTime(BRelTime v) {
        this.set(elapsedTime, (BValue)v, null);
    }

    public void appendRecord() {
        this.invoke(appendRecord, null, null);
    }

    public void syncConfig() {
        this.invoke(syncConfig, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.setActive(this.getActivePeriod().isActive(BAbsTime.make()));
        if (!this.getHistoryConfig().getTimeZone().equals((Object)BTimeZone.getLocal())) {
            this.getHistoryConfig().setTimeZone(BTimeZone.getLocal());
        }
    }

    public BOrd getSourceOrd() {
        BComponentSpace cs = this.getComponentSpace();
        if (cs == null) {
            return null;
        }
        BOrd base = cs.getOrdInSession();
        if (base == null) {
            return null;
        }
        return BOrd.make((BOrd)base, (BOrd)this.getSlotPathOrd());
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)elapsedTime)) {
            return this.getElapsedTimeFacets();
        }
        if (slot.equals((Object)timestamp) || slot.equals((Object)timestampEnd)) {
            return this.getTimestampFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void changed(Property p, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(enabled)) {
            if (this.getEnabled()) {
                BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
                if (localDb == null) {
                    System.out.println("Local history database not available.");
                    return;
                }
                try (HistoryDatabaseConnection conn = localDb.getDbConnection(null);){
                    BHistoryId id = BHistoryId.make((String)Sys.getStation().getStationName(), (String)this.resolveHistoryName());
                    if (!conn.exists(id)) {
                        this.createHistory();
                    }
                }
                catch (Exception e) {
                    System.out.println(this.getSlotPath() + " - error resolving history database connection");
                    e.printStackTrace();
                    return;
                }
                this.updateStatus();
            }
        } else if (p.equals(bypassInput)) {
            if (this.getBypassInput().getValue() && !this.getLastInput().getValue()) {
                this.setStartTime(BAbsTime.make());
                this.getLastInput().setValue(this.getBypassInput().getValue());
            } else if (!this.getBypassInput().getValue() && this.getLastInput().getValue()) {
                this.getLastInput().setValue(this.getBypassInput().getValue());
                this.appendRecord();
            }
        } else if (p.equals(activePeriod)) {
            this.setActive(this.getActivePeriod().isActive(BAbsTime.make()));
        } else if (p.equals(elapsedTimeFacets) || p.equals(timestampFacets)) {
            this.syncConfig();
        } else if (!p.equals(status) && !p.equals(faultCause)) {
            this.updateStatus();
        }
    }

    public void historyConfigChanged(BHistoryConfig config, Property p) {
        if (!this.isRunning()) {
            return;
        }
        if (config != this.getHistoryConfig()) {
            return;
        }
        this.syncConfig();
    }

    public synchronized void doSyncConfig() {
        if (this.getEnabled()) {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            BHistoryConfig config = this.getHistoryConfig();
            config.setTimeZone(BTimeZone.getLocal());
            BFacets f1 = (BFacets)config.get(ELAPSED_TIME_FACETS);
            if (f1 != null) {
                config.set(ELAPSED_TIME_FACETS, (BValue)BFacets.make((BFacets)this.getElapsedTimeFacets()));
            } else {
                config.add(ELAPSED_TIME_FACETS, (BValue)BFacets.make((BFacets)this.getElapsedTimeFacets()));
            }
            BFacets f2 = (BFacets)config.get(TIMESTAMP_END_FACETS);
            if (f2 != null) {
                config.set(TIMESTAMP_END_FACETS, (BValue)BFacets.make((BFacets)this.getTimestampFacets()));
            } else {
                config.add(TIMESTAMP_END_FACETS, (BValue)BFacets.make((BFacets)this.getTimestampFacets()));
            }
            BFacets f3 = (BFacets)config.get(TIMESTAMP_FACETS);
            if (f3 != null) {
                config.set(TIMESTAMP_FACETS, (BValue)BFacets.make((BFacets)this.getTimestampFacets()));
            } else {
                config.add(TIMESTAMP_FACETS, (BValue)BFacets.make((BFacets)this.getTimestampFacets()));
            }
            try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                conn.reconfigureHistory(this.getHistoryConfig());
            }
            this.setHistoryConfig(config);
        }
    }

    public void updateStatus() {
        if (!this.getEnabled()) {
            this.setStatus(BStatus.disabled);
            this.setFaultCause("");
        } else {
            boolean validName = this.getHistoryConfig().getId().isValid();
            if (!validName) {
                this.setStatus(BStatus.fault);
                this.setFaultCause("Invalid history name.");
            } else {
                this.setStatus(BStatus.ok);
                this.setFaultCause("");
            }
        }
    }

    public void createHistory() throws Exception {
        try {
            this.getHistoryConfig().setRecordType(BTypeSpec.make((String)"vykonPro", (String)"BypassTimeRecord"));
            BOrdList source = BOrdList.make((BOrd)this.getSourceOrd());
            this.getHistoryConfig().setSource(source);
            this.getHistoryConfig().setId(BHistoryId.make((String)Sys.getStation().getStationName(), (String)this.resolveHistoryName()));
            BHistoryConfig config = this.getHistoryConfig();
            BFacets f1 = (BFacets)config.get(ELAPSED_TIME_FACETS);
            if (f1 != null) {
                config.set(ELAPSED_TIME_FACETS, (BValue)BFacets.make((BFacets)this.getElapsedTimeFacets()));
            } else {
                config.add(ELAPSED_TIME_FACETS, (BValue)BFacets.make((BFacets)this.getElapsedTimeFacets()));
            }
            BFacets f2 = (BFacets)config.get(TIMESTAMP_END_FACETS);
            if (f2 != null) {
                config.set(TIMESTAMP_END_FACETS, (BValue)BFacets.make((BFacets)this.getTimestampFacets()));
            } else {
                config.add(TIMESTAMP_END_FACETS, (BValue)BFacets.make((BFacets)this.getTimestampFacets()));
            }
            BFacets f3 = (BFacets)config.get(TIMESTAMP_FACETS);
            if (f3 != null) {
                config.set(TIMESTAMP_FACETS, (BValue)BFacets.make((BFacets)this.getTimestampFacets()));
            } else {
                config.add(TIMESTAMP_FACETS, (BValue)BFacets.make((BFacets)this.getTimestampFacets()));
            }
            this.setHistoryConfig(config);
            BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
            if (localDb == null) {
                System.out.println("Local history database not available.");
                return;
            }
            try (HistoryDatabaseConnection conn = localDb.getDbConnection(null);){
                if (conn.getHistory(config.getId()) == null) {
                    conn.createHistory(config);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAppendRecord() throws Exception {
        if (this.getActivePeriod().isActive(BAbsTime.make()) && this.getEnabled()) {
            try (HistoryDatabaseConnection conn = null;){
                BHistoryDatabase localDb = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
                if (localDb == null) {
                    System.out.println("Local history database not available.");
                    return;
                }
                BHistoryId id = BHistoryId.make((String)Sys.getStation().getStationName(), (String)this.resolveHistoryName());
                conn = localDb.getDbConnection(null);
                if (!conn.exists(id)) {
                    this.createHistory();
                }
                BIHistory history = conn.getHistory(id);
                BAbsTime current = BAbsTime.make();
                this.elapsedMillis = current.getMillis() - this.getStartTime().getMillis();
                if (this.elapsedMillis < 0L) {
                    this.elapsedMillis = 0L;
                }
                this.elapTime = BRelTime.make((long)this.elapsedMillis);
                BAbsTime lastTimestamp = conn.getLastTimestamp(history);
                if (Clock.time().isAfter(lastTimestamp)) {
                    BBypassTimeRecord rec = new BBypassTimeRecord(this.getStartTime(), current, this.elapTime);
                    conn.append(history, (BIHistoryRecordSet)rec);
                    this.setTimestamp(this.getStartTime());
                    this.setTimestampEnd(current);
                    this.setElapsedTime(this.elapTime);
                }
            }
        }
    }

    public String resolveHistoryName() {
        BFormat pattern = this.getHistoryName();
        return SlotPath.escape((String)SlotPath.unescape((String)pattern.format((Object)this)));
    }
}

