/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.energy;

import com.vykon.vykonPro.enums.BCalculationModeEnum;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BNumericDelta
extends BComponent {
    public static final Property deltaFacets = BNumericDelta.newProperty((int)0, (BValue)BFacets.makeNumeric(), null);
    public static final Property delta = BNumericDelta.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property in = BNumericDelta.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property lastIn = BNumericDelta.newProperty((int)4, (int)0, null);
    public static final Property rollover = BNumericDelta.newProperty((int)0, (int)0, null);
    public static final Property calculationMode = BNumericDelta.newProperty((int)0, (BValue)BDynamicEnum.make((int)0), (BFacets)BFacets.makeEnum((BEnumRange)BEnumRange.make((Type)BCalculationModeEnum.TYPE)));
    public static final Property executePeriod = BNumericDelta.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1L)));
    public static final Property lastUpdateTime = BNumericDelta.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Action calculate = BNumericDelta.newAction((int)4, null);
    public static final Action manualCalculate = BNumericDelta.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BNumericDelta.class);
    Clock.Ticket ticket = null;
    private static final BIcon icon = BIcon.std((String)"delta.png");

    public BFacets getDeltaFacets() {
        return (BFacets)this.get(deltaFacets);
    }

    public void setDeltaFacets(BFacets v) {
        this.set(deltaFacets, (BValue)v, null);
    }

    public BStatusNumeric getDelta() {
        return (BStatusNumeric)this.get(delta);
    }

    public void setDelta(BStatusNumeric v) {
        this.set(delta, (BValue)v, null);
    }

    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    public double getLastIn() {
        return this.getDouble(lastIn);
    }

    public void setLastIn(double v) {
        this.setDouble(lastIn, v, null);
    }

    public double getRollover() {
        return this.getDouble(rollover);
    }

    public void setRollover(double v) {
        this.setDouble(rollover, v, null);
    }

    public BEnum getCalculationMode() {
        return (BEnum)this.get(calculationMode);
    }

    public void setCalculationMode(BEnum v) {
        this.set(calculationMode, (BValue)v, null);
    }

    public BRelTime getExecutePeriod() {
        return (BRelTime)this.get(executePeriod);
    }

    public void setExecutePeriod(BRelTime v) {
        this.set(executePeriod, (BValue)v, null);
    }

    public BAbsTime getLastUpdateTime() {
        return (BAbsTime)this.get(lastUpdateTime);
    }

    public void setLastUpdateTime(BAbsTime v) {
        this.set(lastUpdateTime, (BValue)v, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public void manualCalculate() {
        this.invoke(manualCalculate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)delta)) {
            return this.getDeltaFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void started() throws Exception {
        if (this.getCalculationMode().getOrdinal() == 0) {
            this.initClockTicket();
        }
        super.started();
        if (!Sys.atSteadyState()) {
            return;
        }
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    public void clockChanged(BRelTime value) {
        if (this.getCalculationMode().getOrdinal() == 0) {
            this.initClockTicket();
        }
    }

    private void initClockTicket() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        BAbsTime now = Clock.time();
        BAbsTime startTime = BAbsTime.make((BAbsTime)now, (BTime)BTime.make((int)0, (int)0, (int)0));
        BRelTime period = this.getExecutePeriod();
        if (period.getMillis() < 1000L) {
            period = BRelTime.MINUTE;
        }
        while (!startTime.isAfter(now)) {
            startTime = startTime.add(period);
        }
        this.ticket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)startTime, (BRelTime)period, (Action)calculate, null);
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals(executePeriod) && this.getCalculationMode().getOrdinal() == 0) {
            this.initClockTicket();
        }
        if (property.equals(calculationMode)) {
            if (this.getCalculationMode().getOrdinal() == 0) {
                this.initClockTicket();
            } else if (this.ticket != null) {
                this.ticket.cancel();
            }
        }
        if (this.getCalculationMode().getOrdinal() == 1 && property.equals(in)) {
            this.calculate();
        }
    }

    public void doCalculate() throws Exception {
        if (this.getIn().getStatus().isValid()) {
            if (this.getIn().getValue() >= this.getLastIn()) {
                this.getDelta().setValue(this.getIn().getValue() - this.getLastIn());
                this.setLastIn(this.getIn().getValue());
            } else if (this.getIn().getValue() < this.getLastIn()) {
                this.getDelta().setValue(this.getRollover() - this.getLastIn() + this.getIn().getValue());
                this.setLastIn(this.getIn().getValue());
            }
        }
        this.setLastUpdateTime(Clock.time());
    }

    public void doManualCalculate() {
        this.calculate();
    }

    public BIcon getIcon() {
        return icon;
    }
}

