/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.energy;

import com.vykon.vykonPro.energy.BConsumptionProperties;
import com.vykon.vykonPro.energy.BDemandProperties;
import com.vykon.vykonPro.enums.BPeakIntervalEnum;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class BBlockDemandCalc
extends BComponent {
    public static final Property status = BBlockDemandCalc.newProperty((int)67, (BValue)BStatus.ok, null);
    public static final Property lastFaultCause = BBlockDemandCalc.newProperty((int)65, (String)"", null);
    public static final Property lastFaultTime = BBlockDemandCalc.newProperty((int)65, (BValue)BAbsTime.NULL, null);
    public static final Property consumptionFacets = BBlockDemandCalc.newProperty((int)256, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"kilowatt hour"), (int)1), null);
    public static final Property demandFacets = BBlockDemandCalc.newProperty((int)256, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"kilowatt"), (int)1), null);
    public static final Property currentPulseCount = BBlockDemandCalc.newProperty((int)328, (BValue)new BStatusNumeric(), null);
    public static final Property kwhPerPulse = BBlockDemandCalc.newProperty((int)256, (double)1.0, null);
    public static final Property kwhPerPulseFacets = BBlockDemandCalc.newProperty((int)256, (BValue)BFacets.make((String)"precision", (int)3), null);
    public static final Property checkFrequency = BBlockDemandCalc.newProperty((int)256, (boolean)true, null);
    public static final Property maxPulseFrequency = BBlockDemandCalc.newProperty((int)256, (int)10, (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"hertz"), (int)1, (double)1.0, (double)100.0));
    public static final Property actualPulseFrequency = BBlockDemandCalc.newProperty((int)3, (int)0, (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"hertz"), (int)1));
    public static final Property meterRollover = BBlockDemandCalc.newProperty((int)256, (long)65535L, null);
    public static final Property peakMode = BBlockDemandCalc.newProperty((int)264, (BValue)new BStatusBoolean(), (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"onPeak"), (BFacets)BFacets.make((String)"falseText", (String)"offPeak")));
    public static final Property kwhTotal = BBlockDemandCalc.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property kwhOffPeakTotal = BBlockDemandCalc.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property kwhOnPeakTotal = BBlockDemandCalc.newProperty((int)9, (BValue)new BStatusNumeric(), null);
    public static final Property monthlyKwh = BBlockDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property monthlyKwhOffPeak = BBlockDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property monthlyKwhOnPeak = BBlockDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property kwh5 = BBlockDemandCalc.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property kwh15 = BBlockDemandCalc.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property kwh30 = BBlockDemandCalc.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property maxKw = BBlockDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property maxKwTimestamp = BBlockDemandCalc.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property maxKwOffPeak = BBlockDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property maxKwOffPeakTimestamp = BBlockDemandCalc.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property maxKwOnPeak = BBlockDemandCalc.newProperty((int)1, (BValue)new BStatusNumeric(), null);
    public static final Property maxKwOnPeakTimestamp = BBlockDemandCalc.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property peakKwInterval = BBlockDemandCalc.newProperty((int)256, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BPeakIntervalEnum.TYPE)), null);
    public static final Property kw5 = BBlockDemandCalc.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property kw15 = BBlockDemandCalc.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Property kw30 = BBlockDemandCalc.newProperty((int)3, (BValue)new BStatusNumeric(), null);
    public static final Action presetKwh = BBlockDemandCalc.newAction((int)256, (BValue)new BConsumptionProperties(), null);
    public static final Action presetKw = BBlockDemandCalc.newAction((int)256, (BValue)new BDemandProperties(), null);
    public static final Action monthlyReset = BBlockDemandCalc.newAction((int)0, null);
    public static final Action reset = BBlockDemandCalc.newAction((int)0, null);
    public static final Action timerExpired5 = BBlockDemandCalc.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BBlockDemandCalc.class);
    Clock.Ticket ticket5 = null;
    double lastPulseCount;
    double currentCount;
    double pulseCountDiff;
    double kwhNew;
    double intervalKwh;
    double lastPulseCount5;
    double lastPulseCount15;
    double lastPulseCount30;
    int elapsedSeconds = 0;
    long lastTicks = 0L;
    long lastTicks5 = 0L;
    long lastTicks15 = 0L;
    long lastTicks30 = 0L;
    boolean checkFreq = false;
    boolean validFreq = false;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getLastFaultCause() {
        return this.getString(lastFaultCause);
    }

    public void setLastFaultCause(String v) {
        this.setString(lastFaultCause, v, null);
    }

    public BAbsTime getLastFaultTime() {
        return (BAbsTime)this.get(lastFaultTime);
    }

    public void setLastFaultTime(BAbsTime v) {
        this.set(lastFaultTime, (BValue)v, null);
    }

    public BFacets getConsumptionFacets() {
        return (BFacets)this.get(consumptionFacets);
    }

    public void setConsumptionFacets(BFacets v) {
        this.set(consumptionFacets, (BValue)v, null);
    }

    public BFacets getDemandFacets() {
        return (BFacets)this.get(demandFacets);
    }

    public void setDemandFacets(BFacets v) {
        this.set(demandFacets, (BValue)v, null);
    }

    public BStatusNumeric getCurrentPulseCount() {
        return (BStatusNumeric)this.get(currentPulseCount);
    }

    public void setCurrentPulseCount(BStatusNumeric v) {
        this.set(currentPulseCount, (BValue)v, null);
    }

    public double getKwhPerPulse() {
        return this.getDouble(kwhPerPulse);
    }

    public void setKwhPerPulse(double v) {
        this.setDouble(kwhPerPulse, v, null);
    }

    public BFacets getKwhPerPulseFacets() {
        return (BFacets)this.get(kwhPerPulseFacets);
    }

    public void setKwhPerPulseFacets(BFacets v) {
        this.set(kwhPerPulseFacets, (BValue)v, null);
    }

    public boolean getCheckFrequency() {
        return this.getBoolean(checkFrequency);
    }

    public void setCheckFrequency(boolean v) {
        this.setBoolean(checkFrequency, v, null);
    }

    public double getMaxPulseFrequency() {
        return this.getDouble(maxPulseFrequency);
    }

    public void setMaxPulseFrequency(double v) {
        this.setDouble(maxPulseFrequency, v, null);
    }

    public double getActualPulseFrequency() {
        return this.getDouble(actualPulseFrequency);
    }

    public void setActualPulseFrequency(double v) {
        this.setDouble(actualPulseFrequency, v, null);
    }

    public long getMeterRollover() {
        return this.getLong(meterRollover);
    }

    public void setMeterRollover(long v) {
        this.setLong(meterRollover, v, null);
    }

    public BStatusBoolean getPeakMode() {
        return (BStatusBoolean)this.get(peakMode);
    }

    public void setPeakMode(BStatusBoolean v) {
        this.set(peakMode, (BValue)v, null);
    }

    public BStatusNumeric getKwhTotal() {
        return (BStatusNumeric)this.get(kwhTotal);
    }

    public void setKwhTotal(BStatusNumeric v) {
        this.set(kwhTotal, (BValue)v, null);
    }

    public BStatusNumeric getKwhOffPeakTotal() {
        return (BStatusNumeric)this.get(kwhOffPeakTotal);
    }

    public void setKwhOffPeakTotal(BStatusNumeric v) {
        this.set(kwhOffPeakTotal, (BValue)v, null);
    }

    public BStatusNumeric getKwhOnPeakTotal() {
        return (BStatusNumeric)this.get(kwhOnPeakTotal);
    }

    public void setKwhOnPeakTotal(BStatusNumeric v) {
        this.set(kwhOnPeakTotal, (BValue)v, null);
    }

    public BStatusNumeric getMonthlyKwh() {
        return (BStatusNumeric)this.get(monthlyKwh);
    }

    public void setMonthlyKwh(BStatusNumeric v) {
        this.set(monthlyKwh, (BValue)v, null);
    }

    public BStatusNumeric getMonthlyKwhOffPeak() {
        return (BStatusNumeric)this.get(monthlyKwhOffPeak);
    }

    public void setMonthlyKwhOffPeak(BStatusNumeric v) {
        this.set(monthlyKwhOffPeak, (BValue)v, null);
    }

    public BStatusNumeric getMonthlyKwhOnPeak() {
        return (BStatusNumeric)this.get(monthlyKwhOnPeak);
    }

    public void setMonthlyKwhOnPeak(BStatusNumeric v) {
        this.set(monthlyKwhOnPeak, (BValue)v, null);
    }

    public BStatusNumeric getKwh5() {
        return (BStatusNumeric)this.get(kwh5);
    }

    public void setKwh5(BStatusNumeric v) {
        this.set(kwh5, (BValue)v, null);
    }

    public BStatusNumeric getKwh15() {
        return (BStatusNumeric)this.get(kwh15);
    }

    public void setKwh15(BStatusNumeric v) {
        this.set(kwh15, (BValue)v, null);
    }

    public BStatusNumeric getKwh30() {
        return (BStatusNumeric)this.get(kwh30);
    }

    public void setKwh30(BStatusNumeric v) {
        this.set(kwh30, (BValue)v, null);
    }

    public BStatusNumeric getMaxKw() {
        return (BStatusNumeric)this.get(maxKw);
    }

    public void setMaxKw(BStatusNumeric v) {
        this.set(maxKw, (BValue)v, null);
    }

    public BAbsTime getMaxKwTimestamp() {
        return (BAbsTime)this.get(maxKwTimestamp);
    }

    public void setMaxKwTimestamp(BAbsTime v) {
        this.set(maxKwTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getMaxKwOffPeak() {
        return (BStatusNumeric)this.get(maxKwOffPeak);
    }

    public void setMaxKwOffPeak(BStatusNumeric v) {
        this.set(maxKwOffPeak, (BValue)v, null);
    }

    public BAbsTime getMaxKwOffPeakTimestamp() {
        return (BAbsTime)this.get(maxKwOffPeakTimestamp);
    }

    public void setMaxKwOffPeakTimestamp(BAbsTime v) {
        this.set(maxKwOffPeakTimestamp, (BValue)v, null);
    }

    public BStatusNumeric getMaxKwOnPeak() {
        return (BStatusNumeric)this.get(maxKwOnPeak);
    }

    public void setMaxKwOnPeak(BStatusNumeric v) {
        this.set(maxKwOnPeak, (BValue)v, null);
    }

    public BAbsTime getMaxKwOnPeakTimestamp() {
        return (BAbsTime)this.get(maxKwOnPeakTimestamp);
    }

    public void setMaxKwOnPeakTimestamp(BAbsTime v) {
        this.set(maxKwOnPeakTimestamp, (BValue)v, null);
    }

    public BEnum getPeakKwInterval() {
        return (BEnum)this.get(peakKwInterval);
    }

    public void setPeakKwInterval(BEnum v) {
        this.set(peakKwInterval, (BValue)v, null);
    }

    public BStatusNumeric getKw5() {
        return (BStatusNumeric)this.get(kw5);
    }

    public void setKw5(BStatusNumeric v) {
        this.set(kw5, (BValue)v, null);
    }

    public BStatusNumeric getKw15() {
        return (BStatusNumeric)this.get(kw15);
    }

    public void setKw15(BStatusNumeric v) {
        this.set(kw15, (BValue)v, null);
    }

    public BStatusNumeric getKw30() {
        return (BStatusNumeric)this.get(kw30);
    }

    public void setKw30(BStatusNumeric v) {
        this.set(kw30, (BValue)v, null);
    }

    public void presetKwh(BConsumptionProperties arg) {
        this.invoke(presetKwh, (BValue)arg, null);
    }

    public void presetKw(BDemandProperties arg) {
        this.invoke(presetKw, (BValue)arg, null);
    }

    public void monthlyReset() {
        this.invoke(monthlyReset, null, null);
    }

    public void reset() {
        this.invoke(reset, null, null);
    }

    public void timerExpired5() {
        this.invoke(timerExpired5, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        this.initTicket5();
        this.lastTicks = Clock.ticks();
        this.lastTicks5 = Clock.ticks();
        this.lastTicks15 = Clock.ticks();
        this.lastTicks30 = Clock.ticks();
        this.lastPulseCount = this.getCurrentPulseCount().getValue();
        this.lastPulseCount5 = this.getCurrentPulseCount().getValue();
        this.lastPulseCount15 = this.getCurrentPulseCount().getValue();
        this.lastPulseCount30 = this.getCurrentPulseCount().getValue();
        super.started();
    }

    public void stopped() throws Exception {
        if (this.ticket5 != null) {
            this.ticket5.cancel();
        }
        super.stopped();
    }

    public void clockChanged(BRelTime value) {
        this.initTicket5();
    }

    private void initTicket5() {
        BAbsTime now = Clock.time();
        if (this.ticket5 != null) {
            this.ticket5.cancel();
        }
        BAbsTime startTime = BAbsTime.make((BAbsTime)now, (BTime)BTime.make((int)0, (int)4, (int)55));
        while (!startTime.isAfter(now)) {
            startTime = startTime.add(BRelTime.makeMinutes((int)5));
        }
        this.ticket5 = Clock.schedulePeriodically((BComponent)this, (BAbsTime)startTime, (BRelTime)BRelTime.makeMinutes((int)5), (Action)timerExpired5, null);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)kwhOffPeakTotal) || slot.equals((Object)kwhOnPeakTotal) || slot.equals((Object)kwh15) || slot.equals((Object)kwh30) || slot.equals((Object)monthlyKwhOnPeak) || slot.equals((Object)monthlyKwhOffPeak)) {
            return this.getConsumptionFacets();
        }
        if (slot.equals((Object)kw15) || slot.equals((Object)kw30) || slot.equals((Object)kw5) || slot.equals((Object)maxKwOffPeak) || slot.equals((Object)maxKwOnPeak)) {
            return this.getDemandFacets();
        }
        if (slot.equals((Object)kwhPerPulse)) {
            return this.getKwhPerPulseFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void changed(Property property, Context context) {
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals(currentPulseCount)) {
            this.calculateTotalKwh();
        }
        super.changed(property, context);
    }

    private int calculateDiffTime(long lastTicks) {
        long thisCountChangeTicks = Clock.ticks();
        long countChangePeriod = thisCountChangeTicks - lastTicks;
        if (countChangePeriod <= 0L) {
            this.setStatus(BStatus.fault);
            this.setLastFaultCause("Elapsed ticks indicate a negative change.");
            this.setLastFaultTime(Clock.time());
            return 0;
        }
        return (int)(countChangePeriod / 1000L);
    }

    private void calculateKw5() {
        this.elapsedSeconds = this.calculateDiffTime(this.lastTicks5);
        this.checkFreq = true;
        this.intervalKwh = this.calculateKwh(this.lastPulseCount5, this.elapsedSeconds);
        this.getKwh5().setValue(this.intervalKwh);
        if (this.validFreq) {
            this.getKw5().setValue(this.intervalKwh / (double)this.elapsedSeconds * 3600.0);
        } else {
            this.getKw5().setValue(0.0);
        }
        this.lastTicks5 = Clock.ticks();
        this.lastPulseCount5 = this.getCurrentPulseCount().getValue();
    }

    private void calculateKw15() {
        this.elapsedSeconds = this.calculateDiffTime(this.lastTicks15);
        this.intervalKwh = this.calculateKwh(this.lastPulseCount15, this.elapsedSeconds);
        this.getKwh15().setValue(this.intervalKwh);
        if (this.validFreq) {
            this.getKw15().setValue(this.intervalKwh / (double)this.elapsedSeconds * 3600.0);
            if (this.getPeakKwInterval().getOrdinal() == 0) {
                this.checkPeakKw(this.getKw15().getValue());
            }
        } else {
            this.getKw15().setValue(0.0);
        }
        this.lastTicks15 = Clock.ticks();
        this.lastPulseCount15 = this.getCurrentPulseCount().getValue();
    }

    private void calculateKw30() {
        this.elapsedSeconds = this.calculateDiffTime(this.lastTicks30);
        this.intervalKwh = this.calculateKwh(this.lastPulseCount30, this.elapsedSeconds);
        this.getKwh30().setValue(this.intervalKwh);
        if (this.validFreq) {
            this.getKw30().setValue(this.intervalKwh / (double)this.elapsedSeconds * 3600.0);
            if (this.getPeakKwInterval().getOrdinal() == 1) {
                this.checkPeakKw(this.getKw30().getValue());
            }
        } else {
            this.getKw30().setValue(0.0);
        }
        this.lastTicks30 = Clock.ticks();
        this.lastPulseCount30 = this.getCurrentPulseCount().getValue();
    }

    private void checkPeakKw(double demand) {
        BTime tstamp = BTime.make((BRelTime)BRelTime.make((long)(Clock.time().getTimeOfDayMillis() + 6000L)));
        if (demand > this.getMaxKw().getValue()) {
            this.getMaxKw().setValue(demand);
            this.setMaxKwTimestamp(BAbsTime.make((BAbsTime)Clock.time(), (BTime)tstamp));
        }
        if (this.getPeakMode().getValue()) {
            if (demand > this.getMaxKwOnPeak().getValue()) {
                this.getMaxKwOnPeak().setValue(demand);
                this.setMaxKwOnPeakTimestamp(BAbsTime.make((BAbsTime)Clock.time(), (BTime)tstamp));
            }
        } else if (demand > this.getMaxKwOffPeak().getValue()) {
            this.getMaxKwOffPeak().setValue(demand);
            this.setMaxKwOffPeakTimestamp(BAbsTime.make((BAbsTime)Clock.time(), (BTime)tstamp));
        }
    }

    private double calculateKwh(double lastCount, int elapsedTime) {
        if (!this.getCurrentPulseCount().getStatus().isValid() || Double.isNaN(this.getCurrentPulseCount().getValue()) || this.getCurrentPulseCount().getValue() < 0.0) {
            this.setStatus(BStatus.fault);
            this.setLastFaultCause("Current pulse counts are not valid.");
            this.setLastFaultTime(Clock.time());
            return 0.0;
        }
        this.currentCount = this.getCurrentPulseCount().getValue();
        this.pulseCountDiff = this.currentCount >= lastCount ? this.currentCount - lastCount : (double)this.getMeterRollover() - lastCount + 1.0 + this.currentCount;
        if (this.pulseCountDiff < 0.0) {
            this.setStatus(BStatus.fault);
            this.setLastFaultCause("Calculated a negative number of pulses. Consumption value not calculated.");
            this.setLastFaultTime(Clock.time());
            return 0.0;
        }
        int maxPulseFreq = (int)this.getMaxPulseFrequency();
        double pulseFreq = this.pulseCountDiff / (double)elapsedTime;
        this.validFreq = false;
        if (pulseFreq != Double.NaN && pulseFreq != Double.POSITIVE_INFINITY && pulseFreq != Double.NEGATIVE_INFINITY && pulseFreq <= (double)maxPulseFreq) {
            this.validFreq = true;
        }
        if (this.checkFreq) {
            if (this.validFreq) {
                this.setActualPulseFrequency(pulseFreq);
            } else {
                this.setActualPulseFrequency(0.0);
            }
            this.checkFreq = false;
        }
        if (this.getCheckFrequency() && !this.validFreq) {
            this.setStatus(BStatus.fault);
            this.setLastFaultCause("Pulse frequency is " + pulseFreq + " which exceeds maxPulseFrequency of " + maxPulseFreq + ". Demand value not calculated.");
            this.setLastFaultTime(Clock.time());
            return 0.0;
        }
        this.kwhNew = this.pulseCountDiff * this.getKwhPerPulse();
        this.setStatus(BStatus.ok);
        return this.kwhNew;
    }

    private void calculateTotalKwh() {
        this.elapsedSeconds = this.calculateDiffTime(this.lastTicks);
        this.intervalKwh = this.calculateKwh(this.lastPulseCount, this.elapsedSeconds);
        this.lastPulseCount = this.currentCount;
        this.lastTicks = Clock.ticks();
        this.getKwhTotal().setValue(this.getKwhTotal().getValue() + this.intervalKwh);
        this.getMonthlyKwh().setValue(this.getMonthlyKwh().getValue() + this.intervalKwh);
        if (this.getPeakMode().getValue()) {
            this.getKwhOnPeakTotal().setValue(this.getKwhOnPeakTotal().getValue() + this.intervalKwh);
            this.getMonthlyKwhOnPeak().setValue(this.getMonthlyKwhOnPeak().getValue() + this.intervalKwh);
        } else {
            this.getKwhOffPeakTotal().setValue(this.getKwhOffPeakTotal().getValue() + this.intervalKwh);
            this.getMonthlyKwhOffPeak().setValue(this.getMonthlyKwhOffPeak().getValue() + this.intervalKwh);
        }
    }

    public void doPresetKwh(BConsumptionProperties arg) {
        this.getKwhTotal().setValue(arg.getKwhTotal());
        this.getKwhOffPeakTotal().setValue(arg.getKwhOffPeakTotal());
        this.getKwhOnPeakTotal().setValue(arg.getKwhOnPeakTotal());
        this.getMonthlyKwh().setValue(arg.getMonthlyKwh());
        this.getMonthlyKwhOffPeak().setValue(arg.getMonthlyKwhOffPeak());
        this.getMonthlyKwhOnPeak().setValue(arg.getMonthlyKwhOnPeak());
    }

    public void doPresetKw(BDemandProperties arg) {
        this.getMaxKw().setValue(arg.getMaxKw());
        this.setMaxKwTimestamp(arg.getMaxKwTimestamp());
        this.getMaxKwOffPeak().setValue(arg.getMaxKwOffPeak());
        this.setMaxKwOffPeakTimestamp(arg.getMaxKwOffPeakTimestamp());
        this.getMaxKwOnPeak().setValue(arg.getMaxKwOnPeak());
        this.setMaxKwOnPeakTimestamp(arg.getMaxKwOnPeakTimestamp());
    }

    public BValue getActionParameterDefault(Action action) {
        if (action == presetKwh) {
            return new BConsumptionProperties();
        }
        if (action == presetKw) {
            return new BDemandProperties();
        }
        return super.getActionParameterDefault(action);
    }

    public void doMonthlyReset() {
        this.getMonthlyKwh().setValue(0.0);
        this.getMonthlyKwhOffPeak().setValue(0.0);
        this.getMonthlyKwhOnPeak().setValue(0.0);
        this.getMaxKw().setValue(0.0);
        this.setMaxKwTimestamp(BAbsTime.NULL);
        this.getMaxKwOffPeak().setValue(0.0);
        this.setMaxKwOffPeakTimestamp(BAbsTime.NULL);
        this.getMaxKwOnPeak().setValue(0.0);
        this.setMaxKwOnPeakTimestamp(BAbsTime.NULL);
    }

    public void doReset() {
        this.getMonthlyKwh().setValue(0.0);
        this.getMonthlyKwhOffPeak().setValue(0.0);
        this.getMonthlyKwhOnPeak().setValue(0.0);
        this.getKwhTotal().setValue(0.0);
        this.getKwhOffPeakTotal().setValue(0.0);
        this.getKwhOnPeakTotal().setValue(0.0);
        this.setActualPulseFrequency(0.0);
        this.getKwh5().setValue(0.0);
        this.getKwh15().setValue(0.0);
        this.getKwh30().setValue(0.0);
        this.getMaxKw().setValue(0.0);
        this.setMaxKwTimestamp(BAbsTime.NULL);
        this.getMaxKwOffPeak().setValue(0.0);
        this.setMaxKwOffPeakTimestamp(BAbsTime.NULL);
        this.getMaxKwOnPeak().setValue(0.0);
        this.setMaxKwOnPeakTimestamp(BAbsTime.NULL);
        this.getKw5().setValue(0.0);
        this.getKw15().setValue(0.0);
        this.getKw30().setValue(0.0);
        this.lastPulseCount5 = this.getCurrentPulseCount().getValue();
        this.lastPulseCount15 = this.getCurrentPulseCount().getValue();
        this.lastPulseCount30 = this.getCurrentPulseCount().getValue();
        this.lastTicks = Clock.ticks();
        this.lastTicks5 = Clock.ticks();
        this.lastTicks15 = Clock.ticks();
        this.lastTicks30 = Clock.ticks();
    }

    public void doTimerExpired5() {
        int currentMinute = Clock.time().getMinute();
        switch (currentMinute) {
            case 4: 
            case 9: 
            case 19: 
            case 24: 
            case 34: 
            case 39: 
            case 49: 
            case 54: {
                this.calculateKw5();
                break;
            }
            case 14: 
            case 44: {
                this.calculateKw15();
                this.calculateKw5();
                break;
            }
            case 29: 
            case 59: {
                this.calculateKw30();
                this.calculateKw15();
                this.calculateKw5();
            }
        }
    }
}

