/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags;

import com.tridium.exporttags.BJoinProfile;
import com.tridium.exporttags.BNiagaraExportTag;
import com.tridium.exporttags.util.BJoinInfo;
import com.tridium.exporttags.util.BJoinReqInfo;
import com.tridium.exporttags.util.ExportTagException;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.driver.BDevice;
import javax.baja.driver.BNetworkExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameList;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=67), @NiagaraProperty(name="logLimit", type="int", defaultValue="600", facets={@Facet(name="BFacets.MIN", value="-1"), @Facet(name="BFacets.MAX", value="10000")})})
@NiagaraActions(value={@NiagaraAction(name="join", returnType="BOrdList"), @NiagaraAction(name="getJoinInfo", parameterType="BJoinReqInfo", defaultValue="new BJoinReqInfo()", returnType="BJoinInfo", flags=4), @NiagaraAction(name="setAllSupervisorStationNames", parameterType="BNameList", defaultValue="BNameList.DEFAULT", flags=144, facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"exportTags:MultiStationNamePickerFE\"")})})
public final class BSubordinateExportTagNetworkExt
extends BNetworkExt
implements BIService {
    @Generated
    public static final Property status = BSubordinateExportTagNetworkExt.newProperty((int)67, (BValue)BStatus.ok, null);
    @Generated
    public static final Property logLimit = BSubordinateExportTagNetworkExt.newProperty((int)0, (int)600, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)-1), (BFacets)BFacets.make((String)"max", (int)10000)));
    @Generated
    public static final Action join = BSubordinateExportTagNetworkExt.newAction((int)0, null);
    @Generated
    public static final Action getJoinInfo = BSubordinateExportTagNetworkExt.newAction((int)4, (BValue)new BJoinReqInfo(), null);
    @Generated
    public static final Action setAllSupervisorStationNames = BSubordinateExportTagNetworkExt.newAction((int)144, (BValue)BNameList.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"exportTags:MultiStationNamePickerFE"));
    @Generated
    public static final Type TYPE = Sys.loadType(BSubordinateExportTagNetworkExt.class);
    private static final BIcon icon = BIcon.std((String)"sync.png");

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public int getLogLimit() {
        return this.getInt(logLimit);
    }

    @Generated
    public void setLogLimit(int v) {
        this.setInt(logLimit, v, null);
    }

    @Generated
    public BOrdList join() {
        return (BOrdList)this.invoke(join, null, null);
    }

    @Generated
    public BJoinInfo getJoinInfo(BJoinReqInfo parameter) {
        return (BJoinInfo)this.invoke(getJoinInfo, (BValue)parameter, null);
    }

    @Generated
    public void setAllSupervisorStationNames(BNameList parameter) {
        this.invoke(setAllSupervisorStationNames, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraNetwork;
    }

    public BIcon getIcon() {
        return icon;
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (this.isRunning() && action == setAllSupervisorStationNames) {
            this.getNiagaraNetwork().getWorkers().process((Object)new Invocation((BComponent)this, action, argument, cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    public void updateStatus() {
        this.setStatus(this.getNiagaraNetwork().getStatus());
        for (BJoinProfile profile : (BJoinProfile[])this.getChildren(BJoinProfile.class)) {
            profile.updateStatus();
        }
    }

    private BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)this.getParent();
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public void serviceStarted() throws Exception {
        this.getComponentSpace().enableMixIn(BJoinProfile.TYPE);
    }

    public void serviceStopped() throws Exception {
        this.getComponentSpace().disableMixIn(BJoinProfile.TYPE);
    }

    public BJoinInfo doGetJoinInfo(BJoinReqInfo req, Context cx) throws Exception {
        BNiagaraStation station = (BNiagaraStation)this.getNiagaraNetwork().getStation(req.getStationName());
        if (station == null) {
            throw new ExportTagException("noSupStationOnSubordinate");
        }
        BJoinProfile profile = (BJoinProfile)station.getMixIn(BJoinProfile.TYPE);
        if (profile == null) {
            throw new ExportTagException("noJoinProfileForStation", req.getStationName());
        }
        return profile.getJoinInfo(req.getStationFolderPath(), cx);
    }

    public BOrdList doJoin(Context cx) throws Exception {
        Array ordArray = new Array(BOrd.class);
        for (BDevice device : this.getNiagaraNetwork().getDevices()) {
            BNiagaraStation station = (BNiagaraStation)device;
            if (station == null) {
                throw new ExportTagException("noSupStationOnSubordinate");
            }
            BJoinProfile profile = (BJoinProfile)station.getMixIn(BJoinProfile.TYPE);
            if (profile == null) {
                throw new ExportTagException("noJoinProfileForStation", station.getStationName());
            }
            if (profile.getStatus().isDisabled()) continue;
            ordArray.add((Object)profile.doJoin(cx));
        }
        return BOrdList.make((BOrd[])((BOrd[])ordArray.trim()));
    }

    public void doSetAllSupervisorStationNames(BNameList names) {
        BITable coll = (BITable)BOrd.make((String)"station:|slot:/|bql:select from exportTags:NiagaraExportTag stop where enabled=true").get((BObject)this);
        try (TableCursor c = coll.cursor();){
            while (c.next()) {
                BNiagaraExportTag tag = (BNiagaraExportTag)((Object)c.get());
                tag.setSupervisorStation(names);
            }
        }
    }
}

