/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.server.point;

import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.server.BModbusServerDevice;
import com.tridium.modbusCore.server.point.BModbusServerNumericProxyExt;
import com.tridium.modbusCore.server.point.BModbusServerPointFolder;
import com.tridium.modbusCore.server.point.BModbusServerProxyExt;
import com.tridium.modbusCore.server.point.BModbusServerRegisterBitProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BModbusServerPointDeviceExt
extends BPointDeviceExt {
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusServerPointDeviceExt.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BModbusServerDevice.TYPE;
    }

    public Type getProxyExtType() {
        return BModbusServerProxyExt.TYPE;
    }

    public Type getPointFolderType() {
        return BModbusServerPointFolder.TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BModbusServerDevice;
    }

    public void childParented(Property prop, BValue newChild, Context context) {
        super.childParented(prop, newChild, context);
        if (newChild instanceof BControlPoint && ((BControlPoint)newChild).isWritablePoint() && ((BControlPoint)newChild).getProxyExt() instanceof BModbusServerProxyExt && this.writablePointAlreadyExists((BModbusServerProxyExt)((BControlPoint)newChild).getProxyExt())) {
            ((BModbusServerProxyExt)((BControlPoint)newChild).getProxyExt()).setDataAddress(new BFlexAddress(BAddressFormatEnum.hex, "-1"));
        }
    }

    private boolean writablePointAlreadyExists(BModbusServerProxyExt newExt) {
        if (newExt == null) {
            return false;
        }
        BControlPoint[] points = this.getPoints();
        if (points == null || points.length <= 0) {
            return false;
        }
        int newOffset = 0;
        if (newExt instanceof BModbusServerNumericProxyExt && (((BModbusServerNumericProxyExt)newExt).isDataTypeLong() || ((BModbusServerNumericProxyExt)newExt).isDataTypeFloat())) {
            newOffset = 1;
        }
        int newAddress = newExt.getDataAddress().getDataAddress();
        for (int i = 0; i < points.length; ++i) {
            if (points[i].getProxyExt().equals((Object)newExt) || !(points[i].getProxyExt() instanceof BModbusServerProxyExt) || !points[i].isWritablePoint()) continue;
            if (points[i].getProxyExt() instanceof BModbusServerRegisterBitProxyExt && newExt instanceof BModbusServerRegisterBitProxyExt) {
                int existAddress = ((BModbusServerProxyExt)points[i].getProxyExt()).getDataAddress().getDataAddress();
                if (!((BModbusServerProxyExt)points[i].getProxyExt()).determineRegisterType().equals((Object)newExt.determineRegisterType()) || existAddress != newAddress || ((BModbusServerRegisterBitProxyExt)points[i].getProxyExt()).getBitNumber() != ((BModbusServerRegisterBitProxyExt)newExt).getBitNumber()) continue;
                return true;
            }
            int existOffset = 0;
            if (points[i].getProxyExt() instanceof BModbusServerNumericProxyExt && (((BModbusServerNumericProxyExt)points[i].getProxyExt()).isDataTypeLong() || ((BModbusServerNumericProxyExt)points[i].getProxyExt()).isDataTypeFloat())) {
                existOffset = 1;
            }
            int existAddress = ((BModbusServerProxyExt)points[i].getProxyExt()).getDataAddress().getDataAddress();
            if (!((BModbusServerProxyExt)points[i].getProxyExt()).determineRegisterType().equals((Object)newExt.determineRegisterType()) || existAddress != newAddress && existAddress != newAddress + newOffset && existAddress + existOffset != newAddress && existAddress + existOffset != newAddress + newOffset) continue;
            return true;
        }
        return false;
    }
}

