/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.point;

import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;
import com.tridium.modbusCore.client.point.BModbusClientProxyExt;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.messages.ModbusReadRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import com.tridium.modbusCore.point.BIModbusRegisterBitProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="regType", type="BRegisterTypeEnum", defaultValue="BRegisterTypeEnum.holding"), @NiagaraProperty(name="bitNumber", type="int", defaultValue="0", facets={@Facet(value="BFacets.makeInt(null, 0, 15)")})})
public class BModbusClientRegisterBitProxyExt
extends BModbusClientProxyExt
implements BIModbusRegisterBitProxyExt {
    @Generated
    public static final Property regType = BModbusClientRegisterBitProxyExt.newProperty((int)0, (BValue)BRegisterTypeEnum.holding, null);
    @Generated
    public static final Property bitNumber = BModbusClientRegisterBitProxyExt.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)15));
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusClientRegisterBitProxyExt.class);

    @Override
    @Generated
    public BRegisterTypeEnum getRegType() {
        return (BRegisterTypeEnum)this.get(regType);
    }

    @Override
    @Generated
    public void setRegType(BRegisterTypeEnum v) {
        this.set(regType, (BValue)v, null);
    }

    @Override
    @Generated
    public int getBitNumber() {
        return this.getInt(bitNumber);
    }

    @Override
    @Generated
    public void setBitNumber(int v) {
        this.setInt(bitNumber, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        if (this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)regType, 1);
        }
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    @Override
    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusClientDevice device = (BModbusClientDevice)this.getDevice();
        int address = device.getDeviceAddress();
        int pointAddress = this.getAbsoluteAddress().getDataAddress();
        int count = 1;
        int code = this.isHoldingRegisterType() ? 3 : 4;
        ModbusReadRequest req = new ModbusReadRequest(device.modbusNet().getModbusMode(), device, address, code, pointAddress, count);
        ModbusResponse rsp = (ModbusResponse)device.sendModbusMessage(req);
        if (rsp == null) {
            rsp = new ModbusResponse(device.modbusNet().getModbusMode(), device);
            rsp.exceptionCode = 9;
        }
        this.setOutValues(rsp);
    }

    public void setOutValues(ModbusResponse rec) {
        if (!rec.isError()) {
            this.setBinaryOutValues(rec);
        } else {
            this.readFail(rec.getExceptionString());
        }
    }

    private void setBinaryOutValues(ModbusResponse rec) {
        int regValue = rec.data[1] & 0xFF | (rec.data[0] & 0xFF) << 8;
        int mask = 1;
        boolean binaryValue = (regValue & (mask <<= this.getBitNumber())) != 0;
        this.readOk((BStatusValue)new BStatusBoolean(binaryValue));
    }

    @Override
    public BRegisterTypesEnum determineRegisterType() {
        if (this.getRegType().equals((Object)BRegisterTypeEnum.holding)) {
            return BRegisterTypesEnum.holdingRegister;
        }
        return BRegisterTypesEnum.inputRegister;
    }

    @Override
    public BEnum getRegisterType() {
        return this.getRegType();
    }

    @Override
    public int determineNumRegisters() {
        return 1;
    }

    @Override
    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(bitNumber)) {
            this.setStale(true, null);
            if (this.getParentPoint().isWritablePoint()) {
                if (((BModbusClientDevice)this.getDevice()).writablePointAlreadyExists(this)) {
                    this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                    this.setDataAddress(new BFlexAddress(BAddressFormatEnum.hex, "-1"));
                } else {
                    this.getTuning().writeDesired();
                }
            }
        } else if (prop.equals(regType)) {
            if (context != noAddressCheck) {
                if (this.getParentPoint().isWritablePoint() && !this.isHoldingRegisterType()) {
                    this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
                } else if (this.getDataAddress().isModbusFormat()) {
                    this.setStale(true, null);
                    if (this.getDataAddress().isModbusHoldingAddress()) {
                        if (!this.isHoldingRegisterType()) {
                            this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
                        }
                    } else if (this.isHoldingRegisterType()) {
                        this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
                    }
                }
            }
            if (this.getDevice() != null) {
                if (this.getParentPoint().isWritablePoint() && ((BModbusClientDevice)this.getDevice()).writablePointAlreadyExists(this)) {
                    this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                    this.setDataAddress(new BFlexAddress(BAddressFormatEnum.hex, "-1"));
                }
                this.adjustPollSubscription();
            }
        }
    }

    @Override
    public boolean isValidAddress(BFlexAddress addr) {
        if (!addr.isModbusFormat()) {
            return addr.isValid();
        }
        if (addr.isModbusAnalogAddress()) {
            if (this.getParentPoint().isWritablePoint()) {
                return addr.isModbusHoldingAddress();
            }
            if (addr.isModbusHoldingAddress()) {
                this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
            } else {
                this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
            }
            return true;
        }
        return false;
    }

    public boolean isHoldingRegisterType() {
        return this.getRegType().equals((Object)BRegisterTypeEnum.holding);
    }

    @Override
    public void devicePoll(BDevicePollConfigEntry entry) {
        block5: {
            if (this.configFault || this.isUnoperational()) {
                return;
            }
            BModbusClientDevice device = (BModbusClientDevice)this.getDevice();
            int numRegisters = 1;
            ModbusResponse rsp = new ModbusResponse(device.modbusNet().getModbusMode(), device);
            int pointAddress = this.getAbsoluteAddress().getDataAddress();
            try {
                if (this.isHoldingRegisterType()) {
                    rsp.data = device.getHoldingRegisterValues(pointAddress, numRegisters, entry);
                    rsp.exceptionCode = device.getHoldingRegistersReadStatus(pointAddress, numRegisters, entry).getErrorCode();
                } else {
                    rsp.data = device.getInputRegisterValues(pointAddress, numRegisters, entry);
                    rsp.exceptionCode = device.getInputRegistersReadStatus(pointAddress, numRegisters, entry).getErrorCode();
                }
                rsp.byteCount = (byte)rsp.data.length;
                rsp.numberPoints = numRegisters;
                this.setOutValues(rsp);
            }
            catch (ModbusException e) {
                if (!this.modbusNet().getModbusLog().isTraceOn()) break block5;
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ">>> devicePoll error", (Throwable)((Object)e));
            }
        }
    }

    public void doWrite(BStatusValue out) {
        if (this.getParentPoint().isWritablePoint() && !this.configFault) {
            if (this.modbusNet() != null) {
                if (out == null) {
                    this.updateOutput(this.getWriteValue());
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                } else {
                    this.updateOutput(out);
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                }
            }
        } else if (this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this + "- This ModbusClient register bit point is not writable, disregarding write request.");
        }
        super.doWrite(out);
    }

    public boolean updateOutput(BStatusValue out) {
        ModbusWriteRequest req2;
        ModbusResponse resp;
        boolean bValue = ((BStatusBoolean)out).getValue();
        BModbusClientDevice device = (BModbusClientDevice)this.getDevice();
        BModbusClientNetwork network = (BModbusClientNetwork)this.modbusNet();
        int address = device.getDeviceAddress();
        int pointAddress = this.getAbsoluteAddress().getDataAddress();
        int count = 1;
        int code = this.isHoldingRegisterType() ? 3 : 4;
        ModbusReadRequest req = new ModbusReadRequest(network.getModbusMode(), device, address, code, pointAddress, count);
        ModbusResponse rsp = (ModbusResponse)device.sendModbusMessage(req);
        if (rsp == null) {
            rsp = new ModbusResponse(network.getModbusMode(), device);
            rsp.exceptionCode = 9;
        }
        if (rsp.isError()) {
            this.writeFail(rsp.getExceptionString());
            return false;
        }
        int regValue = rsp.data[1] & 0xFF | (rsp.data[0] & 0xFF) << 8;
        byte[] dataOut = new byte[2];
        int mask = 1;
        regValue = bValue ? (regValue |= mask) : (regValue &= ~(mask <<= this.getBitNumber()));
        dataOut[0] = (byte)(regValue >> 8 & 0xFF);
        dataOut[1] = (byte)(regValue & 0xFF);
        code = 6;
        if (device.isPresetMultiple()) {
            code = 16;
        }
        if ((resp = (ModbusResponse)device.sendModbusMessage(req2 = new ModbusWriteRequest(network.getModbusMode(), device, address, code, pointAddress, count, dataOut))) == null) {
            resp = new ModbusResponse(network.getModbusMode(), device);
            resp.exceptionCode = 9;
        }
        if (resp.isError() && resp.exceptionCode != 5) {
            this.writeFail(resp.getExceptionString());
            return false;
        }
        this.writeOk(out);
        return true;
    }
}

