/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.point;

import com.tridium.modbusCore.ModbusErrorCodes;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigTable;
import com.tridium.modbusCore.client.point.BModbusClientPointDeviceExt;
import com.tridium.modbusCore.client.point.BModbusClientPollGroup;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.enums.BDataSourceEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.point.BIModbusReadProxyExt;
import com.tridium.modbusCore.point.BModbusProxyExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="absoluteAddress", type="BFlexAddress", defaultValue="new BFlexAddress()", flags=3), @NiagaraProperty(name="dataSource", type="BDataSourceEnum", defaultValue="BDataSourceEnum.pointPoll", flags=3)})
public abstract class BModbusClientProxyExt
extends BModbusProxyExt
implements ModbusErrorCodes,
BIModbusReadProxyExt {
    @Generated
    public static final Property absoluteAddress = BModbusClientProxyExt.newProperty((int)3, (BValue)new BFlexAddress(), null);
    @Generated
    public static final Property dataSource = BModbusClientProxyExt.newProperty((int)3, (BValue)BDataSourceEnum.pointPoll, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusClientProxyExt.class);
    protected Object pollSync = new Object();
    protected boolean subscribed = false;
    protected boolean configFault = false;
    private Object lastPollGroupCode = null;

    @Override
    @Generated
    public BFlexAddress getAbsoluteAddress() {
        return (BFlexAddress)this.get(absoluteAddress);
    }

    @Override
    @Generated
    public void setAbsoluteAddress(BFlexAddress v) {
        this.set(absoluteAddress, (BValue)v, null);
    }

    @Override
    @Generated
    public BDataSourceEnum getDataSource() {
        return (BDataSourceEnum)this.get(dataSource);
    }

    @Override
    @Generated
    public void setDataSource(BDataSourceEnum v) {
        this.set(dataSource, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPollGroupCode() {
        Object object = this.pollSync;
        synchronized (object) {
            if (this.lastPollGroupCode != null) {
                return this.lastPollGroupCode;
            }
            BDevicePollConfigEntry entry = null;
            BModbusClientDevice device = (BModbusClientDevice)this.getDevice();
            if (device != null) {
                BRegisterTypesEnum dataType = this.determineRegisterType();
                BDevicePollConfigEntry[] entries = null;
                if (dataType.equals((Object)BRegisterTypesEnum.holdingRegister)) {
                    entries = device.getDevicePollConfig().getActiveHoldingRegisterPollEntries();
                } else if (dataType.equals((Object)BRegisterTypesEnum.inputRegister)) {
                    entries = device.getDevicePollConfig().getActiveInputRegisterPollEntries();
                } else if (dataType.equals((Object)BRegisterTypesEnum.discreteCoil)) {
                    entries = device.getDevicePollConfig().getActiveBinaryCoilPollEntries();
                } else if (dataType.equals((Object)BRegisterTypesEnum.discreteInput)) {
                    entries = device.getDevicePollConfig().getActiveBinaryInputPollEntries();
                }
                int numRegisters = this.determineNumRegisters();
                this.setCurrentAbsoluteAddress();
                int pointAddress = this.getAbsoluteAddress().getDataAddress();
                entry = BDevicePollConfigTable.findPollConfigEntry(entries, pointAddress, numRegisters);
            }
            if (entry != null) {
                this.setDataSource(BDataSourceEnum.devicePoll);
                this.lastPollGroupCode = entry;
            } else {
                this.setDataSource(BDataSourceEnum.pointPoll);
                this.lastPollGroupCode = this;
            }
            return this.lastPollGroupCode;
        }
    }

    public Type getPollGroupType() {
        return BModbusClientPollGroup.TYPE;
    }

    public Type getDeviceExtType() {
        return BModbusClientPointDeviceExt.TYPE;
    }

    public boolean write(Context cx) throws Exception {
        if (this.configFault) {
            return false;
        }
        return super.write(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSubscribed(Context cx) throws Exception {
        this.setCurrentAbsoluteAddress();
        super.readSubscribed(cx);
        Object object = this.pollSync;
        synchronized (object) {
            this.subscribed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readUnsubscribed(Context cx) throws Exception {
        Object object = this.pollSync;
        synchronized (object) {
            if (!this.subscribed) {
                return;
            }
            this.subscribed = false;
        }
        super.readUnsubscribed(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustPollSubscription() {
        Object object = this.pollSync;
        synchronized (object) {
            if (this.subscribed) {
                try {
                    this.readUnsubscribed(null);
                    this.lastPollGroupCode = null;
                    this.readSubscribed(null);
                }
                catch (Exception e) {
                    this.modbusNet().getModbusLog().error(this.getParent().getName() + ">>> adjustPollSubscription error", (Throwable)e);
                }
            } else {
                this.lastPollGroupCode = null;
            }
        }
    }

    public void started() throws Exception {
        BModbusClientDevice device;
        this.setCurrentAbsoluteAddress();
        if (this.getParentPoint().isWritablePoint() && (device = (BModbusClientDevice)this.getDevice()) != null) {
            if (device.writablePointAlreadyExists(this)) {
                this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                this.setDataAddress(new BFlexAddress(BAddressFormatEnum.hex, "-1"));
            }
            device.addWritableProxy(this);
        }
        super.started();
    }

    public void stopped() throws Exception {
        BModbusClientDevice device;
        if (this.getParentPoint().isWritablePoint() && (device = (BModbusClientDevice)this.getDevice()) != null) {
            device.removeWritableProxy(this);
        }
        super.stopped();
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(dataAddress)) {
            this.setStale(true, null);
            if (!this.isValidAddress(this.getDataAddress()) && Sys.atSteadyState() && this.modbusNet() != null && context != Context.commit) {
                this.modbusNet().getModbusLog().error("Illegal Modbus address for point " + this.getParent().getName() + ": Modbus Address does not match Object type.");
            }
            if (this.getDevice() != null) {
                this.adjustPollSubscription();
                this.setCurrentAbsoluteAddress();
                if (!this.configFault) {
                    this.readReset();
                }
                if (this.getParentPoint().isWritablePoint()) {
                    if (((BModbusClientDevice)this.getDevice()).writablePointAlreadyExists(this)) {
                        this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                        this.set(dataAddress, (BValue)new BFlexAddress(BAddressFormatEnum.hex, "-1"), null);
                    } else {
                        this.getTuning().writeDesired();
                    }
                }
            }
        }
    }

    public void setCurrentAbsoluteAddress() {
        if (!this.isValidAddress(this.getDataAddress())) {
            this.configFault = true;
            String errMsg = "Illegal Modbus address " + (Object)((Object)this.getDataAddress()) + " for this point's configuration.";
            this.readFail(errMsg);
        } else {
            this.configFault = false;
        }
        int baseAddr = 0;
        try {
            baseAddr = ((BModbusClientDevice)this.getDevice()).getRegisterBaseAddress(this.getRegisterType());
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException e) {
            baseAddr = 0;
        }
        try {
            BFlexAddress absAddr = (BFlexAddress)this.getDataAddress().newCopy();
            int rawAddress = absAddr.isModbusFormat() ? Integer.valueOf(absAddr.getAddress()).intValue() : absAddr.getDataAddress();
            absAddr.setAddressFromInt(rawAddress + baseAddr);
            this.setAbsoluteAddress(absAddr);
        }
        catch (NullPointerException absAddr) {
        }
        catch (NumberFormatException e) {
            BFlexAddress absAddr = (BFlexAddress)this.getDataAddress().newCopy();
            absAddr.setAddressFromInt(baseAddr);
            this.setAbsoluteAddress(absAddr);
        }
    }

    @Override
    public void poll() {
        if (this.configFault || this.isUnoperational()) {
            return;
        }
        if (this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this.getParent().getName() + ">>> BModbusClientProxyExt.poll");
        }
        this.read();
    }

    public boolean isValidAddress(BFlexAddress addr) {
        return addr.isValid();
    }

    public abstract void devicePoll(BDevicePollConfigEntry var1);

    public abstract BRegisterTypesEnum determineRegisterType();

    public abstract BEnum getRegisterType();

    public abstract int determineNumRegisters();
}

