/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client;

import com.tridium.basicdriver.message.Message;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.ModbusErrorCodes;
import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.datatypes.BCommStatus;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigTable;
import com.tridium.modbusCore.client.datatypes.BModbusClientConfig;
import com.tridium.modbusCore.client.point.BModbusClientBooleanProxyExt;
import com.tridium.modbusCore.client.point.BModbusClientNumericBitsProxyExt;
import com.tridium.modbusCore.client.point.BModbusClientNumericProxyExt;
import com.tridium.modbusCore.client.point.BModbusClientPointDeviceExt;
import com.tridium.modbusCore.client.point.BModbusClientProxyExt;
import com.tridium.modbusCore.client.point.BModbusClientRegisterBitProxyExt;
import com.tridium.modbusCore.client.point.BModbusClientStringProxyExt;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.enums.BStatusTypeEnum;
import com.tridium.modbusCore.messages.ModbusMessageConst;
import com.tridium.modbusCore.messages.ModbusReadRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.util.DataTypeUtil;
import java.util.Arrays;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="modbusConfig", type="BModbusConfig", defaultValue="new BModbusClientConfig()", override=true), @NiagaraProperty(name="pingAddress", type="BFlexAddress", defaultValue="new BFlexAddress()"), @NiagaraProperty(name="pingAddressDataType", type="BDataTypeEnum", defaultValue="BDataTypeEnum.integerType"), @NiagaraProperty(name="pingAddressRegType", type="BRegisterTypeEnum", defaultValue="BRegisterTypeEnum.holding"), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="inputRegisterBaseAddress", type="BFlexAddress", defaultValue="new BFlexAddress()"), @NiagaraProperty(name="holdingRegisterBaseAddress", type="BFlexAddress", defaultValue="new BFlexAddress()"), @NiagaraProperty(name="coilStatusBaseAddress", type="BFlexAddress", defaultValue="new BFlexAddress()"), @NiagaraProperty(name="inputStatusBaseAddress", type="BFlexAddress", defaultValue="new BFlexAddress()"), @NiagaraProperty(name="devicePollConfig", type="BDevicePollConfigTable", defaultValue="new BDevicePollConfigTable()"), @NiagaraProperty(name="points", type="BModbusClientPointDeviceExt", defaultValue="new BModbusClientPointDeviceExt()")})
public abstract class BModbusClientDevice
extends BModbusDevice
implements ModbusMessageConst,
ModbusErrorCodes {
    @Generated
    public static final Property modbusConfig = BModbusClientDevice.newProperty((int)0, (BValue)new BModbusClientConfig(), null);
    @Generated
    public static final Property pingAddress = BModbusClientDevice.newProperty((int)0, (BValue)new BFlexAddress(), null);
    @Generated
    public static final Property pingAddressDataType = BModbusClientDevice.newProperty((int)0, (BValue)BDataTypeEnum.integerType, null);
    @Generated
    public static final Property pingAddressRegType = BModbusClientDevice.newProperty((int)0, (BValue)BRegisterTypeEnum.holding, null);
    @Generated
    public static final Property pollFrequency = BModbusClientDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property inputRegisterBaseAddress = BModbusClientDevice.newProperty((int)0, (BValue)new BFlexAddress(), null);
    @Generated
    public static final Property holdingRegisterBaseAddress = BModbusClientDevice.newProperty((int)0, (BValue)new BFlexAddress(), null);
    @Generated
    public static final Property coilStatusBaseAddress = BModbusClientDevice.newProperty((int)0, (BValue)new BFlexAddress(), null);
    @Generated
    public static final Property inputStatusBaseAddress = BModbusClientDevice.newProperty((int)0, (BValue)new BFlexAddress(), null);
    @Generated
    public static final Property devicePollConfig = BModbusClientDevice.newProperty((int)0, (BValue)new BDevicePollConfigTable(), null);
    @Generated
    public static final Property points = BModbusClientDevice.newProperty((int)0, (BValue)new BModbusClientPointDeviceExt(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusClientDevice.class);
    private Vector<BModbusClientProxyExt> writableProxies = new Vector();
    private int pingsFailed = 0;
    private boolean rdCommError = false;
    private boolean pollRegistered = false;

    @Generated
    public BFlexAddress getPingAddress() {
        return (BFlexAddress)this.get(pingAddress);
    }

    @Generated
    public void setPingAddress(BFlexAddress v) {
        this.set(pingAddress, (BValue)v, null);
    }

    @Generated
    public BDataTypeEnum getPingAddressDataType() {
        return (BDataTypeEnum)this.get(pingAddressDataType);
    }

    @Generated
    public void setPingAddressDataType(BDataTypeEnum v) {
        this.set(pingAddressDataType, (BValue)v, null);
    }

    @Generated
    public BRegisterTypeEnum getPingAddressRegType() {
        return (BRegisterTypeEnum)this.get(pingAddressRegType);
    }

    @Generated
    public void setPingAddressRegType(BRegisterTypeEnum v) {
        this.set(pingAddressRegType, (BValue)v, null);
    }

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public BFlexAddress getInputRegisterBaseAddress() {
        return (BFlexAddress)this.get(inputRegisterBaseAddress);
    }

    @Generated
    public void setInputRegisterBaseAddress(BFlexAddress v) {
        this.set(inputRegisterBaseAddress, (BValue)v, null);
    }

    @Generated
    public BFlexAddress getHoldingRegisterBaseAddress() {
        return (BFlexAddress)this.get(holdingRegisterBaseAddress);
    }

    @Generated
    public void setHoldingRegisterBaseAddress(BFlexAddress v) {
        this.set(holdingRegisterBaseAddress, (BValue)v, null);
    }

    @Generated
    public BFlexAddress getCoilStatusBaseAddress() {
        return (BFlexAddress)this.get(coilStatusBaseAddress);
    }

    @Generated
    public void setCoilStatusBaseAddress(BFlexAddress v) {
        this.set(coilStatusBaseAddress, (BValue)v, null);
    }

    @Generated
    public BFlexAddress getInputStatusBaseAddress() {
        return (BFlexAddress)this.get(inputStatusBaseAddress);
    }

    @Generated
    public void setInputStatusBaseAddress(BFlexAddress v) {
        this.set(inputStatusBaseAddress, (BValue)v, null);
    }

    @Generated
    public BDevicePollConfigTable getDevicePollConfig() {
        return (BDevicePollConfigTable)this.get(devicePollConfig);
    }

    @Generated
    public void setDevicePollConfig(BDevicePollConfigTable v) {
        this.set(devicePollConfig, (BValue)v, null);
    }

    @Generated
    public BModbusClientPointDeviceExt getPoints() {
        return (BModbusClientPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BModbusClientPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(inputRegisterBaseAddress)) {
            if (this.getInputRegisterBaseAddress().isModbusFormat() && !this.getInputRegisterBaseAddress().isModbusInputAddress()) {
                this.setInputRegisterBaseAddress((BFlexAddress)inputRegisterBaseAddress.getDefaultValue());
                if (this.modbusNet() != null) {
                    this.modbusNet().getModbusLog().error("Illegal input register base address on " + this.getName() + ".  Must be an Input register address 3x");
                }
            }
            this.updateProxyPointSubscriptions();
        } else if (property.equals(devicePollConfig)) {
            this.updateProxyPointSubscriptions();
        } else if (property.equals(holdingRegisterBaseAddress)) {
            if (this.getHoldingRegisterBaseAddress().isModbusFormat() && !this.getHoldingRegisterBaseAddress().isModbusHoldingAddress()) {
                this.setHoldingRegisterBaseAddress((BFlexAddress)holdingRegisterBaseAddress.getDefaultValue());
                if (this.modbusNet() != null) {
                    this.modbusNet().getModbusLog().error("Illegal holding register base address on " + this.getName() + ".  Must be a Holding register address 4x");
                }
            }
            this.updateProxyPointSubscriptions();
        } else if (property.equals(coilStatusBaseAddress)) {
            if (this.getCoilStatusBaseAddress().isModbusFormat() && !this.getCoilStatusBaseAddress().isModbusCoilAddress()) {
                this.setCoilStatusBaseAddress((BFlexAddress)coilStatusBaseAddress.getDefaultValue());
                if (this.modbusNet() != null) {
                    this.modbusNet().getModbusLog().error("Illegal coil status base address on " + this.getName() + ".  Must be a Coil address 0x");
                }
            }
            this.updateProxyPointSubscriptions();
        } else if (property.equals(inputStatusBaseAddress)) {
            if (this.getInputStatusBaseAddress().isModbusFormat() && !this.getInputStatusBaseAddress().isModbusStatusAddress()) {
                this.setInputStatusBaseAddress((BFlexAddress)inputStatusBaseAddress.getDefaultValue());
                if (this.modbusNet() != null) {
                    this.modbusNet().getModbusLog().error("Illegal input status base address on " + this.getName() + ".  Must be a Status address 1x");
                }
            }
            this.updateProxyPointSubscriptions();
        }
    }

    public String toString(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("[" + this.getDeviceAddress() + "]");
        return sb.toString();
    }

    public abstract Message sendModbusMessage(Message var1);

    private void setCommStatusOutput(BDevicePollConfigEntry entry, int exceptionCode) {
        if (!this.isDisabled()) {
            boolean bl = this.rdCommError = exceptionCode != 0 && exceptionCode != -2;
        }
        if (entry != null) {
            entry.setReadStatus(new BCommStatus(exceptionCode));
        }
    }

    public void doPing() {
        ModbusReadRequest req;
        if (this.isDisabled() || this.isFault()) {
            return;
        }
        if (this.modbusNet() == null) {
            this.pingFail("No modbus network found");
            return;
        }
        if (!this.modbusNet().isCommActive()) {
            return;
        }
        try {
            req = this.getPingRequest();
        }
        catch (Exception e) {
            this.modbusNet().getModbusLog().error("Error in " + this.getName() + " pinging.  Check Device Status Monitor Address: ", (Throwable)e);
            return;
        }
        ModbusResponse rsp = (ModbusResponse)this.sendModbusMessage(req);
        if (this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace("ping(): " + this.getName() + "[" + this.getDeviceAddress() + "] is " + (rsp == null ? "down" : "up"));
        }
        if (rsp != null && rsp.exceptionCode != 10 && rsp.exceptionCode != 11) {
            this.pingOk();
            this.resetPingsFailed();
        } else if (this.incrementPingsFailed() > ((BModbusClientNetwork)this.modbusNet()).getMaxFailsUntilDeviceDown()) {
            String cause = this.getLexicon().getText("pingFail");
            if (rsp != null) {
                cause = cause + ": " + rsp.getExceptionString();
            }
            this.pingFail(cause);
        }
    }

    private ModbusReadRequest getPingRequest() {
        int address = this.getDeviceAddress();
        int pointAddress = this.getPointAddress();
        int count = 1;
        int dataMode = this.getModbusMode();
        if (this.isDataTypeLong()) {
            count *= 2;
        } else if (this.isDataTypeFloat()) {
            count *= 2;
        }
        int code = this.isHoldingRegisterType() ? 3 : 4;
        ModbusReadRequest req = new ModbusReadRequest(dataMode, this, address, code, pointAddress, count);
        return req;
    }

    public boolean isPresetMultiple() {
        if (this.getModbusConfig().getOverrideNetwork()) {
            return ((BModbusClientConfig)this.getModbusConfig()).getUsePresetMultipleRegister();
        }
        return ((BModbusClientNetwork)this.getNetwork()).getUsePresetMultipleRegister();
    }

    public boolean isForceMultiple() {
        if (this.getModbusConfig().getOverrideNetwork()) {
            return ((BModbusClientConfig)this.getModbusConfig()).getUseForceMultipleCoil();
        }
        return ((BModbusClientNetwork)this.getNetwork()).getUseForceMultipleCoil();
    }

    public int getPointAddress() {
        return this.getPingAddress().getDataAddress();
    }

    public boolean isHoldingRegisterType() {
        return this.getPingAddressRegType() == BRegisterTypeEnum.holding;
    }

    public boolean isDataTypeInteger() {
        return DataTypeUtil.is16BitInteger(this.getPingAddressDataType());
    }

    public boolean isDataTypeLong() {
        return DataTypeUtil.is32BitLong(this.getPingAddressDataType());
    }

    public boolean isDataTypeFloat() {
        return DataTypeUtil.isFloat(this.getPingAddressDataType());
    }

    public int getRegisterBaseAddress(BEnum registerType) {
        if (registerType.equals((Object)BRegisterTypeEnum.holding)) {
            return this.getHoldingRegisterBaseAddress().getDataAddress();
        }
        if (registerType.equals((Object)BRegisterTypeEnum.input)) {
            return this.getInputRegisterBaseAddress().getDataAddress();
        }
        if (registerType.equals((Object)BStatusTypeEnum.coil)) {
            return this.getCoilStatusBaseAddress().getDataAddress();
        }
        return this.getInputStatusBaseAddress().getDataAddress();
    }

    protected int getRegisterBaseAddressFromType(BRegisterTypesEnum registerType) {
        if (registerType.equals((Object)BRegisterTypesEnum.holdingRegister)) {
            return this.getHoldingRegisterBaseAddress().getDataAddress();
        }
        if (registerType.equals((Object)BRegisterTypesEnum.inputRegister)) {
            return this.getInputRegisterBaseAddress().getDataAddress();
        }
        if (registerType.equals((Object)BRegisterTypesEnum.discreteCoil)) {
            return this.getCoilStatusBaseAddress().getDataAddress();
        }
        return this.getInputStatusBaseAddress().getDataAddress();
    }

    private void updateProxyPointSubscriptions() {
        BControlPoint[] points = this.getPoints().getPoints();
        for (int i = 0; i < points.length; ++i) {
            BAbstractProxyExt proxyExt = points[i].getProxyExt();
            if (!(proxyExt instanceof BModbusClientProxyExt)) continue;
            ((BModbusClientProxyExt)proxyExt).adjustPollSubscription();
        }
    }

    public BCommStatus getHoldingRegistersReadStatus(int address, int addressNum, BDevicePollConfigEntry entry) throws ModbusException {
        if (entry == null) {
            throw new ModbusException(102);
        }
        return entry.getReadStatus();
    }

    public BCommStatus getInputRegistersReadStatus(int address, int addressNum, BDevicePollConfigEntry entry) throws ModbusException {
        if (entry == null) {
            throw new ModbusException(102);
        }
        return entry.getReadStatus();
    }

    public BCommStatus getBinaryCoilsReadStatus(int address, int addressNum, BDevicePollConfigEntry entry) throws ModbusException {
        if (entry == null) {
            throw new ModbusException(102);
        }
        return entry.getReadStatus();
    }

    public BCommStatus getBinaryInputsReadStatus(int address, int addressNum, BDevicePollConfigEntry entry) throws ModbusException {
        if (entry == null) {
            throw new ModbusException(102);
        }
        return entry.getReadStatus();
    }

    public byte[] getHoldingRegisterValues(int address, int numRegisters, BDevicePollConfigEntry entry) throws ModbusException {
        int startAddress;
        byte[] registerData = new byte[numRegisters * 2];
        try {
            startAddress = entry.getStartAddress().getDataAddress();
        }
        catch (Exception e) {
            throw new ModbusException(103);
        }
        if (address < startAddress) {
            throw new ModbusException(102);
        }
        int registerOffset = address - startAddress;
        if (registerOffset + numRegisters > entry.getConsecutivePointsToPoll()) {
            throw new ModbusException(102);
        }
        int registerByteOffset = registerOffset * 2;
        if (entry.getByteArray() == null) {
            throw new ModbusException(103);
        }
        if (entry.getByteArray().length < entry.getConsecutivePointsToPoll() * 2) {
            throw new ModbusException(103);
        }
        byte[] holdingRegisterByteArray = entry.getByteArray();
        for (int i = 0; i < numRegisters * 2; ++i) {
            registerData[i] = holdingRegisterByteArray[registerByteOffset + i];
        }
        return registerData;
    }

    public byte[] getInputRegisterValues(int address, int numRegisters, BDevicePollConfigEntry entry) throws ModbusException {
        int startAddress;
        byte[] registerData = new byte[numRegisters * 2];
        try {
            startAddress = entry.getStartAddress().getDataAddress();
        }
        catch (Exception e) {
            throw new ModbusException(103);
        }
        if (address < startAddress) {
            throw new ModbusException(102);
        }
        int registerOffset = address - startAddress;
        if (registerOffset + numRegisters > entry.getConsecutivePointsToPoll()) {
            throw new ModbusException(102);
        }
        int registerByteOffset = registerOffset * 2;
        if (entry.getByteArray() == null) {
            throw new ModbusException(103);
        }
        if (entry.getByteArray().length < entry.getConsecutivePointsToPoll() * 2) {
            throw new ModbusException(103);
        }
        byte[] inputRegisterByteArray = entry.getByteArray();
        for (int i = 0; i < numRegisters * 2; ++i) {
            registerData[i] = inputRegisterByteArray[registerByteOffset + i];
        }
        return registerData;
    }

    public byte[] getCoilStatusValues(int address, int numRegisters, BDevicePollConfigEntry entry) throws ModbusException {
        int startAddress;
        int byteCount = 1;
        byte[] registerData = new byte[byteCount];
        try {
            startAddress = entry.getStartAddress().getDataAddress();
        }
        catch (Exception e) {
            throw new ModbusException(103);
        }
        if (address < startAddress) {
            throw new ModbusException(102);
        }
        int registerOffset = address - startAddress;
        if (registerOffset + numRegisters > entry.getConsecutivePointsToPoll()) {
            throw new ModbusException(102);
        }
        int registerByteOffset = 0;
        int startBit = 0;
        int dataMask = 255 >> 8 - numRegisters;
        if (registerOffset != 0) {
            startBit = registerOffset % 8;
            registerByteOffset = registerOffset / 8;
        }
        if (entry.getByteArray() == null) {
            throw new ModbusException(103);
        }
        if (entry.getByteArray().length < byteCount) {
            throw new ModbusException(103);
        }
        byte[] coilStatusByteArray = entry.getByteArray();
        if (startBit == 0) {
            registerData[0] = (byte)(coilStatusByteArray[registerByteOffset] & dataMask);
        } else {
            int temp = coilStatusByteArray[registerByteOffset] & 0xFF;
            if (startBit + numRegisters > 8) {
                temp |= (coilStatusByteArray[registerByteOffset + 1] & 0xFF) << 8;
            }
            registerData[0] = (byte)((temp >>= startBit) & dataMask);
        }
        return registerData;
    }

    public byte[] getInputStatusValues(int address, int numRegisters, BDevicePollConfigEntry entry) throws ModbusException {
        byte[] inputStatusByteArray;
        int startAddress;
        int byteCount = 1;
        byte[] registerData = new byte[byteCount];
        try {
            startAddress = entry.getStartAddress().getDataAddress();
        }
        catch (Exception e) {
            throw new ModbusException(103);
        }
        if (address < startAddress) {
            throw new ModbusException(102);
        }
        int registerOffset = address - startAddress;
        if (registerOffset + numRegisters > entry.getConsecutivePointsToPoll()) {
            throw new ModbusException(102);
        }
        int registerByteOffset = 0;
        int startBit = 0;
        int dataMask = 255 >> 8 - numRegisters;
        if (registerOffset != 0) {
            startBit = registerOffset % 8;
            registerByteOffset = registerOffset / 8;
        }
        if ((inputStatusByteArray = entry.getByteArray()) == null) {
            throw new ModbusException(103);
        }
        if (inputStatusByteArray.length < byteCount) {
            throw new ModbusException(103);
        }
        if (startBit == 0) {
            registerData[0] = (byte)(inputStatusByteArray[registerByteOffset] & dataMask);
        } else {
            int temp = inputStatusByteArray[registerByteOffset] & 0xFF;
            if (startBit + numRegisters > 8) {
                temp |= (inputStatusByteArray[registerByteOffset + 1] & 0xFF) << 8;
            }
            registerData[0] = (byte)((temp >>= startBit) & dataMask);
        }
        return registerData;
    }

    public byte[] readRegisters(int code, int startAddress, int numRegisters, int minReadSize, BDevicePollConfigEntry entry) throws ModbusException {
        int address = this.getDeviceAddress();
        byte[] data = new byte[(numRegisters / minReadSize + 1) * minReadSize * 2];
        int maxReadSize = 125 - 125 % minReadSize;
        int modbusMode = this.getModbusMode();
        if (modbusMode == 0) {
            maxReadSize /= 2;
        }
        int count = 0;
        int bytesRead = 0;
        if (numRegisters == 0) {
            this.setCommStatusOutput(entry, -2);
            return data;
        }
        if (code != 3 && code != 4) {
            throw new ModbusException(100);
        }
        do {
            ModbusReadRequest req;
            ModbusResponse rsp;
            if ((rsp = (ModbusResponse)this.sendModbusMessage(req = new ModbusReadRequest(modbusMode, this, address, code, startAddress, count = numRegisters > maxReadSize ? maxReadSize : numRegisters + numRegisters % minReadSize))) == null) {
                rsp = new ModbusResponse(modbusMode, this);
                rsp.exceptionCode = 9;
                this.setCommStatusOutput(entry, rsp.exceptionCode);
                throw new ModbusException(101);
            }
            for (int i = 0; i < rsp.byteCount; ++i) {
                data[bytesRead] = rsp.data[i];
                ++bytesRead;
            }
            this.setCommStatusOutput(entry, rsp.exceptionCode);
            startAddress += maxReadSize;
        } while ((numRegisters -= maxReadSize) > 0);
        return data;
    }

    public byte[] readStatusRegisters(int code, int startAddress, int numRegisters, BDevicePollConfigEntry entry) throws ModbusException {
        int address = this.getDeviceAddress();
        int count = 0;
        int maxReadSize = 2000;
        int modbusMode = this.getModbusMode();
        if (modbusMode == 0) {
            maxReadSize /= 2;
        }
        int byteCount = 0;
        byteCount = numRegisters % 8 > 0 ? numRegisters / 8 + 1 : numRegisters / 8;
        byte[] data = new byte[byteCount];
        int bytesRead = 0;
        if (numRegisters == 0) {
            this.setCommStatusOutput(entry, -2);
            return data;
        }
        if (code != 2 && code != 1) {
            throw new ModbusException(100);
        }
        do {
            ModbusReadRequest req;
            ModbusResponse rsp;
            if ((rsp = (ModbusResponse)this.sendModbusMessage(req = new ModbusReadRequest(modbusMode, this, address, code, startAddress, count = numRegisters > maxReadSize ? maxReadSize : numRegisters))) == null) {
                rsp = new ModbusResponse(modbusMode, this);
                rsp.exceptionCode = 9;
                this.setCommStatusOutput(entry, rsp.exceptionCode);
                throw new ModbusException(101);
            }
            for (int i = 0; i < rsp.byteCount; ++i) {
                data[bytesRead] = rsp.data[i];
                ++bytesRead;
            }
            this.setCommStatusOutput(entry, rsp.exceptionCode);
            startAddress += maxReadSize;
        } while ((numRegisters -= maxReadSize) > 0);
        return data;
    }

    public BDevicePollConfigEntry[] getOptimumDevicePollConfigEntryList() {
        int difference;
        int startIndex;
        int consecutiveCount;
        int[] sortedList;
        BControlPoint[] points = this.getPoints().getPoints();
        if (points == null || points.length < 1) {
            return null;
        }
        BDevicePollConfigEntry[] temp = new BDevicePollConfigEntry[points.length];
        int entryCount = 0;
        Vector<BModbusClientProxyExt> holdingRegisterList = new Vector<BModbusClientProxyExt>();
        Vector<BModbusClientProxyExt> inputRegisterList = new Vector<BModbusClientProxyExt>();
        Vector<BModbusClientProxyExt> coilStatusList = new Vector<BModbusClientProxyExt>();
        Vector<BModbusClientProxyExt> inputStatusList = new Vector<BModbusClientProxyExt>();
        for (int i = 0; i < points.length; ++i) {
            BAbstractProxyExt proxyExt = points[i].getProxyExt();
            if (!(proxyExt instanceof BModbusClientProxyExt)) continue;
            BRegisterTypesEnum dataType = ((BModbusClientProxyExt)proxyExt).determineRegisterType();
            if (dataType.equals((Object)BRegisterTypesEnum.holdingRegister)) {
                holdingRegisterList.addElement((BModbusClientProxyExt)proxyExt);
                continue;
            }
            if (dataType.equals((Object)BRegisterTypesEnum.inputRegister)) {
                inputRegisterList.addElement((BModbusClientProxyExt)proxyExt);
                continue;
            }
            if (dataType.equals((Object)BRegisterTypesEnum.discreteCoil)) {
                coilStatusList.addElement((BModbusClientProxyExt)proxyExt);
                continue;
            }
            if (!dataType.equals((Object)BRegisterTypesEnum.discreteInput)) continue;
            inputStatusList.addElement((BModbusClientProxyExt)proxyExt);
        }
        if (holdingRegisterList.size() > 0 && (sortedList = BModbusClientDevice.sortByAbsoluteAddress(holdingRegisterList)) != null && sortedList.length > 0) {
            int currentIndex = 0;
            while (currentIndex < sortedList.length) {
                int startAddress = sortedList[currentIndex];
                consecutiveCount = 1;
                for (int i = startIndex = currentIndex + 1; i < sortedList.length; ++i) {
                    currentIndex = i;
                    difference = sortedList[i] - sortedList[i - 1];
                    if (difference <= 0) continue;
                    if (difference != 1) break;
                    ++consecutiveCount;
                }
                if (consecutiveCount > 1) {
                    BFlexAddress newAddr = new BFlexAddress();
                    newAddr.setAddressFormat(BAddressFormatEnum.modbus);
                    newAddr.setAddressFromInt(startAddress + 40001);
                    temp[entryCount] = new BDevicePollConfigEntry(true, BRegisterTypesEnum.holdingRegister, newAddr, consecutiveCount, 1);
                    ++entryCount;
                }
                if (startIndex < sortedList.length) continue;
                ++currentIndex;
            }
        }
        if (inputRegisterList.size() > 0 && (sortedList = BModbusClientDevice.sortByAbsoluteAddress(inputRegisterList)) != null && sortedList.length > 0) {
            int currentIndex = 0;
            while (currentIndex < sortedList.length) {
                int startAddress = sortedList[currentIndex];
                consecutiveCount = 1;
                for (int i = startIndex = currentIndex + 1; i < sortedList.length; ++i) {
                    currentIndex = i;
                    difference = sortedList[i] - sortedList[i - 1];
                    if (difference <= 0) continue;
                    if (difference != 1) break;
                    ++consecutiveCount;
                }
                if (consecutiveCount > 1) {
                    BFlexAddress newAddr = new BFlexAddress();
                    newAddr.setAddressFormat(BAddressFormatEnum.modbus);
                    newAddr.setAddressFromInt(startAddress + 30001);
                    temp[entryCount] = new BDevicePollConfigEntry(true, BRegisterTypesEnum.inputRegister, newAddr, consecutiveCount, 1);
                    ++entryCount;
                }
                if (startIndex < sortedList.length) continue;
                ++currentIndex;
            }
        }
        if (coilStatusList.size() > 0 && (sortedList = BModbusClientDevice.sortByAbsoluteAddress(coilStatusList)) != null && sortedList.length > 0) {
            int currentIndex = 0;
            while (currentIndex < sortedList.length) {
                int startAddress = sortedList[currentIndex];
                consecutiveCount = 1;
                for (int i = startIndex = currentIndex + 1; i < sortedList.length; ++i) {
                    currentIndex = i;
                    difference = sortedList[i] - sortedList[i - 1];
                    if (difference <= 0) continue;
                    if (difference != 1) break;
                    ++consecutiveCount;
                }
                if (consecutiveCount > 1) {
                    BFlexAddress newAddr = new BFlexAddress();
                    newAddr.setAddressFormat(BAddressFormatEnum.modbus);
                    newAddr.setAddressFromInt(startAddress + 1);
                    temp[entryCount] = new BDevicePollConfigEntry(true, BRegisterTypesEnum.discreteCoil, newAddr, consecutiveCount, 1);
                    ++entryCount;
                }
                if (startIndex < sortedList.length) continue;
                ++currentIndex;
            }
        }
        if (inputStatusList.size() > 0 && (sortedList = BModbusClientDevice.sortByAbsoluteAddress(inputStatusList)) != null && sortedList.length > 0) {
            int currentIndex = 0;
            while (currentIndex < sortedList.length) {
                int startAddress = sortedList[currentIndex];
                consecutiveCount = 1;
                for (int i = startIndex = currentIndex + 1; i < sortedList.length; ++i) {
                    currentIndex = i;
                    difference = sortedList[i] - sortedList[i - 1];
                    if (difference <= 0) continue;
                    if (difference != 1) break;
                    ++consecutiveCount;
                }
                if (consecutiveCount > 1) {
                    BFlexAddress newAddr = new BFlexAddress();
                    newAddr.setAddressFormat(BAddressFormatEnum.modbus);
                    newAddr.setAddressFromInt(startAddress + 10001);
                    temp[entryCount] = new BDevicePollConfigEntry(true, BRegisterTypesEnum.discreteInput, newAddr, consecutiveCount, 1);
                    ++entryCount;
                }
                if (startIndex < sortedList.length) continue;
                ++currentIndex;
            }
        }
        BDevicePollConfigEntry[] result = new BDevicePollConfigEntry[entryCount];
        System.arraycopy(temp, 0, result, 0, entryCount);
        return result;
    }

    private static int[] sortByAbsoluteAddress(Vector<BModbusClientProxyExt> proxyList) {
        Vector<Integer> addressList = new Vector<Integer>();
        BModbusClientProxyExt[] proxies = proxyList.toArray(new BModbusClientProxyExt[0]);
        for (int i = 0; i < proxies.length; ++i) {
            if (proxies[i] instanceof BModbusClientStringProxyExt) {
                addressList.addElement(((BModbusClientStringProxyExt)proxies[i]).getAbsoluteAddress().getDataAddress());
                for (int j = 1; j < ((BModbusClientStringProxyExt)proxies[i]).getNumberRegisters(); ++j) {
                    addressList.addElement(((BModbusClientStringProxyExt)proxies[i]).getAbsoluteAddress().getDataAddress() + j);
                }
                continue;
            }
            if (proxies[i] instanceof BModbusClientNumericProxyExt) {
                addressList.addElement(((BModbusClientNumericProxyExt)proxies[i]).getAbsoluteAddress().getDataAddress());
                if (!((BModbusClientNumericProxyExt)proxies[i]).getDataType().equals((Object)BDataTypeEnum.floatType) && !((BModbusClientNumericProxyExt)proxies[i]).getDataType().equals((Object)BDataTypeEnum.longType)) continue;
                addressList.addElement(((BModbusClientNumericProxyExt)proxies[i]).getAbsoluteAddress().getDataAddress() + 1);
                continue;
            }
            if (!(proxies[i] instanceof BModbusClientProxyExt)) continue;
            addressList.addElement(proxies[i].getAbsoluteAddress().getDataAddress());
        }
        if (addressList.size() < 1) {
            return null;
        }
        Object[] addresses = addressList.toArray();
        int[] sortedList = new int[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            sortedList[i] = (Integer)addresses[i];
        }
        Arrays.sort(sortedList);
        return sortedList;
    }

    @Override
    public BPointDeviceExt getPointDeviceExt() {
        return this.getPoints();
    }

    public int incrementPingsFailed() {
        ++this.pingsFailed;
        return this.pingsFailed;
    }

    public void resetPingsFailed() {
        this.pingsFailed = 0;
    }

    public void addWritableProxy(BModbusClientProxyExt proxyExt) {
        if (this.writableProxies.contains(proxyExt)) {
            return;
        }
        this.writableProxies.add(proxyExt);
    }

    public void removeWritableProxy(BModbusClientProxyExt proxyExt) {
        this.writableProxies.remove(proxyExt);
    }

    public boolean writablePointAlreadyExists(BModbusClientProxyExt newExt) {
        int newAddress;
        if (newExt == null) {
            return false;
        }
        if (this.writableProxies.size() <= 0) {
            return false;
        }
        int newOffset = 0;
        if (newExt instanceof BModbusClientNumericProxyExt && (((BModbusClientNumericProxyExt)newExt).isDataTypeLong() || ((BModbusClientNumericProxyExt)newExt).isDataTypeFloat())) {
            newOffset = 1;
        }
        if ((newAddress = newExt.getDataAddress().getDataAddress()) < 0) {
            return false;
        }
        for (int i = 0; i < this.writableProxies.size(); ++i) {
            BModbusClientProxyExt existingProxy = this.writableProxies.elementAt(i);
            if (existingProxy.equals(newExt) || !(existingProxy instanceof BModbusClientProxyExt)) continue;
            int existAddress = existingProxy.getDataAddress().getDataAddress();
            if (existingProxy instanceof BModbusClientRegisterBitProxyExt && newExt instanceof BModbusClientRegisterBitProxyExt) {
                if (!existingProxy.determineRegisterType().equals((Object)newExt.determineRegisterType()) || existAddress != newAddress || ((BModbusClientRegisterBitProxyExt)existingProxy).getBitNumber() != ((BModbusClientRegisterBitProxyExt)newExt).getBitNumber()) continue;
                return true;
            }
            if (existingProxy instanceof BModbusClientNumericBitsProxyExt && newExt instanceof BModbusClientNumericBitsProxyExt) {
                if (!existingProxy.determineRegisterType().equals((Object)newExt.determineRegisterType()) || existAddress != newAddress || (((BModbusClientNumericBitsProxyExt)existingProxy).getRegisterMask() & ((BModbusClientNumericBitsProxyExt)newExt).getRegisterMask()) == 0) continue;
                return true;
            }
            if (existingProxy instanceof BModbusClientNumericBitsProxyExt && newExt instanceof BModbusClientRegisterBitProxyExt) {
                if (!existingProxy.determineRegisterType().equals((Object)newExt.determineRegisterType()) || existAddress != newAddress || (((BModbusClientNumericBitsProxyExt)existingProxy).getRegisterMask() & 1 << ((BModbusClientRegisterBitProxyExt)newExt).getBitNumber()) == 0) continue;
                return true;
            }
            if (existingProxy instanceof BModbusClientRegisterBitProxyExt && newExt instanceof BModbusClientNumericBitsProxyExt) {
                if (!existingProxy.determineRegisterType().equals((Object)newExt.determineRegisterType()) || existAddress != newAddress || (((BModbusClientNumericBitsProxyExt)newExt).getRegisterMask() & 1 << ((BModbusClientRegisterBitProxyExt)existingProxy).getBitNumber()) == 0) continue;
                return true;
            }
            int existOffset = 0;
            if (existingProxy instanceof BModbusClientNumericProxyExt && (((BModbusClientNumericProxyExt)existingProxy).isDataTypeLong() || ((BModbusClientNumericProxyExt)existingProxy).isDataTypeFloat())) {
                existOffset = 1;
            }
            if (!existingProxy.determineRegisterType().equals((Object)newExt.determineRegisterType()) || existAddress != newAddress && existAddress != newAddress + newOffset && existAddress + existOffset != newAddress && existAddress + existOffset != newAddress + newOffset) continue;
            return true;
        }
        return false;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        try {
            out.startProps();
            out.trTitle((Object)"WritablePoint Cache", 1);
            for (int i = 0; i < this.writableProxies.size(); ++i) {
                BModbusClientProxyExt proxy = this.writableProxies.elementAt(i);
                BControlPoint point = proxy.getParentPoint();
                String name = "";
                name = proxy.getType().is(BModbusClientBooleanProxyExt.TYPE) ? "Coil   : 0x" : "Holding: 0x";
                name = name + Integer.toHexString(proxy.getDataAddress().getDataAddress()) + ": ";
                out.prop((Object)name, (Object)proxy.getParentPoint().getSlotPath());
            }
            out.endProps();
        }
        catch (Exception e) {
            out.endProps();
        }
    }
}

