/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.sqlserver;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.TridiumHostnameVerifier;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.CryptoSupport;
import com.tridium.crypto.core.io.TrustManagerBuilder;
import com.tridium.rdb.sqlserver.BSqlServerDatabase;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.sys.BajaRuntimeException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public final class SqlServerClientTrustManager
extends X509ExtendedTrustManager {
    private final BSslTlsEnum minTlsProtocol;
    private final TrustManager[] trustManagers;
    private final String expectedHostname;
    private final boolean verifyHostnameInCertificate;
    private static final TrustManager[] EMPTY_TRUST_MANAGER_ARRAY = new TrustManager[0];
    private static final X509Certificate[] EMPTY_X_509_CERTIFICATE_ARRAY = new X509Certificate[0];
    private static final String NEGOTIATED_TLS_PROTOCOL_TOO_LOW_FORMAT = "Negotiated TLS version is too low, requested: %s, negotiated: %s";
    private static final String CLIENT_CERT_AUTH_NOT_SUPPORTED_MESSAGE = "No client certs trusted by the client Trust Manager";

    public SqlServerClientTrustManager(String rdbSqlServerOrd) throws CertificateException {
        BSqlServerDatabase db;
        try {
            OrdTarget dbOrd = BOrd.make((String)rdbSqlServerOrd).resolve();
            db = (BSqlServerDatabase)dbOrd.get().as(BSqlServerDatabase.class);
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Unable to resolve rdbSqlServer at ord: " + rdbSqlServerOrd);
        }
        this.minTlsProtocol = db.getTlsMinProtocol();
        String sqlServerCertAlias = db.getSqlServerCert();
        this.verifyHostnameInCertificate = db.getVerifySubjectInCertificate();
        this.expectedHostname = db.getServerCertificateSubjectIdentifier();
        try {
            if (this.verifyHostnameInCertificate && !sqlServerCertAlias.isEmpty()) {
                X509Certificate sqlServerCert = CoreCryptoManager.get().getUserTrustStore().getCertificate(sqlServerCertAlias);
                TrustAnchor sqlServerTrustAnchor = new TrustAnchor(sqlServerCert, null);
                this.trustManagers = TrustManagerBuilder.getTrustManagers(Collections.singleton(sqlServerTrustAnchor));
            } else {
                this.trustManagers = EMPTY_TRUST_MANAGER_ARRAY;
            }
        }
        catch (Exception e) {
            String exceptionMessage = String.format("Unable to obtain SQL Server Certificate for alias: %s", sqlServerCertAlias);
            throw new CertificateException(exceptionMessage, e);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType, Socket socket) throws CertificateException {
        throw new CertificateException(CLIENT_CERT_AUTH_NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType, Socket socket) throws CertificateException {
        if (socket instanceof SSLSocket) {
            String handshakeTlsProtocol = ((SSLSocket)socket).getHandshakeSession().getProtocol();
            this.checkTlsVersionFromHandshake(handshakeTlsProtocol);
        }
        this.checkServerTrusted(x509Certificates, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType, SSLEngine sslEngine) throws CertificateException {
        throw new CertificateException(CLIENT_CERT_AUTH_NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType, SSLEngine sslEngine) throws CertificateException {
        if (sslEngine != null) {
            String handshakeTlsProtocol = sslEngine.getHandshakeSession().getProtocol();
            this.checkTlsVersionFromHandshake(handshakeTlsProtocol);
        }
        this.checkServerTrusted(x509Certificates, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        throw new CertificateException(CLIENT_CERT_AUTH_NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        TridiumHostnameVerifier hostnameVerifier;
        for (X509Certificate cert : x509Certificates) {
            cert.checkValidity();
        }
        if (x509Certificates[0].getExtendedKeyUsage() != null && !CertUtils.isServerCertificate((X509Certificate)x509Certificates[0])) {
            throw new CertificateException("The certificate presented is not issued for server authentication");
        }
        if (this.verifyHostnameInCertificate && !(hostnameVerifier = new TridiumHostnameVerifier(null)).verify(this.expectedHostname, x509Certificates)) {
            throw new CertificateException("Hostname in server certificate does not match expected value");
        }
        if (this.trustManagers.length > 0 && this.trustManagers[0] != null && this.trustManagers[0] instanceof X509TrustManager) {
            ((X509TrustManager)this.trustManagers[0]).checkServerTrusted(x509Certificates, authType);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return EMPTY_X_509_CERTIFICATE_ARRAY;
    }

    private void checkTlsVersionFromHandshake(String handshakeTlsProtocol) throws CertificateException {
        BSslTlsEnum negotiatedTlsProtocol = BSslTlsEnum.make((String)((String)CryptoSupport.TYPE_TAG_TO_VERSION.get(handshakeTlsProtocol)));
        if (this.minTlsProtocol.compareTo((Object)negotiatedTlsProtocol) > 0) {
            String exceptionMessage = String.format(NEGOTIATED_TLS_PROTOCOL_TOO_LOW_FORMAT, this.minTlsProtocol, negotiatedTlsProtocol);
            throw new CertificateException(exceptionMessage);
        }
    }
}

