/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.sqlserver;

import com.tridium.crypto.core.cert.PemSource;
import com.tridium.rdb.BEncryptableTransportRdbms;
import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.jdbc.RdbmsDialect;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import com.tridium.rdb.sqlserver.BConnectionPool;
import com.tridium.rdb.sqlserver.BSqlServerConnector;
import com.tridium.rdb.sqlserver.BSqlServerVersion;
import com.tridium.rdb.sqlserver.history.BSqlServerHistoryDeviceExt;
import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.SQLException;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbmsTimestampStorage;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.Constraint;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.security.auth.x500.X500Principal;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="instanceName", type="String", defaultValue=""), @NiagaraProperty(name="port", type="int", defaultValue="1433"), @NiagaraProperty(name="histories", type="BSqlServerHistoryDeviceExt", defaultValue="new BSqlServerHistoryDeviceExt()"), @NiagaraProperty(name="connectionPool", type="BConnectionPool", defaultValue="new BConnectionPool()", flags=4), @NiagaraProperty(name="extraConnectionProperties", type="String", defaultValue=""), @NiagaraProperty(name="version", type="BSqlServerVersion", defaultValue="BSqlServerVersion.sqlServer2008", flags=0x10000000), @NiagaraProperty(name="connector", type="BSqlServerConnector", defaultValue="BSqlServerConnector.jtds"), @NiagaraProperty(name="sqlServerCert", type="String", defaultValue="", flags=4, facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"workbench:UserTrustCertificateAliasFE\"))"), @Facet(value="BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make(\"webEditors:CertificateAliasEditor\"))"), @Facet(value="BFacets.make(\"storeId\", BString.make(\"USER_TRUST_STORE\"))"), @Facet(value="BFacets.make(\"purposeId\", BString.make(\"\"))")})})
public class BSqlServerDatabase
extends BEncryptableTransportRdbms {
    @Generated
    public static final Property instanceName = BSqlServerDatabase.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property port = BSqlServerDatabase.newProperty((int)0, (int)1433, null);
    @Generated
    public static final Property histories = BSqlServerDatabase.newProperty((int)0, (BValue)new BSqlServerHistoryDeviceExt(), null);
    @Generated
    public static final Property connectionPool = BSqlServerDatabase.newProperty((int)4, (BValue)new BConnectionPool(), null);
    @Generated
    public static final Property extraConnectionProperties = BSqlServerDatabase.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property version = BSqlServerDatabase.newProperty((int)0x10000000, (BValue)BSqlServerVersion.sqlServer2008, null);
    @Generated
    public static final Property connector = BSqlServerDatabase.newProperty((int)0, (BValue)BSqlServerConnector.jtds, null);
    @Generated
    public static final Property sqlServerCert = BSqlServerDatabase.newProperty((int)4, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"workbench:UserTrustCertificateAliasFE")), (BFacets)BFacets.make((String)"uxFieldEditor", (BIDataValue)BString.make((String)"webEditors:CertificateAliasEditor"))), (BFacets)BFacets.make((String)"storeId", (BIDataValue)BString.make((String)"USER_TRUST_STORE"))), (BFacets)BFacets.make((String)"purposeId", (BIDataValue)BString.make((String)""))));
    @Generated
    public static final Type TYPE = Sys.loadType(BSqlServerDatabase.class);
    private final RdbmsDialect DIALECT = new RdbmsDialect(){

        public String getValidationQuery() {
            return "select 1;";
        }

        public void issueCheckpoint(Connection conn) throws SQLException {
        }

        public boolean supportsBatchInsert() {
            return false;
        }

        public boolean supportsBatchUpdate() {
            return true;
        }

        public boolean supportsBatchDelete() {
            return true;
        }

        public int getInsertionMode() {
            return 1;
        }

        public String getIdentityCreation() {
            return "IDENTITY";
        }

        public String getIdentityLookup() {
            throw new UnsupportedOperationException();
        }

        public String getSequenceName(String tableName) {
            throw new UnsupportedOperationException();
        }

        public String getSequenceLookup(String tableName) {
            throw new UnsupportedOperationException();
        }

        public String getAlterColumn() {
            return "ALTER COLUMN";
        }

        public String getAlterColumnSuffix() {
            return null;
        }

        public boolean getAlterColumnSupportsNotNull() {
            return true;
        }

        public String getStringLengthFunctionName() {
            return "LEN";
        }

        public int getMaxTableName() {
            return 128;
        }

        public int getMaxIndexName() {
            return 128;
        }

        public int getMaxConstraintName() {
            return 128;
        }

        public int getMaxColumnName() {
            return 128;
        }

        public boolean allowsUnicodeNames() {
            return true;
        }

        public String getColumnIdentifier(String schemaName, String tableName, String columnName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName + ".\"" + columnName + "\"";
            }
            return tableName + ".\"" + columnName + "\"";
        }

        public String getTableIdentifier(String schemaName, String tableName) {
            if (schemaName != null && schemaName.length() > 0) {
                return schemaName + "." + tableName;
            }
            return tableName;
        }

        public String getDropIndex(String tableName, String indexName) {
            return "DROP INDEX " + tableName + "." + indexName;
        }

        public String getDropConstraint(String tableName, Constraint constraint) {
            return "ALTER TABLE " + tableName + " DROP CONSTRAINT " + constraint.getName();
        }

        public String getIntType() {
            return "INTEGER";
        }

        public String getLongType() {
            return "BIGINT";
        }

        public String getFloatType() {
            return "REAL";
        }

        public String getDoubleType() {
            return "DOUBLE PRECISION";
        }

        public String getCharType() {
            return BSqlServerDatabase.this.getUseUnicodeEncodingScheme() ? "NCHAR" : "CHAR";
        }

        public String getVarCharType() {
            return BSqlServerDatabase.this.getUseUnicodeEncodingScheme() ? "NVARCHAR" : "VARCHAR";
        }

        public String getUuidType() {
            return "UNIQUEIDENTIFIER";
        }

        public String getDateType() {
            return "DATE";
        }

        public String getBooleanType() {
            return "BIT";
        }

        public String getTimestampType() {
            return "DATETIME";
        }

        public boolean supportsBooleanType() {
            return true;
        }

        public boolean supportsMillisecondTimestamp() {
            return false;
        }

        public boolean useUtcTimestamps() {
            return BSqlServerDatabase.this.getTimestampStorage().equals((Object)BRdbmsTimestampStorage.utcTimestamp);
        }

        public boolean supportsDateType() {
            return BSqlServerDatabase.this.getVersion().getOrdinal() >= 2;
        }

        public String getBlobType() {
            return "IMAGE";
        }

        public boolean usesDefaultBlobTranslator() {
            return true;
        }

        public void setBlobValue(RdbmsPreparedStatement prep, int index, byte[] bytes) {
            throw new UnsupportedOperationException();
        }

        public String getClobType() {
            return BSqlServerDatabase.this.getUseUnicodeEncodingScheme() ? "NTEXT" : "TEXT";
        }

        public boolean usesDefaultClobTranslator() {
            return true;
        }

        public void setClobValue(RdbmsPreparedStatement prep, int index, String str) {
            throw new UnsupportedOperationException();
        }

        public AesSysKeyEncoder getSysEncoder() {
            return BSqlServerDatabase.this.getEncoder();
        }

        public String getOnDelete(int onDelete) {
            switch (onDelete) {
                case 1: {
                    return "CASCADE";
                }
                case 0: {
                    return "NO ACTION";
                }
            }
            throw new IllegalStateException();
        }

        public boolean supportsDropColumn() {
            return true;
        }

        public boolean supportsRenameTable() {
            return false;
        }

        public boolean supportsClusteredIndex() {
            return true;
        }

        public int getJdbcTypeBlob() {
            return 2004;
        }

        public int getJdbcTypeBoolean() {
            return -7;
        }

        public int getJdbcTypeChar() {
            return 1;
        }

        public int getJdbcTypeClob() {
            return 2005;
        }

        public int getJdbcTypeDouble() {
            return 8;
        }

        public int getJdbcTypeFloat() {
            return 7;
        }

        public int getJdbcTypeInt() {
            return 4;
        }

        public int getJdbcTypeLong() {
            return -5;
        }

        public int getJdbcTypeTimestamp() {
            return -5;
        }

        public int getJdbcTypeUuid() {
            return 1;
        }

        public int getJdbcTypeVarchar() {
            return 12;
        }

        public int getJdbcTypeDate() {
            return this.supportsDateType() ? 91 : 93;
        }
    };

    @Generated
    public String getInstanceName() {
        return this.getString(instanceName);
    }

    @Generated
    public void setInstanceName(String v) {
        this.setString(instanceName, v, null);
    }

    @Generated
    public int getPort() {
        return this.getInt(port);
    }

    @Generated
    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    @Generated
    public BSqlServerHistoryDeviceExt getHistories() {
        return (BSqlServerHistoryDeviceExt)this.get(histories);
    }

    @Generated
    public void setHistories(BSqlServerHistoryDeviceExt v) {
        this.set(histories, (BValue)v, null);
    }

    @Generated
    public BConnectionPool getConnectionPool() {
        return (BConnectionPool)this.get(connectionPool);
    }

    @Generated
    public void setConnectionPool(BConnectionPool v) {
        this.set(connectionPool, (BValue)v, null);
    }

    @Generated
    public String getExtraConnectionProperties() {
        return this.getString(extraConnectionProperties);
    }

    @Generated
    public void setExtraConnectionProperties(String v) {
        this.setString(extraConnectionProperties, v, null);
    }

    @Generated
    public BSqlServerVersion getVersion() {
        return (BSqlServerVersion)this.get(version);
    }

    @Generated
    public void setVersion(BSqlServerVersion v) {
        this.set(version, (BValue)v, null);
    }

    @Generated
    public BSqlServerConnector getConnector() {
        return (BSqlServerConnector)this.get(connector);
    }

    @Generated
    public void setConnector(BSqlServerConnector v) {
        this.set(connector, (BValue)v, null);
    }

    @Generated
    public String getSqlServerCert() {
        return this.getString(sqlServerCert);
    }

    @Generated
    public void setSqlServerCert(String v) {
        this.setString(sqlServerCert, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSqlServerDatabase() {
    }

    public BSqlServerDatabase(BOrd address, int port) {
        this.setHostAddress(address);
        this.setPort(port);
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "rdbSqlServer");
    }

    public Connection getConnection(String userName, BPassword password) throws SQLException {
        BStatus status = this.getStatus();
        if (status.isFault()) {
            return null;
        }
        return this.getConnectionPool().getConnection(userName, AccessController.doPrivileged(() -> ((BPassword)password).getValue()));
    }

    public void rdbmsStarted() throws Exception {
        super.rdbmsStarted();
        this.setFlags((Slot)connector, this.getFlags((Slot)connector) | 1 | 4);
        this.setConnector(BSqlServerConnector.mssql);
        int flags = this.getFlags((Slot)sqlServerCert);
        this.setFlags((Slot)sqlServerCert, flags &= 0xFFFFFFFB);
    }

    public RdbmsContext getRdbmsContext() {
        return this.DIALECT;
    }

    protected void loadTrustStore(KeyStore keyStore, Context context) throws IOException {
    }

    protected void saveTrustStore(KeyStore keyStore, Context context) throws IOException {
    }

    protected void updateCertificateInTrustStore(String serverCertificateAlias, Context context) {
    }

    public String getServerCertificateSubjectIdentifier() {
        String subjectIdentifier = "";
        if (this.getVerifySubjectInCertificate() && this.getSqlServerCert().isEmpty()) {
            subjectIdentifier = this.getHostname();
        }
        try {
            X509Certificate serverCertificate = this.getServerCertificateFromSource(this.getSqlServerCert());
            if (serverCertificate != null) {
                subjectIdentifier = PemSource.extractCommonName((X500Principal)serverCertificate.getSubjectX500Principal());
            }
        }
        catch (GeneralSecurityException e) {
            throw new BajaRuntimeException((Throwable)e);
        }
        return subjectIdentifier;
    }

    protected Property getServerCertificateProperty() {
        return sqlServerCert;
    }

    public Path getTrustStorePath() {
        return null;
    }
}

