/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro;

import com.tridium.gx.DefaultGeomPeer;
import com.tridium.gx.FontPeer;
import com.tridium.gx.GeomPeer;
import com.tridium.gx.GxEnv;
import com.tridium.gx.ImagePeer;
import com.tridium.gx.micro.MicroFont;
import com.tridium.gx.micro.MicroFontPeer;
import com.tridium.gx.micro.MicroFontReader;
import com.tridium.gx.micro.MicroImagePeer;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.IGeom;

public class MicroEnv
extends GxEnv {
    static Logger logger = Logger.getLogger("com.tridium.gx.micro");
    private static ConcurrentHashMap<BFont, BFont> fontSubstitutions = new ConcurrentHashMap();
    private static boolean warned = false;

    public boolean isRotationSupported() {
        return true;
    }

    public FontPeer makeFontPeer(BFont font) {
        return MicroEnv.peer(font);
    }

    public GeomPeer makeGeomPeer(IGeom geom) {
        return DefaultGeomPeer.make((IGeom)geom);
    }

    public ImagePeer makeImagePeer(BImage image) {
        return MicroEnv.peer(image);
    }

    public BImage makeImage(byte[] data) {
        throw new UnsupportedOperationException("Memory images not supported.");
    }

    public BImage makeImage(double width, double height) {
        throw new UnsupportedOperationException("Memory images not supported.");
    }

    public static MicroFontPeer peer(BFont font) {
        MicroFont microFont = MicroFontReader.read(font);
        if (microFont == null) {
            BFont substitute = fontSubstitutions.get(font);
            if (substitute == null) {
                substitute = MicroFontReader.getSubstitute(font);
                fontSubstitutions.put(font, substitute);
                if (!(font.getName().equals("monospaced") || font.getName().equals("sansserif") || font.getName().equals("serif"))) {
                    if (!warned) {
                        logger.log(Level.WARNING, "Substituting a missing MicroFont with another MicroFont. Set this log's level to FINE for more details.");
                        warned = true;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Substituting in " + substitute + " for " + font + ". To remove this warning, use the Embedded Device Font Tool to generate the missing " + font + " MicroFont (.font file).");
                    }
                } else if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Substituting in " + substitute + " for " + font + ".");
                }
            }
            microFont = MicroFontReader.read(substitute);
        }
        return new MicroFontPeer(microFont, font.getSize());
    }

    public List<String> getFontList() {
        return MicroFontReader.getFontList();
    }

    public static MicroImagePeer peer(BImage image) {
        return new MicroImagePeer(image);
    }
}

