/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui.station;

import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.ui.util.BInputStreamPane;
import com.tridium.provisioningNiagara.station.BStationProxy;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BStationProxyOutputPane
extends BInputStreamPane {
    @Generated
    public static final Type TYPE = Sys.loadType(BStationProxyOutputPane.class);
    private BStationProxy station = null;
    private boolean updatesOnly = false;
    private volatile FilePath capturePath = null;
    private volatile Writer captureWriter = null;
    private static final Logger log = Logger.getLogger("provisioningNiagara");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BStationProxyOutputPane() {
        this.setBufferTime(-1);
    }

    public BStationProxyOutputPane(int rows, int cols) {
        super(rows, cols);
        this.setBufferTime(-1);
    }

    public BStationProxyOutputPane(int rows, int cols, boolean updatesOnly) {
        super(rows, cols);
        this.setBufferTime(-1);
        this.updatesOnly = updatesOnly;
    }

    protected InputStream getInputStream() {
        try {
            return this.station.getStationOutput(true, this.updatesOnly);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void loadStation(BStationProxy value) {
        BStationProxy oldStation = this.station;
        this.station = value;
        if (oldStation != this.station) {
            this.load();
        }
    }

    public void setCapturePath(FilePath value) {
        this.capturePath = value;
    }

    protected synchronized void startUpdates(BInputStreamPane.OutputWatcher value) {
        if (this.capturePath != null) {
            try {
                this.captureWriter = new BufferedWriter(new OutputStreamWriter(BFileSystem.INSTANCE.makeFile(this.capturePath).getOutputStream()));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Exception occurred while starting station proxy output updates", e);
            }
        }
        super.startUpdates(value);
    }

    public void append(String text) {
        super.append(text);
        if (this.captureWriter != null) {
            try {
                this.captureWriter.write(text);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Exception occurred while appending station proxy output", e);
                try {
                    this.captureWriter.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.captureWriter = null;
            }
        }
    }

    public synchronized void stopUpdates() {
        super.stopUpdates();
        try {
            Thread.sleep(BStationSurrogate.getStreamTimeoutMillis() + 100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.captureWriter != null) {
            try {
                this.captureWriter.close();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Exception occurred while stopping station proxy output updates", e);
            }
            this.captureWriter = null;
        }
    }

    public BStationProxy getStation() {
        return this.station;
    }
}

