/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.ui;

import com.tridium.batchJob.ui.ViewQueryParameter;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.FavoriteDirectory;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import com.tridium.provisioningNiagara.ui.BNiagaraNetworkJobEditor;
import com.tridium.template.TemplateConst;
import com.tridium.template.file.NtplUtil;
import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BValueList;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.UnresolvedException;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.provisioningNiagara.BNiagaraNetworkJob;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"provisioningNiagara:ProvisioningNiagaraNetworkExt"})})
public class BNiagaraNetworkJobBuilder
extends BNiagaraNetworkJobEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraNetworkJobBuilder.class);
    private Command submit = new Submit();
    private Command copyTemplates;
    public static final String TEMPLATE_CACHE = "file:^templateCache";
    BProvisioningNiagaraNetworkExt nwExt;
    public static final Logger log = Logger.getLogger("provisioningNiagara");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNiagaraNetworkJobBuilder() {
        this.buttons.add(this.submit);
        this.copyTemplates = new CopyTemplates();
        this.buttons.add(this.copyTemplates);
    }

    public void doLoadValue(BObject value, Context cx) throws Exception {
        this.nwExt = (BProvisioningNiagaraNetworkExt)value;
        this.nwExt.lease();
        BDeviceNetwork network = (BDeviceNetwork)BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get(value);
        this.stations.load(network);
        this.allJobSteps.load(null, (BObject)network);
        BWbShell shell = BWbShell.getWbShell((BWidget)this);
        if (shell != null) {
            this.buttons.add(shell.getRefreshCommand(), true, true);
            OrdQuery[] q = shell.getActiveOrd().parse();
            if (q[q.length - 1] instanceof ViewQuery) {
                String stepParms;
                ViewQuery vq = (ViewQuery)q[q.length - 1];
                String stationIds = vq.getParameter("stations", null);
                if (stationIds != null) {
                    this.stations.addDevices((BSimple[])((BString[])((BValueList)ViewQueryParameter.decode((String)stationIds)).toArray()));
                }
                if ((stepParms = vq.getParameter("steps", null)) != null) {
                    for (String parm : TextUtil.split((String)stepParms, (char)',')) {
                        BObject stepObj = ViewQueryParameter.decode((String)parm);
                        this.allJobSteps.addJobStep((BJobStep)stepObj);
                    }
                }
            }
        }
    }

    @Override
    protected BNiagaraNetworkJob saveJob() {
        BNiagaraNetworkJob job = new BNiagaraNetworkJob();
        this.stations.saveToJob((BDeviceNetworkJob)job);
        job.setAlertOnStepFailure(this.alertOnStepFailureCheckBox.isSelected());
        job.setAlertOnJobSuccess(this.alertOnJobSuccessCheckBox.isSelected());
        this.allJobSteps.saveToStage((BJobStage)job.getInitialStage());
        this.allJobSteps.saveToStage((BJobStage)job.getForEachStationStage());
        return job;
    }

    @Override
    public void doHandleListUpdated(BWidgetEvent event) {
        boolean enable = this.stations.getModel().getItemCount() > 0 && this.allJobSteps.getModel().getItemCount() > 0;
        this.submit.setEnabled(enable);
    }

    private class CopyTemplates
    extends Command
    implements TemplateConst {
        public CopyTemplates() {
            super((BWidget)BNiagaraNetworkJobBuilder.this, BNiagaraNetworkJobEditor.lex, "NiagaraNetworkJobBuilder.copyTemplates");
            this.setEnabled(true);
        }

        public CommandArtifact doInvoke() {
            try {
                BWbShell shell = BWbShell.getWbShell((BWidget)BNiagaraNetworkJobBuilder.this);
                BDirectory currentSelection = FavoriteDirectory.loadByPath((String)"provisioning", (String)"lastTemplateDirBrowsed", (FilePath)NtplUtil.getTemplateDirectory().getFilePath());
                ExtFileFilter templateFilter = new ExtFileFilter("Template And Excel Files", new String[]{"ntpl", "napl", "xlsx", "xls"});
                BIFile[] templateFiles = BFileChooserDialog.chooseFiles((BWidget)shell, (BImage)BImage.make((String)BNiagaraNetworkJobEditor.lex.getText("NiagaraNetworkJobBuilder.copyFileDialog.icon")), (String)BNiagaraNetworkJobEditor.lex.getText("NiagaraNetworkJobBuilder.copyFileDialog.title"), (String)BNiagaraNetworkJobEditor.lex.getText("NiagaraNetworkJobBuilder.copyFileDialog.message"), (BIFile)currentSelection, (IFileFilter)templateFilter, (IFileFilter)templateFilter);
                if (templateFiles == null || templateFiles.length == 0) {
                    return null;
                }
                FilePath savePath = null;
                String[] names = new String[templateFiles.length];
                BObject[] objects = new BObject[templateFiles.length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = templateFiles[i].getFileName();
                    objects[i] = (BObject)templateFiles[i];
                }
                BObject cacheDir = this.getTarget(BOrd.make((String)BNiagaraNetworkJobBuilder.TEMPLATE_CACHE), (BObject)BNiagaraNetworkJobBuilder.this.nwExt);
                if (cacheDir instanceof BDirectory && !this.deleteExistingFiles(names, (BDirectory)cacheDir, shell)) {
                    return null;
                }
                Mark mark = new Mark(objects, names);
                mark.copyTo(cacheDir, new BComponent(), (Context)new BasicContext());
                savePath = templateFiles[0].getFilePath().getParent();
                if (savePath != null) {
                    FavoriteDirectory.savePath((String)"provisioning", (String)"lastTemplateDirBrowsed", (FilePath)savePath);
                }
                StringJoiner sj = new StringJoiner(",");
                for (String fileName : names) {
                    sj.add(fileName);
                }
                BDialog.info((BWidget)BNiagaraNetworkJobBuilder.this, (String)BNiagaraNetworkJobEditor.lex.getText("NiagaraNetworkJobBuilder.copyTemplates.complete"), (Object)BString.make((String)BNiagaraNetworkJobEditor.lex.getText("NiagaraNetworkJobBuilder.copyTemplates.completeDetail", new Object[]{BNiagaraNetworkJobBuilder.TEMPLATE_CACHE, sj.toString()})));
            }
            catch (Exception e) {
                BDialog.error((BWidget)BNiagaraNetworkJobBuilder.this, (String)BNiagaraNetworkJobEditor.lex.getText("NiagaraNetworkJobBuilder.copyTemplates.error"), (Object)BNiagaraNetworkJobEditor.lex.getText("NiagaraNetworkJobBuilder.copyTemplates.errorDetail"), (Throwable)e);
            }
            return null;
        }

        private boolean deleteExistingFiles(String[] filenamesToDelete, BDirectory cacheDir, BWbShell shell) {
            BIFile[] cacheFiles;
            ArrayList<BIFile> deleteList = new ArrayList<BIFile>();
            block2: for (BIFile file : cacheFiles = cacheDir.listFiles()) {
                for (String fileName : filenamesToDelete) {
                    if (!file.getFileName().equalsIgnoreCase(fileName)) continue;
                    deleteList.add(file);
                    continue block2;
                }
            }
            if (!deleteList.isEmpty()) {
                StringJoiner sj = new StringJoiner(",");
                for (BIFile file : deleteList) {
                    sj.add(file.getFileName());
                }
                if (2 == BDialog.open((BWidget)shell, (String)BNiagaraNetworkJobEditor.lex.getText("NiagaraNetworkJobBuilder.deleteExisting.title"), (Object)BNiagaraNetworkJobEditor.lex.getText("NiagaraNetworkJobBuilder.deleteExisting.message", new Object[]{sj.toString()}), (int)3, (BImage)BDialog.WARNING_ICON, (String)null)) {
                    return false;
                }
                for (BIFile file : deleteList) {
                    try {
                        file.delete();
                    }
                    catch (Exception e) {
                        BDialog.error((BWidget)BNiagaraNetworkJobBuilder.this, (String)BNiagaraNetworkJobEditor.lex.getText("NiagaraNetworkJobBuilder.deleteExisting.title"), (Object)BNiagaraNetworkJobEditor.lex.getText("NiagaraNetworkJobBuilder.deleteExisting.error", new Object[]{file.getFileName()}), (Throwable)e);
                        return false;
                    }
                }
            }
            return true;
        }

        private BObject getTarget(BOrd ord, BObject target) throws Exception {
            BObject obj;
            try {
                obj = ord.resolve(target).get();
            }
            catch (UnresolvedException e) {
                OrdQuery[] oqs;
                for (OrdQuery oq : oqs = ord.parse()) {
                    if (!(oq instanceof FilePath)) continue;
                    FilePath fp = (FilePath)oq;
                    BDirectory rootDir = (BDirectory)BOrd.make((String)"file:^").resolve(target).get();
                    rootDir.getFileSpace().makeDir(fp);
                }
                obj = ord.resolve(target).get();
            }
            return obj;
        }
    }

    private class Submit
    extends Command {
        public Submit() {
            super((BWidget)BNiagaraNetworkJobBuilder.this, BNiagaraNetworkJobEditor.lex, "NiagaraNetworkJobBuilder.submit");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                BBatchJobService batch = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get(BNiagaraNetworkJobBuilder.this.getCurrentValue());
                batch.lease();
                BBatchJob job = batch.submitJob((BBatchJob)BNiagaraNetworkJobBuilder.this.saveJob(), null);
                BWbShell shell = BWbShell.getWbShell((BWidget)BNiagaraNetworkJobBuilder.this);
                if (shell != null) {
                    shell.hyperlink(job.getNavOrd());
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }
}

