/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.certificate;

import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.provisioningNiagara.ui.certificate.BFileNameFormat;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasAndPassword;
import javax.baja.security.BPassword;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="fileNaming", type="BFileNameFormat", defaultValue="BFileNameFormat.DEFAULT"), @NiagaraProperty(name="serverCertAlias", type="String", defaultValue="BString.DEFAULT", flags=5, deprecated=true), @NiagaraProperty(name="certAliasAndPassword", type="BCertificateAliasAndPassword", defaultValue="BCertificateAliasAndPassword.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")})})
public class BExportCsrJobStep
extends BDeviceJobStep {
    @Generated
    public static final Property fileNaming = BExportCsrJobStep.newProperty((int)0, (BValue)BFileNameFormat.DEFAULT, null);
    @Deprecated
    @Generated
    public static final Property serverCertAlias = BExportCsrJobStep.newProperty((int)5, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property certAliasAndPassword = BExportCsrJobStep.newProperty((int)0, (BValue)BCertificateAliasAndPassword.DEFAULT, (BFacets)BFacets.make((String)"security", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BExportCsrJobStep.class);
    private static final Logger logger = Logger.getLogger("provisioningNiagara");

    @Generated
    public BFileNameFormat getFileNaming() {
        return (BFileNameFormat)this.get(fileNaming);
    }

    @Generated
    public void setFileNaming(BFileNameFormat v) {
        this.set(fileNaming, (BValue)v, null);
    }

    @Deprecated
    @Generated
    public String getServerCertAlias() {
        return this.getString(serverCertAlias);
    }

    @Deprecated
    @Generated
    public void setServerCertAlias(String v) {
        this.setString(serverCertAlias, v, null);
    }

    @Generated
    public BCertificateAliasAndPassword getCertAliasAndPassword() {
        return (BCertificateAliasAndPassword)this.get(certAliasAndPassword);
    }

    @Generated
    public void setCertAliasAndPassword(BCertificateAliasAndPassword v) {
        this.set(certAliasAndPassword, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BExportCsrJobStep() {
    }

    public BExportCsrJobStep(BFileNameFormat fileNaming, String serverCertAlias, BPassword certPassword) {
        this.setFileNaming(fileNaming);
        this.setServerCertAlias(serverCertAlias);
        this.getCertAliasAndPassword().setAlias(serverCertAlias);
        this.getCertAliasAndPassword().setPassword(certPassword);
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            BIFile targetFile;
            FilePath exportPath;
            String fileName;
            NPKCS10CertificationRequest csr;
            BPlatCryptoManager cryptoManager;
            BFoxSession session;
            boolean stationRunning = util.hasRunningStation();
            if (stationRunning) {
                session = util.getEngagedFoxSession();
                BCertManagerService remoteCertService = (BCertManagerService)BOrd.make((String)"service:platCrypto:CertManagerService").get((BObject)session);
                cryptoManager = new ChannelCryptoManager((BComponent)remoteCertService);
            } else {
                session = util.getDaemonSession();
                cryptoManager = new BPlatCryptoManager((BDaemonSession)session);
            }
            try {
                if (cryptoManager.getCryptoManagerVersion().compareTo((Object)ICoreCryptoManager.ADVANCED_CERT_GEN_VERSION) >= 0) {
                    String certPassword = this.getCertAliasAndPassword().getPassword() != null && !this.getCertAliasAndPassword().getPassword().isDefault() ? AccessController.doPrivileged(() -> ((BPassword)this.getCertAliasAndPassword().getPassword()).getValue()) : null;
                    csr = cryptoManager.generateCSR(this.getCertAliasAndPassword().getAlias(), certPassword);
                } else {
                    csr = cryptoManager.generateCSR(this.getServerCertAlias(), null);
                }
            }
            catch (Exception e) {
                details.failed("provisioningNiagara", "ExportCsrJobStep.failed.csr");
                details.complete(BJobState.failed);
                if (util != null) {
                    if (var6_7 != null) {
                        try {
                            util.close();
                        }
                        catch (Throwable throwable) {
                            var6_7.addSuppressed(throwable);
                        }
                    } else {
                        util.close();
                    }
                }
                return;
            }
            if (csr == null) {
                details.failed("provisioningNiagara", "ExportCsrJobStep.failed.csr");
                details.complete(BJobState.failed);
                return;
            }
            BFileNameFormat fileNamingValue = this.getFileNaming();
            if (fileNamingValue == BFileNameFormat.hostname) {
                fileName = ((NiagaraStation)device).getRemoteHost().getHostname();
            } else if (fileNamingValue == BFileNameFormat.hostId) {
                if (stationRunning) {
                    BSystemPlatformService systemPlatformService = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)session);
                    systemPlatformService.lease(Integer.MAX_VALUE);
                    fileName = systemPlatformService.getHostId();
                } else {
                    fileName = ((BDaemonSession)session).getHostProperties().getHostId();
                }
            } else {
                fileName = ((BINiagaraStation)device).getStationName();
            }
            fileName = fileName + '.' + this.getCertAliasAndPassword().getAlias() + ".csr";
            try {
                exportPath = new FilePath("^csrExport").merge(fileName);
            }
            catch (Exception e) {
                details.failed("provisioningNiagara", "ExportCsrJobStep.failed.syntax");
                details.complete(BJobState.failed);
                if (util != null) {
                    if (var6_7 != null) {
                        try {
                            util.close();
                        }
                        catch (Throwable throwable) {
                            var6_7.addSuppressed(throwable);
                        }
                    } else {
                        util.close();
                    }
                }
                return;
            }
            try {
                targetFile = BFileSystem.INSTANCE.makeFile(exportPath);
            }
            catch (Exception e) {
                details.failed("provisioningNiagara", "ExportCsrJobStep.failed.create");
                details.complete(BJobState.failed);
                if (util != null) {
                    if (var6_7 != null) {
                        try {
                            util.close();
                        }
                        catch (Throwable throwable) {
                            var6_7.addSuppressed(throwable);
                        }
                    } else {
                        util.close();
                    }
                }
                return;
            }
            try (JcaPEMWriter pem = new JcaPEMWriter((Writer)new OutputStreamWriter(targetFile.getOutputStream()));){
                pem.writeObject((Object)new JcaPKCS10CertificationRequest(csr.getRequest().getEncoded()));
            }
            catch (Exception e) {
                details.failed("provisioningNiagara", "ExportCsrJobStep.failed.write");
                details.complete(BJobState.failed);
                if (util != null) {
                    if (var6_7 != null) {
                        try {
                            util.close();
                        }
                        catch (Throwable throwable) {
                            var6_7.addSuppressed(throwable);
                        }
                    } else {
                        util.close();
                    }
                }
                return;
            }
            details.success();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, this.lexValue("unexpectedError", new Object[0]), e);
            throw e;
        }
    }

    public void started() throws Exception {
        super.started();
        if (!Flags.has((BComplex)this, (Slot)serverCertAlias, (int)0x10000000)) {
            this.getCertAliasAndPassword().setAlias(this.getServerCertAlias());
            Flags.add((BComponent)this, (Slot)serverCertAlias, null, (int[])new int[]{0x10000005});
        }
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }

    public String toString(Context context) {
        return this.getLexicon().getText("ExportCsrJobStep.displayName", new Object[]{this.getFileNaming().toString(context), this.getCertAliasAndPassword().getAlias()});
    }
}

