/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara.bootstrap;

import com.tridium.data.BDataRow;
import com.tridium.fox.session.Fox;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.provisioningNiagara.ProvisioningConnectionUtil;
import com.tridium.sys.NreLib;
import java.net.InetAddress;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.collection.BITable;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="username", type="String", defaultValue="BString.DEFAULT"), @NiagaraProperty(name="password", type="BPassword", defaultValue="BPassword.DEFAULT"), @NiagaraProperty(name="address", type="BOrd", defaultValue="BOrd.NULL")})
public class BSetupReciprocalConnectionStep
extends BDeviceJobStep {
    @Generated
    public static final Property username = BSetupReciprocalConnectionStep.newProperty((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property password = BSetupReciprocalConnectionStep.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property address = BSetupReciprocalConnectionStep.newProperty((int)0, (BValue)BOrd.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSetupReciprocalConnectionStep.class);
    private static final Logger logger = Logger.getLogger("provisioningNiagara");

    @Generated
    public String getUsername() {
        return this.getString(username);
    }

    @Generated
    public void setUsername(String v) {
        this.setString(username, v, null);
    }

    @Generated
    public BPassword getPassword() {
        return (BPassword)this.get(password);
    }

    @Generated
    public void setPassword(BPassword v) {
        this.set(password, (BValue)v, null);
    }

    @Generated
    public BOrd getAddress() {
        return (BOrd)this.get(address);
    }

    @Generated
    public void setAddress(BOrd v) {
        this.set(address, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSetupReciprocalConnectionStep() {
    }

    public BSetupReciprocalConnectionStep(String username, BPassword password, BOrd address) {
        this.setUsername(username);
        this.setPassword(password);
        this.setAddress(address);
    }

    protected void doRun(BBatchJobService svc, BDeviceStepDetails details, BDevice device, DeviceNetworkJobOp op) throws Exception {
        logger.finest("Entering doRun()");
        try (ProvisioningConnectionUtil util = new ProvisioningConnectionUtil(device, details);){
            logger.fine(() -> String.format("Updating reciprocal connection for station %s", device.getName()));
            BFoxSession session = util.getEngagedFoxSession();
            BStation remoteStation = (BStation)BOrd.make((String)"station:|slot:/").get((BObject)session);
            String thisStationName = Sys.getStation().getStationName();
            List<BNiagaraNetwork> networks = this.getNiagaraNetworks(remoteStation);
            if (networks.size() == 0) {
                logger.warning(this.lexValue("noNiagaraNetworks", new Object[0]));
                details.vaFailed(this.lexKey("noNiagaraNetworks"), new String[0]);
                details.complete(BJobState.failed);
            } else {
                BNiagaraStation reciprocalStation = this.findReciprocalStation(thisStationName, networks);
                if (reciprocalStation == null) {
                    reciprocalStation = this.createReciprocalStation(details, thisStationName, networks);
                }
                this.updateReciprocalStation(reciprocalStation, session);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, this.lexValue("unexpectedError", new Object[0]), e);
            throw e;
        }
    }

    private BNiagaraStation createReciprocalStation(BDeviceStepDetails details, String stationName, List<BNiagaraNetwork> niagaraNetworks) {
        BNiagaraNetwork niagaraNetwork = niagaraNetworks.get(0);
        niagaraNetwork.lease();
        BNiagaraStation station = new BNiagaraStation();
        niagaraNetwork.add(stationName, (BValue)station);
        station = (BNiagaraStation)niagaraNetwork.get(stationName);
        String networkName = niagaraNetwork.getDisplayName(null) == null ? niagaraNetwork.getName() : niagaraNetwork.getDisplayName(null);
        logger.info(this.lexValue("createdReciprocalStation", new Object[]{stationName, networkName}));
        details.vaMessage(this.lexKey("createdReciprocalStation"), new String[]{stationName, networkName});
        return station;
    }

    private void updateReciprocalStation(BNiagaraStation niagaraStation, BFoxSession session) {
        BPassword boundPassword = this.getPassword();
        BPassword unboundPassword = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)boundPassword).getValue()));
        BUsernameAndPassword credentials = new BUsernameAndPassword(this.getUsername(), unboundPassword);
        niagaraStation.lease(2);
        niagaraStation.getClientConnection().setCredentials((BIUserCredentials)credentials);
        niagaraStation.setEnabled(true);
        BFoxService foxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
        if (foxService.getFoxsEnabled()) {
            niagaraStation.getClientConnection().setPort(foxService.getFoxsPort().getBindingPort());
        } else {
            niagaraStation.getClientConnection().setPort(foxService.getFoxPort().getBindingPort());
        }
        niagaraStation.getClientConnection().setUseFoxs(foxService.getFoxsEnabled());
        if (!this.getAddress().equivalent((Object)BOrd.NULL) && !this.getAddress().equivalent((Object)BOrd.make((String)"ip:"))) {
            niagaraStation.setAddress(this.getAddress());
        } else if (niagaraStation.getAddress().equivalent((Object)BOrd.NULL) || niagaraStation.getAddress().equivalent((Object)BOrd.make((String)"ip:"))) {
            String reciprocalIpAddress = Fox.hostAddress;
            try {
                BIpHost ipHost;
                if (session.getHost() instanceof BIpHost && (ipHost = (BIpHost)session.getHost()).isNumericAddress()) {
                    InetAddress remoteStationAddress = IPAddressUtil.numericStringToInetAddress((String)ipHost.getNumericAddress(false));
                    reciprocalIpAddress = NreLib.getLocalHost((InetAddress)remoteStationAddress).getHostAddress();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            niagaraStation.setAddress(BOrd.make((String)("ip:" + reciprocalIpAddress)));
        }
    }

    private BNiagaraStation findReciprocalStation(String reciprocalStationName, List<BNiagaraNetwork> niagaraNetworks) {
        BNiagaraStation station = null;
        block0: for (BNiagaraNetwork niagaraNetwork : niagaraNetworks) {
            for (BDevice remoteDevice : niagaraNetwork.getDevices()) {
                logger.fine(() -> String.format("Found station %s in network %s", remoteDevice.getName(), niagaraNetwork.getName()));
                if (!remoteDevice.getName().equals(reciprocalStationName)) continue;
                station = (BNiagaraStation)remoteDevice;
                continue block0;
            }
        }
        return station;
    }

    private List<BNiagaraNetwork> getNiagaraNetworks(BStation remoteStation) {
        BITable table = (BITable)BOrd.make((String)"bql:select slotPath from niagaraDriver:NiagaraNetwork").get((BObject)remoteStation);
        ArrayList<BNiagaraNetwork> networks = new ArrayList<BNiagaraNetwork>();
        for (BDataRow row : table.cursor()) {
            BString slotPath = (BString)row.cell(table.getColumns().get(0));
            logger.finest(() -> String.format("slotPath = %s", slotPath.toString()));
            BNiagaraNetwork network = (BNiagaraNetwork)BOrd.make((String)slotPath.toString()).get((BObject)remoteStation);
            networks.add(network);
        }
        return networks;
    }

    public Set<BDevice> getParallelExecutionConflicts(BBatchJobService svc, BDevice device, Set<BDevice> allDevices, DeviceNetworkJobOp op) {
        return Collections.singleton(device);
    }

    public String toString(Context context) {
        if (!this.getAddress().isNull()) {
            return this.getLexicon().getText("SetupReciprocalConnectionStep.displayName", new Object[]{this.getUsername(), this.getAddress()});
        }
        return this.getLexicon().getText("SetupReciprocalConnectionStep.displayNameWithNullAddress", new Object[]{this.getUsername()});
    }
}

