/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.provisioningNiagara;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.provisioningNiagara.BAsyncActionEvent;
import com.tridium.provisioningNiagara.BPlatformConnection;
import com.tridium.provisioningNiagara.BProvisioningNiagaraNetworkExt;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.driver.BDeviceExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.ICancelHint;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3)})
@NiagaraActions(value={@NiagaraAction(name="cancelAsyncAction", parameterType="BString", defaultValue="BString.DEFAULT", flags=20), @NiagaraAction(name="makeInvokeId", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BString", flags=4)})
@NiagaraTopic(name="asyncActionComplete", eventType="BAsyncActionEvent", flags=4)
public abstract class BProvisioningStationExt
extends BDeviceExt
implements BIMixIn,
BIStatus {
    @Generated
    public static final Property enabled = BProvisioningStationExt.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property status = BProvisioningStationExt.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BProvisioningStationExt.newProperty((int)3, (String)"", null);
    @Generated
    public static final Action cancelAsyncAction = BProvisioningStationExt.newAction((int)20, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action makeInvokeId = BProvisioningStationExt.newAction((int)4, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Topic asyncActionComplete = BProvisioningStationExt.newTopic((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BProvisioningStationExt.class);
    static final int FATAL_FAULT = 1;
    public static final String NOTIFY_ACTION_COMPLETE = "notifyActionComplete";
    private static volatile Type[] TYPES;
    private int flags = 0;
    private int oldStatus = -1;
    private final Map<BString, List<CanceledListener>> canceledListenersByInvokeId = new HashMap<BString, List<CanceledListener>>();
    private long asyncInvokeId = 1L;

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public void cancelAsyncAction(BString parameter) {
        this.invoke(cancelAsyncAction, (BValue)parameter, null);
    }

    @Generated
    public BString makeInvokeId(BString parameter) {
        return (BString)this.invoke(makeInvokeId, (BValue)parameter, null);
    }

    @Generated
    public void fireAsyncActionComplete(BAsyncActionEvent event) {
        this.fire(asyncActionComplete, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public boolean isUnoperational() {
        return this.isDown() || this.isDisabled() || this.isFault();
    }

    protected boolean propagateDeviceDownStatus() {
        return false;
    }

    protected boolean propagatePlatformConnectionStatus() {
        return true;
    }

    public void updateStatus() {
        int newStatus = this.getStatus().getBits();
        BNiagaraStation station = this.getNiagaraStation();
        if (station == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraStation");
        }
        BStatus device = station == null ? BStatus.ok : station.getStatus();
        BProvisioningNiagaraNetworkExt nwExt = null;
        try {
            nwExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        BStatus conn = BStatus.ok;
        BPlatformConnection platConn = null;
        if (station != null) {
            platConn = (BPlatformConnection)station.getMixIn(BPlatformConnection.TYPE);
            conn = platConn == null ? BStatus.fault : platConn.getStatus();
        }
        newStatus = !this.getEnabled() || device.isDisabled() || nwExt == null || nwExt.isDisabled() ? (newStatus |= 1) : (newStatus &= 0xFFFFFFFE);
        newStatus = this.propagateDeviceDownStatus() && device.isDown() || this.propagatePlatformConnectionStatus() && conn.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        if (this.fatalFault()) {
            newStatus |= 2;
        } else if (nwExt == null) {
            newStatus |= 2;
            this.setFaultCause("No niagara provisioning network ext");
        } else if (device.isFault()) {
            newStatus |= 2;
            this.setFaultCause("Device fault: " + this.getNiagaraStation().getFaultCause());
        } else if (this.propagatePlatformConnectionStatus() && conn.isFault()) {
            newStatus |= 2;
            if (platConn == null) {
                this.setFaultCause("No platform connection mix-in");
            } else {
                this.setFaultCause("Platform connection fault: " + platConn.getFaultCause());
            }
        } else {
            newStatus &= 0xFFFFFFFD;
            this.setFaultCause("");
        }
        if (this.oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
    }

    public final boolean isFatalFault() {
        return this.fatalFault();
    }

    private void checkFatalFault() {
        if (this.fatalFault()) {
            return;
        }
        try {
            BProvisioningNiagaraNetworkExt nwExt = (BProvisioningNiagaraNetworkExt)Sys.getService((Type)BProvisioningNiagaraNetworkExt.TYPE);
            if (nwExt.isFatalFault()) {
                this.fatalFault(true);
                this.setFaultCause("Provisioning niagara network ext fault: " + nwExt.getFaultCause());
                return;
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            this.fatalFault(true);
            this.setFaultCause("No niagara provisioning network ext");
            return;
        }
        if (this.getNiagaraStation() == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraStation");
            return;
        }
        if (this.getNiagaraStation().isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Device fault: " + this.getNiagaraStation().getFaultCause());
            return;
        }
        if (this.getNiagaraNetwork() == null) {
            this.fatalFault(true);
            this.setFaultCause("Not under NiagaraNetwork");
            return;
        }
        if (this.getNiagaraNetwork().isFatalFault()) {
            this.fatalFault(true);
            this.setFaultCause("Network fault: " + this.getNiagaraNetwork().getFaultCause());
            return;
        }
        this.setFaultCause("");
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraStation;
    }

    public void started() throws Exception {
        this.checkFatalFault();
        this.updateStatus();
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            this.updateStatus();
        }
    }

    public BValue invokeSync(Action action, ICancelHint cancel, Context cx) {
        if (!action.getDeclaringType().is(this.getType())) {
            throw new IllegalArgumentException(action.getName() + " is not an action for " + this.getType());
        }
        if (!action.getFacets().getb(NOTIFY_ACTION_COMPLETE, false)) {
            throw new IllegalArgumentException(action.getName() + " does not support synchronous invocation");
        }
        BString invokeId = this.makeInvokeId(action);
        AsyncActionCompleteSubscriber sub = new AsyncActionCompleteSubscriber(invokeId);
        sub.subscribe((BComponent)this, 1);
        this.invoke(action, (BValue)invokeId, cx);
        while (!sub.isComplete()) {
            if (cancel != null && cancel.isCanceled()) {
                this.invoke(cancelAsyncAction, (BValue)invokeId, cx);
                throw new ICancelHint.CanceledException();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                throw new BajaRuntimeException((Throwable)ie);
            }
        }
        return sub.getReturnValue();
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        return this.getPlatformConnection().getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCancelAsyncAction(BString invokeId, Context cx) {
        Map<BString, List<CanceledListener>> map = this.canceledListenersByInvokeId;
        synchronized (map) {
            List<CanceledListener> listeners = this.canceledListenersByInvokeId.get(invokeId);
            if (listeners != null) {
                for (CanceledListener listener : listeners) {
                    listener.setCanceled();
                }
            }
        }
    }

    protected BString makeInvokeId(Action action) {
        return this.makeInvokeId(BString.make((String)action.getName()));
    }

    public BString doMakeInvokeId(BString actionName) {
        return BString.make((String)(actionName.toString() + this.asyncInvokeId++));
    }

    protected void checkCanceled(CanceledListener listener) {
        if (listener != null) {
            listener.checkCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CanceledListener startAsyncAction(BString invokeId, Context cx) {
        if (invokeId == null) {
            return null;
        }
        Map<BString, List<CanceledListener>> map = this.canceledListenersByInvokeId;
        synchronized (map) {
            List<CanceledListener> listeners = this.canceledListenersByInvokeId.get(invokeId);
            if (listeners == null) {
                listeners = new ArrayList<CanceledListener>();
                this.canceledListenersByInvokeId.put(invokeId, listeners);
            }
            CanceledListener result = new CanceledListener(invokeId);
            listeners.add(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void asyncActionComplete(CanceledListener listener, BValue returnValue, Context cx) {
        if (listener == null) {
            return;
        }
        Map<BString, List<CanceledListener>> map = this.canceledListenersByInvokeId;
        synchronized (map) {
            List<CanceledListener> listeners = this.canceledListenersByInvokeId.get(listener.getInvokeId());
            if (listeners != null && listeners.remove(listener) && listeners.size() == 0) {
                this.canceledListenersByInvokeId.remove(listener.getInvokeId());
            }
        }
        this.fireAsyncActionComplete(new BAsyncActionEvent(listener.getInvokeId(), returnValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void asyncActionException(CanceledListener listener, Exception e, Context cx) throws Exception {
        if (listener == null) {
            throw e;
        }
        Map<BString, List<CanceledListener>> map = this.canceledListenersByInvokeId;
        synchronized (map) {
            List<CanceledListener> listeners = this.canceledListenersByInvokeId.get(listener.getInvokeId());
            if (listeners != null && listeners.remove(listener) && listeners.size() == 0) {
                this.canceledListenersByInvokeId.remove(listener.getInvokeId());
            }
        }
        this.fireAsyncActionComplete(new BAsyncActionEvent(listener.getInvokeId(), e));
    }

    public BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.getDevice();
    }

    public BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)this.getNetwork();
    }

    public BPlatformConnection getPlatformConnection() {
        return (BPlatformConnection)this.getNiagaraStation().getMixIn(BPlatformConnection.TYPE);
    }

    protected BDaemonSession getDaemonSession() throws Exception {
        BPlatformConnection platformConn = this.getPlatformConnection();
        if (platformConn == null || platformConn.getStatus().isFault() || platformConn.getStatus().isDisabled() || platformConn.getHealth().inFailure()) {
            return null;
        }
        return platformConn.getDaemonSession();
    }

    public static Type[] getStationExtTypes() {
        if (TYPES == null) {
            TypeInfo[] t = Sys.getRegistry().getConcreteTypes(TYPE.getTypeInfo());
            Type[] temp = new Type[t.length];
            for (int i = 0; i < t.length; ++i) {
                temp[i] = t[i].getTypeSpec().getResolvedType();
            }
            TYPES = temp;
        }
        return TYPES;
    }

    protected void processException(Exception e) throws Exception {
        if (!(e instanceof AuthenticationException) && !(e instanceof ConnectException)) {
            throw e;
        }
    }

    private boolean fatalFault() {
        return (this.flags & 1) != 0;
    }

    private void fatalFault(boolean b) {
        this.flags = b ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    private static class AsyncActionCompleteSubscriber
    extends Subscriber {
        private final BString invokeId;
        private boolean complete = false;
        private BValue returnValue;

        public AsyncActionCompleteSubscriber(BString invokeId) {
            this.invokeId = invokeId;
        }

        public void event(BComponentEvent event) {
            BAsyncActionEvent actionEvent;
            if (event.getId() == 5 && event.getSlot() == asyncActionComplete && (actionEvent = (BAsyncActionEvent)event.getValue()).getInvokeId().equals((Object)this.invokeId)) {
                this.unsubscribeAll();
                this.returnValue = actionEvent.getReturnValue();
                this.complete = true;
            }
        }

        public boolean isComplete() {
            return this.complete;
        }

        public BValue getReturnValue() {
            return this.returnValue;
        }
    }

    protected static class CanceledListener
    implements ICancelHint {
        private boolean isCanceled;
        private final BString invokeId;

        public CanceledListener(BString invokeId) {
            this.invokeId = invokeId;
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public void checkCanceled() {
            if (this.isCanceled) {
                throw new ICancelHint.CanceledException();
            }
        }

        public void setCanceled() {
            this.isCanceled = true;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ICancelHint)) {
                return false;
            }
            return o == this;
        }

        public int hashCode() {
            return this.invokeId.hashCode();
        }

        public BString getInvokeId() {
            return this.invokeId;
        }
    }
}

