/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.query.util;

import javax.baja.query.BExpression;
import javax.baja.query.BPredicate;
import javax.baja.query.util.Exprs;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Property;

public class Predicates
extends Exprs {
    protected static final BExpression TRUE = Predicates.eq((BExpression)Predicates.simple((BSimple)BInteger.make((int)1)), Predicates.simple((BSimple)BInteger.make((int)1)));
    protected static final BExpression FALSE = Predicates.eq((BExpression)Predicates.simple((BSimple)BInteger.make((int)1)), Predicates.simple((BSimple)BInteger.make((int)2)));

    public static BExpression and(BExpression lhs, BExpression rhs) {
        return Predicates.binary(lhs, "AND", rhs);
    }

    public static BExpression eq(String field, BSimple value) {
        return Predicates.binary(field, "=", value);
    }

    public static BExpression eq(Property property, BSimple value) {
        return Predicates.eq(property.getName(), value);
    }

    public static BExpression eq(BExpression expr, BSimple value) {
        return Predicates.binary(expr, "=", Predicates.simple(value));
    }

    public static BExpression eq(String field, String otherField) {
        return Predicates.binary(field, "=", otherField);
    }

    public static BExpression eq(Property p1, Property p2) {
        return Predicates.eq(p1.getName(), p2.getName());
    }

    public static BExpression eq(BExpression expr1, BExpression expr2) {
        return Predicates.binary(expr1, "=", expr2);
    }

    public static BExpression ge(String field, BSimple value) {
        return Predicates.binary(field, ">=", value);
    }

    public static BExpression ge(Property property, BSimple value) {
        return Predicates.ge(property.getName(), value);
    }

    public static BExpression ge(BExpression expr, BSimple value) {
        return Predicates.binary(expr, ">=", Predicates.simple(value));
    }

    public static BExpression ge(String field, String otherField) {
        return Predicates.binary(field, ">=", otherField);
    }

    public static BExpression ge(Property p1, Property p2) {
        return Predicates.ge(p1.getName(), p2.getName());
    }

    public static BExpression ge(BExpression expr1, BExpression expr2) {
        return Predicates.binary(expr1, ">=", expr2);
    }

    public static BExpression gt(String field, BSimple value) {
        return Predicates.binary(field, ">", value);
    }

    public static BExpression gt(Property property, BSimple value) {
        return Predicates.gt(property.getName(), value);
    }

    public static BExpression gt(BExpression expr, BSimple value) {
        return Predicates.binary(expr, ">", Predicates.simple(value));
    }

    public static BExpression gt(String field, String otherField) {
        return Predicates.binary(field, ">", otherField);
    }

    public static BExpression gt(Property p1, Property p2) {
        return Predicates.gt(p1.getName(), p2.getName());
    }

    public static BExpression gt(BExpression expr1, BExpression expr2) {
        return Predicates.binary(expr1, ">", expr2);
    }

    public static BExpression in(String field, BSimple[] values) {
        return Predicates.binary(Predicates.field(field), "IN", Predicates.list(values));
    }

    public static BExpression in(Property property, BSimple[] values) {
        return Predicates.in(property.getName(), values);
    }

    public static BExpression in(BExpression expr, BSimple[] values) {
        return Predicates.binary(expr, "IN", Predicates.list(values));
    }

    public static BExpression le(String field, BSimple value) {
        return Predicates.binary(field, "<=", value);
    }

    public static BExpression le(Property property, BSimple value) {
        return Predicates.le(property.getName(), value);
    }

    public static BExpression le(BExpression expr, BSimple value) {
        return Predicates.binary(expr, "<=", Predicates.simple(value));
    }

    public static BExpression le(String field, String otherField) {
        return Predicates.binary(field, "<=", otherField);
    }

    public static BExpression le(Property p1, Property p2) {
        return Predicates.le(p1.getName(), p2.getName());
    }

    public static BExpression le(BExpression expr1, BExpression expr2) {
        return Predicates.binary(expr1, "<=", expr2);
    }

    public static BExpression like(String field, BString pattern) {
        return Predicates.binary(field, "LIKE", (BSimple)pattern);
    }

    public static BExpression like(Property property, BString pattern) {
        return Predicates.like(property.getName(), pattern);
    }

    public static BExpression like(BExpression expr, BString pattern) {
        return Predicates.binary(expr, "LIKE", Predicates.simple((BSimple)pattern));
    }

    public static BExpression lt(String field, BSimple value) {
        return Predicates.binary(field, "<", value);
    }

    public static BExpression lt(BExpression expr, BSimple value) {
        return Predicates.binary(expr, "<", Predicates.simple(value));
    }

    public static BExpression lt(Property property, BSimple value) {
        return Predicates.lt(property.getName(), value);
    }

    public static BExpression lt(String field, String otherField) {
        return Predicates.binary(field, "<", otherField);
    }

    public static BExpression lt(Property p1, Property p2) {
        return Predicates.lt(p1.getName(), p2.getName());
    }

    public static BExpression lt(BExpression expr1, BExpression expr2) {
        return Predicates.binary(expr1, "<", expr2);
    }

    public static BExpression ne(String field, BSimple value) {
        return Predicates.binary(field, "!=", value);
    }

    public static BExpression ne(BExpression expr, BSimple value) {
        return Predicates.binary(expr, "!=", Predicates.simple(value));
    }

    public static BExpression ne(Property property, BSimple value) {
        return Predicates.ne(property.getName(), value);
    }

    public static BExpression ne(String field, String otherField) {
        return Predicates.binary(field, "!=", otherField);
    }

    public static BExpression ne(Property p1, Property p2) {
        return Predicates.ne(p1.getName(), p2.getName());
    }

    public static BExpression ne(BExpression expr1, BExpression expr2) {
        return Predicates.binary(expr1, "!=", expr2);
    }

    public static BExpression not(BExpression exprToNegate) {
        return Predicates.unary("NOT", exprToNegate);
    }

    public static BExpression not(BPredicate predicate) {
        return Predicates.not((BExpression)predicate.getPredicateExpr().newCopy());
    }

    public static BExpression or(BExpression lhs, BExpression rhs) {
        return Predicates.binary(lhs, "OR", rhs);
    }

    public static BExpression TRUE() {
        return TRUE.newExprCopy();
    }

    public static BExpression FALSE() {
        return FALSE.newExprCopy();
    }
}

