/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm.tcp;

import com.tridium.driver.util.DrByteArrayUtil;
import com.tridium.ndriver.comm.DebugStream;
import com.tridium.ndriver.comm.ILinkLayer;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NCommException;
import com.tridium.ndriver.comm.NLinkMessageFactory;
import com.tridium.ndriver.comm.tcp.ITcpEventListener;
import com.tridium.ndriver.datatypes.BCommConfig;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.datatypes.BTcpCommConfig;
import com.tridium.ndriver.util.SpyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.IntHashMap;
import javax.baja.spy.SpyWriter;

public class TcpLinkLayer
implements ILinkLayer {
    private static int nextSessionId = 1;
    Vector<ITcpEventListener> evlisteners = new Vector();
    private Logger log;
    private NComm comm;
    private BTcpCommConfig comCfg;
    private NLinkMessageFactory lnkFac;
    private ServerSocket srvSock = null;
    private boolean done = true;
    private boolean serverRunning = false;
    private Statistics stats = new Statistics();
    Map<String, LinkSession> sessions = new ConcurrentHashMap<String, LinkSession>(30);
    IntHashMap sessionsById = new IntHashMap(30);
    LinkServer receive = null;
    Thread rcvThread;

    public TcpLinkLayer(NComm comm, BTcpCommConfig comCfg) {
        this.comm = comm;
        this.comCfg = comCfg;
        this.lnkFac = comCfg.getLinkMessageFactory();
    }

    @Override
    public void start() throws Exception {
        this.log().fine("start TcpLinkLayer");
        this.done = false;
        if (!this.comCfg.getServerEnabled()) {
            if (this.log().isLoggable(Level.FINE)) {
                this.log().fine("comm config server disabled, skipping server startup");
            }
        } else if (this.myPort() == 0) {
            this.log().info("comm config port set to 0, skipping server startup");
        } else {
            this.startServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.done = true;
        this.stopServer();
        Iterator<LinkSession> iterator = this.sessions.values().iterator();
        while (iterator.hasNext()) {
            LinkSession t;
            LinkSession linkSession = t = iterator.next();
            synchronized (linkSession) {
                t.listening = false;
                t.close();
                t.notify();
            }
        }
        this.sessions.clear();
    }

    private void startServer() throws IOException {
        InetAddress ia = this.myIp();
        this.srvSock = ia == null ? new ServerSocket(this.myPort()) : new ServerSocket(this.myPort(), 5, ia);
        this.serverRunning = true;
        this.receive = new LinkServer();
        this.rcvThread = new Thread((Runnable)this.receive, this.comCfg.getResourcePrefix() + ".LinkServer");
        this.rcvThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopServer() {
        this.serverRunning = false;
        try {
            if (this.srvSock != null) {
                this.srvSock.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Iterator<Map.Entry<String, LinkSession>> iterator = this.sessions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, LinkSession> entry = iterator.next();
            LinkSession t = entry.getValue();
            if (!t.server) continue;
            LinkSession linkSession = t;
            synchronized (linkSession) {
                t.listening = false;
                t.close();
                t.notify();
            }
            iterator.remove();
        }
    }

    @Override
    public void verifySettings(BCommConfig comCfg) throws Exception {
        boolean enabled;
        boolean bl = enabled = ((BTcpCommConfig)comCfg).getServerEnabled() && this.myPort() != 0;
        if (enabled && !this.serverRunning) {
            this.startServer();
        } else if (!enabled && this.serverRunning) {
            this.stopServer();
        } else if (enabled && (this.srvSock == null || this.srvSock.getLocalPort() != this.myPort())) {
            ServerSocket s = this.srvSock;
            this.srvSock = new ServerSocket(this.myPort());
            s.close();
        }
    }

    private int myPort() {
        return this.comCfg.getAddress().getPort();
    }

    private InetAddress myIp() {
        BIpAddress myAdr = this.comCfg.getAddress();
        if (myAdr.getIpAddress().equalsIgnoreCase("local")) {
            return null;
        }
        return myAdr.getInetAddress();
    }

    @Override
    public void sendMessage(LinkMessage msg) throws Exception {
        if (this.done) {
            return;
        }
        BIpAddress addr = (BIpAddress)((Object)msg.address);
        LinkSession ls = this.getLinkSession(addr);
        this.log().fine("sendMessage to " + msg.address);
        ls.doSend(msg);
        ++this.stats.msgSent;
    }

    private synchronized LinkSession getLinkSession(BIpAddress address) throws Exception {
        String key;
        LinkSession ls = (LinkSession)this.sessionsById.get(address.getSessionId());
        if (ls == null && (ls = this.sessions.get(key = address.toString())) == null) {
            ls = new LinkSession(address);
            this.log().fine("created LinkSession for " + (Object)((Object)address));
            this.sessions.put(key, ls);
        }
        return ls;
    }

    public int createSession(BIpAddress tcpAdr) throws Exception {
        int sessionId = this.getNextSessionId();
        LinkSession ls = new LinkSession(tcpAdr, sessionId);
        this.sessionsById.put(sessionId, (Object)ls);
        this.log().fine("created LinkSession " + sessionId + " for " + (Object)((Object)tcpAdr));
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(int sessionId) throws Exception {
        LinkSession ls = (LinkSession)this.sessionsById.remove(sessionId);
        if (ls == null) {
            return;
        }
        if (this.log().isLoggable(Level.FINE)) {
            this.log().fine("close LinkSession " + sessionId + " for " + (Object)((Object)ls.addr));
        }
        LinkSession linkSession = ls;
        synchronized (linkSession) {
            ls.listening = false;
            ls.close();
            ls.notify();
        }
    }

    private synchronized int getNextSessionId() {
        int n = nextSessionId++;
        if (nextSessionId < 0) {
            nextSessionId = 1;
        }
        return n;
    }

    public void registerTcpEvenListener(ITcpEventListener listener) {
        if (!this.evlisteners.contains(listener)) {
            this.evlisteners.add(listener);
        }
    }

    public void unregisterTcpEvenListener(ITcpEventListener listener) {
        this.evlisteners.remove(listener);
    }

    private void socketTerminated(BIpAddress addr, boolean server) {
        for (int i = 0; i < this.evlisteners.size(); ++i) {
            this.evlisteners.elementAt(i).socketTerminated(addr, server);
        }
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps("TcpLinkLayer");
        out.prop((Object)"done", this.done);
        out.prop((Object)"srvSock inet address", (Object)(this.srvSock != null ? this.srvSock.getInetAddress().toString() : "n/a"));
        out.prop((Object)"srvSock port", (Object)(this.srvSock != null ? Integer.toString(this.srvSock.getLocalPort()) : "n/a"));
        out.prop((Object)"number of linkSessions", this.sessions.size());
        out.endProps();
        out.startTable(true);
        out.trTitle((Object)"sessions", 8);
        out.w((Object)"<tr>").th((Object)"id").th((Object)"server").th((Object)"ip").th((Object)"port").th((Object)"myPort").th((Object)"bound").th((Object)"listening").th((Object)"soTimeout").w((Object)"</tr>\n");
        for (LinkSession c : this.sessions.values()) {
            this.spySession(out, c);
        }
        out.endTable();
        out.startTable(true);
        out.trTitle((Object)"sessionsById", 8);
        out.w((Object)"<tr>").th((Object)"id").th((Object)"server").th((Object)"ip").th((Object)"port").th((Object)"myPort").th((Object)"bound").th((Object)"listening").th((Object)"soTimeout").w((Object)"</tr>\n");
        LinkSession[] a = (LinkSession[])this.sessionsById.toArray((Object[])new LinkSession[this.sessionsById.size()]);
        for (int i = 0; i < a.length; ++i) {
            this.spySession(out, a[i]);
        }
        out.endTable();
        SpyUtil.spy(out, "TcpLink Statistics", this.stats);
    }

    private void spySession(SpyWriter out, LinkSession c) {
        String sto = "n/a";
        try {
            sto = Integer.toString(c.sock.getSoTimeout());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        out.w((Object)"<tr>");
        out.td((Object)Integer.toString(c.addr.getSessionId()));
        out.td((Object)Boolean.toString(c.server));
        out.td((Object)c.addr.getIpAddress());
        out.td((Object)(c.sock != null ? Integer.toString(c.sock.getPort()) : "n/a"));
        out.td((Object)(c.sock != null ? Integer.toString(c.sock.getLocalPort()) : "n/a"));
        out.td((Object)(c.sock != null ? Boolean.toString(c.sock.isBound()) : "n/a"));
        out.td((Object)Boolean.toString(c.listening));
        out.td((Object)sto);
        out.w((Object)"</tr>\n");
    }

    @Override
    public void resetStats() {
        this.stats = new Statistics();
    }

    public final Logger log() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.comCfg.getResourcePrefix() + ".Link");
        }
        return this.log;
    }

    public static class Statistics {
        public long msgSent = 0L;
        public long msgReceived = 0L;
        public long receiveError = 0L;
        public long acceptedConnections = 0L;
    }

    private class LinkServer
    implements Runnable {
        int cnt = 0;

        private LinkServer() {
        }

        @Override
        public void run() {
            while (TcpLinkLayer.this.serverRunning) {
                try {
                    Socket s = TcpLinkLayer.this.srvSock.accept();
                    LinkSession ls = new LinkSession(s);
                    Thread t = new Thread((Runnable)ls, TcpLinkLayer.this.comCfg.getResourcePrefix() + ".In.LinkSession" + this.cnt++);
                    t.start();
                    ++((TcpLinkLayer)TcpLinkLayer.this).stats.acceptedConnections;
                }
                catch (Throwable e) {
                    if (!TcpLinkLayer.this.serverRunning) {
                        return;
                    }
                    String msg = "Exception caught in LinkReceiver. " + e;
                    if (TcpLinkLayer.this.log().isLoggable(Level.FINE)) {
                        TcpLinkLayer.this.log().log(Level.SEVERE, msg, e);
                        continue;
                    }
                    TcpLinkLayer.this.log().log(Level.SEVERE, msg);
                }
            }
        }
    }

    private class LinkSession
    implements Runnable {
        Socket sock;
        BIpAddress addr;
        boolean listening = false;
        boolean server;
        boolean sent = false;
        int timeOut = 0;
        DebugStream debIn = new DebugStream(TcpLinkLayer.access$300(TcpLinkLayer.this).getLinkMaxLength());

        LinkSession(BIpAddress tcpAdr) throws Exception {
            this.addr = (BIpAddress)tcpAdr.newCopy(true);
            this.server = false;
            this.timeOut = TcpLinkLayer.this.comCfg.getSendSocketTO() * 1000;
        }

        LinkSession(BIpAddress tcpAdr, int sessionId) throws Exception {
            this.addr = (BIpAddress)tcpAdr.newCopy(true);
            this.addr.setSessionId(sessionId);
            this.server = false;
            this.timeOut = 0;
        }

        LinkSession(Socket s) throws Exception {
            this.sock = s;
            this.addr = new BIpAddress(this.sock.getInetAddress(), this.sock.getPort());
            this.addr.setSessionId(TcpLinkLayer.this.getNextSessionId());
            TcpLinkLayer.this.sessions.put(this.addr.toString(), this);
            this.server = true;
            this.timeOut = TcpLinkLayer.this.comCfg.getServerSocketTO() * 1000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkSession linkSession = this;
            synchronized (linkSession) {
                this.notifyAll();
            }
            this.listening = true;
            try {
                this.sock.setSoTimeout(this.timeOut);
            }
            catch (SocketException e) {
                TcpLinkLayer.this.log().log(Level.SEVERE, "Unable to set socket timeout " + (Object)((Object)this.addr), e);
            }
            while (this.listening) {
                boolean trace = TcpLinkLayer.this.log().isLoggable(Level.FINE);
                try {
                    LinkMessage tmsg = TcpLinkLayer.this.lnkFac.getLinkMessage();
                    tmsg.address = this.addr;
                    InputStream in = this.sock.getInputStream();
                    if (trace) {
                        in = this.debIn.reset(in);
                    }
                    boolean complete = tmsg.receive(in);
                    if (trace && this.debIn.hasDebug()) {
                        TcpLinkLayer.this.log().fine("rcvd:" + (complete ? "" : "frag:") + this.debIn.debugString());
                    }
                    if (complete) {
                        TcpLinkLayer.this.comm.receiveMessage(tmsg);
                        ++((TcpLinkLayer)TcpLinkLayer.this).stats.msgReceived;
                        this.sent = false;
                        continue;
                    }
                    TcpLinkLayer.this.lnkFac.releaseLinkMessage(tmsg);
                    if (this.listening && trace) {
                        TcpLinkLayer.this.log().fine("Remote socket closed for " + (Object)((Object)this.addr));
                    }
                    this.terminate();
                }
                catch (SocketTimeoutException e) {
                    if (this.sent) continue;
                    if (this.listening) {
                        if (trace) {
                            TcpLinkLayer.this.log().log(Level.FINE, "Timeout LinkSession for " + (Object)((Object)this.addr), e);
                        }
                        ++((TcpLinkLayer)TcpLinkLayer.this).stats.receiveError;
                    }
                    this.terminate();
                }
                catch (Throwable e) {
                    if (this.listening) {
                        String msg = "Exception caught in LinkReceiver for " + (Object)((Object)this.addr) + "\n";
                        if (trace) {
                            TcpLinkLayer.this.log().log(Level.SEVERE, msg, e);
                        } else {
                            TcpLinkLayer.this.log.log(Level.SEVERE, msg);
                        }
                        ++((TcpLinkLayer)TcpLinkLayer.this).stats.receiveError;
                    }
                    this.terminate();
                }
            }
        }

        private synchronized void listen() throws Exception {
            if (this.sock == null) {
                this.sock = new Socket();
            }
            if (!this.sock.isConnected()) {
                try {
                    if (TcpLinkLayer.this.log().isLoggable(Level.FINE)) {
                        TcpLinkLayer.this.log().fine("connect socket " + (Object)((Object)this.addr));
                    }
                    InetSocketAddress insa = new InetSocketAddress(this.addr.getInetAddress(), this.addr.getPort());
                    this.sock.connect(insa, 1000);
                }
                catch (Exception e) {
                    this.sock = null;
                    throw new NCommException("Can not connect to " + (Object)((Object)this.addr), e);
                }
            }
            if (!this.listening) {
                if (TcpLinkLayer.this.log().isLoggable(Level.FINE)) {
                    TcpLinkLayer.this.log().fine("start rcvThread " + (Object)((Object)this.addr));
                }
                Thread rcvThread = new Thread((Runnable)this, TcpLinkLayer.this.comCfg.getResourcePrefix() + ".LinkSession");
                rcvThread.start();
                try {
                    this.wait(1000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        synchronized void doSend(LinkMessage msg) throws Exception {
            try {
                this.listen();
                if (TcpLinkLayer.this.log().isLoggable(Level.FINE)) {
                    TcpLinkLayer.this.log().fine("send:" + DrByteArrayUtil.toString((byte[])msg.getByteArray(), (int)msg.getLength()));
                }
                this.sock.getOutputStream().write(msg.getByteArray(), 0, msg.getLength());
                this.sent = true;
            }
            finally {
                TcpLinkLayer.this.lnkFac.releaseLinkMessage(msg);
            }
        }

        void close() {
            this.listening = false;
            try {
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (Throwable e) {
                String msg = "close: can't close socket: " + e;
                if (TcpLinkLayer.this.log().isLoggable(Level.FINE)) {
                    TcpLinkLayer.this.log().log(Level.WARNING, msg, e);
                }
                TcpLinkLayer.this.log().log(Level.WARNING, msg);
            }
        }

        void terminate() {
            TcpLinkLayer.this.log().fine("terminate " + (Object)((Object)this.addr));
            this.listening = false;
            try {
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (Throwable e) {
                String msg = "terminate: can't close socket: " + e;
                if (TcpLinkLayer.this.log().isLoggable(Level.FINE)) {
                    TcpLinkLayer.this.log().log(Level.WARNING, msg, e);
                }
                TcpLinkLayer.this.log().log(Level.WARNING, msg);
            }
            TcpLinkLayer.this.sessions.remove(this.addr.toString());
            TcpLinkLayer.this.sessionsById.remove(this.addr.getSessionId());
            TcpLinkLayer.this.socketTerminated(this.addr, this.server);
        }
    }
}

