/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm;

import com.tridium.ndriver.comm.FragmentManager;
import com.tridium.ndriver.comm.IFragmentable;
import com.tridium.ndriver.comm.NCommException;
import com.tridium.ndriver.comm.NCommTimeoutException;
import com.tridium.ndriver.comm.NMessage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;

public class NCommTimer {
    private final Hashtable<Object, Transaction> trnsHash;
    private final TransactionTimer transactionTimer = new TransactionTimer(32);
    private final TransactionTimer fragTimer = new TransactionTimer(32);
    private Thread transactionTimerThread = null;
    private Thread fragTimerThread = null;
    private boolean done = false;
    private final int maxTrans;
    private final int maxTrnsWait;
    private int curTrans;
    private final Pool trnsPool;
    private final Pool fragPool;
    private final Hashtable<Object, Frags> fragHash;
    private FragmentManager fragMgr;
    String name;

    public NCommTimer(int maxOutstandingTransactions, int maxTransactionWait, String name) {
        this.maxTrans = maxOutstandingTransactions;
        this.maxTrnsWait = maxTransactionWait;
        this.trnsPool = new Pool(32){

            @Override
            Timed makeInstance() {
                return new Transaction();
            }
        };
        this.fragPool = new Pool(32){

            @Override
            Timed makeInstance() {
                return new Frags();
            }
        };
        this.trnsHash = new Hashtable();
        this.fragHash = new Hashtable();
        this.name = name;
    }

    public void start() {
        this.done = false;
        this.transactionTimerThread = new Thread((Runnable)this.transactionTimer, this.name + ".TransactionTimer");
        this.transactionTimerThread.start();
        this.transactionTimerThread.setPriority(5);
        this.fragTimerThread = new Thread((Runnable)this.fragTimer, this.name + ".FragTimer");
        this.fragTimerThread.start();
        this.fragTimerThread.setPriority(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        Object t;
        this.done = true;
        if (this.transactionTimerThread != null) {
            this.transactionTimerThread.interrupt();
            this.transactionTimerThread = null;
        }
        if (this.fragTimerThread != null) {
            this.fragTimerThread.interrupt();
            this.fragTimerThread = null;
        }
        Enumeration<Transaction> ent = this.trnsHash.elements();
        while (ent.hasMoreElements()) {
            t = ent.nextElement();
            Transaction transaction = t;
            synchronized (transaction) {
                this.freeTransaction((Transaction)t);
                t.notifyAll();
            }
        }
        this.trnsHash.clear();
        t = this.trnsHash;
        synchronized (t) {
            this.trnsHash.notifyAll();
        }
        Enumeration<Frags> enf = this.fragHash.elements();
        while (enf.hasMoreElements()) {
            Frags f;
            Frags frags = f = enf.nextElement();
            synchronized (frags) {
                this.closeFragTimer(f.fragment);
                f.notifyAll();
            }
        }
        this.fragHash.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getTransaction(NMessage msg) throws Exception {
        if (this.done) {
            return null;
        }
        Hashtable<Object, Transaction> hashtable = this.trnsHash;
        synchronized (hashtable) {
            if (this.curTrans >= this.maxTrans) {
                try {
                    this.trnsHash.wait(this.maxTrnsWait * 1000);
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            if (this.curTrans >= this.maxTrans) {
                throw new NCommException("Would exceed maximum outstanding request messages.");
            }
            Transaction t = (Transaction)this.trnsPool.make();
            t.req = msg;
            this.trnsHash.put(msg.getTag(), t);
            TransactionTimer transactionTimer = this.transactionTimer;
            synchronized (transactionTimer) {
                if (this.transactionTimer.start(t)) {
                    this.transactionTimer.notifyAll();
                }
            }
            ++this.curTrans;
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeTransaction(Transaction transaction) {
        if (transaction == null || transaction.freeTrns) {
            return;
        }
        Hashtable<Object, Transaction> hashtable = this.trnsHash;
        synchronized (hashtable) {
            TransactionTimer transactionTimer = this.transactionTimer;
            synchronized (transactionTimer) {
                this.transactionTimer.cancel(transaction);
                this.transactionTimer.notifyAll();
            }
            this.trnsHash.remove(transaction.getTag());
            this.trnsPool.release(transaction);
            --this.curTrans;
            this.trnsHash.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Transaction getTransactionMatch(Object tag) {
        Hashtable<Object, Transaction> hashtable = this.trnsHash;
        synchronized (hashtable) {
            return this.trnsHash.get(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetTimer(Transaction transaction) {
        TransactionTimer transactionTimer = this.transactionTimer;
        synchronized (transactionTimer) {
            if (this.transactionTimer.restart(transaction)) {
                this.transactionTimer.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startFragTimer(IFragmentable f) {
        if (this.done) {
            return;
        }
        TransactionTimer transactionTimer = this.fragTimer;
        synchronized (transactionTimer) {
            Pool pool = this.fragPool;
            synchronized (pool) {
                Frags frg = (Frags)this.fragPool.make();
                frg.fragment = f;
                this.fragHash.put(f.getHash(), frg);
                if (this.fragTimer.start(frg)) {
                    this.fragTimer.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeFragTimer(IFragmentable f) {
        TransactionTimer transactionTimer = this.fragTimer;
        synchronized (transactionTimer) {
            Pool pool = this.fragPool;
            synchronized (pool) {
                Frags frg = this.fragHash.get(f.getHash());
                if (frg == null) {
                    return;
                }
                this.fragTimer.cancel(frg);
                this.fragTimer.notifyAll();
                this.fragHash.remove(f.getHash());
                this.fragPool.release(frg);
            }
        }
    }

    void setFragmentManager(FragmentManager fm) {
        this.fragMgr = fm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        out.startProps("TransactionManager");
        out.prop((Object)"done", this.done);
        out.prop((Object)"maximum transactions ", this.maxTrans);
        out.prop((Object)"transaction wait(seconds) ", this.maxTrnsWait);
        if (this.trnsPool != null) {
            out.prop((Object)"transPool max", this.trnsPool.cnt);
            out.prop((Object)"transPool available", this.trnsPool.v.size());
        }
        if (this.fragPool != null) {
            out.prop((Object)"fragPool max", this.fragPool.cnt);
            out.prop((Object)"fragPool available", this.fragPool.v.size());
        }
        out.endProps();
        TransactionTimer transactionTimer = this.transactionTimer;
        synchronized (transactionTimer) {
            this.transactionTimer.spy(out, "transactions");
        }
        transactionTimer = this.fragTimer;
        synchronized (transactionTimer) {
            this.fragTimer.spy(out, "frags");
        }
    }

    abstract class Pool {
        Vector<Timed> v;
        int maxSize;
        int cnt = 0;

        Pool(int size) {
            this.maxSize = size;
            this.v = new Vector(size);
        }

        synchronized Timed make() {
            Timed t = null;
            if (this.v.size() > 0) {
                t = this.v.remove(0);
            } else {
                t = this.makeInstance();
                ++this.cnt;
            }
            t.init();
            return t;
        }

        abstract Timed makeInstance();

        synchronized void release(Timed t) {
            t.free();
            if (this.v.size() < this.maxSize) {
                this.v.add(t);
            }
        }
    }

    class Frags
    extends Timed {
        IFragmentable fragment;

        Frags() {
        }

        @Override
        void init() {
        }

        @Override
        void free() {
            this.fragment = null;
        }

        @Override
        void timeOut() {
            NCommTimer.this.fragMgr.fragTimeout(this.fragment);
        }

        @Override
        long getTimeOut() {
            return this.fragment.getTimeout();
        }
    }

    public class Transaction
    extends Timed {
        boolean complete;
        boolean freeTrns;
        boolean timeout;
        boolean respRcvd;
        private Exception exception;
        private NMessage req;
        private NMessage resp;

        Transaction() {
        }

        @Override
        void init() {
            this.complete = false;
            this.exception = null;
            this.resp = null;
            this.freeTrns = false;
            this.endTime = 0L;
            this.timeout = false;
            this.respRcvd = false;
        }

        @Override
        void free() {
            this.exception = null;
            this.resp = null;
            this.freeTrns = true;
            this.endTime = 0L;
            this.timeout = false;
            this.respRcvd = false;
        }

        void setComplete(boolean c) {
            this.complete = c;
        }

        boolean getComplete() {
            return this.complete;
        }

        void setResponseMessage(NMessage msg) {
            this.resp = msg;
        }

        NMessage getResponseMessage() {
            return this.resp;
        }

        void setRequestMessage(NMessage msg) {
            this.req = msg;
        }

        NMessage getRequestMessage() {
            return this.req;
        }

        void setException(Exception e) {
            this.exception = e;
        }

        Exception getException() {
            return this.exception;
        }

        boolean isDone() {
            return this.respRcvd || this.timeout;
        }

        Object getTag() {
            return this.req.getTag();
        }

        boolean getTimeout() {
            return this.timeout;
        }

        @Override
        synchronized void timeOut() {
            if (!this.freeTrns && !this.getComplete()) {
                this.timeout = true;
                this.setException((Exception)((Object)new NCommTimeoutException(this.req.toTraceString())));
                this.notifyAll();
            }
        }

        void receivedResponse() {
            this.respRcvd = true;
            this.notifyAll();
        }

        @Override
        long getTimeOut() {
            return this.getRequestMessage().getResponseTimeOut() + this.getRequestMessage().getRespTimePadding();
        }
    }

    abstract class Timed {
        long endTime;

        Timed() {
        }

        void setEndTime(long s) {
            this.endTime = s;
        }

        long getEndTime() {
            return this.endTime;
        }

        abstract void timeOut();

        abstract long getTimeOut();

        abstract void init();

        abstract void free();
    }

    private class TransactionTimer
    implements Runnable {
        private final Vector<Timed> v;
        private int timeToWait;

        TransactionTimer(int max) {
            this.v = new Vector(max);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!NCommTimer.this.done) {
                TransactionTimer transactionTimer = this;
                synchronized (transactionTimer) {
                    long currTime = Clock.ticks();
                    this.timeToWait = 10000;
                    if (!this.v.isEmpty()) {
                        Timed curTrans = this.v.firstElement();
                        long toTime = curTrans.getEndTime();
                        if (toTime <= currTime) {
                            this.v.removeElement(curTrans);
                            curTrans.timeOut();
                            this.timeToWait = 0;
                        } else {
                            this.timeToWait = (int)(toTime - currTime);
                        }
                    }
                    try {
                        this.wait(this.timeToWait);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        boolean start(Timed tmd) {
            int i;
            long transTime = tmd.getTimeOut();
            long endTime = Clock.ticks() + transTime;
            tmd.setEndTime(endTime);
            for (i = 0; i < this.v.size() && this.v.elementAt(i).getEndTime() <= endTime; ++i) {
            }
            this.v.insertElementAt(tmd, i);
            boolean notifyAll = false;
            if (i == 0) {
                notifyAll = true;
            }
            return notifyAll;
        }

        boolean restart(Timed trans) {
            this.v.remove(trans);
            return this.start(trans);
        }

        boolean cancel(Timed trans) {
            trans.setEndTime(0L);
            this.v.removeElement(trans);
            return true;
        }

        private void spy(SpyWriter out, String title) throws Exception {
            out.startProps(title + "Timer");
            out.prop((Object)"currTime", (Object)Long.toString(Clock.ticks()));
            out.prop((Object)"timeToWait", this.timeToWait);
            out.endProps();
            out.startTable(true);
            out.trTitle((Object)title, 2);
            out.w((Object)"<tr>").th((Object)"id").th((Object)"endTime").w((Object)"</tr>\n");
            for (int i = 0; i < this.v.size(); ++i) {
                Timed c = this.v.elementAt(i);
                out.w((Object)"<tr>");
                out.td((Object)Integer.toString(i));
                out.td((Object)Long.toString(c.getEndTime()));
                out.w((Object)"</tr>\n");
            }
            out.endTable();
        }
    }
}

