/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.gx;

import java.util.Objects;
import javax.baja.gx.Geom;
import javax.baja.gx.IEllipseGeom;
import javax.baja.sys.BDouble;

public final class EllipseGeom
extends Geom
implements IEllipseGeom {
    public double x;
    public double y;
    public double width;
    public double height;

    public EllipseGeom(IEllipseGeom r) {
        this.set(r.x(), r.y(), r.width(), r.height());
    }

    public EllipseGeom(double x, double y, double width, double height) {
        this.set(x, y, width, height);
    }

    public EllipseGeom(double width, double height) {
        this.set(0.0, 0.0, width, height);
    }

    public EllipseGeom() {
        this.set(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public int getGeomCase() {
        return 3;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double width() {
        return this.width;
    }

    @Override
    public double height() {
        return this.height;
    }

    public void set(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void translate(double dx, double dy) {
        this.x += dx;
        this.y += dy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EllipseGeom) {
            EllipseGeom e = (EllipseGeom)obj;
            return this.x == e.x && this.y == e.y && this.width == e.width && this.height == e.height;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.width, this.height);
    }

    public String toString() {
        return BDouble.encode((double)this.x) + "," + BDouble.encode((double)this.y) + "," + BDouble.encode((double)this.width) + "," + BDouble.encode((double)this.height);
    }
}

