/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.actionArgSets.BLivePointSearchDiscoverOptions;
import com.tridium.mbus.ui.BPointDiscoveryModeSelectPane;
import com.tridium.mbus.ui.BPointLiveScanOptionsPane;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;

class PointDiscoveryWizardModel
extends WizardModel
implements BPointDiscoveryModeSelectPane.DiscoveryModeListener {
    private static final BImage bannerImg = BImage.make((String)"module://icons/x32/wizard.png");
    private final BWizardHeader banner = new BWizardHeader(bannerImg, "", "");
    private final BBorderPane bannerBorder = new BBorderPane((BWidget)new BNullWidget(), 10.0, 10.0, 10.0, 10.0);
    private final BEdgePane bannerPane = new BEdgePane((BWidget)this.banner, null, null, null, (BWidget)this.bannerBorder);
    private int currentStep = 0;
    private boolean userCompleted = false;
    private BPointDiscoveryModeSelectPane pointDiscoveryModeSelectPane = null;
    private BPointLiveScanOptionsPane liveScanLimitsPane = null;
    protected BOrd currentDevice = null;

    PointDiscoveryWizardModel() {
    }

    public void setDevice(BOrd deviceOrd) {
        this.currentDevice = deviceOrd;
    }

    public String getTitle() {
        return MbusToolkit.getText((String)"PointDiscoveryWizard.title");
    }

    public void init() {
        this.pointDiscoveryModeSelectPane = new BPointDiscoveryModeSelectPane(this);
        this.liveScanLimitsPane = new BPointLiveScanOptionsPane();
        this.liveScanLimitsPane.setDeviceRef(this.currentDevice);
        this.checkStep();
    }

    public void next() {
        ++this.currentStep;
        this.checkStep();
    }

    public void back() {
        --this.currentStep;
        this.checkStep();
    }

    public boolean finish() {
        if (this.isLivePointScan() && !this.liveScanLimitsPane.validate()) {
            BDialog.error((BWidget)this.getWizard(), (Object)MbusToolkit.getText((String)"PointDiscoveryWizard.scanLimitCorrectionReq"));
            return false;
        }
        this.userCompleted = true;
        return true;
    }

    private void checkStep() {
        switch (this.currentStep) {
            case 0: {
                int modelFlags = this.isDatabasePointScan() ? 4 : 6;
                this.setBannerWidget((BWidget)this.pointDiscoveryModeSelectPane, MbusToolkit.getText((String)"PointDiscoveryWizard.discoveryMode"), MbusToolkit.getText((String)"PointDiscoveryWizard.discoveryPointModeSelect"), modelFlags);
                break;
            }
            case 1: {
                int modelFlags = 5;
                this.setBannerWidget((BWidget)this.liveScanLimitsPane, MbusToolkit.getText((String)"PointDiscoveryWizard.scanLimitSetup"), MbusToolkit.getText((String)"PointDiscoveryWizard.scanLimitSetupDesc"), modelFlags);
                break;
            }
        }
    }

    private void setBannerWidget(BWidget w, String title, String description, int flags) {
        this.bannerBorder.setContent(w);
        this.banner.setTitle(title);
        this.banner.setDescription(description);
        this.update((BWidget)this.bannerPane, flags);
    }

    public boolean isUserFinished() {
        return this.userCompleted;
    }

    public boolean isDatabasePointScan() {
        return this.pointDiscoveryModeSelectPane.isScanDatabaseDiscover();
    }

    public boolean isLivePointScan() {
        return this.pointDiscoveryModeSelectPane.isScanLiveDeviceDiscover();
    }

    public BLivePointSearchDiscoverOptions getPointDiscoverOptions() {
        BLivePointSearchDiscoverOptions discoveryOpts = new BLivePointSearchDiscoverOptions();
        discoveryOpts.setMaxSequentialReads(this.liveScanLimitsPane.getMaximumReadsLimit());
        return discoveryOpts;
    }

    @Override
    public void modeChanged() {
        this.checkStep();
    }
}

