/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.ui;

import com.tridium.weather.ui.BWeatherIconSize;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.advisory.BAdvisory;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"weather:WeatherReport", "weather:CurrentConditions"})})
@NiagaraProperties(value={@NiagaraProperty(name="iconSize", type="BWeatherIconSize", defaultValue="BWeatherIconSize.x64"), @NiagaraProperty(name="tempFont", type="BFont", defaultValue="BFont.make(lex.getText(\"temp.font\"))"), @NiagaraProperty(name="tempBrush", type="BBrush", defaultValue="BColor.black.toBrush()"), @NiagaraProperty(name="stateFont", type="BFont", defaultValue="BFont.make(lex.getText(\"state.font\"))"), @NiagaraProperty(name="stateBrush", type="BBrush", defaultValue="BColor.black.toBrush()"), @NiagaraProperty(name="alarmStateBrush", type="BBrush", defaultValue="BColor.red.toBrush()"), @NiagaraProperty(name="halign", type="BHalign", defaultValue="BHalign.center"), @NiagaraProperty(name="valign", type="BValign", defaultValue="BValign.center")})
public class BCurrentWeatherView
extends BWbComponentView {
    private static final Lexicon lex = Lexicon.make((String)"weather");
    @Generated
    public static final Property iconSize = BCurrentWeatherView.newProperty((int)0, (BValue)BWeatherIconSize.x64, null);
    @Generated
    public static final Property tempFont = BCurrentWeatherView.newProperty((int)0, (BValue)BFont.make((String)lex.getText("temp.font")), null);
    @Generated
    public static final Property tempBrush = BCurrentWeatherView.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    @Generated
    public static final Property stateFont = BCurrentWeatherView.newProperty((int)0, (BValue)BFont.make((String)lex.getText("state.font")), null);
    @Generated
    public static final Property stateBrush = BCurrentWeatherView.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    @Generated
    public static final Property alarmStateBrush = BCurrentWeatherView.newProperty((int)0, (BValue)BColor.red.toBrush(), null);
    @Generated
    public static final Property halign = BCurrentWeatherView.newProperty((int)0, (BValue)BHalign.center, null);
    @Generated
    public static final Property valign = BCurrentWeatherView.newProperty((int)0, (BValue)BValign.center, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCurrentWeatherView.class);
    private BLabel icon;
    private BLabel temperature;
    private BLabel state;
    private Context cx;

    @Generated
    public BWeatherIconSize getIconSize() {
        return (BWeatherIconSize)this.get(iconSize);
    }

    @Generated
    public void setIconSize(BWeatherIconSize v) {
        this.set(iconSize, (BValue)v, null);
    }

    @Generated
    public BFont getTempFont() {
        return (BFont)this.get(tempFont);
    }

    @Generated
    public void setTempFont(BFont v) {
        this.set(tempFont, (BValue)v, null);
    }

    @Generated
    public BBrush getTempBrush() {
        return (BBrush)this.get(tempBrush);
    }

    @Generated
    public void setTempBrush(BBrush v) {
        this.set(tempBrush, (BValue)v, null);
    }

    @Generated
    public BFont getStateFont() {
        return (BFont)this.get(stateFont);
    }

    @Generated
    public void setStateFont(BFont v) {
        this.set(stateFont, (BValue)v, null);
    }

    @Generated
    public BBrush getStateBrush() {
        return (BBrush)this.get(stateBrush);
    }

    @Generated
    public void setStateBrush(BBrush v) {
        this.set(stateBrush, (BValue)v, null);
    }

    @Generated
    public BBrush getAlarmStateBrush() {
        return (BBrush)this.get(alarmStateBrush);
    }

    @Generated
    public void setAlarmStateBrush(BBrush v) {
        this.set(alarmStateBrush, (BValue)v, null);
    }

    @Generated
    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    @Generated
    public void setHalign(BHalign v) {
        this.set(halign, (BValue)v, null);
    }

    @Generated
    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    @Generated
    public void setValign(BValign v) {
        this.set(valign, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (this.getCurrentValue() == null) {
            return;
        }
        if (prop.equals(iconSize) || prop.equals(tempFont) || prop.equals(tempBrush) || prop.equals(stateFont) || prop.equals(stateBrush) || prop.equals(halign) || prop.equals(valign)) {
            this.loadValue(this.getCurrentValue(), this.getCurrentContext());
        }
    }

    protected void doLoadValue(BObject v, Context cx) {
        BCurrentConditions current;
        this.cx = cx;
        if (v instanceof BWeatherReport) {
            current = ((BWeatherReport)v).getCurrent();
        } else if (v instanceof BCurrentConditions) {
            current = (BCurrentConditions)v;
        } else {
            throw new IllegalStateException("No current conditions available from " + v.getType());
        }
        current.lease();
        BFacets facets = current.getSlotFacets((Slot)BCurrentConditions.temp);
        if (cx != null) {
            facets = BFacets.make((BFacets)facets, (BFacets)cx.getFacets());
        }
        this.temperature = new BLabel(current.getTemp().valueToString((Context)facets));
        this.temperature.setFont(this.getTempFont());
        this.temperature.setForeground(this.getTempBrush());
        BGridPane right = new BGridPane(1);
        right.setRowGap(1.0);
        if (current.getTemp().getStatus().isValid()) {
            right.add(null, (BValue)this.temperature);
        }
        if (current.getState().getStatus().isValid()) {
            current.getAdvisories().lease();
            BAdvisory advisory = current.getAdvisories().getMostUrgent();
            if (advisory != null) {
                advisory.lease();
                this.state = new BLabel(advisory.getWeatherSummary().getValue());
                this.state.setForeground(this.getAlarmStateBrush());
                String img = advisory.getState().getValue().getOrdinal() != 21 ? BCurrentWeatherView.getWeatherIcon(advisory.getState().getEnum(), current.getSunDown().getBoolean()) : BCurrentWeatherView.getWeatherIcon(current.getState().getEnum(), current.getSunDown().getBoolean());
                if (!current.getState().getStatus().isValid()) {
                    img = "unknown";
                }
                String size = this.getIconSize() == BWeatherIconSize.x64 ? "64" : "32";
                this.icon = new BLabel(BImage.make((String)("module://weather/rc/" + img + size + ".png")));
            } else {
                this.state = new BLabel(current.getState().valueToString(cx));
                this.state.setForeground(this.getStateBrush());
                String img = BCurrentWeatherView.getWeatherIcon(current.getState().getEnum(), current.getSunDown().getBoolean());
                if (!current.getState().getStatus().isValid()) {
                    img = "unknown";
                }
                String size = this.getIconSize() == BWeatherIconSize.x64 ? "64" : "32";
                this.icon = new BLabel(BImage.make((String)("module://weather/rc/" + img + size + ".png")));
            }
            this.state.setFont(this.getStateFont());
            right.add(null, (BValue)this.state);
        } else {
            this.icon = new BLabel(BImage.make((String)"module://weather/rc/unknown32.png"));
        }
        BGridPane grid = new BGridPane(2);
        grid.setColumnGap(6.0);
        grid.add(null, (BValue)this.icon);
        grid.add(null, (BValue)right);
        grid.setHalign(this.getHalign());
        grid.setValign(this.getValign());
        this.setContent((BWidget)grid);
        this.registerForComponentEvents((BComponent)current);
    }

    public static String getWeatherIcon(BEnum state) {
        return BCurrentWeatherView.getWeatherIcon(state, false);
    }

    public static String getWeatherIcon(BEnum state, boolean sunDown) {
        switch (state.getOrdinal()) {
            case 0: 
            case 1: 
            case 4: {
                if (!sunDown) {
                    return "sunny";
                }
                return "nightClear";
            }
            case 3: 
            case 7: {
                if (!sunDown) {
                    return "partlySunny";
                }
                return "nightMostlyCloudy";
            }
            case 2: 
            case 5: 
            case 6: {
                if (!sunDown) {
                    return "mostlySunny";
                }
                return "nightPartlyCloudy";
            }
            case 8: 
            case 9: {
                return "cloudy";
            }
            case 15: {
                if (!sunDown) {
                    return "fog";
                }
                return "nightFog";
            }
            case 16: {
                return "haze";
            }
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 26: {
                return "rain";
            }
            case 14: {
                return "freezingRain";
            }
            case 13: {
                return "thunder";
            }
            case 17: {
                return "snow";
            }
            case 18: 
            case 23: {
                return "windy";
            }
            case 20: {
                return "dust";
            }
            case 22: 
            case 24: {
                return "flood";
            }
            case 27: {
                return "earthquake";
            }
            case 25: 
            case 28: {
                return "fire";
            }
        }
        return "unknown";
    }

    public void handleComponentEvent(BComponentEvent event) {
        BComponent c = event.getSourceComponent();
        if (c != this.getCurrentValue()) {
            return;
        }
        if (c instanceof BCurrentConditions) {
            BCurrentConditions current = (BCurrentConditions)c;
            if (event.getSlot().equals((Object)BCurrentConditions.temp)) {
                this.temperature.setText(current.getTemp().valueToString((Context)current.getSlotFacets((Slot)BCurrentConditions.temp)));
            }
            if (event.getSlot().equals((Object)BCurrentConditions.state) || event.getSlot().equals((Object)BCurrentConditions.status)) {
                String img = BCurrentWeatherView.getWeatherIcon(current.getState().getEnum(), current.getSunDown().getBoolean());
                if (!current.getState().getStatus().isValid()) {
                    img = "unknown";
                }
                String size = this.getIconSize() == BWeatherIconSize.x64 ? "64" : "32";
                this.icon.setImage(BImage.make((String)("module://weather/rc/" + img + size + ".png")));
                if (current.getState().getStatus().isValid()) {
                    if (current.getStatus().isAlarm()) {
                        this.state.setText(current.getWeatherSummary().getValue());
                    } else {
                        this.state.setText(current.getState().valueToString(this.cx));
                    }
                }
            }
            this.relayout();
        }
    }
}

