/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bql;

import com.tridium.bql.BIBqlResolver;
import com.tridium.bql.BLocalBqlResolver;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.bql.BqlQuery;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ordScheme="bql")
@NiagaraSingleton
public class BBqlScheme
extends BOrdScheme {
    @Generated
    public static final BBqlScheme INSTANCE = new BBqlScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BBqlScheme.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BBqlScheme() {
        super("bql");
    }

    public OrdQuery parse(String queryText) {
        try {
            return BqlQuery.make(queryText);
        }
        catch (RuntimeException e) {
            throw new SyntaxException(queryText, (Throwable)e);
        }
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) {
        BISession session = this.toSession(base);
        BIBqlResolver resolver = this.getResolver(session);
        if (resolver == null) {
            throw new InvalidOrdBaseException("" + base.get());
        }
        String bqlText = ((BqlQuery)query).getUnescaped();
        if (bqlText == null || bqlText.length() == 0) {
            return new OrdTarget(base, (BObject)resolver);
        }
        return resolver.resolve(session, base, (BqlQuery)query);
    }

    private BISession toSession(OrdTarget baseTarget) {
        if (baseTarget == null) {
            throw new InvalidOrdBaseException("null");
        }
        BISession session = null;
        for (OrdTarget target = baseTarget; target != null && (session = BOrd.toSession((BObject)target.get())) == null; target = target.getBaseOrdTarget()) {
        }
        if (session != null) {
            return session;
        }
        throw new InvalidOrdBaseException("" + baseTarget.get());
    }

    private BIBqlResolver getResolver(BISession session) {
        AgentList agents = Sys.getRegistry().getAgents(session.getType().getTypeInfo());
        if ((agents = agents.filter(AgentFilter.is((Type)BIBqlResolver.TYPE))).size() == 0) {
            return BLocalBqlResolver.INSTANCE;
        }
        return (BIBqlResolver)agents.getDefault().getInstance();
    }
}

