/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.script;

import com.tridium.script.ScriptField;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;

public class PropertyField
implements ScriptField {
    private Property prop;

    public PropertyField(Property prop) {
        this.prop = prop;
    }

    public Property getProperty() {
        return this.prop;
    }

    @Override
    public String scriptName() {
        return this.prop.getName();
    }

    @Override
    public String scriptDisplayName(Object target, Context cx) {
        if (target != null) {
            return ((BComplex)target).getDisplayName((Slot)this.prop, cx);
        }
        return this.prop.getDefaultDisplayName(cx);
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    public boolean isReusable() {
        return true;
    }

    @Override
    public Class<?> scriptType() {
        return this.prop.getType().getTypeClass();
    }

    @Override
    public Object scriptGet(Object target, Context cx) throws Exception {
        BComplex complex = (BComplex)target;
        if (this.prop.isFrozen()) {
            return complex.get(this.prop);
        }
        Property p = complex.getProperty(this.prop.getName());
        if (p != null) {
            return complex.get(p);
        }
        return null;
    }

    @Override
    public int scriptFlags(Object target) {
        BComplex complex = (BComplex)target;
        if (this.prop.isFrozen()) {
            return complex.getFlags((Slot)this.prop);
        }
        Property p = complex.getProperty(this.prop.getName());
        if (p != null) {
            return complex.getFlags((Slot)p);
        }
        return 0;
    }

    @Override
    public BFacets scriptFacets(Object target) {
        BComplex complex = (BComplex)target;
        if (this.prop.isFrozen()) {
            return complex.getSlotFacets((Slot)this.prop);
        }
        Property p = complex.getProperty(this.prop.getName());
        if (p != null) {
            return complex.getSlotFacets((Slot)p);
        }
        return BFacets.NULL;
    }
}

