/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.projection;

import com.tridium.bql.expression.BPath;
import com.tridium.bql.projection.ProjectionColumn;
import com.tridium.bql.projection.ProjectionTableCursor;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public class PathProjectionColumn
extends ProjectionColumn {
    private final BPath path;
    private final String name;
    private final Type type;
    private final Context cx;

    public PathProjectionColumn(BPath expr, Type type, String displayName, Context cx) {
        this(expr.toString(), expr, type, displayName, cx);
    }

    public PathProjectionColumn(String name, BPath expr, Type type, String displayName, Context cx) {
        super(displayName);
        this.name = name;
        this.path = expr;
        this.type = type;
        this.cx = cx;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getDefaultDisplayName(Context cx) {
        return this.path.getPath().getDisplayName(null, cx);
    }

    public Type getType() {
        return this.type;
    }

    public int getFlags() {
        return 0;
    }

    public BFacets getFacets() {
        return BFacets.NULL;
    }

    @Override
    public BIObject getProjectionCell(ProjectionTableCursor.ProjectionRow<? extends BIObject> row) {
        return this.path.evaluate((BObject)row.rowObject(), this.cx);
    }

    @Override
    public BFacets getProjectionFacets(ProjectionTableCursor.ProjectionRow<? extends BIObject> row) {
        return this.path.evaluateFacets(row.rowObject(), this.cx);
    }

    @Override
    public String toString() {
        return this.getName() + ',' + this.getType();
    }
}

