/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.filter;

import com.tridium.bql.filter.BRangeFilter;
import javax.baja.bql.BIBqlFilter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BExpression;
import javax.baja.query.BIQueryFilter;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:Double"})})
@NiagaraProperties(value={@NiagaraProperty(name="minValue", type="double", defaultValue="0d"), @NiagaraProperty(name="maxValue", type="double", defaultValue="0d")})
public class BDoubleFilter
extends BRangeFilter
implements BIBqlFilter,
BIQueryFilter {
    @Generated
    public static final Property minValue = BDoubleFilter.newProperty((int)0, (double)0.0, null);
    @Generated
    public static final Property maxValue = BDoubleFilter.newProperty((int)0, (double)0.0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDoubleFilter.class);

    @Generated
    public double getMinValue() {
        return this.getDouble(minValue);
    }

    @Generated
    public void setMinValue(double v) {
        this.setDouble(minValue, v, null);
    }

    @Generated
    public double getMaxValue() {
        return this.getDouble(maxValue);
    }

    @Generated
    public void setMaxValue(double v) {
        this.setDouble(maxValue, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void init(BObject o) {
    }

    @Override
    public String getPredicate(String columnName) {
        double min = this.getMinValue();
        double max = this.getMaxValue();
        if (!this.getMinEnabled() && !this.getMaxEnabled()) {
            return null;
        }
        StringBuilder s = new StringBuilder(64);
        if (this.getMinEnabled()) {
            s.append(columnName);
            s.append(" >= ");
            try {
                s.append(BDouble.make((double)min).encodeToString());
            }
            catch (Exception e) {
                e.printStackTrace();
                s.append("error");
            }
        }
        if (this.getMaxEnabled()) {
            if (s.length() != 0) {
                s.append(" and ");
            }
            s.append(columnName);
            s.append(" <= ");
            try {
                s.append(BDouble.make((double)max).encodeToString());
            }
            catch (Exception e) {
                e.printStackTrace();
                s.append("error");
            }
        }
        return s.toString();
    }

    public BExpression getExpression(BExpression columnExpression) {
        BDouble min = BDouble.make((double)this.getMinValue());
        BDouble max = BDouble.make((double)this.getMaxValue());
        if (!this.getMinEnabled() && !this.getMaxEnabled()) {
            return null;
        }
        if (this.getMinEnabled() && !this.getMaxEnabled()) {
            return Predicates.ge((BExpression)columnExpression, (BSimple)min);
        }
        if (this.getMaxEnabled() && !this.getMinEnabled()) {
            return Predicates.le((BExpression)columnExpression, (BSimple)min);
        }
        return Predicates.and((BExpression)Predicates.ge((BExpression)columnExpression, (BSimple)min), (BExpression)Predicates.le((BExpression)((BExpression)columnExpression.newCopy()), (BSimple)max));
    }

    @Override
    public boolean accept(BObject o) {
        double value = ((BDouble)o).getDouble();
        double min = this.getMinValue();
        double max = this.getMaxValue();
        boolean retVal = true;
        if (this.getMinEnabled() && value < min) {
            retVal = false;
        }
        if (this.getMaxEnabled() && value > max) {
            retVal = false;
        }
        return retVal;
    }
}

