/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.filter;

import com.tridium.bql.filter.BNullBitString;
import javax.baja.bql.BIBqlFilter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBitString;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:BitString"})})
@NiagaraProperties(value={@NiagaraProperty(name="include", type="BBitString", defaultValue="BNullBitString.DEFAULT"), @NiagaraProperty(name="exclude", type="BBitString", defaultValue="BNullBitString.DEFAULT")})
public class BBitStringFilter
extends BComponent
implements BIBqlFilter {
    @Generated
    public static final Property include = BBitStringFilter.newProperty((int)0, (BValue)BNullBitString.DEFAULT, null);
    @Generated
    public static final Property exclude = BBitStringFilter.newProperty((int)0, (BValue)BNullBitString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBitStringFilter.class);

    @Generated
    public BBitString getInclude() {
        return (BBitString)this.get(include);
    }

    @Generated
    public void setInclude(BBitString v) {
        this.set(include, (BValue)v, null);
    }

    @Generated
    public BBitString getExclude() {
        return (BBitString)this.get(exclude);
    }

    @Generated
    public void setExclude(BBitString v) {
        this.set(exclude, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBitStringFilter() {
    }

    public BBitStringFilter(BBitString include, BBitString exclude) {
        this.setInclude(include);
        this.setExclude(exclude);
    }

    @Override
    public void init(BObject o) {
        BBitString empty = ((BBitString)o).getInstance(new int[0]);
        this.setInclude(empty);
        this.setExclude(empty);
    }

    @Override
    public String getPredicate(String columnName) {
        String s;
        String includeMask = BBitStringFilter.toBitsMask(this.getInclude(), columnName);
        String excludeMask = BBitStringFilter.toBitsMask(this.getExclude(), columnName);
        StringBuilder sb = new StringBuilder(includeMask);
        if (!excludeMask.isEmpty()) {
            if (!includeMask.isEmpty()) {
                sb.append(" and ");
            }
            sb.append("not ").append(excludeMask);
        }
        return (s = sb.toString()).isEmpty() ? null : s;
    }

    private static String toBitsMask(BBitString bitString, String columnName) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (int ordinal : bitString.getOrdinals()) {
            if (!bitString.getBit(ordinal)) continue;
            if (count > 0) {
                sb.append(" or ");
            }
            ++count;
            sb.append(columnName).append('.').append(bitString.getTag(ordinal));
        }
        return count > 1 ? "(" + sb + ")" : sb.toString();
    }

    @Override
    public boolean accept(BObject o) {
        BBitString bitString = (BBitString)o;
        return BBitStringFilter.anyMatch(bitString, this.getInclude(), true) && !BBitStringFilter.anyMatch(bitString, this.getExclude(), false);
    }

    private static boolean anyMatch(BBitString candidate, BBitString criteria, boolean matchOnEmpty) {
        boolean criteriaEmpty = true;
        for (int ordinal : criteria.getOrdinals()) {
            if (!criteria.getBit(ordinal)) continue;
            if (candidate.getBit(ordinal)) {
                return true;
            }
            criteriaEmpty = false;
        }
        return matchOnEmpty && criteriaEmpty;
    }
}

