/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql;

import com.tridium.bql.BSelect;
import com.tridium.bql.collection.BObjectTable;
import com.tridium.bql.collection.BqlColumn;
import com.tridium.bql.collection.BqlColumnList;
import com.tridium.bql.collection.TypeColumnList;
import com.tridium.bql.expression.ExprEngine;
import com.tridium.bql.util.BqlUtil;
import com.tridium.collection.BListTable;
import com.tridium.util.ClassUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.expression.BSimpleExpression;
import javax.baja.sys.BIObject;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public class Ordering {
    private BSelect query;
    private BOrderByColumn[] fields;
    private ExprEngine engine;

    public Ordering(BSelect query) {
        this.query = query;
        this.fields = query.getOrdering().getOrderByColumns();
        this.engine = query.getExprEngine();
    }

    public BITable<? extends BIObject> order(BITable<? extends BIObject> table, Context cx) {
        Context context;
        Array orderRecords = new Array(OrderByRecord.class);
        HashSet<Type> types = new HashSet<Type>();
        try (TableCursor cursor = table.cursor();){
            while (cursor.next()) {
                OrderByRecord rec = new OrderByRecord();
                BObject o = (BObject)cursor.get();
                types.add(o.getType());
                if (!o.isComponent() && o.isComplex() && o.asComplex().getParentComponent() == null) {
                    o = o.asComplex().newCopy(true);
                }
                rec.object = o;
                rec.colValues = new BObject[this.fields.length];
                BExpression[] resolvedExprs = this.resolveColumns();
                for (int i = 0; i < resolvedExprs.length; ++i) {
                    rec.colValues[i] = this.engine.evaluate(resolvedExprs[i], o, cx);
                }
                orderRecords.add((Object)rec);
            }
            context = BqlUtil.mergeCursorContextFacets(cx, cursor.getContext());
        }
        if (orderRecords.size() == 0) {
            return table;
        }
        OrderByComparator comparator = new OrderByComparator();
        Object[] records = (OrderByRecord[])orderRecords.trim();
        SortUtil.sort((Object[])records, (Object[])records, (Comparator)comparator);
        BObject[] sorted = new BObject[records.length];
        for (int i = 0; i < records.length; ++i) {
            sorted[i] = ((OrderByRecord)records[i]).object;
        }
        return this.makeTable(table.getColumns(), types, sorted, context);
    }

    private BObjectTable makeTable(ColumnList cols, Set<Type> types, BObject[] sorted, Context cx) {
        Column[] origCols = cols.list();
        boolean allBql = true;
        for (int i = 0; i < origCols.length; ++i) {
            allBql &= origCols[i] instanceof BqlColumn;
        }
        if (allBql) {
            return new BObjectTable(cols, (BITable<? extends BIObject>)new BListTable(Arrays.asList(sorted), cx));
        }
        Type[] objectTypes = types.toArray(new Type[0]);
        Type common = ClassUtil.getCommonSuperType((Type[])objectTypes);
        TypeColumnList typeColumns = new TypeColumnList(common, cx);
        BqlColumnList bqlColumns = new BqlColumnList();
        for (int i = 0; i < origCols.length; ++i) {
            if (origCols[i] instanceof BqlColumn) {
                bqlColumns.addColumn(origCols[i]);
                continue;
            }
            BqlColumn bqlColumn = (BqlColumn)typeColumns.get(origCols[i].getName());
            if (bqlColumn == null) continue;
            bqlColumns.addColumn(bqlColumn);
        }
        BListTable listTable = new BListTable(Arrays.asList(sorted), cx);
        if (bqlColumns.size() == 0) {
            return new BObjectTable(typeColumns, (BITable<? extends BIObject>)listTable);
        }
        return new BObjectTable(bqlColumns, (BITable<? extends BIObject>)listTable);
    }

    private BExpression[] resolveColumns() {
        BExpression[] resolved = new BExpression[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getColumnExpression() instanceof BSimpleExpression) {
                int projCol = ((BNumber)((BSimpleExpression)this.fields[i].getColumnExpression()).getSimpleValue()).getInt();
                resolved[i] = this.query.getProjection().getProjectionColumns()[projCol - 1].getColumnExpression();
                continue;
            }
            resolved[i] = this.fields[i].getColumnExpression();
        }
        return resolved;
    }

    private class OrderByComparator
    implements Comparator<OrderByRecord> {
        private OrderByComparator() {
        }

        @Override
        public int compare(OrderByRecord o1, OrderByRecord o2) {
            int result = 0;
            for (int i = 0; i < o1.colValues.length; ++i) {
                result = SortUtil.compare((Object)o1.colValues[i], (Object)o2.colValues[i]);
                if (result == 0) continue;
                if (Ordering.this.fields[i].isAscending()) break;
                result *= -1;
                break;
            }
            return result;
        }
    }

    private static class OrderByRecord {
        public BObject object;
        public BObject[] colValues;

        private OrderByRecord() {
        }
    }
}

