/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.portal.wb;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.subscription.AccessTokenApi;
import com.tridium.nre.subscription.DeviceCodeApi;
import com.tridium.nre.subscription.EntitlementApi;
import com.tridium.nre.subscription.RegistrationApi;
import com.tridium.nre.subscription.RetrieveEntitlements;
import com.tridium.nre.subscription.SubscriptionLicenseUtil;
import com.tridium.nre.util.LicenseMode;
import com.tridium.platform.license.LicenseModel;
import com.tridium.portal.api.PortalApi;
import com.tridium.portal.api.XLicense;
import com.tridium.portal.util.LicenseDownload;
import com.tridium.portal.wb.BModalFrame;
import com.tridium.sys.Nre;
import com.tridium.sys.license.subscription.SubscriptionLicenseManager;
import com.tridium.workbench.web.BUrlTextField;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

public class LicenseProcedure {
    static final Lexicon lex = Lexicon.make((String)PortalApi.MODULE.getModuleName());
    static final BImage keys32 = BImage.make((String)"module://icons/x32/keys.png");
    static final BImage network32 = BImage.make((String)"module://icons/x32/network.png");
    static final BImage info32 = BImage.make((String)"module://icons/x32/info.png");
    static final BImage warning32 = BImage.make((String)"module://icons/x32/warning.png");
    static final BImage error32 = BImage.make((String)"module://icons/x32/error.png");
    private BTextEditorPane details;
    BModalFrame frame = new BModalFrame();
    boolean licenseInstalled;
    private static final Logger logger = Logger.getLogger("portalApi");
    private static final char[] INVALID_CHARACTERS = new char[]{'{', '}', '(', ')', '<', '>', '&', '*', '\u2018', '|', '=', '?', ';', '$', '^', '#', '~', '!', '%', '@', '+', ',', '`', '\"'};
    private static final boolean HEADLESS = AccessController.doPrivileged(() -> Boolean.getBoolean("java.awt.headless"));

    public static void licenseMe() {
        new LicenseProcedure().doLicenseMe();
    }

    private void doLicenseMe() {
        if (SubscriptionLicenseUtil.getLicenseMode() == LicenseMode.SUBSCRIPTION) {
            boolean alreadyRegenerated = false;
            if ("cloned".equals(SubscriptionLicenseUtil.getHostIdStatus())) {
                if (this.dialogResponse("RegenerateNreIdDialog", 1)) {
                    try {
                        SubscriptionLicenseUtil.regenerateNreId();
                        alreadyRegenerated = true;
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Unable to regenerate Host ID.", e);
                        return;
                    }
                } else {
                    Nre.licenseFailure();
                }
            }
            if ("unregistered".equals(SubscriptionLicenseUtil.getHostIdStatus())) {
                if (!alreadyRegenerated && this.dialogResponse("RegenerateUnregisteredNreIdDialog", 3)) {
                    try {
                        SubscriptionLicenseUtil.regenerateNreId();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Unable to regenerate Host ID.", e);
                    }
                }
                if (this.dialogResponse("RegisterNreIdDialog", 3)) {
                    DeviceCodeApi deviceCodeApi = new DeviceCodeApi();
                    EntitlementApi.EntitlementStatus deviceCodeStatus = deviceCodeApi.getDeviceCode();
                    if (deviceCodeStatus.isSuccess()) {
                        this.stepTo(new ShowUserCode(deviceCodeStatus));
                    } else {
                        this.stepTo(new ShowRegistrationFailure("Code fetch failed: " + deviceCodeStatus.getMessage()));
                    }
                } else {
                    Nre.licenseFailure();
                }
            }
            if ("ok".equals(SubscriptionLicenseUtil.getHostIdStatus())) {
                EntitlementApi.EntitlementStatus status;
                SubscriptionLicenseManager mgr = new SubscriptionLicenseManager();
                mgr.checkEntitlement();
                try {
                    status = AccessController.doPrivileged(() -> RetrieveEntitlements.getLastEntitlementStatus());
                }
                catch (PrivilegedActionException e) {
                    logger.log(Level.SEVERE, "Unable to get the last subscription license status:", e);
                    Nre.licenseFailure();
                    return;
                }
                if (status == null) {
                    logger.log(Level.SEVERE, "Last subscription license status was null.");
                    Nre.licenseFailure();
                    return;
                }
                if (!status.isSuccess()) {
                    this.stepTo(new ShowEntitlementFailure(this.getDisplayMessage(status.getMessage()), status.getMessage()));
                }
            }
            this.frame.openModal();
        } else {
            if (PortalApi.brandGet((String)"license.autoFetch", (boolean)true)) {
                this.stepTo(new CheckServer());
            } else {
                this.stepTo(new LicenseUnavailable(null));
            }
            this.frame.openModal();
        }
    }

    public static void requestLicense(BWidgetShell owner, String hostId) {
        try {
            if (PortalApi.brandGet((String)"license.onlineRequest", (boolean)true) && PortalApi.checkConnectivity()) {
                LicenseProcedure.requestLicense(hostId);
            } else {
                LicenseProcedure.showEmailDialog(owner, hostId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LicenseProcedure.showErrorDialog(owner, hostId);
        }
    }

    public static void requestLicense(String hostId) throws Exception {
        Process p;
        if (HEADLESS) {
            throw new UnsupportedOperationException("Display required to launch external application");
        }
        String portalHost = PortalApi.getPortalAddress();
        for (char invalidChar : INVALID_CHARACTERS) {
            if (portalHost.indexOf(invalidChar) == -1) continue;
            throw new IllegalArgumentException("Provided portal host contains invalid character '" + invalidChar + "'");
        }
        if (hostId == null) {
            hostId = PortalApi.MY_HOST_ID;
        }
        String brand = PortalApi.brandGet((String)"brand.id", (String)"vykon");
        String toEncode = "brand=" + brand + '&' + "hostId=" + hostId + '&' + "clientVersion=" + Sys.getBajaVersion().toString(2);
        String encoded = Base64.getUrlEncoder().encodeToString(toEncode.getBytes(StandardCharsets.UTF_8));
        String scheme = "";
        if (!portalHost.contains("://")) {
            scheme = "http://";
        }
        String url = scheme + portalHost + "/license/request?params=" + encoded;
        try {
            p = AccessController.doPrivileged(() -> {
                if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.linux)) {
                    return new ProcessBuilder("xdg-open", url).start();
                }
                return new ProcessBuilder("cmd.exe", "/c", "start", url).start();
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        int exitCode = p.waitFor();
        if (exitCode != 0 && exitCode != 1) {
            throw new RuntimeException("exit=" + exitCode);
        }
    }

    public void stepTo(Step step) {
        this.frame.setTitle(step.title);
        BWizardHeader header = new BWizardHeader(keys32, step.title, step.description);
        BButton def = null;
        BGridPane buttons = new BGridPane(step.commands.length);
        buttons.setUniformColumnWidth(true);
        buttons.setColumnAlign(BHalign.fill);
        for (int i = 0; i < step.commands.length; ++i) {
            Command cmd = step.commands[i];
            if (cmd instanceof ToggleCommand) {
                BToggleButton toggleButton = new BToggleButton((ToggleCommand)cmd, true, false);
                buttons.add(null, (BValue)toggleButton);
                continue;
            }
            BButton button = new BButton(cmd, true, true);
            if (i == 0 && !(cmd instanceof ExitCommand)) {
                def = button;
            }
            buttons.add(null, (BValue)button);
        }
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)header);
        edge.setCenter((BWidget)new BBorderPane(step.content, 8.0, 8.0, 4.0, 8.0));
        edge.setBottom((BWidget)new BBorderPane((BWidget)buttons, 0.0, 0.0, 8.0, 0.0));
        this.frame.setContent((BWidget)edge);
        this.frame.relayout();
        this.frame.requestFocus();
        this.frame.setDefaultButton(def);
        this.frame.center();
        if (step.runInBackground) {
            step.runInBackground();
        } else {
            step.run();
        }
    }

    static BWidget createRequestEmailContent(String hostId, String msg) {
        if (hostId == null) {
            hostId = PortalApi.MY_HOST_ID;
        }
        BEdgePane main = new BEdgePane();
        BLabel label = new BLabel(LicenseProcedure.getErrorInstructions(msg, "licenseUnavailable"));
        label.setHalign(BHalign.left);
        main.setTop((BWidget)label);
        String[] brandKeys = PortalApi.getBrandKeys();
        ArrayList<SubmitItem> temp = new ArrayList<SubmitItem>(brandKeys.length);
        for (String key : brandKeys) {
            if (!key.startsWith("submit.")) continue;
            SubmitItem item = new SubmitItem(key, PortalApi.brandGet((String)key, null));
            if ("hostId".equals(item.key)) {
                item.value = hostId;
            }
            if ("version".equals(item.key)) {
                item.value = Sys.getBajaVersion().toString();
            }
            temp.add(item);
        }
        Object[] items = temp.toArray(new SubmitItem[0]);
        SortUtil.sort((Object[])items);
        StringBuilder text = new StringBuilder(128);
        for (Object item : items) {
            text.append(((SubmitItem)item).display).append(':').append(' ');
            if (!((SubmitItem)item).value.isEmpty()) {
                text.append(((SubmitItem)item).value);
            } else {
                text.append('<').append(((SubmitItem)item).display.toLowerCase()).append('>');
            }
            text.append('\n');
        }
        BTextEditor content = new BTextEditor(text.toString(), false);
        main.setCenter((BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)content, BBorder.inset, BInsets.make((double)4.0, (double)0.0, (double)4.0, (double)0.0)), 4.0, 0.0, 4.0, 0.0));
        return main;
    }

    static String getErrorInstructions(String baseKey) {
        return LicenseProcedure.getErrorInstructions(null, baseKey);
    }

    static String getErrorInstructions(String preMsg, String baseKey) {
        Object[] args;
        String key;
        String msg;
        String vendor = PortalApi.brandGet((String)"license.provider", (String)"Tridium");
        String email = PortalApi.brandGet((String)"license.email", null);
        String phone = PortalApi.brandGet((String)"license.phone", null);
        String string = msg = preMsg == null ? "" : preMsg + ' ';
        if (email != null && phone != null) {
            key = baseKey + ".messageEmailOrPhone";
            args = new Object[]{vendor, email, phone};
            msg = msg + lex.getText(key, args);
        } else if (email != null) {
            key = baseKey + ".messageEmail";
            args = new Object[]{vendor, email};
            msg = msg + lex.getText(key, args);
        } else if (phone != null) {
            key = baseKey + ".messagePhone";
            args = new Object[]{vendor, phone};
            msg = msg + lex.getText(key, args);
        } else {
            Object[] args2 = new Object[]{vendor};
            msg = msg + lex.getText(baseKey + ".message", args2);
        }
        StringTokenizer t = new StringTokenizer(msg, " ");
        StringBuilder s = new StringBuilder(msg.length());
        int linelen = 0;
        while (t.hasMoreTokens()) {
            if (linelen > 60) {
                s.append('\n');
                linelen = 0;
            }
            String word = t.nextToken();
            if (linelen != 0) {
                s.append(' ');
                ++linelen;
            }
            s.append(word);
            linelen += word.length();
        }
        return s.toString();
    }

    static BWidget createLicenseUnvailableContent(XLicense lic) {
        String s = lic.toSubmitString();
        BTextEditor editor = new BTextEditor(s, false);
        BTextEditorPane pane = new BTextEditorPane(editor, 15, 40);
        BLabel msg = new BLabel(LicenseProcedure.getErrorInstructions("licenseUnavailable"));
        msg.setHalign(BHalign.left);
        BEdgePane top = new BEdgePane();
        top.setLeft((BWidget)new BBorderPane((BWidget)new BLabel(error32)));
        top.setCenter((BWidget)new BBorderPane((BWidget)msg));
        BGridPane gridPane = new BGridPane(1);
        gridPane.add("pane", (BValue)pane);
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BBorderPane((BWidget)top));
        edge.setCenter((BWidget)gridPane);
        return edge;
    }

    static BWidget message(String key, Object[] args) {
        BLabel msg = new BLabel(lex.getText(key, args));
        msg.setHalign(BHalign.left);
        return msg;
    }

    static void showEmailDialog(BWidgetShell owner, String hostId) {
        BDialog.open((BWidget)owner, (String)lex.getText("requestLicense.title"), (Object)LicenseProcedure.createRequestEmailContent(hostId, null), (int)1);
    }

    static void showErrorDialog(BWidgetShell owner, String hostId) {
        BDialog.open((BWidget)owner, (String)lex.getText("requestLicense.title"), (Object)LicenseProcedure.createRequestEmailContent(hostId, lex.getText("requestLicenseOnline.error")), (int)1);
    }

    private boolean dialogResponse(String lexBaseKey, int dialogType) {
        return 1 == BDialog.open(null, (String)lex.getText(lexBaseKey + ".title"), (Object)lex.getText(lexBaseKey + ".description"), (int)dialogType);
    }

    private void fetchEntitlements(SubscriptionLicenseManager slm) {
        try {
            AccessController.doPrivileged(() -> {
                slm.refreshLrtIfNreIdChanged();
                slm.postInit();
                return null;
            });
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to start subscription licensing check.", e);
        }
    }

    private String getDisplayMessage(String message) {
        String displayMessage = message;
        if (displayMessage.contains("Exception:")) {
            displayMessage = displayMessage.substring(displayMessage.indexOf("Exception:") + 10);
        }
        if (displayMessage.contains(": ")) {
            displayMessage = displayMessage.substring(0, displayMessage.indexOf(": "));
        }
        if (displayMessage.contains(":\n")) {
            displayMessage = displayMessage.substring(0, displayMessage.indexOf(":\n"));
        }
        if (displayMessage.contains("\n")) {
            displayMessage = displayMessage.substring(0, displayMessage.indexOf(10));
        }
        if (displayMessage.charAt(0) == ' ') {
            displayMessage = displayMessage.substring(1);
        }
        return displayMessage;
    }

    class LicenseUnavailable
    extends Step {
        LicenseUnavailable(XLicense lic) {
            super("licenseUnavailable");
            if (lic == null) {
                lic = new XLicense();
            }
            this.content = LicenseProcedure.createLicenseUnvailableContent(lic);
            this.commands = new Command[]{new ExitCommand(false)};
        }
    }

    class OnlineError
    extends Step {
        OnlineError(Exception ex) {
            super("onlineError");
            this.content = LicenseProcedure.createRequestEmailContent(null, lex.getText("onlineError.noBrowser"));
            this.commands = new Command[]{new ExitCommand(false)};
        }
    }

    class DoneOnline
    extends Step {
        DoneOnline() {
            super("doneOnline");
            this.content = new BBorderPane(LicenseProcedure.message("doneOnline.message", null), 0.0, 0.0, 8.0, 0.0);
            this.commands = new Command[]{new ExitCommand(false)};
        }
    }

    static class SubmitItem
    implements Comparable<SubmitItem> {
        public int index;
        public String key;
        public String display;
        public String value;

        public SubmitItem(String fullKey, String display) {
            int dot1 = fullKey.indexOf(46);
            int dot2 = fullKey.lastIndexOf(46);
            this.index = Integer.parseInt(fullKey.substring(dot1 + 1, dot2));
            this.key = fullKey.substring(dot2 + 1);
            this.display = display;
            this.value = "";
        }

        public String toString() {
            return this.index + ": " + this.key + '=' + this.value;
        }

        @Override
        public int compareTo(SubmitItem i) {
            return this.index - i.index;
        }
    }

    class RequestLicenseEmail
    extends Step {
        RequestLicenseEmail() {
            super("requestLicense");
            this.content = LicenseProcedure.createRequestEmailContent(null, null);
            this.commands = new Command[]{new ExitCommand(false)};
        }
    }

    class RequestLicenseOnline
    extends Step {
        RequestLicenseOnline() {
            super("requestLicense");
            this.content = new BBorderPane(LicenseProcedure.message("requestLicenseOnline.message", null), 0.0, 0.0, 8.0, 0.0);
            this.commands = new Command[]{new CancelCommand(false)};
        }

        @Override
        public void run() {
            try {
                Thread.sleep(2500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                LicenseProcedure.requestLicense(null);
            }
            catch (Exception ex) {
                LicenseProcedure.this.stepTo(new OnlineError(ex));
                return;
            }
            LicenseProcedure.this.stepTo(new DoneOnline());
        }
    }

    class LicenseInstalled
    extends Step {
        XElem[] licenses;
        XElem[] certificates;

        LicenseInstalled(XElem[] licenses, XElem[] certificates) {
            super("licenseInstalled");
            this.licenses = (XElem[])licenses.clone();
            this.certificates = (XElem[])certificates.clone();
            this.content = new BLabel(info32, lex.getText("licenseInstalled.message"));
            this.commands = new Command[]{new ContinueCommand()};
        }

        @Override
        public void run() {
            try {
                LicenseDownload.copyLicenses((XElem[])this.licenses);
                LicenseDownload.copyCertificates((XElem[])this.certificates);
                AccessController.doPrivileged(Nre::getLicenseManager).reload();
                LicenseProcedure.this.licenseInstalled = true;
            }
            catch (Throwable e) {
                BDialog.error((BWidget)LicenseProcedure.this.frame, (String)lex.getText("licenseInstalled.cannotWrite"), (Object)e);
            }
        }
    }

    class LicenseModelOption
    extends ToggleCommand {
        LicenseModel model;

        public LicenseModelOption(LicenseModel model) {
            super((BWidget)LicenseProcedure.this.frame, lex.getText("chooseLicense.option", new Object[]{model.toString()}), null, null, null);
            this.model = model;
        }
    }

    class ChooseLicense
    extends Step {
        List<LicenseModel> licenseFileElems;
        ToggleCommandGroup<ToggleCommand> commandGroup;

        public ChooseLicense(List<LicenseModel> licenseModels) {
            super("chooseLicense");
            this.commandGroup = new ToggleCommandGroup();
            this.licenseFileElems = licenseModels;
            BGridPane grid = new BGridPane(1);
            grid.setHalign(BHalign.left);
            grid.setColumnAlign(BHalign.left);
            boolean first = true;
            for (LicenseModel model : licenseModels) {
                LicenseModelOption command = new LicenseModelOption(model);
                this.commandGroup.add((ToggleCommand)command);
                if (first) {
                    command.setSelected(true);
                    first = false;
                }
                grid.add(null, (BValue)new BRadioButton((ToggleCommand)command, true, false));
            }
            BLabel headerLabel = new BLabel(lex.getText("chooseLicense.header"));
            headerLabel.setHalign(BHalign.left);
            this.content = new BEdgePane((BWidget)new BBorderPane((BWidget)headerLabel, 0.0, 0.0, 8.0, 0.0), null, (BWidget)new BBorderPane((BWidget)new BNullWidget(), 0.0, 10.0, 0.0, 0.0), null, (BWidget)new BBorderPane((BWidget)grid, 0.0, 0.0, 8.0, 0.0));
            this.commands = new Command[]{new ContinueCommand(){

                @Override
                public CommandArtifact doInvoke() {
                    XElem[] licenseElems = ((LicenseModelOption)ChooseLicense.this.commandGroup.getSelected()).model.getLicenseElements();
                    String[] vendorsArray = LicenseDownload.licenseToVendors((XElem[])licenseElems);
                    XElem[] certificateElems = null;
                    try {
                        certificateElems = PortalApi.getCertificates((String[])vendorsArray);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (certificateElems == null) {
                        certificateElems = new XElem[]{};
                    }
                    LicenseProcedure.this.stepTo(new LicenseInstalled(licenseElems, certificateElems));
                    return null;
                }
            }, new CancelCommand(false)};
        }
    }

    class CheckServer
    extends Step {
        CheckServer() {
            super("checkServer");
            this.runInBackground = true;
            this.content = new BLabel(network32, lex.getText("checkServer.message"));
            this.commands = new Command[]{new ExitCommand(true)};
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                XElem[] licensesElem = PortalApi.getLicenses((String)PortalApi.MY_HOST_ID, (String)PortalApi.getLocalBrandId(), (Version)Sys.getBajaVersion());
                if (licensesElem == null || licensesElem.length == 0) {
                    if (PortalApi.brandGet((String)"license.onlineRequest", (boolean)true) && PortalApi.checkConnectivity()) {
                        LicenseProcedure.this.stepTo(new RequestLicenseOnline());
                    } else {
                        LicenseProcedure.this.stepTo(new RequestLicenseEmail());
                    }
                } else if (licensesElem.length == 1) {
                    XElem[] licenseElems = licensesElem[0].elems("license");
                    String[] vendorsArray = LicenseDownload.licenseToVendors((XElem[])licenseElems);
                    XElem[] certificateElems = PortalApi.getCertificates((String[])vendorsArray);
                    if (certificateElems == null) {
                        certificateElems = new XElem[]{};
                    }
                    LicenseProcedure.this.stepTo(new LicenseInstalled(licenseElems, certificateElems));
                } else {
                    LicenseProcedure.this.stepTo(new ChooseLicense(LicenseModel.make((XElem[])licensesElem)));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                LicenseProcedure.this.stepTo(new RequestLicenseEmail());
            }
        }
    }

    public class ShowEntitlementFailure
    extends Step {
        public ShowEntitlementFailure(String displayMessage, String message) {
            super("showEntitlementFailure");
            this.runInBackground = false;
            if (!message.equals(displayMessage)) {
                LicenseProcedure.this.details = new BTextEditorPane();
                if (!message.isEmpty()) {
                    LicenseProcedure.this.details.getEditor().setText(message);
                }
                LicenseProcedure.this.details.setVisible(false);
                this.content = new BEdgePane((BWidget)new BLabel(displayMessage, BHalign.center), (BWidget)LicenseProcedure.this.details, null, null, null);
                this.commands = new Command[]{new DetailsToggle((BWidget)LicenseProcedure.this.frame), new ExitCommand(false)};
            } else {
                this.content = new BEdgePane((BWidget)new BLabel(displayMessage, BHalign.center), null, null, null, null);
                this.commands = new Command[]{new ExitCommand(false)};
            }
        }
    }

    public class ShowRegistrationFailure
    extends Step {
        public ShowRegistrationFailure(String displayMessage) {
            super("showRegistrationFailure");
            this.content = new BEdgePane((BWidget)new BLabel(displayMessage, BHalign.center), null, null, null, null);
            this.commands = new Command[]{new ExitCommand(false)};
        }
    }

    public class ShowUserCode
    extends Step {
        private final EntitlementApi.EntitlementStatus deviceCodeStatus;

        public ShowUserCode(EntitlementApi.EntitlementStatus deviceCodeStatus) {
            super("showUserCode");
            this.runInBackground = false;
            this.deviceCodeStatus = deviceCodeStatus;
            this.content = this.getUserCodeDialogContent(deviceCodeStatus.getUserCode(), deviceCodeStatus.getVerificationUri());
            this.commands = new Command[]{new ContinueCommand(){

                @Override
                public CommandArtifact doInvoke() {
                    if (AccessTokenApi.isAccessTokenPollComplete()) {
                        if (AccessTokenApi.getAccessTokenPollStatus().isSuccess()) {
                            LicenseProcedure.this.stepTo(new GetSubscriptionKey(AccessTokenApi.getAccessTokenPollStatus()));
                        } else {
                            LicenseProcedure.this.stepTo(new ShowRegistrationFailure("Access token request failed: " + AccessTokenApi.getAccessTokenPollStatus().getMessage()));
                        }
                    } else {
                        BDialog.info((BWidget)LicenseProcedure.this.frame, (Object)"Please approve the device by entering the Code at the Verification URL.");
                    }
                    return null;
                }
            }, new ExitCommand(true){

                @Override
                public CommandArtifact doInvoke() {
                    int r;
                    if (this.confirm && (r = BDialog.confirm((BWidget)LicenseProcedure.this.frame, (Object)lex.getText("exit.confirm"))) != 4) {
                        return null;
                    }
                    AccessTokenApi.Poll.stop();
                    System.exit(0);
                    return null;
                }
            }};
        }

        private BGridPane getUserCodeDialogContent(String userCode, String verificationUrl) {
            BGridPane editorPane = new BGridPane(2);
            int codeVisibleColumns = 20;
            int urlVisibleColumns = 20;
            if (userCode.length() > 18) {
                codeVisibleColumns = userCode.length() + 2;
            }
            if (verificationUrl.length() > 18) {
                urlVisibleColumns = verificationUrl.length() + 2;
            }
            editorPane.add(null, (BValue)new BLabel("Code: "));
            BTextField code = new BTextField(userCode, codeVisibleColumns, false);
            editorPane.add("code", (BValue)code);
            editorPane.add(null, (BValue)new BLabel("Verification URL: "));
            BUrlTextField url = new BUrlTextField(verificationUrl, urlVisibleColumns);
            editorPane.add("url", (BValue)url);
            return editorPane;
        }

        @Override
        public void run() {
            AccessTokenApi.Poll.start((String)this.deviceCodeStatus.getDeviceCode(), (int)this.deviceCodeStatus.getInterval());
        }
    }

    public class GetSubscriptionKey
    extends Step {
        private final EntitlementApi.EntitlementStatus pollStatus;
        private final BTextField subKeyField;

        public GetSubscriptionKey(EntitlementApi.EntitlementStatus status) {
            super("getSubscriptionKey");
            this.subKeyField = new BTextField();
            this.runInBackground = false;
            this.pollStatus = status;
            BGridPane grid = new BGridPane(1);
            grid.setHalign(BHalign.center);
            grid.setColumnAlign(BHalign.center);
            grid.add("subscriptionKey", (BValue)this.subKeyField);
            this.content = new BEdgePane((BWidget)new BLabel("Please enter the subscription key:", BHalign.center), (BWidget)grid, null, null, (BWidget)new BBorderPane((BWidget)new BNullWidget(), 10.0, 0.0, 0.0, 0.0));
            this.commands = new Command[]{new ContinueCommand(){

                @Override
                public CommandArtifact doInvoke() {
                    if (!SubscriptionLicenseUtil.isKeyValid((String)GetSubscriptionKey.this.subKeyField.getText())) {
                        BDialog.info((BWidget)LicenseProcedure.this.frame, (Object)"Please enter a valid Subscription Key.");
                        return null;
                    }
                    RegistrationApi registrationApi = new RegistrationApi();
                    EntitlementApi.EntitlementStatus registrationStatus = registrationApi.register(GetSubscriptionKey.this.pollStatus, GetSubscriptionKey.this.subKeyField.getText());
                    if (registrationStatus.isSuccess()) {
                        LicenseProcedure.this.fetchEntitlements((SubscriptionLicenseManager)Nre.getLicenseManager());
                        LicenseProcedure.this.frame.closeModal();
                    } else {
                        LicenseProcedure.this.stepTo(new ShowRegistrationFailure("Registration failed: " + registrationStatus.getMessage()));
                    }
                    return null;
                }
            }, new ExitCommand(true)};
        }
    }

    class Step
    implements Runnable {
        boolean runInBackground;
        String title;
        String description;
        BWidget content;
        Command[] commands;

        Step(String baseKey) {
            this.title = lex.getText(baseKey + ".title");
            this.description = lex.getText(baseKey + ".description");
        }

        public void runInBackground() {
            new Thread((Runnable)this, "LicenseProcedure").start();
        }

        @Override
        public void run() {
        }
    }

    class DetailsToggle
    extends ToggleCommand {
        DetailsToggle(BWidget owner) {
            super(owner, UiLexicon.bajaui().getText("dialog.details"));
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            LicenseProcedure.this.details.setVisible(sel);
            LicenseProcedure.this.frame.setScreenSizeToPreferredSize();
        }
    }

    class ContinueCommand
    extends StepCommand {
        ContinueCommand() {
            super("continue");
        }

        public CommandArtifact doInvoke() {
            LicenseProcedure.this.frame.closeModal();
            return null;
        }
    }

    class CancelCommand
    extends StepCommand {
        boolean confirm;

        CancelCommand(boolean confirm) {
            super("cancel");
            this.confirm = confirm;
        }

        public CommandArtifact doInvoke() {
            int r;
            if (this.confirm && (r = BDialog.confirm((BWidget)LicenseProcedure.this.frame, (Object)lex.getText("cancel.confirm"))) != 4) {
                return null;
            }
            System.exit(0);
            return null;
        }
    }

    class ExitCommand
    extends StepCommand {
        boolean confirm;

        ExitCommand(boolean confirm) {
            super("exit");
            this.confirm = confirm;
        }

        public CommandArtifact doInvoke() {
            int r;
            if (this.confirm && (r = BDialog.confirm((BWidget)LicenseProcedure.this.frame, (Object)lex.getText("exit.confirm"))) != 4) {
                return null;
            }
            System.exit(0);
            return null;
        }
    }

    class StepCommand
    extends Command {
        StepCommand(String keyBase) {
            super((BWidget)LicenseProcedure.this.frame, LicenseProcedure.lex.module, keyBase);
        }
    }
}

