/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.ui;

import com.tridium.exporttags.BJoinProfile;
import com.tridium.exporttags.ui.JobTracker;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;

@NiagaraType(agent={@AgentOn(types={"exportTags:SubordinateExportTagNetworkExt"})})
public class BJoinProfileManager
extends BFolderManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BJoinProfileManager.class);
    private MgrColumn colName = new MgrColumn.Name(2);
    private MgrColumn colType = new MgrColumn.Type(2);
    private MgrColumn colEnabled = new MgrColumn.Prop(BJoinProfile.enabled, 3);
    private MgrColumn colLastJoin = new MgrColumn.Prop(BJoinProfile.lastJoin);
    private MgrColumn colStation = new StationNameCol();
    private MgrColumn colStationDisplayName = new MgrColumn.Prop(BJoinProfile.stationDisplayName, 1);
    private MgrColumn colDefaultUser = new MgrColumn.Prop(BJoinProfile.defaultUser, 1);
    private MgrColumn colDefaultUserPassword = new MgrColumn.Prop(BJoinProfile.defaultUserPassword, 1);
    private MgrColumn colDefaultIpAddress = new MgrColumn.Prop(BJoinProfile.defaultIpAddress, 3);
    private MgrColumn colDefaultPort = new MgrColumn.Prop(BJoinProfile.defaultPort, 3);
    private MgrColumn colDefaultUseFoxs = new MgrColumn.Prop(BJoinProfile.defaultUseFoxs, 3);
    private MgrColumn colDefaultFoxsPort = new MgrColumn.Prop(BJoinProfile.defaultFoxsPort, 3);
    private MgrColumn colStationFile = new MgrColumn.Prop(BJoinProfile.stationFile, 1);
    private MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colEnabled, this.colStation, this.colLastJoin, this.colStationDisplayName, this.colDefaultUser, this.colDefaultUserPassword, this.colDefaultIpAddress, this.colDefaultPort, this.colDefaultUseFoxs, this.colDefaultFoxsPort, this.colStationFile};
    private static final Lexicon lex = Lexicon.make(BJoinProfileManager.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(BOrd.make((String)"service:niagaraDriver:NiagaraNetwork").get(obj), cx);
        ((FolderController)this.getController()).allDescendants.setSelected(true);
        this.getModel().getTable().setMultipleSelection(false);
    }

    private class StationNameCol
    extends MgrColumn {
        protected StationNameCol() {
            super(lex.get("joinProfileManager.stationName"));
        }

        public Object get(Object row) {
            BComponent parent = (BComponent)((BJoinProfile)row).getParent();
            if (parent != null) {
                return parent.getDisplayName(null);
            }
            return "";
        }
    }

    private class JoinCmd
    extends MgrController.MgrCommand {
        public JoinCmd(BWidget owner) {
            super(owner, lex, "commands.join");
        }

        public CommandArtifact doInvoke(CommandEvent event) throws Exception {
            BJoinProfile profile = (BJoinProfile)BJoinProfileManager.this.getModel().getTable().getSelectedComponent();
            BOrd ord = profile.join();
            if (ord.isNull()) {
                throw new LocalizableException(BJoinProfileManager.this.getType().getModule().getModuleName(), "joinProfileManager.unableToLaunchJoin");
            }
            JobTracker.open((BWidget)BJoinProfileManager.this, (BComponent)BJoinProfileManager.this.getCurrentValue(), ord);
            return null;
        }
    }

    private class Controller
    extends FolderController {
        private JoinCmd joinCmd;

        public Controller(BJoinProfileManager manager) {
            super((BFolderManager)manager);
            this.joinCmd = new JoinCmd((BWidget)manager);
            this.joinCmd.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.edit, this.joinCmd};
        }

        protected MgrController.IMgrCommand[] makeTagCommands() {
            return new MgrController.IMgrCommand[0];
        }

        public void updateCommands() {
            boolean b;
            BMgrTable table = this.getManager().getModel().getTable();
            boolean bl = b = table != null && !table.getSelection().isEmpty();
            if (b) {
                BJoinProfile profile = (BJoinProfile)table.getSelectedComponent();
                b = !profile.getStatus().isDisabled();
            }
            this.joinCmd.setEnabled(b);
        }

        public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
            BComponent comp = table.getComponentAt(row);
            BWbShell shell = BJoinProfileManager.this.getWbShell();
            if (comp != null && shell != null) {
                shell.hyperlink(comp.getNavOrd());
            }
        }
    }

    private class Model
    extends FolderModel {
        public Model(BJoinProfileManager manager) {
            super((BFolderManager)manager);
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BJoinProfile.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BJoinProfile.TYPE);
        }

        protected MgrColumn[] makeColumns() {
            return BJoinProfileManager.this.cols;
        }

        public Type getFolderType() {
            return BFolder.TYPE;
        }
    }
}

