/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.BWifiNetworkVector;
import com.tridium.platwifi.BWifiPlatformService;
import com.tridium.platwifi.BWifiSettings;
import com.tridium.platwifi.ui.BWifiAccessPointManager;
import com.tridium.platwifi.ui.BWifiNetworksManager;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType
public class BWifiPlatformServicePlugin
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiPlatformServicePlugin.class);
    private BWifiNetworksManager networkManager;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiPlatformServicePlugin() {
        this.autoRegisterForComponentEvents = false;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BWifiPlatformService service = (BWifiPlatformService)value;
        service.poll();
        this.registerForComponentEvents((BComponent)service, 3);
        service.getSettings().lease(Integer.MAX_VALUE);
        service.getSettings().getComponentSpace().sync();
        this.networkManager = new BWifiNetworksManager(service);
        BWifiAccessPointManager accessPointManager = new BWifiAccessPointManager(service);
        if (this.get("networkManagerModified") != null) {
            this.remove("networkManagerModified");
        }
        this.linkTo("networkManagerModified", (BComponent)this.networkManager, (Slot)BWifiNetworksManager.pluginModified, (Slot)setModified);
        BTabbedPane configurationPane = new BTabbedPane();
        configurationPane.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"wireless.png")), LexiconText.make((Type)TYPE, (String)"WifiConfiguration.networkManager.label").getText(cx), Theme.widget().getBoldText()), (BWidget)new BBorderPane((BWidget)this.networkManager, BBorder.none, BInsets.DEFAULT));
        configurationPane.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"remoteMgmt.png")), LexiconText.make((Type)TYPE, (String)"WifiConfiguration.accessPointManager.label").getText(cx), Theme.widget().getBoldText()), (BWidget)new BBorderPane((BWidget)accessPointManager, BBorder.none, BInsets.DEFAULT));
        BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)configurationPane, BBorder.none));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground((IStylable)scrollPane));
        this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(cx), (BWidget)scrollPane));
        this.networkManager.loadValue((BObject)service.getSettings(), cx);
        accessPointManager.loadValue((BObject)service.getSettings(), cx);
        BSystemPlatformService sys = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)service);
        sys.lease();
        this.setReadonly(sys.getIsServiceReadonly());
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (value == null) {
            return null;
        }
        BWifiPlatformService service = (BWifiPlatformService)value;
        this.networkManager.saveValue((BObject)service.getSettings(), cx);
        BSystemPlatformService system = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)service);
        if (system.getLocalDaemonAccess() != BDaemonAccessLevel.restricted) {
            service.savePlatformServiceProperties();
        }
        return value;
    }

    public void doSetReadonly(boolean readonly) {
        this.networkManager.setReadonly(readonly);
    }

    public final void handleComponentEvent(BComponentEvent evt) {
        if (evt.getSourceComponent() instanceof BWifiSettings || evt.getSourceComponent() instanceof BWifiNetworkVector || evt.getSourceComponent() instanceof BWifiNetwork) {
            this.networkManager.handleComponentEvent(evt);
        } else {
            super.handleComponentEvent(evt);
        }
    }
}

