/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platwifi.BSupplicantNetBlock;
import com.tridium.platwifi.BSupplicantNetBlockVector;
import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.BWifiNetworkMode;
import com.tridium.platwifi.BWifiNetworkVector;
import com.tridium.platwifi.BWifiPlatformService;
import com.tridium.platwifi.BWifiSettings;
import com.tridium.platwifi.WifiUtil;
import com.tridium.platwifi.daemon.message.ChangeGatewaySwitchingMessage;
import com.tridium.platwifi.security.BWifiAuthenticationMethod;
import com.tridium.platwifi.security.BWifiEncryptionMethod;
import com.tridium.platwifi.security.BWifiSecurityPolicy;
import com.tridium.platwifi.security.BWifiSecuritySettings;
import com.tridium.platwifi.security.BWifiWPAPSKSettings;
import com.tridium.platwifi.status.BWifiNetworkStateEnum;
import com.tridium.platwifi.status.BWifiSupplicantStateEnum;
import com.tridium.platwifi.ui.BDiscoverPreferences;
import com.tridium.platwifi.ui.BWifiDiscoverDialog;
import com.tridium.platwifi.ui.BWifiNetworkEditorDialog;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import java.security.AccessController;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Logger;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="handleDiscoveredTableModified"), @NiagaraAction(name="handleDiscoveredSelectionModified"), @NiagaraAction(name="handleDiscoveredFocusModified", parameterType="BFocusEvent", defaultValue="new BFocusEvent()"), @NiagaraAction(name="handleDatabaseSelectionModified"), @NiagaraAction(name="handleDatabaseFocusModified", parameterType="BFocusEvent", defaultValue="new BFocusEvent()"), @NiagaraAction(name="setEnabledStates"), @NiagaraAction(name="gatewaySwitchingModified", flags=4)})
public class BWifiNetworksManager
extends BWbComponentView {
    @Generated
    public static final Action handleDiscoveredTableModified = BWifiNetworksManager.newAction((int)0, null);
    @Generated
    public static final Action handleDiscoveredSelectionModified = BWifiNetworksManager.newAction((int)0, null);
    @Generated
    public static final Action handleDiscoveredFocusModified = BWifiNetworksManager.newAction((int)0, (BValue)new BFocusEvent(), null);
    @Generated
    public static final Action handleDatabaseSelectionModified = BWifiNetworksManager.newAction((int)0, null);
    @Generated
    public static final Action handleDatabaseFocusModified = BWifiNetworksManager.newAction((int)0, (BValue)new BFocusEvent(), null);
    @Generated
    public static final Action setEnabledStates = BWifiNetworksManager.newAction((int)0, null);
    @Generated
    public static final Action gatewaySwitchingModified = BWifiNetworksManager.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiNetworksManager.class);
    private final Object operationMonitor = new Object();
    private boolean operationTakingPlace = false;
    protected BDaemonSession wifiDaemonSession = null;
    protected BWifiPlatformService wifiPlatformService = null;
    protected BGridPane ledgerPane = null;
    protected BTextField clientAdapterTextField = null;
    protected BTextField connectedSsidTextField = null;
    protected BTextField clientAddressTextField = null;
    protected BTextField clientIpTextField = null;
    protected BTextField supplicantStateTextField = null;
    protected BCheckBox updateGatewayCheckbox = null;
    boolean allowRefresh = true;
    protected BWifiNetwork currentNetwork = null;
    protected BTitlePane titledDatabaseTable = null;
    protected BTitlePane titledDiscoveryTable = null;
    protected BTable discoveredNetworkTable = null;
    protected BTable databaseNetworkTable = null;
    protected WifiNetworkTableModel discoveredNetworkTableModel = null;
    protected WifiNetworkTableModel databaseNetworkTableModel = null;
    protected BButtonPane discoverButtons = null;
    protected DiscoverCommand discoverNetworksCommand = null;
    protected AddCommand addNetworkCommand = null;
    protected BButtonPane databaseButtons = null;
    protected ConnectCommand connectNetworkCommand = null;
    protected NewCommand newNetworkCommand = null;
    protected EditCommand editNetworkCommand = null;
    protected DisconnectCommand disconnectNetworkCommand = null;
    protected RemoveCommand removeNetworkCommand = null;
    public static final int DIALOG_WIDTH = 500;
    public static final int DIALOG_HEIGHT = 800;
    public static final BImage UNSECURED_NETWORK_ICON = BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png")}));
    public static final BImage SECURED_NETWORK_ICON = BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/securityDomain.png")}));
    public static final BImage UNAVAILABLE_NETWORK_ICON = BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloudDisconnected.png")}));
    BWifiSupplicantStateEnum oldState = BWifiSupplicantStateEnum.idle;
    BWifiSupplicantStateEnum newState;
    boolean clientModeEnabled = false;

    @Generated
    public void handleDiscoveredTableModified() {
        this.invoke(handleDiscoveredTableModified, null, null);
    }

    @Generated
    public void handleDiscoveredSelectionModified() {
        this.invoke(handleDiscoveredSelectionModified, null, null);
    }

    @Generated
    public void handleDiscoveredFocusModified(BFocusEvent parameter) {
        this.invoke(handleDiscoveredFocusModified, (BValue)parameter, null);
    }

    @Generated
    public void handleDatabaseSelectionModified() {
        this.invoke(handleDatabaseSelectionModified, null, null);
    }

    @Generated
    public void handleDatabaseFocusModified(BFocusEvent parameter) {
        this.invoke(handleDatabaseFocusModified, (BValue)parameter, null);
    }

    @Generated
    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    @Generated
    public void gatewaySwitchingModified() {
        this.invoke(gatewaySwitchingModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiNetworksManager(BDaemonSession wifiDaemonSession) {
        this.wifiDaemonSession = wifiDaemonSession;
        this.wifiPlatformService = null;
    }

    public BWifiNetworksManager(BWifiPlatformService wifiPlatformService) {
        this.wifiPlatformService = wifiPlatformService;
        this.wifiDaemonSession = null;
    }

    public final void doLoadValue(BObject value, Context contextIn) {
        if (this.isOperationTakingPlace()) {
            return;
        }
        this.autoRegisterForComponentEvents = false;
        this.ledgerPane = new BGridPane(2);
        this.ledgerPane.setRowAlign(BValign.top);
        this.ledgerPane.setHalign(BHalign.left);
        this.ledgerPane.setColumnAlign(BHalign.left);
        this.ledgerPane.setRowGap(5.0);
        this.ledgerPane.setColumnGap(10.0);
        this.ledgerPane.setStretchColumn(1);
        this.supplicantStateTextField = new BTextField(BWifiSupplicantStateEnum.unknown.getTag(), 32, false);
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.settings.wpaState.label"), (BWidget)this.supplicantStateTextField);
        this.clientAdapterTextField = new BTextField("", 32, false);
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.settings.clientModeAdapter.label"), (BWidget)this.clientAdapterTextField);
        this.clientAddressTextField = new BTextField("", 32, false);
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.settings.clientAddress.label"), (BWidget)this.clientAddressTextField);
        this.clientIpTextField = new BTextField("", 32, false);
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.settings.clientIpAddress.label"), (BWidget)this.clientIpTextField);
        this.connectedSsidTextField = new BTextField("", 32, false);
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.settings.connectedSsid.label"), (BWidget)this.connectedSsidTextField);
        String updateGatewayCheckBoxText = LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.settings.updateGateway.checkbox.label").getText(null);
        this.updateGatewayCheckbox = new BCheckBox(updateGatewayCheckBoxText, false);
        LabelUtil.addLabelWidgetPair((BPane)this.ledgerPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.settings.updateGateway.label"), (BWidget)this.updateGatewayCheckbox);
        this.linkTo(null, (BComponent)this.updateGatewayCheckbox, (Slot)BCheckBox.actionPerformed, (Slot)gatewaySwitchingModified);
        BBorderPane settingsBorder = new BBorderPane((BWidget)this.ledgerPane);
        settingsBorder.setBorder(BBorder.solid);
        settingsBorder.setLabel((BWidget)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platWifi", (String)"WifiNetworkManager.settings.label"), (boolean)true));
        settingsBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)6.0, (double)0.0));
        this.discoveredNetworkTableModel = new WifiNetworkTableModel(true, true, false, true, false, true, true, true);
        this.discoveredNetworkTable = new BTable((TableModel)this.discoveredNetworkTableModel);
        this.discoveredNetworkTable.setCellRenderer((TableCellRenderer)new WifiNetworkCellRenderer());
        this.discoveredNetworkTable.setController((TableController)new DiscoveryTableController());
        this.discoveredNetworkTable.setHeaderVisible(true);
        this.discoveredNetworkTable.setMultipleSelection(false);
        this.discoveredNetworkTable.setVscrollBarVisible(true);
        this.linkTo(null, (BComponent)this.discoveredNetworkTable, (Slot)BTable.selectionModified, (Slot)handleDiscoveredSelectionModified);
        this.linkTo(null, (BComponent)this.discoveredNetworkTable, (Slot)BTable.tableModified, (Slot)handleDiscoveredTableModified);
        this.linkTo(null, (BComponent)this.discoveredNetworkTable, (Slot)BTable.focusEvent, (Slot)handleDiscoveredFocusModified);
        this.discoverButtons = new BButtonPane();
        this.discoverButtons.setColumnCount(2);
        this.discoverButtons.setUniformColumnWidth(false);
        this.discoverButtons.setBandBrush(Theme.scrollPane().getControlBackground());
        BBorderPane discoverButtonBorder = new BBorderPane((BWidget)this.discoverButtons);
        discoverButtonBorder.setPadding(BInsets.make((double)5.0, (double)0.0, (double)0.0, (double)0.0));
        this.titledDiscoveryTable = BTitlePane.makePane((String)this.getLexicon().getText("WifiNetworkManager.header.discovered"), (BTable)this.discoveredNetworkTable);
        this.titledDiscoveryTable.setBottom((BWidget)discoverButtonBorder);
        BBorderPane titledDiscoveryTableBorder = new BBorderPane((BWidget)this.titledDiscoveryTable);
        titledDiscoveryTableBorder.setBorder(BBorder.solid);
        titledDiscoveryTableBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)6.0, (double)0.0));
        this.databaseNetworkTableModel = new WifiNetworkTableModel(false, true, true, false, true, true, false, false);
        this.databaseNetworkTable = new BTable((TableModel)this.databaseNetworkTableModel);
        this.databaseNetworkTable.setCellRenderer((TableCellRenderer)new WifiNetworkCellRenderer());
        this.databaseNetworkTable.setController((TableController)new DatabaseTableController());
        this.databaseNetworkTable.setHeaderVisible(true);
        this.databaseNetworkTable.setMultipleSelection(false);
        this.linkTo(null, (BComponent)this.databaseNetworkTable, (Slot)BTable.tableModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.databaseNetworkTable, (Slot)BTable.focusEvent, (Slot)handleDatabaseFocusModified);
        this.linkTo(null, (BComponent)this.databaseNetworkTable, (Slot)BTable.actionPerformed, (Slot)handleDatabaseSelectionModified);
        this.databaseButtons = new BButtonPane();
        this.databaseButtons.setColumnCount(5);
        this.databaseButtons.setUniformColumnWidth(false);
        this.databaseButtons.setBandBrush(Theme.scrollPane().getControlBackground());
        BBorderPane databaseButtonBorder = new BBorderPane((BWidget)this.databaseButtons);
        databaseButtonBorder.setPadding(BInsets.make((double)5.0, (double)0.0, (double)0.0, (double)0.0));
        this.titledDatabaseTable = BTitlePane.makePane((String)this.getLexicon().getText("WifiNetworkManager.header.database"), (BTable)this.databaseNetworkTable);
        this.titledDatabaseTable.setBottom((BWidget)databaseButtonBorder);
        BBorderPane titledDatabaseTableBorder = new BBorderPane((BWidget)this.titledDatabaseTable);
        titledDatabaseTableBorder.setBorder(BBorder.solid);
        titledDatabaseTableBorder.setMargin(BInsets.make((double)0.0, (double)0.0, (double)6.0, (double)0.0));
        BGridPane assembledPanes = new BGridPane();
        assembledPanes.setColumnCount(1);
        assembledPanes.setUniformColumnWidth(true);
        assembledPanes.setStretchColumn(0);
        assembledPanes.setColumnAlign(BHalign.fill);
        assembledPanes.add("wifiSettings", (BValue)settingsBorder);
        assembledPanes.add("apBorder", (BValue)titledDiscoveryTableBorder);
        assembledPanes.add("dhcpBorder", (BValue)titledDatabaseTableBorder);
        this.setContent((BWidget)new BScrollPane((BWidget)new BBorderPane((BWidget)assembledPanes)));
        this.discoverNetworksCommand = new DiscoverCommand();
        this.discoverButtons.add("discover", (BValue)new BButton((Command)this.discoverNetworksCommand, true, true));
        this.addNetworkCommand = new AddCommand();
        this.discoverButtons.add("add", (BValue)new BButton((Command)this.addNetworkCommand, true, true));
        this.connectNetworkCommand = new ConnectCommand();
        this.databaseButtons.add("connect", (BValue)new BButton((Command)this.connectNetworkCommand, true, true));
        this.disconnectNetworkCommand = new DisconnectCommand();
        this.databaseButtons.add("disconnect", (BValue)new BButton((Command)this.disconnectNetworkCommand, true, true));
        this.editNetworkCommand = new EditCommand();
        this.databaseButtons.add("edit", (BValue)new BButton((Command)this.editNetworkCommand, true, true));
        this.newNetworkCommand = new NewCommand();
        this.databaseButtons.add("new", (BValue)new BButton((Command)this.newNetworkCommand, true, true));
        this.removeNetworkCommand = new RemoveCommand();
        this.databaseButtons.add("remove", (BValue)new BButton((Command)this.removeNetworkCommand, true, true));
        this.doSetEnabledStates();
        this.refreshSettings((BWifiSettings)value, contextIn);
    }

    public final void refreshSettings(BWifiSettings wifiSettings, Context contextIn) {
        if (this.isOperationTakingPlace()) {
            return;
        }
        if (wifiSettings == null) {
            return;
        }
        this.lockModifiedState();
        boolean alreadyModified = this.isModified();
        Context cx = contextIn == null ? new BasicContext() : contextIn;
        this.clientModeEnabled = wifiSettings.getMonitorData().getWifiSwitchPosition().getOrdinal() == 1;
        this.newState = wifiSettings.getStaWpaSupplicantState();
        if (!wifiSettings.getMonitorData().getWifimonState().startsWith("sta_")) {
            this.newState = BWifiSupplicantStateEnum.notrunning;
        }
        this.supplicantStateTextField.setText(this.newState.getTag());
        this.clientAdapterTextField.setText(wifiSettings.getStaAdapterName());
        this.connectedSsidTextField.setText(wifiSettings.getStaCurrentNetworkSsid());
        this.clientAddressTextField.setText(wifiSettings.getStaCurrentNetworkAddress());
        this.clientIpTextField.setText(wifiSettings.getStaCurrentNetworkIpAddress());
        this.updateGatewayCheckbox.setSelected(wifiSettings.getStaSwitchDefaultGateway());
        String currentNetworkSsid = wifiSettings.getStaCurrentNetworkSsid();
        BSupplicantNetBlockVector networkBlocks = wifiSettings.getSupplicantNetworkBlocks();
        if (!cx.getFacets().get("poll", (BObject)BBoolean.FALSE).equals((Object)BBoolean.TRUE)) {
            this.databaseNetworkTableModel.clear();
            BComponent[] netBlocks = networkBlocks.getChildComponents();
            for (int i = 0; i < netBlocks.length; ++i) {
                BSupplicantNetBlock netBlock = (BSupplicantNetBlock)netBlocks[i];
                BWifiNetwork databaseNet = this.netBlockToNetwork(netBlock);
                if (currentNetworkSsid.equals(netBlock.getSsid())) {
                    this.currentNetwork = databaseNet;
                }
                this.databaseNetworkTableModel.addNetwork(databaseNet, BWifiNetworksManager.SECURED_NETWORK_ICON);
            }
        }
        if (!this.newState.equals((Object)this.oldState)) {
            switch (this.newState.getOrdinal()) {
                case 0: {
                    this.discoveredNetworkTableModel.clear();
                    for (int i = 0; i < this.databaseNetworkTableModel.getRowCount(); ++i) {
                        this.databaseNetworkTableModel.setStatusAt(i, BWifiNetworkStateEnum.unknown);
                    }
                    break;
                }
                case 1: {
                    this.discoveredNetworkTableModel.clear();
                    for (int i = 0; i < this.databaseNetworkTableModel.getRowCount(); ++i) {
                        this.databaseNetworkTableModel.setStatusAt(i, BWifiNetworkStateEnum.unavailable);
                    }
                    break;
                }
                case 2: 
                case 3: {
                    this.discoveredNetworkTableModel.clear();
                    for (int i = 0; i < this.databaseNetworkTableModel.getRowCount(); ++i) {
                        this.databaseNetworkTableModel.setStatusAt(i, BWifiNetworkStateEnum.disconnected);
                    }
                    break;
                }
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    String ssid = wifiSettings.getStaCurrentNetworkSsid();
                    int row = this.databaseNetworkTableModel.getRowForSsid(ssid);
                    if (row == -1) break;
                    this.databaseNetworkTableModel.setStatusAt(row, BWifiNetworkStateEnum.connecting);
                    break;
                }
                case 9: {
                    String ssid = wifiSettings.getStaCurrentNetworkSsid();
                    int row = this.databaseNetworkTableModel.getRowForSsid(ssid);
                    if (row == -1) break;
                    this.databaseNetworkTableModel.setStatusAt(row, BWifiNetworkStateEnum.connected);
                    break;
                }
            }
            this.databaseNetworkTableModel.updateValues(true);
            this.oldState = BWifiSupplicantStateEnum.make((int)this.newState.getOrdinal());
        }
        if (!cx.getFacets().get("poll", (BObject)BBoolean.FALSE).equals((Object)BBoolean.TRUE)) {
            this.databaseNetworkTableModel.sortColumn = 3;
            this.databaseNetworkTableModel.updateValues(true);
        }
        this.unlockModifiedState();
        if (!alreadyModified) {
            this.clearModified();
        }
        this.doSetEnabledStates();
    }

    private BWifiNetwork netBlockToNetwork(BSupplicantNetBlock block) {
        BWifiNetwork network = new BWifiNetwork();
        network.setSsid(block.getSsid());
        BWifiWPAPSKSettings securitySettings = network.getSecuritySettings();
        securitySettings.setAuthentication(BWifiAuthenticationMethod.open);
        securitySettings.setGroupCipher(BWifiEncryptionMethod.toEncryptionMethodEnum((String)block.getGroup()));
        securitySettings.setPairwiseCipher(BWifiEncryptionMethod.toEncryptionMethodEnum((String)block.getPairwise()));
        securitySettings.setNetworkKey(BPassword.make((String)block.getPsk()));
        network.setPriority(block.getPriority());
        network.setSsidBroadcasted(block.getScan_ssid() == 0);
        network.setMode(BWifiNetworkMode.managed);
        network.setProtocols(block.getProto());
        network.setSecurityPolicies(BWifiSecurityPolicy.toSecurityPolicyEnum((String)block.getProto(), (BWifiAuthenticationMethod)BWifiAuthenticationMethod.open));
        return network;
    }

    protected final BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (!this.isModified()) {
            return value;
        }
        if (value == null) {
            return null;
        }
        BWifiSettings wifiSettings = (BWifiSettings)value;
        wifiSettings.getSupplicantNetworkBlocks().removeAll();
        for (int idx = 0; idx < this.databaseNetworkTableModel.getRowCount(); ++idx) {
            wifiSettings.getSupplicantNetworkBlocks().add("block" + idx, (BValue)this.databaseNetworkTableModel.getNetblockAt(idx));
        }
        return value;
    }

    public void doSetReadonly(boolean readonly) {
        this.doSetEnabledStates();
    }

    public final void doSetEnabledStates() {
        boolean editorEnabled;
        boolean readOnly = this.isReadonly();
        boolean actionsEnabled = this.clientModeEnabled && !readOnly;
        boolean bl = editorEnabled = !readOnly;
        if (this.titledDiscoveryTable != null) {
            this.titledDiscoveryTable.setEnabled(actionsEnabled);
        }
        if (this.discoveredNetworkTable != null) {
            this.discoveredNetworkTable.setEnabled(actionsEnabled);
        }
        if (this.titledDatabaseTable != null) {
            this.titledDatabaseTable.setEnabled(editorEnabled);
        }
        if (this.databaseNetworkTable != null) {
            this.databaseNetworkTable.setEnabled(editorEnabled);
        }
        if (!this.isOperationTakingPlace()) {
            if (this.discoverButtons != null) {
                this.discoverButtons.setEnabled(actionsEnabled);
            }
            if (this.discoverNetworksCommand != null) {
                this.discoverNetworksCommand.setEnabled(actionsEnabled);
            }
            if (this.databaseButtons != null) {
                this.databaseButtons.setEnabled(editorEnabled);
            }
            if (this.newNetworkCommand != null) {
                this.newNetworkCommand.setEnabled(editorEnabled);
            }
        }
        this.doHandleDatabaseSelectionModified();
    }

    public final void handleComponentEvent(BComponentEvent evt) {
    }

    public void doHandleDatabaseSelectionModified() {
        int[] rows = this.databaseNetworkTable.getSelection().getRows();
        if (rows.length != 1) {
            this.connectNetworkCommand.setEnabled(false);
            this.disconnectNetworkCommand.setEnabled(false);
            this.editNetworkCommand.setEnabled(false);
            this.removeNetworkCommand.setEnabled(false);
            this.newNetworkCommand.setEnabled(true);
            this.allowRefresh = true;
        } else {
            this.allowRefresh = false;
            boolean editorReadOnly = this.isReadonly();
            if (!this.isOperationTakingPlace()) {
                BWifiNetwork target = this.databaseNetworkTableModel.getNetworkAt(this.databaseNetworkTableModel.getSelection().getAnchor());
                BWifiNetworkStateEnum targetState = target.getNetworkState();
                if (targetState == BWifiNetworkStateEnum.disconnected) {
                    this.disconnectNetworkCommand.setEnabled(false);
                    this.connectNetworkCommand.setEnabled(this.clientModeEnabled);
                } else if (targetState == BWifiNetworkStateEnum.connected || targetState == BWifiNetworkStateEnum.connecting) {
                    this.connectNetworkCommand.setEnabled(false);
                    this.disconnectNetworkCommand.setEnabled(this.clientModeEnabled);
                } else {
                    if (this.supplicantStateTextField.getText().equals(BWifiSupplicantStateEnum.disconnected.getTag())) {
                        this.connectNetworkCommand.setEnabled(this.clientModeEnabled);
                    } else {
                        this.connectNetworkCommand.setEnabled(false);
                    }
                    this.disconnectNetworkCommand.setEnabled(false);
                }
                this.editNetworkCommand.setEnabled(!editorReadOnly);
                this.newNetworkCommand.setEnabled(!editorReadOnly);
                this.removeNetworkCommand.setEnabled(!editorReadOnly);
            }
        }
    }

    public void doHandleDatabaseFocusModified(BFocusEvent event) {
        if (event.getId() == 1005) {
            this.allowRefresh = true;
            this.databaseNetworkTable.getSelection().deselectAll();
            this.doSetEnabledStates();
        }
    }

    public void doHandleDiscoveredSelectionModified() {
        this.allowRefresh = true;
        int[] rows = this.discoveredNetworkTable.getSelection().getRows();
        if (rows.length != 1) {
            this.addNetworkCommand.setEnabled(false);
        } else {
            BImage icon = this.discoveredNetworkTableModel.getNetworkIconImageAt(this.discoveredNetworkTableModel.getSelection().getAnchor());
            boolean readOnly = this.isReadonly();
            if (!this.isOperationTakingPlace()) {
                this.addNetworkCommand.setEnabled(!readOnly && !icon.equals((Object)UNAVAILABLE_NETWORK_ICON));
            }
        }
    }

    public void doHandleDiscoveredTableModified() {
    }

    public void doHandleDiscoveredFocusModified(BFocusEvent event) {
    }

    public void doGatewaySwitchingModified() {
        this.doGatewaySwitchingModified(true);
    }

    public void doGatewaySwitchingModified(boolean sendDaemonMessage) {
        if (!this.isReadonly()) {
            boolean switchingModified = false;
            try {
                switchingModified = this.updateGatewayCheckbox.getSelected();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sendDaemonMessage) {
                try {
                    System.out.println("sending ChangeGatewaySwitchingMessage:" + switchingModified);
                    this.wifiDaemonSession.sendMessage((DaemonMessage)new ChangeGatewaySwitchingMessage(switchingModified));
                }
                catch (Exception e) {
                    String message = this.getLexicon().getText("WifiNetworkManager.settings.updateGateway.error", new Object[]{switchingModified});
                    BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)message, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOperationTakingPlace() {
        boolean rc;
        Object object = this.operationMonitor;
        synchronized (object) {
            rc = this.operationTakingPlace;
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOperationTakingPlace(boolean input) {
        Object object = this.operationMonitor;
        synchronized (object) {
            this.operationTakingPlace = input;
        }
    }

    private void saveParent() throws Exception {
        BWifiNetworksManager ancestor = this;
        BFacets saveFacets = BFacets.make((String)"savetype", (String)"supplicant");
        BasicContext saveContext = new BasicContext((Context)null, saveFacets);
        while ((ancestor = ancestor.getParent()) != null) {
            if (!(ancestor instanceof BWbComponentView)) continue;
            BWbComponentView plugin = ancestor;
            plugin.saveValue((Context)saveContext);
            return;
        }
        throw new CannotSaveException("Can not find eligible parent (BWbComponentView)");
    }

    protected BDaemonSession getWifiDaemonSession() {
        return this.wifiDaemonSession;
    }

    protected BWifiPlatformService getWifiPlatformService() {
        return this.wifiPlatformService;
    }

    public class WifiNetworkCellRenderer
    extends TableCellRenderer {
        public WifiNetworkTableModel getWifiNetworkTableModel() {
            return (WifiNetworkTableModel)this.getTable().getModel();
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            return super.getForeground(cell);
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return super.getSelectionForeground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            String s = this.getCellText(cell);
            BImage cellIcon = this.getWifiNetworkTableModel().getCellIcon(cell.row, cell.column);
            double textWidth = 5.0;
            double iconWidth = 0.0;
            if (s != null && s.length() > 0) {
                textWidth = Theme.table().getCellFont().width(s) + 12.0;
            }
            if (cellIcon != null) {
                iconWidth = cellIcon.getWidth() + 4.0;
            }
            return iconWidth + textWidth;
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            String s;
            WifiNetworkTableModel model = this.getWifiNetworkTableModel();
            this.paintCellBackground(g, cell);
            double x = 2.0;
            double y = (cell.height - 16.0) / 2.0;
            BImage icon = model.getCellIcon(cell.row, cell.column);
            if (icon != null) {
                g.drawImage(icon, x, y);
                x += 20.0;
            }
            if ((s = this.getCellText(cell)) != null && s.length() > 0) {
                BFont font = Theme.table().getCellFont();
                switch (model.getColumnAlignment(cell.column).getOrdinal()) {
                    case 2: {
                        x = cell.width - 2.0 - font.width(s);
                        break;
                    }
                    case 1: {
                        x = (cell.width - font.width(s)) / 2.0;
                    }
                }
                g.setFont(font);
                g.drawString(s, x, font.getAscent() + 5.0);
            }
        }
    }

    public class WifiNetworkTableRow {
        private BWifiNetwork network;
        private BImage rowNetworkIcon;
        private int databaseIndex;

        public void setNetwork(BWifiNetwork value) {
            this.network = value;
        }

        public BWifiNetwork getCurrentWifiNetwork() {
            return this.network;
        }

        public String getSSID() {
            return this.network.getSsid();
        }

        public String getBSSID() {
            return this.network.getBssid();
        }

        public BWifiNetworkMode getMode() {
            return this.network.getMode();
        }

        public BInteger getChannel() {
            return BInteger.make((int)this.network.getChannel());
        }

        public BWifiSecurityPolicy getSecurityPolicy() {
            return this.network.getSecurityPolicies();
        }

        public BWifiNetworkStateEnum getNetworkState() {
            return this.network.getNetworkState();
        }

        public BInteger getSignalStrengthPercentage() {
            return BInteger.make((int)this.network.getSignalStrength());
        }

        public String getFlags() {
            return this.network.getScanResultFlags();
        }

        public BInteger getPriority() {
            return BInteger.make((int)this.network.getPriority());
        }

        public void setStatus(BWifiNetworkStateEnum temp) {
            this.network.setNetworkState(temp);
        }

        public void setStrength(int signalStrength) {
            this.network.setSignalStrength(signalStrength);
        }

        public void setPriority(int priority) {
            this.network.setPriority(priority);
        }

        public BImage getSignalStrengthImage() {
            int strength = this.getSignalStrengthPercentage().getInt();
            if (strength >= 80) {
                return BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/fiveBars.png")}));
            }
            if (strength >= 60) {
                return BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/fourBars.png")}));
            }
            if (strength >= 40) {
                return BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/threeBars.png")}));
            }
            if (strength >= 20) {
                return BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/twoBars.png")}));
            }
            if (strength > 0) {
                return BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/oneBar.png")}));
            }
            return BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/zeroBars.png")}));
        }

        public void setNetworkIcon(BImage newIcon) {
            this.rowNetworkIcon = newIcon;
        }

        public BImage getNetworkIcon() {
            return this.rowNetworkIcon;
        }

        public void setDatabaseIndex(int newIndex) {
            this.databaseIndex = newIndex;
        }

        public int getDatabaseIndex() {
            return this.databaseIndex;
        }

        public int compareStatus(WifiNetworkTableRow row) {
            BWifiNetworkStateEnum LHSRowStatus = this.getNetworkState();
            BWifiNetworkStateEnum RHSRowStatus = row.getNetworkState();
            if (LHSRowStatus.getOrdinal() < RHSRowStatus.getOrdinal()) {
                return 1;
            }
            if (LHSRowStatus.getOrdinal() > RHSRowStatus.getOrdinal()) {
                return -1;
            }
            return 0;
        }

        public int compareSecurity(WifiNetworkTableRow row) {
            BWifiSecurityPolicy LHSRowSecurity = this.getSecurityPolicy();
            BWifiSecurityPolicy RHSRowSecurity = row.getSecurityPolicy();
            boolean LHSHighestSecurity = false;
            boolean RHSHighestSecurity = false;
            if (LHSRowSecurity.getOrdinal() == RHSRowSecurity.getOrdinal()) {
                return 0;
            }
            if (LHSRowSecurity.equals((Object)BWifiSecurityPolicy.wpa_2_psk)) {
                if (RHSRowSecurity.equals((Object)BWifiSecurityPolicy.wpa_psk)) {
                    return -1;
                }
                if (RHSRowSecurity.equals((Object)BWifiSecurityPolicy.wpapsk_wpa2psk)) {
                    return -1;
                }
            }
            if (LHSRowSecurity.equals((Object)BWifiSecurityPolicy.wpapsk_wpa2psk)) {
                if (RHSRowSecurity.equals((Object)BWifiSecurityPolicy.wpa_2_psk)) {
                    return 1;
                }
                if (RHSRowSecurity.equals((Object)BWifiSecurityPolicy.wpa_psk)) {
                    return -1;
                }
            }
            return 1;
        }
    }

    private class DatabaseTableController
    extends TableController {
        private DatabaseTableController() {
        }

        protected void cellPressed(BMouseEvent event, int row, int column) {
            if (event.isPopupTrigger()) {
                super.cellPressed(event, row, column);
                return;
            }
            if (column != 0 || event.getX() > 14.0) {
                if (event.getClickCount() > 1) {
                    if (!BWifiNetworksManager.this.isOperationTakingPlace()) {
                        BWifiNetworksManager.this.editNetworkCommand.invoke();
                    }
                } else {
                    super.cellPressed(event, row, column);
                }
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            if (!BWifiNetworksManager.this.isOperationTakingPlace()) {
                BMenu menu = new BMenu();
                menu.add(null, (BValue)new BActionMenuItem((Command)BWifiNetworksManager.this.editNetworkCommand), null);
                menu.add(null, (BValue)new BActionMenuItem((Command)BWifiNetworksManager.this.removeNetworkCommand), null);
                menu.add(null, (BValue)new BSeparator());
                menu.add(null, (BValue)new BActionMenuItem((Command)BWifiNetworksManager.this.disconnectNetworkCommand), null);
                menu.open((BWidget)BWifiNetworksManager.this.databaseNetworkTable, event.getX(), event.getY());
            }
        }
    }

    private class DiscoveryTableController
    extends TableController {
        private DiscoveryTableController() {
        }

        protected void cellPressed(BMouseEvent event, int row, int column) {
            if (event.isPopupTrigger()) {
                super.cellPressed(event, row, column);
                return;
            }
            if (column != 0 || event.getX() > 14.0) {
                if (event.getClickCount() > 1) {
                    if (BWifiNetworksManager.this.addNetworkCommand.isEnabled()) {
                        BWifiNetworksManager.this.addNetworkCommand.invoke();
                    }
                } else {
                    super.cellPressed(event, row, column);
                }
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            BMenu menu = new BMenu();
            menu.add(null, (BValue)new BActionMenuItem((Command)BWifiNetworksManager.this.addNetworkCommand), null);
            menu.open((BWidget)BWifiNetworksManager.this.discoveredNetworkTable, event.getX(), event.getY());
        }
    }

    public class WifiNetworkTableModel
    extends TableModel {
        private static final int SSID_COL = 0;
        private static final int BSSID_COL = 1;
        private static final int MODE_COL = 2;
        private static final int STATUS_COL = 3;
        private static final int SIGNAL_STRENGTH_PER_COL = 4;
        private static final int PRIORITY_COL = 5;
        private static final int CHANNEL_COL = 6;
        private static final int SECURITY_POLICY_COL = 7;
        private static final int FLAGS_COL = 8;
        private boolean sortAscending = true;
        private boolean needsSort = true;
        private int sortColumn;
        protected Array<BInteger> viewableColumns;
        protected Array<WifiNetworkTableRow> rows = new Array(WifiNetworkTableRow.class);

        public WifiNetworkTableModel(boolean showBSSID, boolean showMode, boolean showPriority, boolean showChannel, boolean showStatus, boolean showPolicy, boolean showSignal, boolean showFlags) {
            this.viewableColumns = new Array(BInteger.class);
            this.viewableColumns.add((Object)BInteger.make((int)0));
            if (showBSSID) {
                this.viewableColumns.add((Object)BInteger.make((int)1));
            }
            if (showMode) {
                this.viewableColumns.add((Object)BInteger.make((int)2));
            }
            if (showPriority) {
                this.viewableColumns.add((Object)BInteger.make((int)5));
            }
            if (showChannel) {
                this.viewableColumns.add((Object)BInteger.make((int)6));
            }
            if (showPolicy) {
                this.viewableColumns.add((Object)BInteger.make((int)7));
            }
            if (showStatus) {
                this.viewableColumns.add((Object)BInteger.make((int)3));
            }
            if (showSignal) {
                this.viewableColumns.add((Object)BInteger.make((int)4));
            }
            if (showFlags) {
                this.viewableColumns.add((Object)BInteger.make((int)8));
            }
        }

        public int getColumnCount() {
            return this.viewableColumns.size();
        }

        public String getColumnName(int col) {
            int targetColumn = ((BInteger)this.viewableColumns.get(col)).getInt();
            switch (targetColumn) {
                case 0: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.SSID.label");
                }
                case 1: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.BSSID.label");
                }
                case 2: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.mode.label");
                }
                case 5: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.priority.label");
                }
                case 6: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.channel.label");
                }
                case 7: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.security.label");
                }
                case 3: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.status.label");
                }
                case 4: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.signalPercent.label");
                }
                case 8: {
                    return TYPE.getModule().getLexicon().get("WifiNetworkManager.column.flags.label");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public Object getValueAt(int row, int col) {
            int targetColumn = ((BInteger)this.viewableColumns.get(col)).getInt();
            switch (targetColumn) {
                case 0: {
                    return this.getRow(row).getSSID();
                }
                case 1: {
                    return this.getRow(row).getBSSID();
                }
                case 2: {
                    return this.getRow(row).getMode().getDisplayTag(null);
                }
                case 5: {
                    return this.getRow(row).getPriority();
                }
                case 6: {
                    return this.getRow(row).getChannel();
                }
                case 7: {
                    BWifiSecurityPolicy policy = this.getRow(row).getSecurityPolicy();
                    return policy.getDisplayTag(null);
                }
                case 3: {
                    return this.getRow(row).getNetworkState();
                }
                case 4: {
                    return this.getRow(row).getSignalStrengthPercentage();
                }
                case 8: {
                    return this.getRow(row).getFlags();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void clear() {
            this.rows.clear();
            this.updateValues(false);
        }

        public void updateTable(boolean resizeColumns) {
            this.needsSort = true;
            super.updateTable(resizeColumns);
        }

        public void sortByColumn(int col, boolean ascending) {
            int targetColumn = ((BInteger)this.viewableColumns.get(col)).getInt();
            if (!this.needsSort && targetColumn == this.sortColumn && ascending == this.sortAscending) {
                return;
            }
            this.sortColumn = targetColumn;
            this.sortAscending = ascending;
            this.updateValues(true);
        }

        protected void updateValues(boolean resort) {
            this.needsSort = false;
            if (resort) {
                int defaultColumn = this.viewableColumns.contains((Object)BInteger.make((int)3)) ? 3 : 4;
                this.rows = this.rows.sort((Comparator)new WifiNetworkTableRowComparator(defaultColumn));
            }
            this.getTable().getSelection().deselectAll();
            this.updateTable(true);
        }

        private void setNetwork(BWifiNetwork network, int id) {
            WifiNetworkTableRow updatedRow = this.makeRow();
            WifiNetworkTableRow existingRow = this.getRow(id);
            updatedRow.setNetwork(network);
            updatedRow.setNetworkIcon(existingRow.getNetworkIcon());
            updatedRow.setDatabaseIndex(existingRow.getDatabaseIndex());
            this.rows.set(id, (Object)updatedRow);
        }

        private void addNetwork(BWifiNetwork network, BImage rowNetworkIcon) {
            if (network == null || network.isNull()) {
                return;
            }
            WifiNetworkTableRow row = this.makeRow();
            row.setNetwork(network);
            row.setNetworkIcon(rowNetworkIcon);
            row.setDatabaseIndex(this.rows.size());
            this.rows.add((Object)row);
        }

        private void addNetwork(BSupplicantNetBlock block, BImage rowNetworkIcon) {
            if (block == null || block.isNull()) {
                return;
            }
            WifiNetworkTableRow row = this.makeRow();
            BWifiNetwork network = new BWifiNetwork();
            network.setSsid(block.getSsid());
            network.setPriority(block.getPriority());
            network.setProtocols(block.getProto());
            network.setSsidBroadcasted(block.getScan_ssid() == 0);
            network.getSecuritySettings().setNetworkKey(BPassword.make((String)block.getPsk()));
            network.setMode(BWifiNetworkMode.managed);
            if (block.getProto().equals("WPA RSN") || block.getProto().equals("WPA WPA2")) {
                network.setSecurityPolicies(BWifiSecurityPolicy.wpapsk_wpa2psk);
            }
            if (block.getProto().equals("WPA")) {
                network.setSecurityPolicies(BWifiSecurityPolicy.wpa_psk);
            }
            if (block.getProto().equals("RSN") || block.getProto().equals("WPA2")) {
                network.setSecurityPolicies(BWifiSecurityPolicy.wpa_2_psk);
            }
            if (block.getPairwise().equals("CCMP")) {
                network.getSecuritySettings().setPairwiseCipher(BWifiEncryptionMethod.ccmp);
            }
            if (block.getPairwise().equals("TKIP")) {
                network.getSecuritySettings().setPairwiseCipher(BWifiEncryptionMethod.tkip);
            }
            if (block.getPairwise().equals("CCMP TKIP")) {
                network.getSecuritySettings().setPairwiseCipher(BWifiEncryptionMethod.ccmpTkip);
            }
            if (block.getGroup().equals("CCMP")) {
                network.getSecuritySettings().setGroupCipher(BWifiEncryptionMethod.ccmp);
            }
            if (block.getGroup().equals("TKIP")) {
                network.getSecuritySettings().setGroupCipher(BWifiEncryptionMethod.tkip);
            }
            if (block.getGroup().equals("CCMP TKIP")) {
                network.getSecuritySettings().setGroupCipher(BWifiEncryptionMethod.ccmpTkip);
            }
            row.setNetwork(network);
            row.setNetworkIcon(rowNetworkIcon);
            row.setDatabaseIndex(this.rows.size());
            this.rows.add((Object)row);
        }

        private void removeNetwork(int idx) {
            if (idx == -1 || idx >= this.getRowCount()) {
                return;
            }
            this.rows.remove(idx);
        }

        private void removeNetwork(String ssid) {
            int i = 0;
            for (i = 0; i < this.getRowCount(); ++i) {
                if (!this.getSSIDAt(i).equals(ssid)) continue;
                this.rows.remove(i);
            }
        }

        protected WifiNetworkTableRow makeRow() {
            return new WifiNetworkTableRow();
        }

        protected WifiNetworkTableRow getRow(int row) {
            return (WifiNetworkTableRow)this.rows.get(row);
        }

        public BWifiNetwork getNetworkAt(int row) {
            return this.getRow(row).getCurrentWifiNetwork();
        }

        public BSupplicantNetBlock getNetblockAt(int row) {
            BSupplicantNetBlock block = new BSupplicantNetBlock();
            BWifiNetwork network = this.getRow(row).getCurrentWifiNetwork();
            BWifiWPAPSKSettings ss = network.getSecuritySettings();
            block.setProto(network.getProtocols());
            block.setPsk(AccessController.doPrivileged(() -> ((BPassword)ss.getNetworkKey()).getValue()));
            block.setPairwise(BWifiEncryptionMethod.getProtoString((BWifiEncryptionMethod)ss.getPairwiseCipher()));
            block.setGroup(BWifiEncryptionMethod.getProtoString((BWifiEncryptionMethod)ss.getPairwiseCipher()));
            block.setKey_mgmt("WPA-PSK");
            block.setScan_ssid(network.getSsidBroadcasted() ? 0 : 1);
            block.setSsid(network.getSsid());
            block.setPriority(network.getPriority());
            return block;
        }

        public String getSSIDAt(int row) {
            return this.getRow(row).getSSID();
        }

        public int getRowForSsid(String ssid) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.getSSIDAt(i).equals(ssid)) continue;
                return i;
            }
            return -1;
        }

        public BImage getNetworkIconImageAt(int row) {
            return this.getRow(row).getNetworkIcon();
        }

        public void setNetworkIconImageAt(int row, BImage newIcon) {
            this.getRow(row).setNetworkIcon(newIcon);
        }

        public BWifiNetworkStateEnum getStatusAt(int row) {
            return this.getRow(row).getNetworkState();
        }

        public void setStatusAt(int row, BWifiNetworkStateEnum temp) {
            this.getRow(row).setStatus(temp);
        }

        public void setStrengthAt(int row, int signalStrength) {
            this.getRow(row).setStrength(signalStrength);
        }

        public void setPriorityAt(int row, int priority) {
            this.getRow(row).setPriority(priority);
        }

        public BImage getCellIcon(int row, int col) {
            int targetColumn = ((BInteger)this.viewableColumns.get(col)).getInt();
            WifiNetworkTableRow rowObject = this.getRow(row);
            if (targetColumn == 0) {
                return rowObject.getNetworkIcon();
            }
            if (targetColumn == 4) {
                return rowObject.getSignalStrengthImage();
            }
            return null;
        }

        private class WifiNetworkTableRowComparator
        implements Comparator<WifiNetworkTableRow> {
            private WifiNetworkColumnComparator[] comparators;

            public WifiNetworkTableRowComparator(int defaultColumn) {
                int i;
                int next;
                int[] sortColumns = new int[9];
                sortColumns[0] = WifiNetworkTableModel.this.sortColumn;
                if (WifiNetworkTableModel.this.sortColumn != defaultColumn) {
                    sortColumns[1] = defaultColumn;
                    next = 2;
                    for (i = 0; i < sortColumns.length; ++i) {
                        if (i == WifiNetworkTableModel.this.sortColumn || i == defaultColumn) continue;
                        sortColumns[next++] = i;
                    }
                } else if (defaultColumn == 3) {
                    sortColumns[1] = 4;
                    next = 2;
                    for (i = 0; i < sortColumns.length; ++i) {
                        if (i == WifiNetworkTableModel.this.sortColumn || i == 4) continue;
                        sortColumns[next++] = i;
                    }
                } else {
                    next = 1;
                    for (i = 0; i < sortColumns.length; ++i) {
                        if (i == WifiNetworkTableModel.this.sortColumn) continue;
                        sortColumns[next++] = i;
                    }
                }
                this.comparators = new WifiNetworkColumnComparator[8];
                for (int i2 = 0; i2 < this.comparators.length; ++i2) {
                    this.comparators[i2] = new WifiNetworkColumnComparator(sortColumns[i2], WifiNetworkTableModel.this.sortAscending);
                }
            }

            @Override
            public int compare(WifiNetworkTableRow row1, WifiNetworkTableRow row2) {
                int result = 0;
                for (int i = 0; i < this.comparators.length && result == 0; ++i) {
                    result = this.comparators[i].compare(row1, row2);
                }
                return result;
            }
        }

        private class WifiNetworkColumnComparator
        implements Comparator<WifiNetworkTableRow> {
            private int comparatorSortColumn;
            private boolean comparatorAscending;

            public WifiNetworkColumnComparator(int comparatorSortColumn, boolean comparatorAscending) {
                this.comparatorSortColumn = comparatorSortColumn;
                this.comparatorAscending = comparatorAscending;
            }

            @Override
            public int compare(WifiNetworkTableRow row1, WifiNetworkTableRow row2) {
                int sortDirection = this.comparatorAscending ? 1 : -1;
                switch (this.comparatorSortColumn) {
                    case 0: {
                        return sortDirection * TextUtil.toLowerCase((String)row1.getSSID()).compareTo(TextUtil.toLowerCase((String)row2.getSSID()));
                    }
                    case 1: {
                        return sortDirection * TextUtil.toLowerCase((String)row1.getBSSID()).compareTo(TextUtil.toLowerCase((String)row2.getBSSID()));
                    }
                    case 2: {
                        if (row1.getMode().getOrdinal() < row2.getMode().getOrdinal()) {
                            return sortDirection * -1;
                        }
                        if (row1.getMode().getOrdinal() > row2.getMode().getOrdinal()) {
                            return sortDirection;
                        }
                        return 0;
                    }
                    case 5: {
                        if (row1.getPriority() == null) {
                            if (row2.getPriority() == null) {
                                return 0;
                            }
                            return sortDirection;
                        }
                        if (row2.getPriority() == null) {
                            return sortDirection * -1;
                        }
                        return sortDirection * row1.getPriority().compareTo((Object)row2.getPriority());
                    }
                    case 6: {
                        if (row1.getChannel() == null) {
                            if (row2.getChannel() == null) {
                                return 0;
                            }
                            return sortDirection;
                        }
                        if (row2.getChannel() == null) {
                            return sortDirection * -1;
                        }
                        return sortDirection * row1.getChannel().compareTo((Object)row2.getChannel());
                    }
                    case 7: {
                        return sortDirection * row1.compareSecurity(row2);
                    }
                    case 3: {
                        return sortDirection * row1.compareStatus(row2);
                    }
                    case 4: {
                        sortDirection = -sortDirection;
                        if (row1.getSignalStrengthPercentage() == null) {
                            if (row2.getSignalStrengthPercentage() == null) {
                                return 0;
                            }
                            return sortDirection;
                        }
                        if (row2.getSignalStrengthPercentage() == null) {
                            return sortDirection * -1;
                        }
                        return sortDirection * row1.getSignalStrengthPercentage().compareTo((Object)row2.getSignalStrengthPercentage());
                    }
                    case 8: {
                        return sortDirection * TextUtil.toLowerCase((String)row1.getSSID()).compareTo(TextUtil.toLowerCase((String)row2.getSSID()));
                    }
                }
                throw new IllegalArgumentException();
            }
        }
    }

    private class NewCommand
    extends AsyncCommand {
        public NewCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDatabaseTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.new.label", "New"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/new.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.new.description", "Create a new 802.11 wireless network connection"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                BWifiNetwork newNetwork;
                BWifiNetworksManager.this.setOperationTakingPlace(true);
                BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                this.setEnabled(false);
                if (shell != null) {
                    shell.enterBusy();
                }
                try {
                    newNetwork = this.promptNew();
                    if (newNetwork == null) {
                        return;
                    }
                }
                catch (Exception e) {
                    return;
                }
                for (int i = 0; i < BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount(); ++i) {
                    if (!BWifiNetworksManager.this.databaseNetworkTableModel.getSSIDAt(i).equals(newNetwork.getSsid())) continue;
                    BDialog.error((BWidget)BWifiNetworksManager.this, (String)BWifiNetworksManager.this.getLexicon().getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)BWifiNetworksManager.this.getLexicon().getText("WifiNetworkConfigurationEditor.cannotSave.duplicateSSID", new Object[]{newNetwork.getSsid()}));
                    return;
                }
                boolean securityConfigured = false;
                SlotCursor c = newNetwork.getSecuritySettings().loadSlots().getProperties();
                if (c.next(BWifiSecuritySettings.class)) {
                    securityConfigured = true;
                }
                BWifiNetworksManager.this.databaseNetworkTableModel.addNetwork(newNetwork, securityConfigured ? SECURED_NETWORK_ICON : UNSECURED_NETWORK_ICON);
                BWifiNetworksManager.this.databaseNetworkTableModel.sortColumn = 3;
                BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
                for (int i = 0; i < BWifiNetworksManager.this.discoveredNetworkTableModel.getRowCount(); ++i) {
                    if (!BWifiNetworksManager.this.discoveredNetworkTableModel.getSSIDAt(i).equalsIgnoreCase(newNetwork.getSsid())) continue;
                    BWifiNetworksManager.this.discoveredNetworkTableModel.setNetworkIconImageAt(i, UNAVAILABLE_NETWORK_ICON);
                    break;
                }
                BWifiNetworksManager.this.saveParent();
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (BWidget)BWifiNetworksManager.this, (Throwable)t);
            }
            finally {
                this.setEnabled(true);
                BWifiNetworksManager.this.databaseButtons.setEnabled(true);
                BWifiNetworksManager.this.setOperationTakingPlace(false);
                if (shell != null) {
                    shell.exitBusy();
                }
            }
        }

        public BWifiNetwork promptNew() throws Exception {
            String title = BWifiNetworksManager.this.getLexicon().get("WifiNetworkConfigurationEditor.new.title", "New Wireless Network");
            BWifiNetwork newNetwork = new BWifiNetwork();
            newNetwork.setSsid("");
            newNetwork.setBssid("00:00:00:00:00:00");
            newNetwork.setChannel(6);
            newNetwork.setPriority(0);
            newNetwork.setSsidBroadcasted(true);
            newNetwork.setMode(BWifiNetworkMode.managed);
            newNetwork.setSecurityPolicies(BWifiSecurityPolicy.wpapsk_wpa2psk);
            newNetwork.getSecuritySettings().setNetworkKey(BPassword.make((String)"passphrase"));
            newNetwork.getSecuritySettings().setGroupCipher(BWifiEncryptionMethod.ccmpTkip);
            newNetwork.getSecuritySettings().setPairwiseCipher(BWifiEncryptionMethod.ccmpTkip);
            newNetwork.getSecuritySettings().setAuthentication(BWifiAuthenticationMethod.open);
            BWifiNetworkEditorDialog dialog = new BWifiNetworkEditorDialog((BWidget)BWifiNetworksManager.this, title, 1, newNetwork);
            dialog.setSize(500.0, 800.0);
            dialog.setBoundsCenteredOnOwner();
            dialog.open();
            if (dialog.getResult() == 1) {
                try {
                    return dialog.getNetwork();
                }
                catch (Exception e) {
                    BDialog.error((BWidget)BWifiNetworksManager.this, (String)BWifiNetworksManager.this.getLexicon().getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)BWifiNetworksManager.this.getLexicon().getText(e.getMessage()));
                    return null;
                }
            }
            return null;
        }
    }

    private class EditCommand
    extends Command {
        public EditCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDatabaseTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.edit.label", "Edit"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/edit.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.edit.description", "Edit the selected 802.11 wireless network"));
        }

        public CommandArtifact doInvoke() throws Exception {
            BWifiNetwork editedNetwork;
            if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount() == 0) {
                return null;
            }
            try {
                editedNetwork = this.promptEdit();
                if (editedNetwork == null) {
                    return null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            editedNetwork.setMode(BWifiNetworkMode.managed);
            BWifiNetworksManager.this.databaseNetworkTableModel.setNetwork(editedNetwork, BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
            BWifiNetworksManager.this.databaseNetworkTableModel.sortColumn = 3;
            BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
            BWifiNetworksManager.this.saveParent();
            return null;
        }

        private BWifiNetwork promptEdit() throws Exception {
            BWifiNetwork networkToEdit = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
            String title = BWifiNetworksManager.this.getLexicon().get("WifiNetworkConfigurationEditor.edit.title", "Edit Wireless Network");
            BWifiNetworkEditorDialog dialog = new BWifiNetworkEditorDialog((BWidget)BWifiNetworksManager.this, title, 0, networkToEdit);
            dialog.setSize(500.0, 800.0);
            dialog.setBoundsCenteredOnOwner();
            dialog.open();
            if (dialog.getResult() == 1) {
                int lines = BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount();
                String ssid = dialog.getNetwork().getSsid();
                for (int i = 0; i < lines; ++i) {
                    BWifiNetwork network = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(i);
                    if (i == BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor() || !network.getSsid().equals(dialog.getNetwork().getSsid())) continue;
                    BDialog.error((BWidget)BWifiNetworksManager.this, (String)BWifiNetworksManager.this.getLexicon().getText("WifiNetworkConfigurationEditor.duplicateError.title"), (Object)BWifiNetworksManager.this.getLexicon().getText("WifiNetworkConfigurationEditor.duplicateError.message"));
                    return networkToEdit;
                }
                try {
                    BWifiNetwork modifiedNetwork = dialog.getNetwork();
                    if (modifiedNetwork != null) {
                        modifiedNetwork.setSignalStrength(networkToEdit.getSignalStrength());
                    }
                    if (modifiedNetwork != null) {
                        modifiedNetwork.setNetworkState(networkToEdit.getNetworkState());
                    }
                    return modifiedNetwork;
                }
                catch (Exception e) {
                    BDialog.error((BWidget)BWifiNetworksManager.this, (String)BWifiNetworksManager.this.getLexicon().getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)BWifiNetworksManager.this.getLexicon().getText(e.getMessage()));
                    return networkToEdit;
                }
            }
            return null;
        }
    }

    private class StatusCommand
    extends Command {
        public StatusCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDatabaseTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.status.label", "Network Status"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/find.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.status.description", "Obtain wireless network status"));
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount() == 0) {
                return null;
            }
            try {
                this.displayStatus();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            return null;
        }

        public void displayStatus() throws Exception {
            Properties statusProperties;
            boolean station;
            BDaemonSession sessionToUse;
            BWifiNetwork networkToDisplay = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
            String title = BWifiNetworksManager.this.getLexicon().get("WifiNetworkConfigurationEditor.status.title", "Wireless Network Status");
            if (BWifiNetworksManager.this.wifiDaemonSession != null) {
                sessionToUse = BWifiNetworksManager.this.wifiDaemonSession;
                Object serviceToUse = null;
                station = false;
            } else if (BWifiNetworksManager.this.wifiPlatformService != null) {
                BWifiPlatformService serviceToUse = BWifiNetworksManager.this.wifiPlatformService;
                sessionToUse = null;
                station = true;
            } else {
                throw new IllegalStateException("Could not find Wifi station platform service or daemon session");
            }
            if (networkToDisplay.getNetworkState() != BWifiNetworkStateEnum.connected) {
                return;
            }
            if (station) {
                statusProperties = new Properties();
            } else {
                statusProperties = WifiUtil.statusFromSession((String)BWifiNetworksManager.this.clientAdapterTextField.getText(), (BDaemonSession)sessionToUse);
                if (statusProperties == null || statusProperties.size() == 0) {
                    throw new BajaRuntimeException("Failed to obtain WiFi network status (\"" + networkToDisplay.getSsid() + "\")");
                }
            }
            BGridPane statusPane = new BGridPane(2);
            statusPane.setRowAlign(BValign.top);
            statusPane.setHalign(BHalign.left);
            statusPane.setColumnAlign(BHalign.left);
            statusPane.setRowGap(5.0);
            statusPane.setColumnGap(10.0);
            statusPane.setStretchColumn(1);
            statusPane.add(null, (BValue)new BLabel(BWifiNetworksManager.this.getLexicon().getText("WifiNetworkManager.networkStatus.SSID.label")));
            statusPane.add(null, (BValue)new BLabel(statusProperties.getProperty("ssid", "Not available")));
            statusPane.add(null, (BValue)new BLabel(BWifiNetworksManager.this.getLexicon().getText("WifiNetworkManager.networkStatus.BSSID.label")));
            statusPane.add(null, (BValue)new BLabel(statusProperties.getProperty("bssid", "Not available")));
            statusPane.add(null, (BValue)new BLabel(BWifiNetworksManager.this.getLexicon().getText("WifiNetworkManager.networkStatus.KeyManagement.label")));
            statusPane.add(null, (BValue)new BLabel(statusProperties.getProperty("key_mgmt", "Not available")));
            statusPane.add(null, (BValue)new BLabel(BWifiNetworksManager.this.getLexicon().getText("WifiNetworkManager.networkStatus.PairwiseCipher.label")));
            statusPane.add(null, (BValue)new BLabel(statusProperties.getProperty("pairwise_cipher", "Not available")));
            statusPane.add(null, (BValue)new BLabel(BWifiNetworksManager.this.getLexicon().getText("WifiNetworkManager.networkStatus.GroupCipher.label")));
            statusPane.add(null, (BValue)new BLabel(statusProperties.getProperty("group_cipher", "Not available")));
            statusPane.add(null, (BValue)new BLabel(BWifiNetworksManager.this.getLexicon().getText("WifiNetworkManager.networkStatus.IPAddress.label")));
            statusPane.add(null, (BValue)new BLabel(statusProperties.getProperty("ip_address", "Not available")));
            BDialog.open((BWidget)BWifiNetworksManager.this, (String)title, (Object)new BBorderPane((BWidget)statusPane), (int)1);
        }
    }

    private class RemoveCommand
    extends AsyncCommand {
        public RemoveCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDatabaseTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.remove.label", "Remove"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/remove.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.remove.description", "Remove a known 802.11 wireless network from the database"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            block14: {
                BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
                try {
                    BWifiNetworksManager.this.setOperationTakingPlace(true);
                    BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                    this.setEnabled(false);
                    if (shell != null) {
                        shell.enterBusy();
                    }
                    if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount() == 0) {
                        return;
                    }
                    if (BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getRowCount() > 1) {
                        return;
                    }
                    BWifiNetwork networkToRemove = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
                    String message = BWifiNetworksManager.this.getLexicon().getText("WifiNetworksManager.remove.confirmSingle", new Object[]{networkToRemove.getSsid()});
                    int result = BDialog.confirm((BWidget)BWifiNetworksManager.this, (Object)message);
                    if (result == 4) {
                        BWifiNetworksManager.this.disconnectNetworkCommand.doInvokeAsync();
                        BWifiNetworksManager.this.setOperationTakingPlace(true);
                        BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                        BWifiNetworksManager.this.databaseNetworkTableModel.removeNetwork(networkToRemove.getSsid());
                        BWifiNetworksManager.this.databaseNetworkTableModel.sortColumn = 3;
                        BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                        BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
                        if (BWifiNetworksManager.this.currentNetwork != null && networkToRemove.getSsid().equals(BWifiNetworksManager.this.currentNetwork.getSsid())) {
                            BWifiNetworksManager.this.currentNetwork = null;
                        }
                        for (int i = 0; i < BWifiNetworksManager.this.discoveredNetworkTableModel.getRowCount(); ++i) {
                            if (!BWifiNetworksManager.this.discoveredNetworkTableModel.getSSIDAt(i).equalsIgnoreCase(networkToRemove.getSsid())) continue;
                            BWifiNetwork target = BWifiNetworksManager.this.discoveredNetworkTableModel.getNetworkAt(i);
                            BWifiNetworksManager.this.discoveredNetworkTableModel.setNetworkIconImageAt(i, target.isNetworkSupported() ? SECURED_NETWORK_ICON : UNSECURED_NETWORK_ICON);
                            break;
                        }
                        BWifiNetworksManager.this.saveParent();
                        break block14;
                    }
                    return;
                }
                catch (Throwable t) {
                    CommandUtil.error((Command)this, (BWidget)BWifiNetworksManager.this, (Throwable)t);
                }
                finally {
                    this.setEnabled(false);
                    BWifiNetworksManager.this.databaseButtons.setEnabled(true);
                    BWifiNetworksManager.this.setOperationTakingPlace(false);
                    if (shell != null) {
                        shell.exitBusy();
                    }
                }
            }
        }
    }

    private class DisconnectCommand
    extends AsyncCommand {
        public DisconnectCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDatabaseTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.disconnect.label", "Disconnect"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/connection.png"), BOrd.make((String)"module://icons/x16/badges/remove.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.disconnect.description", "Disconnect from the selected 802.11 wireless network"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                boolean station;
                BDaemonSession sessionToUse;
                BWifiNetworksManager.this.setOperationTakingPlace(true);
                BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                this.setEnabled(false);
                if (shell != null) {
                    shell.enterBusy();
                }
                if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount() == 0) {
                    return;
                }
                if (BWifiNetworksManager.this.wifiDaemonSession != null) {
                    sessionToUse = BWifiNetworksManager.this.wifiDaemonSession;
                    Object serviceToUse = null;
                    station = false;
                } else if (BWifiNetworksManager.this.wifiPlatformService != null) {
                    BWifiPlatformService serviceToUse = BWifiNetworksManager.this.wifiPlatformService;
                    sessionToUse = null;
                    station = true;
                } else {
                    throw new IllegalStateException("Could not find Wifi station platform service or daemon session");
                }
                BWifiNetwork toDisconnect = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
                if (toDisconnect.getNetworkState() == BWifiNetworkStateEnum.disconnected || toDisconnect.getNetworkState() == BWifiNetworkStateEnum.disabled) {
                    return;
                }
                toDisconnect.setNetworkState(BWifiNetworkStateEnum.disconnecting);
                if (BWifiNetworksManager.this.databaseNetworkTableModel.getStatusAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor()) != BWifiNetworkStateEnum.disabled) {
                    BWifiNetworksManager.this.databaseNetworkTableModel.setStatusAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor(), BWifiNetworkStateEnum.disconnecting);
                }
                if (station) {
                    throw new BajaRuntimeException("disconnect not implemented in platform service (" + toDisconnect.getSsid() + ")");
                }
                if (!WifiUtil.disconnectFromSession((String)BWifiNetworksManager.this.clientAdapterTextField.getText(), (BDaemonSession)sessionToUse)) {
                    throw new BajaRuntimeException("Failed to disconnect from selected WiFi network (" + toDisconnect.getSsid() + ")");
                }
                if (BWifiNetworksManager.this.currentNetwork != null && BWifiNetworksManager.this.currentNetwork.getSsid().equalsIgnoreCase(toDisconnect.getSsid())) {
                    if (BWifiNetworksManager.this.currentNetwork.getNetworkState() != BWifiNetworkStateEnum.disabled) {
                        BWifiNetworksManager.this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.disconnected);
                    }
                    BWifiNetworksManager.this.currentNetwork = null;
                    BWifiNetworksManager.this.supplicantStateTextField.setText(BWifiSupplicantStateEnum.disconnected.getDisplayTag(null));
                }
                if (BWifiNetworksManager.this.databaseNetworkTableModel.getStatusAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor()) != BWifiNetworkStateEnum.disabled) {
                    BWifiNetworksManager.this.databaseNetworkTableModel.setStatusAt(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor(), BWifiNetworkStateEnum.disconnected);
                }
                BWifiNetworksManager.this.databaseNetworkTableModel.sortColumn = 3;
                BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (BWidget)BWifiNetworksManager.this, (Throwable)t);
            }
            finally {
                this.setEnabled(true);
                BWifiNetworksManager.this.databaseButtons.setEnabled(true);
                BWifiNetworksManager.this.setOperationTakingPlace(false);
                if (shell != null) {
                    shell.exitBusy();
                }
            }
        }
    }

    private class ConnectCommand
    extends AsyncCommand {
        public ConnectCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDatabaseTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.connect.label", "Connect"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/connection.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.connect.description", "Connect to the selected 802.11 wireless network"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                boolean station;
                BDaemonSession sessionToUse;
                BWifiNetworksManager.this.setOperationTakingPlace(true);
                BWifiNetworksManager.this.databaseButtons.setEnabled(false);
                this.setEnabled(false);
                if (shell != null) {
                    shell.enterBusy();
                }
                if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount() == 0) {
                    return;
                }
                if (BWifiNetworksManager.this.wifiDaemonSession != null) {
                    sessionToUse = BWifiNetworksManager.this.wifiDaemonSession;
                    Object serviceToUse = null;
                    station = false;
                } else if (BWifiNetworksManager.this.wifiPlatformService != null) {
                    BWifiPlatformService serviceToUse = BWifiNetworksManager.this.wifiPlatformService;
                    sessionToUse = null;
                    station = true;
                } else {
                    throw new IllegalStateException("Could not find Wifi station platform service or daemon session");
                }
                WifiNetworkTableRow selectedRow = BWifiNetworksManager.this.databaseNetworkTableModel.getRow(BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().getAnchor());
                BWifiNetwork toConnect = selectedRow.getCurrentWifiNetwork();
                if (toConnect.getNetworkState() == BWifiNetworkStateEnum.connected) {
                    return;
                }
                if (station) {
                    throw new BajaRuntimeException("connect not implemented in station view (" + toConnect.getSsid() + ")");
                }
                if (!WifiUtil.connectFromSession((String)BWifiNetworksManager.this.clientAdapterTextField.getText(), (String)String.valueOf(selectedRow.getDatabaseIndex()), (BDaemonSession)sessionToUse)) {
                    throw new BajaRuntimeException("Failed to connect to selected WiFi network (" + toConnect.getSsid() + ")");
                }
                if (BWifiNetworksManager.this.currentNetwork != null && !BWifiNetworksManager.this.currentNetwork.getSsid().equalsIgnoreCase(toConnect.getSsid())) {
                    BWifiNetworksManager.this.currentNetwork = null;
                }
                if (BWifiNetworksManager.this.currentNetwork == null) {
                    BWifiNetworksManager.this.currentNetwork = toConnect;
                }
                BWifiNetworksManager.this.currentNetwork.setNetworkState(BWifiNetworkStateEnum.connecting);
                BWifiNetworksManager.this.databaseNetworkTableModel.sortColumn = 3;
                BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (BWidget)BWifiNetworksManager.this, (Throwable)t);
            }
            finally {
                this.setEnabled(true);
                BWifiNetworksManager.this.databaseButtons.setEnabled(true);
                BWifiNetworksManager.this.setOperationTakingPlace(false);
                if (shell != null) {
                    shell.exitBusy();
                }
            }
        }
    }

    private class AddCommand
    extends AsyncCommand {
        public AddCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDiscoveryTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.add.label", "Add"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/import.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.add.description", "Add the selected 802.11 wireless network to the database"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                BWifiNetworksManager.this.setOperationTakingPlace(true);
                BWifiNetworksManager.this.discoverButtons.setEnabled(false);
                this.setEnabled(false);
                if (shell != null) {
                    shell.enterBusy();
                }
                if (BWifiNetworksManager.this.discoveredNetworkTableModel.getRowCount() == 0) {
                    return;
                }
                BWifiNetwork addedNetwork = this.promptAdd();
                if (addedNetwork == null) {
                    return;
                }
                if (BWifiNetworksManager.this.databaseNetworkTableModel.getRowForSsid(addedNetwork.getSsid()) >= 0) {
                    BDialog.error((BWidget)BWifiNetworksManager.this, (String)BWifiNetworksManager.this.getLexicon().getText("WifiNetworkConfigurationEditor.duplicateError.title"), (Object)BWifiNetworksManager.this.getLexicon().getText("WifiNetworkConfigurationEditor.duplicateError.message"));
                    return;
                }
                for (int i = 0; i < BWifiNetworksManager.this.discoveredNetworkTableModel.getRowCount(); ++i) {
                    if (!BWifiNetworksManager.this.discoveredNetworkTableModel.getSSIDAt(i).equals(addedNetwork.getSsid())) continue;
                    BWifiNetworksManager.this.discoveredNetworkTableModel.setNetworkIconImageAt(i, UNAVAILABLE_NETWORK_ICON);
                }
                BWifiNetworksManager.this.discoveredNetworkTableModel.updateValues(false);
                BWifiNetworksManager.this.databaseNetworkTableModel.addNetwork(addedNetwork, addedNetwork.isNetworkSupported() ? SECURED_NETWORK_ICON : UNSECURED_NETWORK_ICON);
                BWifiNetworksManager.this.databaseNetworkTableModel.sortColumn = 3;
                BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                BWifiNetworksManager.this.databaseNetworkTableModel.getSelection().deselectAll();
                BWifiNetworksManager.this.saveParent();
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (BWidget)BWifiNetworksManager.this, (Throwable)t);
            }
            finally {
                this.setEnabled(true);
                BWifiNetworksManager.this.discoverButtons.setEnabled(true);
                BWifiNetworksManager.this.setOperationTakingPlace(false);
                if (shell != null) {
                    shell.exitBusy();
                }
            }
        }

        public BWifiNetwork promptAdd() throws Exception {
            BWifiNetwork networkToAdd = (BWifiNetwork)BWifiNetworksManager.this.discoveredNetworkTableModel.getNetworkAt(BWifiNetworksManager.this.discoveredNetworkTableModel.getSelection().getAnchor()).newCopy(true);
            boolean supportedNetworkSecurityFound = false;
            networkToAdd.getSecurityPolicies();
            if (!networkToAdd.isNetworkSupported()) {
                String title = BWifiNetworksManager.this.getLexicon().get("WifiNetworkConfigurationEditor.errorAdd.title", "Add Wireless Network");
                BDialog.error((BWidget)BWifiNetworksManager.this, (String)title, (Object)BWifiNetworksManager.this.getLexicon().getText("WifiNetworkConfigurationEditor.errorAdd.message", new Object[]{networkToAdd.getSsid()}));
                return null;
            }
            int oldNetworkStrength = networkToAdd.getSignalStrength();
            String title = BWifiNetworksManager.this.getLexicon().get("WifiNetworkConfigurationEditor.add.title", "Add Wireless Network");
            BWifiNetworkEditorDialog dialog = new BWifiNetworkEditorDialog((BWidget)BWifiNetworksManager.this, title, 2, networkToAdd);
            dialog.setPreferredSize(500.0, 800.0);
            dialog.setBoundsCenteredOnOwner();
            dialog.open();
            if (dialog.getResult() == 1) {
                try {
                    BWifiNetwork modifiedNetwork = dialog.getNetwork();
                    if (modifiedNetwork != null) {
                        modifiedNetwork.setSignalStrength(oldNetworkStrength);
                    }
                    return modifiedNetwork;
                }
                catch (Exception e) {
                    BDialog.error((BWidget)BWifiNetworksManager.this, (String)BWifiNetworksManager.this.getLexicon().getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)BWifiNetworksManager.this.getLexicon().getText(e.getMessage()));
                    return null;
                }
            }
            return null;
        }
    }

    private class DiscoverCommand
    extends AsyncCommand {
        public DiscoverCommand() {
            super((BWidget)BWifiNetworksManager.this.titledDiscoveryTable, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.discover.label", "Discover"), BImage.make((BOrdList)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"module://icons/x16/cloud.png"), BOrd.make((String)"module://icons/x16/badges/find.png")})), null, BWifiNetworksManager.this.getLexicon().get("WifiNetworkManager.discover.description", "Discover 802.11 wireless networks"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doInvokeAsync() {
            BWbShell shell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                boolean station;
                BWifiPlatformService serviceToUse;
                BDaemonSession sessionToUse;
                BWifiNetworksManager.this.setOperationTakingPlace(true);
                BWifiNetworksManager.this.discoverButtons.setEnabled(false);
                this.setEnabled(false);
                BWifiNetworksManager.this.lockModifiedState();
                BDiscoverPreferences prefs = new BDiscoverPreferences();
                String title = BWifiNetworksManager.this.getLexicon().getText("networkdiscover.title");
                BWifiDiscoverDialog dialog = new BWifiDiscoverDialog((BWidget)BWifiNetworksManager.this, title, prefs);
                dialog.setBoundsCenteredOnOwner();
                dialog.open();
                if (dialog.getResult() != 1) {
                    return;
                }
                if (shell != null) {
                    shell.enterBusy();
                }
                if (BWifiNetworksManager.this.wifiDaemonSession != null) {
                    sessionToUse = BWifiNetworksManager.this.wifiDaemonSession;
                    serviceToUse = null;
                    station = false;
                } else if (BWifiNetworksManager.this.wifiPlatformService != null) {
                    serviceToUse = BWifiNetworksManager.this.wifiPlatformService;
                    sessionToUse = null;
                    station = true;
                } else {
                    throw new IllegalStateException("Could not find Wifi station platform service or daemon session");
                }
                BWifiNetworkVector result = null;
                BWifiNetworksManager.this.supplicantStateTextField.setText("Scanning");
                BWifiNetworksManager.this.discoveredNetworkTableModel.clear();
                DiscoverThread myDiscoverTaskThread = station ? new DiscoverThread(BWifiNetworksManager.this.clientAdapterTextField.getText(), serviceToUse) : new DiscoverThread(BWifiNetworksManager.this.clientAdapterTextField.getText(), sessionToUse);
                myDiscoverTaskThread.start();
                int stopCount = 0;
                int STOP_SEC = 15;
                while (myDiscoverTaskThread.isAlive() && ++stopCount < STOP_SEC) {
                    Thread.sleep(1000L);
                }
                if (stopCount == STOP_SEC) {
                    Logger.getLogger("wifi").severe("WiFi discovery task is taking excessive time, terminating task");
                    myDiscoverTaskThread.interrupt();
                    myDiscoverTaskThread.join(2000L);
                } else {
                    result = myDiscoverTaskThread.getResults();
                }
                if (result != null) {
                    for (int idx = 0; idx < BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount(); ++idx) {
                        BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(idx).setSignalStrength(0);
                    }
                    SlotCursor c = result.loadSlots().getProperties();
                    while (c.next(BWifiNetwork.class)) {
                        BWifiNetwork discoveredNetwork = (BWifiNetwork)c.get();
                        boolean foundInDatabase = false;
                        for (int idx = 0; idx < BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount(); ++idx) {
                            if (!BWifiNetworksManager.this.databaseNetworkTableModel.getSSIDAt(idx).equals(discoveredNetwork.getSsid())) continue;
                            foundInDatabase = true;
                            BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(idx).setSignalStrength(discoveredNetwork.getSignalStrength());
                            break;
                        }
                        this.icon = foundInDatabase || discoveredNetwork.getNetworkState() == BWifiNetworkStateEnum.disabled ? UNAVAILABLE_NETWORK_ICON : (discoveredNetwork.isNetworkSupported() ? SECURED_NETWORK_ICON : UNSECURED_NETWORK_ICON);
                        boolean dup = BWifiNetworksManager.this.discoveredNetworkTableModel.getRowForSsid(discoveredNetwork.getSsid()) != -1;
                        boolean show = discoveredNetwork.isNetworkSupported() && discoveredNetwork.getSsidBroadcasted() && !dup;
                        show = show || prefs.getShowUnsupported() && !discoveredNetwork.isNetworkSupported();
                        show = show || prefs.getShowHidden() && !discoveredNetwork.getSsidBroadcasted();
                        if (!(show = show || prefs.getShowDuplicate() && dup)) continue;
                        BWifiNetworksManager.this.discoveredNetworkTableModel.addNetwork(discoveredNetwork, this.icon);
                    }
                    for (int idx = 0; idx < BWifiNetworksManager.this.databaseNetworkTableModel.getRowCount(); ++idx) {
                        BWifiNetwork databaseNetwork = BWifiNetworksManager.this.databaseNetworkTableModel.getNetworkAt(idx);
                        if (databaseNetwork.getSignalStrength() == 0 && databaseNetwork.getSsidBroadcasted()) {
                            databaseNetwork.setNetworkState(BWifiNetworkStateEnum.notinrange);
                            continue;
                        }
                        BWifiNetworkStateEnum currentStatus = databaseNetwork.getNetworkState();
                        if (currentStatus == BWifiNetworkStateEnum.connected || currentStatus == BWifiNetworkStateEnum.connecting || currentStatus == BWifiNetworkStateEnum.disconnecting || currentStatus == BWifiNetworkStateEnum.disconnected || currentStatus == BWifiNetworkStateEnum.disabled) continue;
                        databaseNetwork.setNetworkState(BWifiNetworkStateEnum.disconnected);
                    }
                    BWifiNetworksManager.this.databaseNetworkTableModel.sortColumn = 3;
                    BWifiNetworksManager.this.discoveredNetworkTableModel.sortColumn = 4;
                    BWifiNetworksManager.this.databaseNetworkTableModel.updateValues(true);
                    BWifiNetworksManager.this.discoveredNetworkTableModel.updateValues(true);
                    result.removeAll();
                }
            }
            catch (Throwable t) {
                CommandUtil.error((Command)this, (BWidget)BWifiNetworksManager.this, (Throwable)t);
            }
            finally {
                BWifiNetworksManager.this.unlockModifiedState();
                this.setEnabled(true);
                BWifiNetworksManager.this.discoverButtons.setEnabled(true);
                BWifiNetworksManager.this.setOperationTakingPlace(false);
                if (shell != null) {
                    shell.exitBusy();
                }
            }
        }

        private class DiscoverThread
        extends Thread {
            private BWifiNetworkVector result = null;
            private BDaemonSession sessionToPoll = null;
            private BWifiPlatformService serviceToPoll = null;
            private boolean daemonMode = false;
            private String adapter = null;

            DiscoverThread(String adapter, BDaemonSession sessionToPoll) {
                this.adapter = adapter;
                this.sessionToPoll = sessionToPoll;
                this.daemonMode = true;
            }

            DiscoverThread(String adapter, BWifiPlatformService serviceToPoll) {
                this.adapter = adapter;
                this.serviceToPoll = serviceToPoll;
                this.daemonMode = false;
            }

            BWifiNetworkVector getResults() {
                return this.result;
            }

            @Override
            public void run() {
                if (this.daemonMode) {
                    try {
                        this.result = WifiUtil.discoverFromSession((String)this.adapter, (BDaemonSession)this.sessionToPoll);
                    }
                    catch (Exception e) {
                        this.result = null;
                    }
                } else {
                    try {
                        this.result = this.serviceToPoll.discoverNetworks(BString.make((String)this.serviceToPoll.getSettings().getStaAdapterName()));
                    }
                    catch (Exception e) {
                        this.result = null;
                    }
                }
            }
        }
    }
}

