/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BLimitedFrozenEnumFE;
import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.security.BWifiSecurityPolicy;
import com.tridium.platwifi.security.BWifiWPAPSKSettings;
import com.tridium.platwifi.ui.security.BWifiWPAPSKEditor;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"platWifi:WifiNetwork"})})
@NiagaraAction(name="setEnabledStates")
public class BWifiNetworkEditor
extends BWbView {
    @Generated
    public static final Action setEnabledStates = BWifiNetworkEditor.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiNetworkEditor.class);
    private BEdgePane securityPane = null;
    private BWifiWPAPSKEditor wpapskEditor = null;
    private BGridPane nonePane = null;
    private BTextField SSIDTextFE = null;
    private BCheckBox SSIDHiddenFE = null;
    private BIntegerFE priorityFE = null;
    private BLimitedFrozenEnumFE securityFE = null;
    private BFacets priorityFacets = BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)9), (String)"fieldWidth", (BIDataValue)BInteger.make((int)2));
    public static final int EDIT_NETWORK = 0;
    public static final int NEW_NETWORK = 1;
    public static final int ADD_NETWORK = 2;

    @Generated
    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void doLoadValue(BObject value, Context contextIn) {
        int configurationMode;
        if (contextIn == null) {
            contextIn = new BasicContext((Context)BFacets.make((String)"configureMode", (int)0));
        }
        int n = configurationMode = contextIn.getFacets().getFacet("configureMode") == null ? 0 : ((BInteger)contextIn.getFacet("configureMode")).getInt();
        if (configurationMode > 2 || configurationMode < 0) {
            configurationMode = 0;
        }
        BGridPane editorPane = new BGridPane();
        editorPane.setColumnAlign(BHalign.fill);
        editorPane.setValign(BValign.top);
        editorPane.setHalign(BHalign.left);
        editorPane.setColumnGap(10.0);
        editorPane.setRowGap(6.0);
        this.SSIDTextFE = new BTextField("", 24);
        LabelUtil.addLabelWidgetPair((BPane)editorPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.column.SSID.label"), (BWidget)this.left((BWidget)this.SSIDTextFE));
        this.SSIDHiddenFE = new BCheckBox();
        if (configurationMode != 2) {
            LabelUtil.addLabelWidgetPair((BPane)editorPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.column.ssidHidden.label"), (BWidget)this.left((BWidget)this.SSIDHiddenFE));
        }
        this.priorityFE = new BIntegerFE();
        LabelUtil.addLabelWidgetPair((BPane)editorPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.column.priority.label"), (BWidget)this.left((BWidget)this.priorityFE));
        this.linkTo(null, (BComponent)this.priorityFE, (Slot)BIntegerFE.pluginModified, (Slot)setModified);
        this.securityFE = new BLimitedFrozenEnumFE();
        LabelUtil.addLabelWidgetPair((BPane)editorPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"WifiNetworkManager.column.security.label"), (BWidget)this.left((BWidget)this.securityFE));
        BWifiNetwork network = (BWifiNetwork)value;
        this.SSIDTextFE.setText(network.getSsid());
        this.linkTo(null, (BComponent)this.SSIDTextFE, (Slot)BTextField.textModified, (Slot)setModified);
        if (this.SSIDHiddenFE != null) {
            this.SSIDHiddenFE.setSelected(!network.getSsidBroadcasted());
            this.linkTo(null, (BComponent)this.SSIDHiddenFE, (Slot)BCheckBox.selected, (Slot)setModified);
        }
        BWifiSecurityPolicy policySeed = BWifiSecurityPolicy.wpapsk_wpa2psk;
        if (network.getProtocols().equals("WPA")) {
            policySeed = BWifiSecurityPolicy.wpa_psk;
        }
        if (network.getProtocols().equals("RSN")) {
            policySeed = BWifiSecurityPolicy.wpa_2_psk;
        }
        if (network.getProtocols().equals("WPA2")) {
            policySeed = BWifiSecurityPolicy.wpa_2_psk;
        }
        Vector<BWifiSecurityPolicy> mypolicies = new Vector<BWifiSecurityPolicy>();
        mypolicies.add(BWifiSecurityPolicy.wpa_psk);
        mypolicies.add(BWifiSecurityPolicy.wpa_2_psk);
        mypolicies.add(BWifiSecurityPolicy.wpapsk_wpa2psk);
        int policiesCount = mypolicies.size();
        Object[] policies = mypolicies.toArray();
        int[] ordinals = new int[policiesCount];
        String[] tags = new String[policiesCount];
        for (int i = 0; i < policiesCount; ++i) {
            ordinals[i] = ((BWifiSecurityPolicy)policies[i]).getOrdinal();
            tags[i] = SlotPath.escape((String)((BWifiSecurityPolicy)policies[i]).getDisplayTag(null));
        }
        BEnumRange range = BEnumRange.make((int[])ordinals, (String[])tags);
        BFacets securityFacets = BFacets.make((String)"range", (BIDataValue)range);
        this.priorityFE.loadValue((BObject)BInteger.make((int)network.getPriority()), (Context)this.priorityFacets);
        this.securityFE.loadValue((BObject)policySeed, (Context)securityFacets);
        this.linkTo(null, (BComponent)this.securityFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setEnabledStates);
        this.linkTo(null, (BComponent)this.securityFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)pluginModified);
        this.securityPane = new BEdgePane();
        this.wpapskEditor = new BWifiWPAPSKEditor();
        BFacets securityEditorFacets = BFacets.NULL;
        this.wpapskEditor.loadValue((BObject)network.getSecuritySettings(), (Context)new BasicContext(contextIn, securityEditorFacets));
        this.linkTo(null, (BComponent)this.wpapskEditor, (Slot)BWifiWPAPSKEditor.pluginModified, (Slot)setModified);
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        this.wpapskEditor.computePreferredSize();
        if (this.wpapskEditor.getPreferredWidth() > maxWidth) {
            maxWidth = this.wpapskEditor.getPreferredWidth();
        }
        if (this.wpapskEditor.getPreferredHeight() > maxHeight) {
            maxHeight = this.wpapskEditor.getPreferredHeight();
        }
        this.securityPane.setLeft((BWidget)new BBox(0.0, maxHeight));
        this.securityPane.setBottom((BWidget)new BBox(maxWidth, 0.0));
        BBorderPane securityBorderPane = new BBorderPane((BWidget)this.securityPane, BBorder.inset);
        securityBorderPane.setLabel((BWidget)LabelUtil.makeLabel((LexiconText)LexiconText.make((String)"platWifi", (String)"WifiNetworkManager.securityOptions.label"), (boolean)true));
        BBorderPane mainPane = new BBorderPane((BWidget)new BEdgePane((BWidget)editorPane, null, null, null, (BWidget)new BBorderPane((BWidget)securityBorderPane, 10.0, 0.0, 0.0, 0.0)));
        mainPane.setBorder(BBorder.solid);
        boolean readonly = configurationMode == 2;
        this.SSIDTextFE.setEnabled(!readonly && configurationMode != 0);
        this.SSIDHiddenFE.setEnabled(!readonly);
        this.setContent((BWidget)mainPane);
        this.doSetEnabledStates();
    }

    public final BObject doSaveValue(BObject value, Context contextIn) throws Exception {
        BWifiNetwork network = (BWifiNetwork)value;
        if (this.SSIDTextFE.getText().trim().length() == 0) {
            this.saveError("WifiNetworkEditor.cannotSave.nullSSID");
        } else {
            network.setSsid(this.SSIDTextFE.getText().trim());
        }
        if (this.SSIDHiddenFE != null) {
            network.setSsidBroadcasted(!this.SSIDHiddenFE.isSelected());
        } else {
            network.setSsidBroadcasted(true);
        }
        BInteger bpriority = (BInteger)this.priorityFE.saveValue();
        network.setPriority(bpriority.getInt());
        BWifiSecurityPolicy policy = (BWifiSecurityPolicy)this.securityFE.saveValue();
        network.setSecurityPolicies(policy);
        if (policy.getOrdinal() == 5) {
            network.setProtocols("RSN");
        }
        if (policy.getOrdinal() == 3) {
            network.setProtocols("WPA");
        }
        if (policy.getOrdinal() == 6) {
            network.setProtocols("WPA RSN");
        }
        BWifiWPAPSKSettings securitySettings = (BWifiWPAPSKSettings)this.wpapskEditor.saveValue(contextIn);
        network.setSecuritySettings(securitySettings);
        return network;
    }

    protected void saveError(String messageTag) throws CannotSaveException {
        if (this.widgetSupport(null) != null) {
            BDialog.error((BWidget)this, (String)this.getLexicon().getText("WifiNetworkConfigurationEditor.cannotSave.title"), (Object)this.getLexicon().getText(this.getLexicon().getText(messageTag)));
            CannotSaveException cse = new CannotSaveException();
            cse.setSilent(true);
            throw cse;
        }
        throw new CannotSaveException(this.getLexicon().getText(messageTag));
    }

    public final void doSetEnabledStates() {
        if (this.securityFE != null) {
            try {
                BWifiSecurityPolicy policy = (BWifiSecurityPolicy)this.securityFE.saveValue();
                if (policy.equals((Object)BWifiSecurityPolicy.none)) {
                    this.securityPane.setCenter((BWidget)this.nonePane);
                } else if (policy.equals((Object)BWifiSecurityPolicy.wpa_psk)) {
                    this.securityPane.setCenter((BWidget)this.wpapskEditor);
                } else if (policy.equals((Object)BWifiSecurityPolicy.wpa_2_psk)) {
                    this.securityPane.setCenter((BWidget)this.wpapskEditor);
                } else if (policy.equals((Object)BWifiSecurityPolicy.wpapsk_wpa2psk)) {
                    this.securityPane.setCenter((BWidget)this.wpapskEditor);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private BWidget left(BWidget content) {
        BGridPane result = new BGridPane(1);
        result.setHalign(BHalign.left);
        result.setColumnAlign(BHalign.left);
        result.add(null, (BValue)content);
        return result;
    }

    public void doSetReadonly(boolean readonly) {
        if (this.wpapskEditor != null) {
            this.wpapskEditor.setReadonly(readonly);
        }
        if (this.SSIDTextFE != null) {
            this.SSIDTextFE.setEnabled(!readonly);
        }
        if (this.SSIDHiddenFE != null) {
            this.SSIDHiddenFE.setEnabled(!readonly);
        }
        if (this.securityFE != null) {
            this.securityFE.setEnabled(!readonly);
        }
    }
}

