/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.ui;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platwifi.BHapdHwModeEnum;
import com.tridium.platwifi.BHtCapabilityEnum;
import com.tridium.platwifi.BWifiChannelListEntry;
import com.tridium.platwifi.BWifiChannelListVector;
import com.tridium.platwifi.BWifiPlatformService;
import com.tridium.platwifi.BWifiSettings;
import com.tridium.platwifi.WifiUtil;
import com.tridium.platwifi.ui.BWifiAccessPointManager;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import java.util.ArrayList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLayout;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.LexiconText;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="enableOkCommand"), @NiagaraAction(name="disableOkCommand"), @NiagaraAction(name="modeModified"), @NiagaraAction(name="capabilityModified"), @NiagaraAction(name="channelModified")})
public class BWifiChannelListVectorEditorDialog
extends BDialog {
    @Generated
    public static final Action enableOkCommand = BWifiChannelListVectorEditorDialog.newAction((int)0, null);
    @Generated
    public static final Action disableOkCommand = BWifiChannelListVectorEditorDialog.newAction((int)0, null);
    @Generated
    public static final Action modeModified = BWifiChannelListVectorEditorDialog.newAction((int)0, null);
    @Generated
    public static final Action capabilityModified = BWifiChannelListVectorEditorDialog.newAction((int)0, null);
    @Generated
    public static final Action channelModified = BWifiChannelListVectorEditorDialog.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiChannelListVectorEditorDialog.class);
    Command okCommand;
    Command cancelCommand;
    int dialogResult;
    BDaemonSession sessionToUse = null;
    BWifiPlatformService serviceToUse = null;
    BWifiAccessPointManager manager;
    BWifiSettings wifiSettings;
    BFrozenEnumFE modeFE;
    BFrozenEnumFE capabilitiesFE;
    BListDropDown channnelDropDown;
    BWifiChannelListVector channels;
    ArrayList<BString> countries;
    String cachedCC;

    @Generated
    public void enableOkCommand() {
        this.invoke(enableOkCommand, null, null);
    }

    @Generated
    public void disableOkCommand() {
        this.invoke(disableOkCommand, null, null);
    }

    @Generated
    public void modeModified() {
        this.invoke(modeModified, null, null);
    }

    @Generated
    public void capabilityModified() {
        this.invoke(capabilityModified, null, null);
    }

    @Generated
    public void channelModified() {
        this.invoke(channelModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiChannelListVectorEditorDialog(BWidget owner, String title, BWifiSettings wifiSettings) throws Exception {
        super(owner, title, true);
        this.wifiSettings = wifiSettings;
        this.okCommand = new Ok((BWidget)this);
        this.cancelCommand = new Cancel((BWidget)this);
        this.okCommand.setEnabled(false);
        this.cancelCommand.setEnabled(true);
        BGridPane actions = new BGridPane(2);
        actions.setColumnAlign(BHalign.fill);
        actions.setUniformColumnWidth(true);
        actions.add(null, (BValue)new BButton(this.okCommand));
        actions.add(null, (BValue)new BButton(this.cancelCommand));
        BGridPane settings = new BGridPane(2);
        settings.setColumnAlign(BHalign.fill);
        settings.setUniformColumnWidth(true);
        this.modeFE = new BFrozenEnumFE();
        this.capabilitiesFE = new BFrozenEnumFE();
        this.channnelDropDown = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BPane)settings, (LexiconText)LexiconText.make((Type)TYPE, (String)"radioConfig.dialog.mode.label"), (BWidget)this.modeFE);
        LabelUtil.addLabelWidgetPair((BPane)settings, (LexiconText)LexiconText.make((Type)TYPE, (String)"radioConfig.dialog.capability.label"), (BWidget)this.capabilitiesFE);
        LabelUtil.addLabelWidgetPair((BPane)settings, (LexiconText)LexiconText.make((Type)TYPE, (String)"radioConfig.dialog.channel.label"), (BWidget)this.channnelDropDown);
        this.linkTo(null, (BComponent)this.modeFE, (Slot)BFrozenEnumFE.pluginModified, (Slot)modeModified);
        this.linkTo(null, (BComponent)this.capabilitiesFE, (Slot)BFrozenEnumFE.pluginModified, (Slot)capabilityModified);
        this.linkTo(null, (BComponent)this.channnelDropDown, (Slot)BListDropDown.valueModified, (Slot)channelModified);
        BEdgePane edgePane = new BEdgePane((BWidget)new BBorderPane((BWidget)settings, 10.0, 10.0, 10.0, 10.0), (BWidget)new BBorderPane((BWidget)actions, 10.0, 10.0, 10.0, 10.0), null, null, null);
        edgePane.getTop().setLayout(BLayout.FILL);
        this.setContent((BWidget)new BScrollPane((BWidget)edgePane));
        this.refreshSettings();
    }

    private void refreshSettings() throws Exception {
        this.manager = (BWifiAccessPointManager)this.getOwner();
        BHapdHwModeEnum mode = this.wifiSettings.getSapHwMode();
        BHtCapabilityEnum capabilities = this.wifiSettings.getSapHtCapab();
        this.modeFE.loadValue((BObject)mode);
        this.capabilitiesFE.loadValue((BObject)this.wifiSettings.getSapHtCapab());
        this.countries = new ArrayList();
        this.channels = new BWifiChannelListVector();
        if (this.manager.getWifiDaemonSession() != null) {
            this.sessionToUse = this.manager.getWifiDaemonSession();
            this.serviceToUse = null;
            String cc = WifiUtil.countryCodeFromSession((BDaemonSession)this.sessionToUse);
            BString ccStr = BString.make((String)cc);
            WifiUtil.channelListFromSession((BWifiChannelListVector)this.channels, (BDaemonSession)this.sessionToUse, (String)cc);
            BList channelList = this.channnelDropDown.getList();
            this.populateChannelList(mode, capabilities, channelList, this.wifiSettings.getSapChannel());
        } else if (this.manager.getWifiPlatformService() != null) {
            this.serviceToUse = this.manager.getWifiPlatformService();
            this.sessionToUse = null;
        } else {
            throw new IllegalStateException("Could not find Wifi station platform service or daemon session");
        }
    }

    private void populateChannelList(BHapdHwModeEnum mode, BHtCapabilityEnum capabilities, BList list, int currentChannel) {
        list.removeAllItems();
        try {
            SlotCursor c = this.channels.loadSlots().getProperties();
            while (c.next(BWifiChannelListEntry.class)) {
                BWifiChannelListEntry entry = (BWifiChannelListEntry)c.get();
                block1 : switch (mode.getOrdinal()) {
                    case 1: {
                        if (entry.getBand().getOrdinal() == 0) break;
                        list.addItem((Object)BInteger.make((int)entry.getChannel()));
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (entry.getBand().getOrdinal() != 0) break;
                        list.addItem((Object)BInteger.make((int)entry.getChannel()));
                        break;
                    }
                    default: {
                        if (capabilities.equals((Object)BHtCapabilityEnum.ht40) || capabilities.equals((Object)BHtCapabilityEnum.ht20ht40)) {
                            switch (entry.getChannel()) {
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 9: 
                                case 10: 
                                case 11: 
                                case 12: 
                                case 13: 
                                case 14: {
                                    break block1;
                                }
                                case 36: 
                                case 44: 
                                case 52: 
                                case 60: 
                                case 100: 
                                case 108: 
                                case 116: 
                                case 124: 
                                case 132: 
                                case 140: 
                                case 149: 
                                case 157: 
                                case 165: {
                                    break block1;
                                }
                                case 40: 
                                case 48: 
                                case 56: 
                                case 64: 
                                case 104: 
                                case 112: 
                                case 120: 
                                case 128: 
                                case 136: 
                                case 153: 
                                case 161: {
                                    list.addItem((Object)BInteger.make((int)entry.getChannel()));
                                    break block1;
                                }
                            }
                            break;
                        }
                        list.addItem((Object)BInteger.make((int)entry.getChannel()));
                    }
                }
                if (currentChannel != entry.getChannel()) continue;
                list.setSelectedIndex(list.getItemCount() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (list.getSelectedItem() == null) {
            list.setSelectedIndex(0);
        } else {
            BInteger bint = (BInteger)list.getSelectedItem();
            if (bint.getInt() != currentChannel) {
                list.setSelectedIndex(0);
            }
        }
    }

    public final void doModeModified() throws Exception {
        BHapdHwModeEnum mode = (BHapdHwModeEnum)this.modeFE.saveValue();
        if (!mode.equals((Object)BHapdHwModeEnum.ieee802_11n)) {
            this.capabilitiesFE.loadValue((BObject)BHtCapabilityEnum.ht20);
            this.capabilitiesFE.setReadonly(true);
        } else {
            this.capabilitiesFE.setReadonly(false);
        }
        BHtCapabilityEnum cap = (BHtCapabilityEnum)this.capabilitiesFE.saveValue();
        BList list = this.channnelDropDown.getList();
        if (list.getItemCount() > 0) {
            int selectedChannel = ((BInteger)list.getSelectedItem()).getInt();
            this.populateChannelList(mode, cap, this.channnelDropDown.getList(), selectedChannel);
            this.enableOkCommand();
        } else {
            this.disableOkCommand();
        }
        this.repaint();
    }

    public void doCapabilityModified() throws Exception {
        this.doModeModified();
    }

    public void doChannelModified() throws Exception {
        this.doModeModified();
    }

    public void doEnableOkCommand() {
        this.okCommand.setEnabled(true);
    }

    public void doDisableOkCommand() {
        this.okCommand.setEnabled(false);
    }

    public int getResult() {
        return this.dialogResult;
    }

    public void windowClosing(BWindowEvent event) {
        super.windowClosing(event);
        this.cancelCommand.invoke();
    }

    class Cancel
    extends Command {
        Cancel(BWidget owner) {
            super(owner, BWifiChannelListVectorEditorDialog.this.getLexicon().getText("radioConfig.dialog.cancel"));
        }

        public CommandArtifact doInvoke() {
            BWifiChannelListVectorEditorDialog.this.dialogResult = 2;
            BWifiChannelListVectorEditorDialog.this.close();
            return null;
        }
    }

    class Ok
    extends Command {
        Ok(BWidget owner) {
            super(owner, BWifiChannelListVectorEditorDialog.this.getLexicon().getText("radioConfig.dialog.ok"));
        }

        public CommandArtifact doInvoke() {
            try {
                BInteger selchannel = (BInteger)BWifiChannelListVectorEditorDialog.this.channnelDropDown.getSelectedItem();
                BWifiChannelListVectorEditorDialog.this.wifiSettings.setSapChannel(selchannel.getInt());
                BWifiChannelListVectorEditorDialog.this.wifiSettings.setSapHwMode((BHapdHwModeEnum)BWifiChannelListVectorEditorDialog.this.modeFE.saveValue());
                BWifiChannelListVectorEditorDialog.this.wifiSettings.setSapHtCapab((BHtCapabilityEnum)BWifiChannelListVectorEditorDialog.this.capabilitiesFE.saveValue());
                BWifiChannelListVectorEditorDialog.this.manager.setModified();
            }
            catch (Exception e) {
                CannotSaveException cse;
                boolean show = true;
                if (e instanceof CannotSaveException && (cse = (CannotSaveException)e).isSilent()) {
                    show = false;
                }
                if (show) {
                    BDialog.error((BWidget)this.getOwner(), (String)BWifiChannelListVectorEditorDialog.this.getLexicon().getText("radioConfig.dialog.cannotSave.title"), (Object)e.getMessage());
                }
                return null;
            }
            BWifiChannelListVectorEditorDialog.this.dialogResult = 1;
            BWifiChannelListVectorEditorDialog.this.close();
            return null;
        }
    }
}

