/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.isom;

import com.tridium.json.JSONException;
import com.tridium.json.JSONObject;
import com.tridium.orion.BOrionObject;
import com.tridiumx.isom.BISOMConfig;
import com.tridiumx.isom.InvalidInputDataException;
import com.tridiumx.isom.InvalidURLFormatException;
import com.tridiumx.isom.JSONUtil;
import com.tridiumx.isom.factory.DataObjectFactory;
import com.tridiumx.isom.validation.validators.ValidatorsManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BQuery;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BWebServlet;
import javax.baja.web.WebOp;

@NiagaraType
@NiagaraProperty(name="config", type="BISOMConfig", defaultValue="new BISOMConfig() ")
public class BISOMServlet
extends BWebServlet {
    public static final String DELIMITER = "/";
    public static final Logger LOG = Logger.getLogger("isom");
    private static final Set<String> SUPPORTED_ACTION_TYPES = new HashSet<String>();
    private static final Set<String> SUPPORTED_ENTITY_TYPES;
    private static final Set<String> SUPPORTED_PROJECTION_TYPES;
    private static final String[] UNSUPPORTED_PATTERNS_IN_URL;
    private static final Map<String, ValidatorsManager> POST_REQUEST_JSON_DATA_PROPERTIES;
    private static final Map<String, ValidatorsManager> PUT_REQUEST_JSON_DATA_PROPERTIES;
    private static final String TRIDIUM = "tridium";
    private static final String ENTSEC_ISOM = "entsecISOM";
    public static final Property config;
    public static final Type TYPE;
    private static final String ISOM_SERVLET_NAME = "ISOM";

    public BISOMConfig getConfig() {
        return (BISOMConfig)this.get(config);
    }

    public void setConfig(BISOMConfig v) {
        this.set(config, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BISOMServlet() {
        this.setServletName(ISOM_SERVLET_NAME);
    }

    public void doGet(WebOp webOp) throws Exception {
        try {
            this.isLicensed();
        }
        catch (FeatureNotLicensedException e) {
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", "Feature is not licensed"));
            return;
        }
        if (!webOp.getRequest().getScheme().equals("https")) {
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", "Service is accessible only through HTTPS"));
            return;
        }
        String uri = webOp.getRequest().getRequestURI();
        if (this.urlHasInappropriateContent(uri)) {
            throw new InvalidURLFormatException(uri);
        }
        List<String> uriItems = BISOMServlet.splitURI(uri);
        if (!this.checkURL(uriItems)) {
            this.sendInvalidURLResponse(webOp);
            return;
        }
        try {
            Map queryStringMap = webOp.getRequest().getParameterMap();
            BQuery query = DataObjectFactory.createQueryObject(uriItems, queryStringMap, this.getConfig());
            BOrionObject[] orionObjects = null;
            if (this.urlHasAssociatedEntity(uriItems)) {
                String associatedOrionObjectInfoInUri = uriItems.get(4);
                orionObjects = this.getConfig().getRefObject(query, associatedOrionObjectInfoInUri);
                if (orionObjects == null) {
                    LOG.fine("No Ref found for the OrionObject");
                }
            } else {
                orionObjects = this.getConfig().queryObjects(query);
            }
            if (orionObjects != null && orionObjects.length > 0) {
                this.sendResponse(webOp, DataObjectFactory.createResponseJSONString(this.getConfig(), orionObjects));
            } else {
                this.sendResponse(webOp, DataObjectFactory.createResourceNotFoundJSONString());
            }
        }
        catch (InvalidInputDataException e) {
            LOG.log(Level.FINE, "Invalid input received in the request", e);
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", e.getMessage()));
        }
    }

    public void doPost(WebOp webOp) throws Exception {
        BOrionObject[] newOrionObjects;
        try {
            this.isLicensed();
        }
        catch (FeatureNotLicensedException e) {
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", "Feature is not licensed"));
            return;
        }
        if (!webOp.getRequest().getScheme().equals("https")) {
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", "Service is accessible only through HTTPS"));
            return;
        }
        if (!webOp.getRequest().getContentType().equalsIgnoreCase("application/json")) {
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", "Unsupported content type. API supports only \"application/json\"."));
            return;
        }
        String uri = webOp.getRequest().getRequestURI();
        if (this.urlHasInappropriateContent(uri)) {
            throw new InvalidURLFormatException(uri);
        }
        List<String> uriItems = BISOMServlet.splitURI(uri);
        if (!this.checkURL(uriItems)) {
            this.sendInvalidURLResponse(webOp);
            return;
        }
        String entityName = uriItems.get(2);
        try {
            BOrionObject additionalInfoOrionObjects;
            JSONObject jsonObject = JSONUtil.getJSONObjectFromWebOp(webOp);
            DataObjectFactory.validateInputJSONObject(POST_REQUEST_JSON_DATA_PROPERTIES.get(entityName), jsonObject);
            BOrionObject orionObject = this.getConfig().orionObjectFromJson(jsonObject, entityName);
            newOrionObjects = this.getConfig().createNewObjects(new BOrionObject[]{orionObject});
            if (this.getConfig().checkIfOrionObjectHasAdditionalInfo(newOrionObjects[0]) && (additionalInfoOrionObjects = this.getConfig().additionalInfoOrionObjectFromJson(jsonObject, newOrionObjects[0])) != null) {
                this.getConfig().createAdditionalInfoObjects(new BOrionObject[]{additionalInfoOrionObjects});
            }
        }
        catch (JSONException e) {
            LOG.log(Level.FINE, "Exception occurred while parsing the input Json", e);
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", "Invalid JSON Object"));
            return;
        }
        catch (InvalidInputDataException e) {
            LOG.log(Level.FINE, "Exception occurred while processing the input Json", e);
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", e.getMessage()));
            return;
        }
        catch (Exception e) {
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", e.getMessage()));
            return;
        }
        JSONObject response = JSONUtil.getJSONObjectWithIds(newOrionObjects, this.getConfig().getIdentifierProperty(entityName));
        this.sendResponse(webOp, response.toString());
    }

    public void doPut(WebOp webOp) throws Exception {
        Map queryStringMap;
        try {
            this.isLicensed();
        }
        catch (FeatureNotLicensedException e) {
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", "Feature is not licensed"));
            return;
        }
        if (!webOp.getRequest().getScheme().equals("https")) {
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", "Service is accessible only through HTTPS"));
            return;
        }
        if (!webOp.getRequest().getContentType().equalsIgnoreCase("application/json")) {
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", "Unsupported content type. API supports only \"application/json\"."));
            return;
        }
        String uri = webOp.getRequest().getRequestURI();
        if (this.urlHasInappropriateContent(uri)) {
            throw new InvalidURLFormatException(uri);
        }
        List<String> uriItems = BISOMServlet.splitURI(uri);
        if (!this.checkURL(uriItems)) {
            this.sendInvalidURLResponse(webOp);
            return;
        }
        BOrionObject[] orionObjectsAfterUpdate = null;
        String entityName = uriItems.get(2);
        try {
            JSONObject jsonObject = JSONUtil.getJSONObjectFromWebOp(webOp);
            DataObjectFactory.validateInputJSONObject(PUT_REQUEST_JSON_DATA_PROPERTIES.get(entityName), jsonObject);
            queryStringMap = webOp.getRequest().getParameterMap();
            BQuery query = DataObjectFactory.createQueryObject(uriItems, queryStringMap, this.getConfig());
            BOrionObject[] orionObjects = this.getConfig().queryObjects(query);
            if (orionObjects == null || orionObjects.length == 0) {
                LOG.fine("Update operation failed. OrionObject in the request is not found in the DB");
                this.sendResponse(webOp, DataObjectFactory.createResourceNotFoundJSONString());
                return;
            }
            BOrionObject orionObjectToBeUpdated = this.getConfig().populateOrionObjectFromJson(jsonObject, orionObjects[0]);
            orionObjectsAfterUpdate = this.getConfig().updateObjects(jsonObject, orionObjectToBeUpdated);
        }
        catch (JSONException e) {
            LOG.log(Level.FINE, "Exception occurred while parsing the input Json", e);
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", "Invalid JSON Object"));
            return;
        }
        catch (InvalidInputDataException e) {
            LOG.log(Level.FINE, "Invalid input received in the request", e);
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", e.getMessage()));
            return;
        }
        catch (Exception e) {
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", e.getMessage()));
            return;
        }
        if (orionObjectsAfterUpdate == null || orionObjectsAfterUpdate.length == 0) {
            LOG.log(Level.FINE, "Update operation failed.");
            this.sendResponse(webOp, DataObjectFactory.createResourceNotFoundJSONString());
            return;
        }
        this.prepareAndSendResponse(true, queryStringMap, uriItems, webOp);
    }

    public void doDelete(WebOp webOp) throws Exception {
        try {
            this.isLicensed();
        }
        catch (FeatureNotLicensedException e) {
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", "Feature is not licensed"));
            return;
        }
        if (!webOp.getRequest().getScheme().equals("https")) {
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", "Service is accessible only through HTTPS"));
            return;
        }
        String uri = webOp.getRequest().getRequestURI();
        if (this.urlHasInappropriateContent(uri)) {
            throw new InvalidURLFormatException(uri);
        }
        List<String> uriItems = BISOMServlet.splitURI(uri);
        if (!this.checkURL(uriItems)) {
            this.sendInvalidURLResponse(webOp);
            return;
        }
        try {
            Map queryStringMap = webOp.getRequest().getParameterMap();
            BQuery query = DataObjectFactory.createQueryObject(uriItems, queryStringMap, this.getConfig());
            boolean result = this.getConfig().deleteObjects(query);
            this.prepareAndSendResponse(result, queryStringMap, uriItems, webOp);
        }
        catch (InvalidInputDataException e) {
            LOG.log(Level.FINE, "Invalid input received in the request", e);
            this.sendResponse(webOp, DataObjectFactory.createFailureModeJSONString("StatusCode", e.getMessage()));
        }
    }

    private void prepareAndSendResponse(boolean result, Map<String, String[]> queryStringMap, List<String> uriItems, WebOp webOp) throws IOException {
        if (result) {
            String externalSystemId = null;
            if (queryStringMap != null) {
                String string = externalSystemId = queryStringMap.get("externalSystemID") == null ? null : queryStringMap.get("externalSystemID")[0];
            }
            if (externalSystemId == null) {
                this.sendResponse(webOp, DataObjectFactory.createResponseJSONString(uriItems.get(3), "id"));
            } else {
                this.sendResponse(webOp, DataObjectFactory.createResponseJSONString(externalSystemId.toString(), "externalSystemID"));
            }
        } else {
            this.sendResponse(webOp, DataObjectFactory.createResourceNotFoundJSONString());
        }
    }

    private boolean urlHasAssociatedEntity(List<String> uriItems) {
        return uriItems.size() > 4 && uriItems.get(4) != null && !uriItems.get(4).toString().equalsIgnoreCase("config");
    }

    private void sendResponse(WebOp webOp, String jsonString) throws IOException {
        webOp.getResponse().setContentType("text/json");
        webOp.getResponse().setStatus(200);
        webOp.getResponse().getWriter().println(jsonString);
    }

    private void sendInvalidURLResponse(WebOp webOp) throws IOException {
        webOp.getResponse().setContentType("text/plain");
        webOp.getResponse().setStatus(404);
        webOp.getResponse().getWriter().println("The URI is not formed correctly. Please refer to the ISOM specification");
    }

    private boolean checkURL(List<String> uriItems) {
        if (uriItems.size() < 4) {
            return false;
        }
        return SUPPORTED_ACTION_TYPES.contains(uriItems.get(1)) && SUPPORTED_ENTITY_TYPES.contains(uriItems.get(2)) && SUPPORTED_PROJECTION_TYPES.contains(uriItems.get(uriItems.size() - 1));
    }

    private boolean urlHasInappropriateContent(String uri) {
        for (int i = 0; i < UNSUPPORTED_PATTERNS_IN_URL.length; ++i) {
            if (!uri.contains(UNSUPPORTED_PATTERNS_IN_URL[i])) continue;
            return true;
        }
        return false;
    }

    private static List<String> splitURI(String s) {
        ArrayList<String> l = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(s, DELIMITER);
        while (token.hasMoreTokens()) {
            l.add(token.nextToken());
        }
        return l;
    }

    private void isLicensed() {
        Feature feature = Sys.getLicenseManager().getFeature(TRIDIUM, ENTSEC_ISOM);
        if (feature != null) {
            feature.check();
        }
    }

    static {
        SUPPORTED_ACTION_TYPES.addAll(Arrays.asList("UserMgmt"));
        SUPPORTED_ENTITY_TYPES = new HashSet<String>();
        SUPPORTED_ENTITY_TYPES.addAll(Arrays.asList("CredentialHolders", "Credentials", "Permissions"));
        SUPPORTED_PROJECTION_TYPES = new HashSet<String>();
        SUPPORTED_PROJECTION_TYPES.addAll(Arrays.asList("config"));
        UNSUPPORTED_PATTERNS_IN_URL = new String[]{"./", "/.", "../", "/.."};
        POST_REQUEST_JSON_DATA_PROPERTIES = new HashMap<String, ValidatorsManager>();
        POST_REQUEST_JSON_DATA_PROPERTIES.put("CredentialHolders", new ValidatorsManager("/rc/properties/credentialHoldersJSONPost.properties"));
        POST_REQUEST_JSON_DATA_PROPERTIES.put("Credentials", new ValidatorsManager("/rc/properties/credentialJSONPost.properties"));
        PUT_REQUEST_JSON_DATA_PROPERTIES = new HashMap<String, ValidatorsManager>();
        PUT_REQUEST_JSON_DATA_PROPERTIES.put("CredentialHolders", new ValidatorsManager("/rc/properties/credentialHoldersJSONPut.properties"));
        PUT_REQUEST_JSON_DATA_PROPERTIES.put("Credentials", new ValidatorsManager("/rc/properties/credentialJSONPut.properties"));
        config = BISOMServlet.newProperty((int)0, (BValue)new BISOMConfig(), null);
        TYPE = Sys.loadType(BISOMServlet.class);
    }
}

