/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.ui;

import com.tridium.ace.component.BAceTextBlock;
import com.tridium.ace.ui.AceTextBlockGlyph;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.Glyph;
import com.tridium.wiresheet.StdComponentGlyph;
import com.tridium.wiresheet.TextBlockGlyph;
import com.tridium.wiresheet.WsController;
import com.tridium.workbench.transfer.TransferArtifact;
import java.util.HashMap;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.BWsTextBlock;
import javax.baja.workbench.BWbShell;

public class AceWsController
extends WsController {
    private HashMap<String, ComponentGlyph> byName = new HashMap();
    private HashMap<Object, ComponentGlyph> byHandle = new HashMap();
    private int auto = -2;

    public AceWsController(BWireSheetPane ws) {
        super(ws);
    }

    public void load(BComponent container) {
        this.byHandle.clear();
        this.byName.clear();
        this.auto = -2;
        super.load(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentGlyph addComponentGlyph(BComponent comp) {
        if (comp instanceof BVector) {
            throw new IllegalStateException();
        }
        HashMap<String, ComponentGlyph> hashMap = this.byName;
        synchronized (hashMap) {
            Object glyph = this.byName.get(comp.getName());
            if (glyph != null) {
                return glyph;
            }
            BWsAnnotation anno = null;
            BValue annoRaw = comp.get("wsAnnotation");
            anno = annoRaw instanceof BWsAnnotation ? (BWsAnnotation)annoRaw : this.nextAutoAnnotation();
            int p = anno.p;
            int q = anno.q;
            int w = anno.wixelWidth;
            int h = anno.wixelHeight;
            if (h < 2) {
                h = 2;
            }
            if (w < 2) {
                w = 2;
            }
            if (p + w > BWsOptions.make().getMaxWidth()) {
                p = BWsOptions.make().getMaxWidth() - w;
            }
            if (q + h > BWsOptions.make().getMaxHeight()) {
                q = BWsOptions.make().getMaxHeight() - h;
            }
            if (p < 0) {
                p = 0;
            }
            if (q < 0) {
                q = 0;
            }
            anno = BWsAnnotation.make((int)p, (int)q, (int)w, (int)h);
            glyph = comp instanceof BWsTextBlock ? new TextBlockGlyph(this.ws, comp, anno) : (comp instanceof BAceTextBlock ? new AceTextBlockGlyph(this.ws, comp, anno) : new StdComponentGlyph(this.ws, comp, anno));
            this.byName.put(comp.getName(), (ComponentGlyph)glyph);
            this.byHandle.put(glyph.handle, (ComponentGlyph)glyph);
            this.ws.getCanvas().getRootGlyph().componentLayer.addToTop((Glyph)glyph);
            return glyph;
        }
    }

    public ComponentGlyph toComponentGlyph(BOrd ord) {
        String s = String.valueOf(ord);
        if (s.startsWith("h:")) {
            String handle = s.substring(2).trim();
            return this.byHandle.get(handle);
        }
        if (s.startsWith("station:") || s.startsWith("slot:")) {
            try {
                BObject obj = ord.get((BObject)this.ws.controller.container);
                if (obj.isComponent()) {
                    return this.byHandle.get(obj.asComponent().getHandle());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void handleComponentEvent(BComponentEvent event) {
        if (this.container == null) {
            return;
        }
        int id = event.getId();
        BComponent src = event.getSourceComponent();
        Object h = src.getHandle();
        String slotName = event.getSlotName();
        if (this.container.getHandle().equals(h)) {
            switch (id) {
                case 1: 
                case 3: {
                    this.reload();
                    break;
                }
                case 2: {
                    ComponentGlyph glyph = this.byName.get(slotName);
                    if (glyph != null) {
                        this.ws.grid.set(glyph.p, glyph.q, glyph.ww, glyph.wh, 0);
                        this.ws.grid.clearLinks();
                    }
                    this.reload();
                }
            }
            return;
        }
        ComponentGlyph glyph = this.byHandle.get(h);
        if (glyph != null) {
            switch (id) {
                case 0: {
                    if (slotName.equals("wsAnnotation")) {
                        this.reload();
                        break;
                    }
                    glyph.changed(slotName);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 8: 
                case 9: 
                case 17: 
                case 18: {
                    this.reload();
                    break;
                }
                case 2: 
                case 6: {
                    this.ws.grid.set(glyph.p, glyph.q, glyph.ww, glyph.wh, 0);
                    this.ws.grid.clearLinks();
                    this.reload();
                }
            }
            return;
        }
        BComponent parent = (BComponent)src.getParent();
        if (parent != null) {
            glyph = this.byHandle.get(parent.getHandle());
        }
        if (glyph != null) {
            switch (id) {
                case 0: {
                    glyph.changed(src.getPropertyInParent().getName());
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeTransfer(TransferArtifact artifact) {
        if (artifact == null) {
            return;
        }
        BWbShell shell = this.ws.getWbShell();
        if (shell != null) {
            shell.enterBusy();
        }
        try {
            String[] names = artifact.getInsertNames();
            this.selection.unselectAll();
            ComponentGlyph[] glyphs = new ComponentGlyph[names.length];
            HashMap<String, ComponentGlyph> hashMap = this.byName;
            synchronized (hashMap) {
                for (int i = 0; i < names.length; ++i) {
                    BValue value = this.container.get(names[i]);
                    if (value == null || !value.isComponent() || value instanceof BVector) continue;
                    glyphs[i] = this.addComponentGlyph(value.asComponent());
                    this.selection.select((Glyph)glyphs[i]);
                }
            }
            for (int i = 0; i < glyphs.length; ++i) {
                glyphs[i].loadLinks();
                glyphs[i].loadRelations();
                glyphs[i].loadKnobs();
                glyphs[i].loadRelationKnobs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
    }
}

