/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bajascript.ux.util;

import com.tridium.box.env.BBajaScriptClientEnv;
import com.tridium.box.json.BoxWriter;
import com.tridium.box.typenode.CommonTypes;
import com.tridium.box.typenode.RegistryEncoderVisitor;
import com.tridium.box.typenode.TypeNode;
import com.tridium.box.typenode.TypeNodeBuilder;
import com.tridium.box.typenode.TypeNodeVisitor;
import com.tridium.json.JSONObject;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.EnumType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.util.List;
import javax.baja.box.BBoxClientEnv;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class CommonTypeLibGenerator {
    private CommonTypeLibGenerator() {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Could not generate Common Types File. Please specify a file!");
        }
        try {
            CommonTypeLibGenerator.generateCommonTypeLib(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateCommonTypeLib(String outputFilePath) throws Exception {
        System.out.println("*** Generating Common Types File *** ");
        for (String typeSpec : CommonTypes.commonTypes) {
            ComplexType clxType;
            Type type = Sys.getType((String)typeSpec);
            if (!(type instanceof ComplexType ? (clxType = (ComplexType)type).getFrozenSlots().length > 0 : type instanceof EnumType && !type.equals(BFrozenEnum.TYPE))) continue;
            throw new Exception("Invalid Common Type: " + type);
        }
        System.out.println("Common Types File: " + outputFilePath);
        StringWriter buff = new StringWriter();
        buff.append("// Copyright 2014, Tridium, Inc. All Rights Reserved\n");
        buff.append("define(['bajaScript/comm'], function(baja){");
        buff.append("'use strict';");
        buff.append("baja.$ctypes='");
        System.out.println("*** Generating compact JSON ***");
        buff.append(CommonTypeLibGenerator.getTypeJson());
        buff.append("';});");
        File file = new File(outputFilePath);
        if (file.exists() && !file.delete()) {
            throw new Exception("Cannot delete file: " + outputFilePath);
        }
        if (!file.createNewFile()) {
            throw new Exception("Unable to create file: " + outputFilePath);
        }
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(file);
            fileOut.write(buff.toString().getBytes("UTF-8"));
        }
        finally {
            try {
                if (fileOut != null) {
                    fileOut.close();
                }
            }
            catch (Exception exception) {}
        }
        System.out.println("*** Finished Generating Common Types File " + outputFilePath + " *** ");
        System.exit(0);
    }

    public static String getTypeJson() throws Exception {
        List nodes = TypeNodeBuilder.make().get(CommonTypes.commonTypes);
        BoxWriter out = new BoxWriter();
        RegistryEncoderVisitor encoder = new RegistryEncoderVisitor(out, null, null, (BBoxClientEnv)BBajaScriptClientEnv.INSTANCE, false, true);
        out.object();
        for (TypeNode node : nodes) {
            node.visit((TypeNodeVisitor)encoder);
        }
        out.endObject();
        String json = JSONObject.quote((String)out.toString());
        return json.substring(1, json.length() - 1);
    }
}

