/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.foxanalyzer;

import com.tridium.fox.message.MessageWriter;
import com.tridium.fox.session.FoxFrame;
import com.tridium.fox.session.FoxSession;
import com.tridium.foxanalyzer.BFoxFrameRecordType;
import com.tridium.foxanalyzer.BFoxFrameType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.baja.history.BHistoryRecord;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="recordType", type="BFoxFrameRecordType", defaultValue="BFoxFrameRecordType.stateChanged"), @NiagaraProperty(name="fType", type="BFoxFrameType", defaultValue="BFoxFrameType.fNull"), @NiagaraProperty(name="id", type="String", defaultValue=""), @NiagaraProperty(name="seq", type="int", defaultValue="-1"), @NiagaraProperty(name="reply", type="int", defaultValue="-1"), @NiagaraProperty(name="channel", type="String", defaultValue=""), @NiagaraProperty(name="command", type="String", defaultValue=""), @NiagaraProperty(name="message", type="String", defaultValue=""), @NiagaraProperty(name="error", type="String", defaultValue="")})
public final class BFoxFrameRecord
extends BHistoryRecord {
    @Generated
    public static final Property recordType = BFoxFrameRecord.newProperty((int)0, (BValue)BFoxFrameRecordType.stateChanged, null);
    @Generated
    public static final Property fType = BFoxFrameRecord.newProperty((int)0, (BValue)BFoxFrameType.fNull, null);
    @Generated
    public static final Property id = BFoxFrameRecord.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property seq = BFoxFrameRecord.newProperty((int)0, (int)-1, null);
    @Generated
    public static final Property reply = BFoxFrameRecord.newProperty((int)0, (int)-1, null);
    @Generated
    public static final Property channel = BFoxFrameRecord.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property command = BFoxFrameRecord.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property message = BFoxFrameRecord.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property error = BFoxFrameRecord.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxFrameRecord.class);

    @Generated
    public BFoxFrameRecordType getRecordType() {
        return (BFoxFrameRecordType)this.get(recordType);
    }

    @Generated
    public void setRecordType(BFoxFrameRecordType v) {
        this.set(recordType, (BValue)v, null);
    }

    @Generated
    public BFoxFrameType getFType() {
        return (BFoxFrameType)this.get(fType);
    }

    @Generated
    public void setFType(BFoxFrameType v) {
        this.set(fType, (BValue)v, null);
    }

    @Generated
    public String getId() {
        return this.getString(id);
    }

    @Generated
    public void setId(String v) {
        this.setString(id, v, null);
    }

    @Generated
    public int getSeq() {
        return this.getInt(seq);
    }

    @Generated
    public void setSeq(int v) {
        this.setInt(seq, v, null);
    }

    @Generated
    public int getReply() {
        return this.getInt(reply);
    }

    @Generated
    public void setReply(int v) {
        this.setInt(reply, v, null);
    }

    @Generated
    public String getChannel() {
        return this.getString(channel);
    }

    @Generated
    public void setChannel(String v) {
        this.setString(channel, v, null);
    }

    @Generated
    public String getCommand() {
        return this.getString(command);
    }

    @Generated
    public void setCommand(String v) {
        this.setString(command, v, null);
    }

    @Generated
    public String getMessage() {
        return this.getString(message);
    }

    @Generated
    public void setMessage(String v) {
        this.setString(message, v, null);
    }

    @Generated
    public String getError() {
        return this.getString(error);
    }

    @Generated
    public void setError(String v) {
        this.setString(error, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BFoxFrameRecord make(BFoxFrameRecordType eventType, FoxSession session, FoxFrame frame, boolean showDebugFrames) {
        BFoxFrameRecord rec = new BFoxFrameRecord();
        rec.setTimestamp(BAbsTime.now());
        rec.setRecordType(eventType);
        rec.setFType(BFoxFrameType.make(frame.frameType));
        rec.setId(session.getId());
        rec.setSeq(frame.sequenceNumber);
        rec.setReply(frame.replyNumber);
        rec.setChannel(frame.channel);
        rec.setCommand(frame.command);
        final StringBuilder buff = new StringBuilder();
        OutputStream outStr = new OutputStream(){

            @Override
            public void write(int b) {
                buff.append((char)b);
            }
        };
        MessageWriter messWrit = new MessageWriter(outStr, showDebugFrames);
        try {
            frame.message.writeValue(messWrit);
            rec.setMessage(buff.toString());
        }
        catch (Exception e) {
            System.out.println("Error writing Fox frame...");
            e.printStackTrace();
            rec.setMessage("Error decoding frame");
        }
        return rec;
    }

    public static BFoxFrameRecord make(BFoxFrameRecordType eventType, String message, Throwable throwable) {
        BFoxFrameRecord rec = new BFoxFrameRecord();
        rec.setTimestamp(BAbsTime.now());
        rec.setRecordType(eventType);
        rec.setMessage(message);
        if (throwable != null) {
            StringWriter writer = new StringWriter();
            throwable.printStackTrace(new PrintWriter(writer));
            rec.setError(writer.toString());
        }
        return rec;
    }

    public static BFoxFrameRecord make(BFoxFrameRecordType eventType, FoxSession session, String message, Throwable throwable) {
        BFoxFrameRecord rec = BFoxFrameRecord.make(eventType, message, throwable);
        if (session != null) {
            rec.setId(session.getId());
        }
        return rec;
    }

    public boolean isFixedSize() {
        return false;
    }

    protected void doRead(DataInput in) throws IOException {
        this.setRecordType(BFoxFrameRecordType.make(in.readInt()));
        this.setFType(BFoxFrameType.make(in.readInt()));
        this.setId(in.readUTF());
        this.setSeq(in.readInt());
        this.setReply(in.readInt());
        this.setChannel(in.readUTF());
        this.setCommand(in.readUTF());
        this.setMessage(in.readUTF());
        this.setError(in.readUTF());
    }

    protected void doWrite(DataOutput out) throws IOException {
        out.writeInt(this.getRecordType().getOrdinal());
        out.writeInt(this.getFType().getOrdinal());
        out.writeUTF(this.getId());
        out.writeInt(this.getSeq());
        out.writeInt(this.getReply());
        out.writeUTF(this.getChannel());
        out.writeUTF(this.getCommand());
        out.writeUTF(this.getMessage());
        out.writeUTF(this.getError());
    }
}

