/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.file;

import com.tridium.file.util.FindUtil;
import com.tridium.template.file.BINtplFile;
import com.tridium.template.file.BNtplFile;
import com.tridium.template.file.NtplUtil;
import java.util.ArrayList;
import java.util.List;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.util.BUuid;

public final class TemplateFileUtil {
    private TemplateFileUtil() {
    }

    public static List<BIFile> getApplicationTemplates() {
        return TemplateFileUtil.getTemplates(NtplUtil.getApplicationDirectory());
    }

    public static List<BIFile> getTemplates() {
        return TemplateFileUtil.getTemplates(NtplUtil.getTemplateDirectory());
    }

    public static List<BIFile> getTemplates(BDirectory directory) {
        return FindUtil.files().ofType(BNtplFile.TYPE).from(directory);
    }

    public static List<BINtplFile> getApplicationTemplatesByUuid(BUuid uuid) {
        return TemplateFileUtil.getTemplatesByUuid(uuid, NtplUtil.getApplicationDirectory());
    }

    public static List<BINtplFile> getTemplatesByUuid(BUuid uuid) {
        return TemplateFileUtil.getTemplatesByUuid(uuid, NtplUtil.getTemplateDirectory());
    }

    public static List<BINtplFile> getTemplatesByUuid(BUuid uuid, BDirectory directory) {
        List<BIFile> templateFiles = TemplateFileUtil.getTemplates(directory);
        ArrayList<BINtplFile> matchingFiles = new ArrayList<BINtplFile>();
        for (BIFile file : templateFiles) {
            BINtplFile tempFile = (BINtplFile)file;
            if (!tempFile.getTemplateManifest().uID.equals((Object)uuid)) continue;
            matchingFiles.add(tempFile);
        }
        return matchingFiles;
    }
}

