/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.application;

import com.tridium.install.BVersion;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.sys.transfer.ReplacingContext;
import com.tridium.template.BApplicationService;
import com.tridium.template.BConfigBinding;
import com.tridium.template.BTemplateConfig;
import com.tridium.template.application.ApplicationTemplateUtil;
import com.tridium.template.application.NameTree;
import com.tridium.template.application.ProgressTracker;
import com.tridium.template.file.BNtplFile;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import javax.baja.agent.BPxView;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.CopyHints;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.util.BFormat;
import javax.baja.util.BUnrestrictedFolder;
import javax.baja.util.BWsAnnotation;

public class ApplicationTemplateInstaller
implements AutoCloseable {
    private final BNtplFile applicationFile;
    private final NameTree componentsToBeRemoved;
    private final ProgressTracker progress;

    public ApplicationTemplateInstaller() {
        this(null, null, new ProgressTracker());
    }

    public ApplicationTemplateInstaller(BOrd templateFileOrd, BOrdList componentsToBeRemoved, ProgressTracker progress) {
        this.applicationFile = templateFileOrd == null ? null : (BNtplFile)templateFileOrd.resolve().get();
        this.componentsToBeRemoved = componentsToBeRemoved == null ? null : ApplicationTemplateUtil.makeNameTree(componentsToBeRemoved);
        this.progress = progress;
    }

    public boolean checkForCompatibleModules() {
        return this.checkStationForCompatibleModules(Sys.getStation());
    }

    private boolean checkStationForCompatibleModules(BStation target) {
        if (this.applicationFile == null) {
            throw new IllegalStateException();
        }
        this.progress.message("application.compatibility.starting", new String[0]);
        List<Map<String, BVersion>> missingDependencies = this.applicationFile.checkRemoteModuleDependencies((BComponent)target);
        Map<String, BVersion> missingModules = missingDependencies.get(0);
        Map<String, BVersion> mismatchedModules = missingDependencies.get(1);
        Map<String, BVersion> missingPxModules = missingDependencies.get(2);
        boolean incompatible = missingModules.size() > 0;
        boolean compatibilityWarnings = mismatchedModules.size() > 0 || missingPxModules.size() > 0;
        for (String string : missingModules.keySet()) {
            this.progress.message("application.compatibility.missingModule", string);
        }
        for (Map.Entry entry : mismatchedModules.entrySet()) {
            this.progress.message("application.compatibility.mismatchedModule", (String)entry.getKey(), ((BVersion)entry.getValue()).toString());
        }
        for (String string : missingPxModules.keySet()) {
            this.progress.message("application.compatibility.missingPxModule", string);
        }
        if (incompatible) {
            this.progress.message("application.compatibility.failed", new String[0]);
        } else if (compatibilityWarnings) {
            this.progress.message("application.compatibility.warnings", new String[0]);
        } else {
            this.progress.message("application.compatibility.passed", new String[0]);
        }
        return !incompatible;
    }

    public void install(Context cx) throws IOException {
        this.installToStation(Sys.getStation(), ApplicationTemplateUtil.describeDefaultStation(cx));
    }

    public void upgrade(Context cx) throws IOException {
        this.upgradeStation(Sys.getStation(), ApplicationTemplateUtil.describeDefaultStation(cx));
    }

    private void installToStation(BStation target, NameTree keepInTarget) throws IOException {
        if (this.applicationFile == null) {
            throw new IllegalStateException();
        }
        try {
            this.basicInstallToStation(target, keepInTarget, this.componentsToBeRemoved);
        }
        catch (Exception e) {
            this.progress.endFailed(e);
            throw e;
        }
        this.progressMessage("application.install.finished", new String[0]);
        this.progress.message("application.install.passwordNote", new String[0]);
    }

    private void upgradeStation(BStation target, NameTree keepInTarget) throws IOException {
        if (this.applicationFile == null) {
            throw new IllegalStateException();
        }
        try {
            this.progressMessage("application.upgrade.saveConfig", new String[0]);
            this.progress.constrain(5);
            Map<String, BValue> rootProps = ApplicationTemplateInstaller.getApplicationProperties(target);
            this.progress.fulfill();
            this.progress.constrain(10);
            NameTree componentsToBeRemoved = ApplicationTemplateInstaller.getMissingOptionalComponents(target, this.applicationFile.getTemplateManifest().optional);
            this.progress.fulfill();
            this.progress.constrain(90);
            this.basicInstallToStation(target, keepInTarget, componentsToBeRemoved);
            this.progress.fulfill();
            this.progressMessage("application.upgrade.restoreConfig", new String[0]);
            this.progress.constrain(100);
            ApplicationTemplateInstaller.setApplicationProperties(target, rootProps);
            this.progress.fulfill();
        }
        catch (Exception e) {
            this.progress.endFailed(e);
            throw e;
        }
        this.progressMessage("application.upgrade.finished", new String[0]);
    }

    private void basicInstallToStation(BStation target, NameTree keepInTarget, NameTree componentsToBeRemoved) throws IOException {
        this.progress.constrain(5);
        BStation source = (BStation)this.applicationFile.getBaseComponent();
        this.progress.fulfill();
        this.progressMessage("application.install.loaded", new String[0]);
        this.progressMessage("application.clear.starting", new String[0]);
        ReplacingContext cx = new ReplacingContext(Context.NULL, BFacets.make((String)"niagaraAutoStart", (BIDataValue)BBoolean.FALSE));
        this.progress.constrain(20);
        this.clearApplicationComponents(target, keepInTarget, (Context)cx);
        this.progress.fulfill();
        this.progress.constrain(30);
        String[] fileKeepers = new String[]{this.applicationFile.getFilePath().toString()};
        this.clearApplicationFiles(target, fileKeepers);
        this.progress.fulfill();
        this.progressMessage("application.clear.finished", new String[0]);
        this.progressMessage("application.install.starting", new String[0]);
        this.progress.constrain(50);
        this.installApplicationFiles(this.applicationFile, target);
        this.progress.fulfill();
        this.progress.constrain(100);
        this.installApplicationComponents(source, componentsToBeRemoved, target, keepInTarget, (Context)cx);
        this.progress.fulfill();
    }

    public void installApplicationComponents(BStation source, BStation target, NameTree keepInTarget, Context cx) {
        this.installApplicationComponents(source, null, target, keepInTarget, cx);
    }

    public void installApplicationComponents(BStation source, NameTree dropFromSource, BStation target, NameTree keepInTarget, Context cx) {
        this.progressMessage("application.deploy.building", new String[0]);
        this.progress.constrain(15);
        CopyHints hints = new CopyHints();
        hints.defaultOnClone = false;
        hints.swizzleHandles = true;
        BStation newSource = (BStation)source.newCopy(hints);
        this.progress.fulfill();
        this.progress.constrain(20);
        if (dropFromSource != null && !dropFromSource.isEmpty()) {
            ApplicationTemplateUtil.deleteComponents((BComponent)newSource, dropFromSource);
        }
        this.progress.fulfill();
        HashMap<Object, Object> handleMap = new HashMap<Object, Object>();
        HashMap<Object, BComponent> needHandles = new HashMap<Object, BComponent>();
        this.progress.constrain(40);
        this.progressMessage("application.deploy.annotate", new String[0]);
        this.transferAnnotations((BComponent)newSource, (BComponent)target, handleMap, needHandles);
        this.progress.fulfill();
        this.progress.constrain(50);
        BComponent[] roots = ApplicationTemplateUtil.findApplicationRoots(newSource, keepInTarget);
        this.progress.fulfill();
        this.progressMessage("application.deploy.relink", new String[0]);
        this.progress.constrain(55);
        this.progress.divide(roots.length);
        for (BComponent root : roots) {
            this.collectComponentsThatNeedHandles(root, needHandles);
            this.progress.cycle();
        }
        this.progress.conquer();
        this.progress.fulfill();
        this.progress.constrain(60);
        if (cx instanceof ReplacingContext) {
            ReplacingContext replacingContext = (ReplacingContext)cx;
            this.progress.divide(needHandles.size());
            Iterator it = needHandles.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                BComponent sourceComponent = (BComponent)entry.getValue();
                Object reusedHandle = replacingContext.removeHandle(this.buildTargetSlotPathOrd(sourceComponent));
                if (reusedHandle != null) {
                    ApplicationTemplateInstaller.setHandle(sourceComponent, reusedHandle);
                    handleMap.put(entry.getKey(), reusedHandle);
                    it.remove();
                }
                this.progress.cycle();
            }
            this.progress.conquer();
        }
        this.progress.fulfill();
        this.progress.constrain(65);
        Object[] newHandles = this.generateHandles(target.getComponentSpace(), needHandles.size());
        this.progress.fulfill();
        this.progress.constrain(70);
        this.progress.divide(needHandles.size());
        int i = 0;
        for (Map.Entry entry : needHandles.entrySet()) {
            Object newHandle = newHandles[i++];
            ApplicationTemplateInstaller.setHandle((BComponent)entry.getValue(), newHandle);
            handleMap.put(entry.getKey(), newHandle);
            this.progress.cycle();
        }
        this.progress.conquer();
        this.progress.fulfill();
        this.progress.constrain(75);
        ApplicationTemplateUtil.purgeBrokenConfigProperties(BTemplateConfig.getConfigForApplication(newSource), handleMap.keySet());
        this.progress.fulfill();
        this.progress.constrain(80);
        this.relink(roots, handleMap);
        this.progress.fulfill();
        this.progressMessage("application.deploy.copying", new String[0]);
        this.progress.constrain(85);
        this.progress.divide(roots.length);
        HashSet<BComponent> parentsOfRoots = new HashSet<BComponent>();
        for (Object root : roots) {
            BComponent newParent = this.moveComponent((BComponent)root, newSource, target, cx);
            if (newParent != null) {
                parentsOfRoots.add(newParent);
            }
            this.progress.cycle();
        }
        this.progress.conquer();
        this.progress.fulfill();
        this.progressMessage("application.deploy.sorting", new String[0]);
        this.progress.constrain(90);
        this.progress.divide(parentsOfRoots.size());
        for (BComponent parent : parentsOfRoots) {
            this.reorderChildrenToMatchSource(parent, target, source);
            this.progress.cycle();
        }
        this.progress.conquer();
        this.progress.fulfill();
        this.progress.divide(roots.length);
        for (Object root : roots) {
            root.start();
            this.progress.cycle();
        }
        this.progress.conquer();
    }

    private BOrd buildTargetSlotPathOrd(BComponent component) {
        ArrayDeque<String> names = new ArrayDeque<String>();
        String name = component.getName();
        while (name != null) {
            names.addFirst(name);
            BComplex parent = component.getParent();
            component = parent instanceof BComponent ? (BComponent)parent : null;
            name = component == null ? null : component.getName();
        }
        return BOrd.make((OrdQuery)new SlotPath("slot", names.toArray(new String[0])));
    }

    public void clearApplicationComponents(BStation target, NameTree keepInTarget, Context cx) {
        this.progress.constrain(20);
        this.progressMessage("application.clear.finding", new String[0]);
        BComponent[] roots = ApplicationTemplateUtil.findApplicationRoots(target, keepInTarget);
        this.progress.fulfill();
        this.progress.divide(roots.length);
        for (BComponent root : roots) {
            assert (root.getPropertyInParent().isDynamic());
            BComponent parent = root.getParent().asComponent();
            Property property = root.getPropertyInParent();
            this.progressMessage("application.clear.removingComponent", root.toPathString());
            parent.setDisplayName(property, null, null);
            parent.remove(property, cx);
            this.progress.cycle();
        }
        this.progress.conquer();
    }

    private void transferAnnotations(BComponent source, BComponent target, Map<Object, Object> handleMap, Map<Object, BComponent> needHandles) {
        for (Property targetProperty : target.getPropertiesArray()) {
            Object sourceHandle;
            BFormat otherDisplayName;
            String name = targetProperty.getName();
            Property sourceProperty = source.getProperty(name);
            if (sourceProperty == null) continue;
            BFormat displayName = source.getDisplayNameFormat(sourceProperty);
            if (!Objects.equals(displayName, otherDisplayName = target.getDisplayNameFormat(targetProperty))) {
                target.setDisplayName(targetProperty, displayName, null);
            }
            BValue targetValue = target.get(targetProperty);
            BValue sourceValue = source.get(sourceProperty);
            if (!targetValue.isComponent() || !sourceValue.isComponent()) continue;
            BComponent sourceComponent = sourceValue.asComponent();
            BComponent targetComponent = targetValue.asComponent();
            BValue sourceAnnotation = sourceComponent.get("wsAnnotation");
            if (sourceAnnotation instanceof BWsAnnotation) {
                BValue targetAnnotation = targetComponent.get("wsAnnotation");
                if (targetAnnotation == null) {
                    targetComponent.add("wsAnnotation", sourceAnnotation);
                } else {
                    targetComponent.set("wsAnnotation", sourceAnnotation);
                }
            }
            if ((sourceHandle = sourceComponent.getHandle()) != null) {
                Object targetHandle = targetComponent.getHandle();
                if (targetHandle == null) {
                    needHandles.put(sourceHandle, targetComponent);
                } else {
                    handleMap.put(sourceHandle, targetHandle);
                }
            }
            this.transferAnnotations(sourceComponent, targetComponent, handleMap, needHandles);
        }
    }

    private Object[] generateHandles(BComponentSpace space, int count) {
        if (space == null || count == 0) {
            return new Object[0];
        }
        return (Object[])space.fw(103, (Object)count, null, null, null);
    }

    private void collectComponentsThatNeedHandles(BComponent component, Map<Object, BComponent> needHandles) {
        Object handle = component.getHandle();
        if (handle != null) {
            needHandles.put(handle, component);
        }
        SlotCursor cursor = component.getProperties();
        while (cursor.nextComponent()) {
            this.collectComponentsThatNeedHandles(cursor.get().asComponent(), needHandles);
        }
    }

    private BComponent moveComponent(BComponent component, BStation sourceStation, BStation targetStation, Context cx) {
        assert (component.getPropertyInParent().isDynamic());
        BComponent newParent = null;
        String name = component.getName();
        BComponent sourceParent = component.getParent().asComponent();
        Stack<String> lineage = ApplicationTemplateInstaller.getLineage(sourceParent, sourceStation);
        BComponent targetParent = ApplicationTemplateInstaller.resolveNamedDescendant(targetStation, lineage);
        if (targetParent != null && targetParent.get(name) == null) {
            Property sourceProperty = component.getPropertyInParent();
            BFormat displayName = sourceParent.getDisplayNameFormat(sourceProperty);
            sourceParent.remove(sourceProperty, Context.skipRemoveCheck);
            this.progress.step(50);
            if (cx == null) {
                cx = new BasicContext(Context.NULL, BFacets.make((String)"niagaraAutoStart", (BIDataValue)BBoolean.FALSE));
            }
            if (!BBoolean.FALSE.equals((Object)cx.getFacet("niagaraAutoStart"))) {
                throw new IllegalStateException("Context must include facet: niagaraAutoStart=FALSE");
            }
            Property targetProperty = targetParent.add(name, (BValue)component, cx);
            targetParent.setDisplayName(targetProperty, displayName, null);
            newParent = targetParent;
            this.progressMessage("application.deploy.added", component.toPathString());
        } else {
            this.progressMessage("application.deploy.notAdded", component.toPathString());
        }
        this.progress.step(100);
        return newParent;
    }

    private void reorderChildrenToMatchSource(BComponent parent, BStation station, BStation sourceStation) {
        if (parent == null) {
            return;
        }
        Stack<String> lineage = ApplicationTemplateInstaller.getLineage(parent, station);
        BComponent sourceParent = ApplicationTemplateInstaller.resolveNamedDescendant(sourceStation, lineage);
        if (sourceParent == null) {
            return;
        }
        Property[] propertiesInOrder = parent.getDynamicPropertiesArray();
        HashSet<Property> propertiesToReorder = new HashSet<Property>(Arrays.asList(propertiesInOrder));
        ArrayList<Property> propertiesInNewOrder = new ArrayList<Property>();
        for (Property sourceProperty : sourceParent.getDynamicPropertiesArray()) {
            String nextPropertyName = sourceProperty.getName();
            Property nextProperty = parent.getProperty(nextPropertyName);
            if (!propertiesToReorder.remove(nextProperty)) continue;
            propertiesInNewOrder.add(nextProperty);
        }
        for (Property nextProperty : propertiesInOrder) {
            if (!propertiesToReorder.remove(nextProperty)) continue;
            propertiesInNewOrder.add(nextProperty);
        }
        parent.reorder(propertiesInNewOrder.toArray(new Property[0]));
    }

    private static BComponent resolveNamedDescendant(BStation station, Stack<String> lineage) {
        BStation descendant = station;
        while (!lineage.empty()) {
            String propertyName = lineage.pop();
            Property property = descendant.getProperty(propertyName);
            if (property == null && descendant.isComponent()) {
                property = descendant.asComponent().add(propertyName, (BValue)new BUnrestrictedFolder());
            }
            if (property == null) {
                return null;
            }
            BValue candidate = descendant.get(property);
            if (!candidate.isComponent()) {
                return null;
            }
            descendant = candidate.asComponent();
        }
        if (!descendant.isComponent()) {
            return null;
        }
        return descendant.asComponent();
    }

    private static Stack<String> getLineage(BComponent component, BStation station) {
        Stack<String> names = new Stack<String>();
        String nextName = component.getName();
        for (BComponent next = component; next != station && nextName != null; next = next.getParent()) {
            names.push(nextName);
            nextName = next == null ? null : next.getName();
        }
        return names;
    }

    private void progressMessage(String lexKey, String ... args) {
        String[] newArgs = Arrays.copyOf(args, args.length + 1);
        newArgs[args.length] = String.format("%3d", this.progress.get());
        this.progress.message(lexKey, newArgs);
    }

    private static void setHandle(BComponent component, Object handle) {
        ((ComponentSlotMap)component.fw(1)).setHandle(handle);
    }

    private void relink(BComponent[] components, Map<Object, Object> handleMap) {
        for (BComponent component : components) {
            this.relink((BComplex)component, handleMap);
        }
    }

    private void relink(BComplex obj, Map<Object, Object> handleMap) {
        for (Property prop : obj.getPropertiesArray()) {
            if (prop.getTypeAccess() != 7) continue;
            BValue kid = obj.get(prop);
            if (kid instanceof BLink) {
                this.relink((BLink)kid, handleMap);
                continue;
            }
            if (kid instanceof BRelation) {
                this.relink((BRelation)kid, handleMap);
                continue;
            }
            if (kid instanceof BOrd) {
                BOrd newOrd = this.relink((BOrd)kid, handleMap);
                if (newOrd == null) continue;
                obj.set(prop, (BValue)newOrd);
                continue;
            }
            if (!(kid instanceof BComplex)) continue;
            this.relink((BComplex)kid, handleMap);
        }
    }

    private BOrd relink(BOrd ord, Map<Object, Object> handleMap) {
        String ordStr = ord.toString();
        if (!ordStr.startsWith("h:")) {
            return null;
        }
        String oldHandle = ordStr.substring(2).trim();
        Object newHandle = handleMap.get(oldHandle);
        BOrd newOrd = newHandle == null ? BOrd.make((String)("h:" + ComponentSlotMap.unswizzle((String)oldHandle))) : BOrd.make((String)("h:" + newHandle));
        return newOrd;
    }

    private void relink(BLink link, Map<Object, Object> handleMap) {
        String ord = link.getSourceOrd().toString();
        if (!ord.startsWith("h:")) {
            return;
        }
        String oldHandle = ord.substring(2).trim();
        Object newHandle = handleMap.get(oldHandle);
        if (newHandle == null) {
            BComponent parent = (BComponent)link.getParent();
            parent.remove(link.getPropertyInParent());
            String targetSlotName = link.getTargetSlotName();
            Slot targetSlot = parent.getSlot(targetSlotName);
            if (targetSlot instanceof Property) {
                Property targetProp = (Property)targetSlot;
                parent.set(targetProp, targetProp.getDefaultValue().newCopy());
            }
        } else {
            BOrd newOrd = BOrd.make((String)("h:" + newHandle));
            link.setSourceOrd(newOrd);
        }
    }

    private void relink(BRelation relation, Map<Object, Object> handleMap) {
        String ord = relation.getSourceOrd().toString();
        if (!ord.startsWith("h:")) {
            return;
        }
        String oldHandle = ord.substring(2).trim();
        Object newHandle = handleMap.get(oldHandle);
        if (newHandle == null) {
            BComponent parent = (BComponent)relation.getParent();
            parent.remove(relation.getPropertyInParent());
        } else {
            BOrd newOrd = BOrd.make((String)("h:" + newHandle));
            relation.setSourceOrd(newOrd);
        }
    }

    public void clearApplicationFiles(BStation target, String[] fileKeepers) throws IOException {
        BDirectory stationHomeDir = this.getStationHomeDir(target);
        BDirectory stationAceDir = this.getStationDir(target, new FilePath("^^ace"));
        if (stationHomeDir != null) {
            if (stationAceDir != null) {
                this.progress.constrain(75);
            }
            HashSet<String> keepTheseFiles = new HashSet<String>(Arrays.asList(fileKeepers));
            this.clearDirectory(stationHomeDir, keepTheseFiles);
            if (stationAceDir != null) {
                this.progress.fulfill();
            }
        }
        if (stationAceDir != null) {
            this.clearDirectory(stationAceDir);
        }
    }

    public void installApplicationFiles(BNtplFile applicationFile, BStation target) throws IOException {
        BDirectory[] sourceDirectories = applicationFile.getStationFileDirectories();
        BFileSpace targetFileSpace = this.getStationFileSpace(target);
        if (targetFileSpace == null) {
            this.progressMessage("application.files.noTarget", new String[0]);
            return;
        }
        this.copyApplicationFiles(sourceDirectories, targetFileSpace, new FilePath("^^"));
    }

    private void copyApplicationFiles(BDirectory[] sourceDirectories, BFileSpace targetSpace, FilePath targetPath) {
        if (sourceDirectories.length == 0) {
            return;
        }
        this.progress.divide(sourceDirectories.length);
        for (BDirectory sourceDirectory : sourceDirectories) {
            FilePath nextPath = targetPath.merge(sourceDirectory.getFileName());
            if (nextPath.equals((Object)new FilePath("^^shared"))) {
                nextPath = new FilePath("^");
            }
            this.copyApplicationFiles(sourceDirectory, targetSpace, nextPath);
            this.progress.cycle();
        }
        this.progress.conquer();
    }

    private void copyApplicationFiles(BDirectory sourceDirectory, BFileSpace targetSpace, FilePath targetPath) {
        BIFile[] files = sourceDirectory.listFiles();
        if (files.length == 0) {
            return;
        }
        this.progress.divide(files.length);
        for (BIFile file : files) {
            FilePath filePath = targetPath.merge(file.getFileName());
            if (file instanceof BDirectory) {
                this.copyApplicationFiles((BDirectory)file, targetSpace, filePath);
            } else {
                boolean copyFailed = false;
                try {
                    BIFile newFile = targetSpace.makeFile(targetPath.merge(file.getFileName()));
                    BajaFileUtil.pipe((BIFile)file, (BIFile)newFile);
                }
                catch (IOException e) {
                    copyFailed = true;
                    this.progressMessage("application.files.copyFailed", filePath.toString(), e.toString());
                }
                if (!copyFailed) {
                    this.progressMessage("application.files.copied", filePath.toString());
                }
            }
            this.progress.cycle();
        }
        this.progress.conquer();
    }

    private BFileSpace getStationFileSpace(BStation target) {
        BDirectory stationHomeDir = this.getStationHomeDir(target);
        if (stationHomeDir == null) {
            return null;
        }
        return stationHomeDir.getFileSpace();
    }

    private BDirectory getStationHomeDir(BStation target) {
        return this.getStationDir(target, new FilePath("^"));
    }

    private BDirectory getStationDir(BStation target, FilePath path) {
        BOrd directoryOrd = BOrd.make((OrdQuery)path);
        BDirectory directory = null;
        try {
            directory = (BDirectory)directoryOrd.get((BObject)target);
        }
        catch (UnresolvedException unresolvedException) {
            // empty catch block
        }
        return directory;
    }

    private void clearDirectory(BDirectory directory) {
        this.clearDirectory(directory, null);
    }

    private boolean clearDirectory(BDirectory directory, Set<String> keepTheseFiles) {
        if (directory == null) {
            return true;
        }
        BIFile[] files = directory.listFiles();
        if (files.length == 0) {
            return true;
        }
        boolean allFilesRemoved = true;
        this.progress.divide(files.length);
        for (BIFile file : files) {
            String filePath = file.getFilePath().toString();
            boolean isDirectory = file instanceof BDirectory;
            boolean allowedToRemove = keepTheseFiles == null || !keepTheseFiles.contains(filePath);
            boolean bl = allFilesRemoved = allFilesRemoved && allowedToRemove;
            if (allowedToRemove && isDirectory) {
                BDirectory childDir = (BDirectory)file;
                allowedToRemove = this.clearDirectory(childDir, keepTheseFiles);
                boolean bl2 = allFilesRemoved = allFilesRemoved && allowedToRemove;
            }
            if (allowedToRemove) {
                allowedToRemove = false;
                try {
                    file.delete();
                    allowedToRemove = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                boolean bl3 = allFilesRemoved = allFilesRemoved && allowedToRemove;
                if (!isDirectory) {
                    this.progressMessage(allowedToRemove ? "application.files.removed" : "application.files.notRemoved", filePath);
                }
            }
            this.progress.cycle();
        }
        this.progress.conquer();
        return allFilesRemoved;
    }

    private static Map<String, BValue> getApplicationProperties(BStation station) {
        HashMap<String, BValue> rootProps = new HashMap<String, BValue>();
        BApplicationService[] serviceArray = (BApplicationService[])station.getServices().getChildren(BApplicationService.class);
        if (serviceArray == null || serviceArray.length != 1) {
            throw new IllegalStateException();
        }
        BApplicationService applicationService = serviceArray[0];
        BTemplateConfig config = applicationService.getConfiguration();
        for (Property property : config.getProperties()) {
            BValue curVal;
            if ((config.getFlags((Slot)property) & 2) != 0 || property.isFrozen() || (curVal = config.get(property)) instanceof BPxView || curVal instanceof BLink || curVal instanceof BConfigBinding || curVal instanceof BComponent) continue;
            rootProps.put(property.getName(), curVal);
        }
        return rootProps;
    }

    private static void setApplicationProperties(BStation station, Map<String, BValue> applicationProperties) {
        BApplicationService[] serviceArray = (BApplicationService[])station.getServices().getChildren(BApplicationService.class);
        if (serviceArray == null || serviceArray.length != 1) {
            throw new IllegalStateException();
        }
        BApplicationService applicationService = serviceArray[0];
        BTemplateConfig config = applicationService.getConfiguration();
        for (Property property : config.getProperties()) {
            BValue bValue = applicationProperties.get(property.getName());
            if (bValue == null) continue;
            config.set(property, bValue.newCopy(true));
        }
    }

    private static NameTree getMissingOptionalComponents(BStation station, Array<BOrd> optionalOrds) {
        BOrdList missingOptionalOrds = BOrdList.DEFAULT;
        for (BOrd optionalComponentOrd : optionalOrds) {
            OrdQuery[] queries = optionalComponentOrd.parse();
            SlotPath path = (SlotPath)queries[queries.length - 1];
            String[] names = path.getNames();
            StringBuilder friendlyName = new StringBuilder(names[1]);
            for (int i = 2; i < names.length; ++i) {
                friendlyName.append('/');
                friendlyName.append(names[i]);
            }
            BOrd searchForOrd = BOrd.make((OrdQuery)new SlotPath(friendlyName.toString()));
            BOrdList searchForList = BOrdList.make((BOrd)searchForOrd);
            NameTree optionalNameTree = ApplicationTemplateUtil.makeNameTree(searchForList);
            BComponent[] foundComponents = ApplicationTemplateUtil.findComponents((BComponent)station, optionalNameTree);
            if (foundComponents.length != 0) continue;
            missingOptionalOrds = BOrdList.add((BOrdList)missingOptionalOrds, (BOrd)searchForOrd);
        }
        return ApplicationTemplateUtil.makeNameTree(missingOptionalOrds);
    }

    @Override
    public void close() {
        if (this.applicationFile != null) {
            this.applicationFile.close();
        }
    }
}

