/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platIEEE8021X;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.platIEEE8021X.IEEE8021XUtil;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.security.IX509CertificateEntry;

public class KeyStoreCertInfo {
    private String alias;
    private IX509CertificateEntry cert;
    private boolean isDateInvalid;
    private boolean isSelfSigned;
    public static final KeyStoreCertInfo BLANK_KEY_CERTIFICATE = new KeyStoreCertInfo();
    public static final KeyStoreCertInfo[] EMPTY_KEY_STORE_LIST = new KeyStoreCertInfo[0];
    public static final String CLIENT_AUTH_USAGE = "1.3.6.1.5.5.7.3.2";
    public static final int BLANK_KEY_CERTIFICATE_INDEX = 0;
    public static final Comparator<KeyStoreCertInfo> KEY_STORE_CERT_INFO_COMPARATOR = (certA, certB) -> {
        String alias1 = certA.toString();
        String alias2 = certB.toString();
        return alias1.compareTo(alias2);
    };
    private static final Logger LOG = Logger.getLogger("platIEEE8021X");

    public static KeyStoreCertInfo[] list(ICoreKeyStore keyStore) throws Exception {
        return KeyStoreCertInfo.make(keyStore);
    }

    public static KeyStoreCertInfo[] make(ICoreKeyStore keyStore) throws Exception {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Making new KeyStoreCertInfo list from provided key store");
        }
        if (keyStore == null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Provided key store is null, returning empty list");
            }
            return EMPTY_KEY_STORE_LIST;
        }
        ArrayList<KeyStoreCertInfo> certsAsArray = new ArrayList<KeyStoreCertInfo>();
        for (IX509CertificateEntry currentCertificateEntry : keyStore.getCertificateEntries()) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Considering key store certificate entry '" + currentCertificateEntry.getAlias() + "' for IEEE 802.1X usage...");
            }
            X509Certificate[] certificates = currentCertificateEntry.getCertificates();
            boolean clientAuthentication = false;
            boolean isSelfSigned = false;
            boolean isDateInvalid = false;
            for (X509Certificate current : certificates) {
                List<String> keyUsage = current.getExtendedKeyUsage();
                if (keyUsage != null) {
                    for (String usage : keyUsage) {
                        if (!CLIENT_AUTH_USAGE.equalsIgnoreCase(usage)) continue;
                        clientAuthentication = true;
                        break;
                    }
                }
                if (NX509Certificate.make((X509Certificate)current).isSelfSigned()) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Certificate entry '" + currentCertificateEntry.getAlias() + "', determined to be self signed");
                    }
                    isSelfSigned = true;
                }
                try {
                    current.checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Certificate entry '" + currentCertificateEntry.getAlias() + "', determined to have invalid date (" + e + ")");
                    }
                    isDateInvalid = true;
                }
            }
            if (!clientAuthentication) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Skipping certificate entry '" + currentCertificateEntry.getAlias() + "', does not contain 'Client Authentication' key usage");
                continue;
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Adding key store certificate entry '" + currentCertificateEntry.getAlias() + "' for 802.1X usage (isSelfSigned = " + isSelfSigned + ", isDateInvalid = " + isDateInvalid + ")");
            }
            certsAsArray.add(new KeyStoreCertInfo(currentCertificateEntry, isDateInvalid, isSelfSigned));
        }
        return certsAsArray.toArray(EMPTY_KEY_STORE_LIST);
    }

    public KeyStoreCertInfo() {
    }

    public KeyStoreCertInfo(IX509CertificateEntry certificate, boolean isDateInvalid, boolean isSelfSigned) {
        this.cert = certificate;
        this.alias = certificate.getAlias();
        this.isDateInvalid = isDateInvalid;
        this.isSelfSigned = isSelfSigned;
    }

    public String toString() {
        if (this == BLANK_KEY_CERTIFICATE) {
            return IEEE8021XUtil.NO_CERTIFICATE;
        }
        return this.alias;
    }

    public String alias() {
        return this.alias;
    }

    public IX509CertificateEntry cert() {
        return this.cert;
    }

    public boolean dateInvalid() {
        return this.isDateInvalid;
    }

    public boolean selfSigned() {
        return this.isSelfSigned;
    }
}

