/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.playback;

import com.tridium.videoDriver.enums.BPlaybackSpeedEnum;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.ui.playback.BPlaybackButton;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;

public class PlaybackGroup
extends ToggleCommandGroup<ToggleCommand> {
    protected final BVideoPlayback videoPlayback;

    public PlaybackGroup(BVideoPlayback videoPlaybackView) {
        this.videoPlayback = videoPlaybackView;
    }

    protected BPlaybackButton getPlaybackButton(ToggleCommand command) {
        if (command == this.videoPlayback.rwdCmd) {
            return this.videoPlayback.rwdButton;
        }
        if (command == this.videoPlayback.ffwdCmd) {
            return this.videoPlayback.ffwdButton;
        }
        if (command == this.videoPlayback.liveCmd) {
            return this.videoPlayback.liveButton;
        }
        if (command == this.videoPlayback.srwdCmd) {
            return this.videoPlayback.srwdButton;
        }
        if (command == this.videoPlayback.sfwdCmd) {
            return this.videoPlayback.sfwdButton;
        }
        if (command == this.videoPlayback.playCmd) {
            return this.videoPlayback.playButton;
        }
        if (command == this.videoPlayback.pauseCmd) {
            return this.videoPlayback.pauseButton;
        }
        throw new BajaRuntimeException("Not implemented for command " + command);
    }

    protected void denySelection() {
        this.videoPlayback.changePlaybackControlDenied();
    }

    protected void allowSelection(BPlaybackTypeEnum newPlaybackTypeEnum, BPlaybackSpeedEnum speed) {
        this.videoPlayback.changePlaybackAllowed(this.getSelected(), newPlaybackTypeEnum, speed, false);
    }

    public void selected(ToggleCommand c) {
        if (this.videoPlayback.isRunning()) {
            BPlaybackButton playbackButton = this.getPlaybackButton(c);
            int intensity = playbackButton.getIntensity();
            if (intensity < 0) {
                throw new IllegalStateException("MultiSpeedToggleCommand command.getIntensity() should not be less than zero.");
            }
            if (intensity == 0) {
                return;
            }
            int playbackSpeedOrd = playbackButton.getIntensity() - 1;
            if (playbackSpeedOrd > 9) {
                this.denySelection();
            } else {
                BPlaybackSpeedEnum speed = BPlaybackSpeedEnum.make((int)playbackSpeedOrd);
                if (c == this.videoPlayback.rwdCmd) {
                    this.allowSelection(BPlaybackTypeEnum.fastRew, speed);
                } else if (c == this.videoPlayback.ffwdCmd) {
                    if (this.videoPlayback.mostRecentValidSelection == this.videoPlayback.liveCmd) {
                        this.denySelection();
                    } else {
                        this.allowSelection(BPlaybackTypeEnum.fastFwd, speed);
                    }
                } else if (c == this.videoPlayback.playCmd) {
                    this.allowSelection(BPlaybackTypeEnum.play, speed);
                } else if (c == this.videoPlayback.srwdCmd) {
                    this.allowSelection(BPlaybackTypeEnum.slowRew, speed);
                } else if (c == this.videoPlayback.sfwdCmd) {
                    if (this.videoPlayback.mostRecentValidSelection == this.videoPlayback.liveCmd) {
                        this.denySelection();
                    } else {
                        this.allowSelection(BPlaybackTypeEnum.slowFwd, speed);
                    }
                } else if (c == this.videoPlayback.liveCmd) {
                    if (playbackButton.getIntensity() == 1 && this.videoPlayback.mostRecentValidSelection != this.videoPlayback.liveCmd) {
                        this.allowSelection(BPlaybackTypeEnum.live, speed);
                    }
                } else if (c == this.videoPlayback.pauseCmd) {
                    if (playbackButton.getIntensity() == 1) {
                        this.allowSelection(BPlaybackTypeEnum.pause, speed);
                    } else {
                        this.denySelection();
                    }
                } else {
                    throw new BajaRuntimeException("Video player selection not implemented: " + c);
                }
            }
        }
    }
}

