/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui.camera;

import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.event.BVideoEvent;
import com.tridium.videoDriver.event.BVideoEventRecall;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BVideoEventChooser
extends BDialog {
    @Generated
    public static final Type TYPE = Sys.loadType(BVideoEventChooser.class);
    public Command pageUpCmd = new Command((BWidget)this, LEX, "VideoEventChooser.PageUp"){

        public CommandArtifact doInvoke() throws Exception {
            BVideoEventChooser.this.doPageUp();
            return null;
        }
    };
    public Command pageDownCmd = new Command((BWidget)this, LEX, "VideoEventChooser.PageDown"){

        public CommandArtifact doInvoke() throws Exception {
            BVideoEventChooser.this.doPageDown();
            return null;
        }
    };
    protected Command pageHomeCmd = new Command((BWidget)this, LEX, "VideoEventChooser.PageHome"){

        public CommandArtifact doInvoke() throws Exception {
            BVideoEventChooser.this.doPageHome();
            return null;
        }
    };
    public Command seekMoreCmd = new Command((BWidget)this, LEX, "VideoEventChooser.SeekMore"){

        public CommandArtifact doInvoke() throws Exception {
            BVideoEventChooser.this.doSeekMore();
            return null;
        }
    };
    public Command selectCmd = new Command((BWidget)this, LEX, "VideoEventChooser.Select"){

        public CommandArtifact doInvoke() throws Exception {
            BVideoEventChooser.this.doSelect();
            BVideoEventChooser.this.close();
            return null;
        }
    };
    public Command cancelCmd = new Command((BWidget)this, (Lexicon)UiLexicon.bajaui(), "commands.close"){

        public CommandArtifact doInvoke() throws Exception {
            BVideoEventChooser.this.doCancel();
            return null;
        }
    };
    private static final BIcon icon = BIcon.make((String)"module://videoDriver/icons/eventsExt.png");
    public static final Lexicon LEX = Lexicon.make(BVideoEventChooser.class);
    protected BVideoEvent[] eventTableArray;
    protected BEdgePane mainEdgePane;
    protected BTable eventTable;
    protected BVideoEventRecall driverEventRecallComponent;
    protected EventPlayback eventPlaybackView;
    protected BAbsTime videoEventListEpicenter = BAbsTime.make();
    protected BPane infoPane;
    protected BLabel infoLabel;
    protected BAbsTime mostRecentEpicenter = BAbsTime.NULL;
    protected String timeIndexHeader = LEX.getText("EventChooserTable.Header.TimeIndex");
    protected String msgTextHeader = LEX.getText("EventChooserTable.Header.MsgText");
    protected String LOADING_EVENTS = LEX.getText("VideoEventChooser.LoadingEvents");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BVideoEventChooser() {
    }

    public BVideoEventChooser(BWidget parentWidget, BVideoEventRecall driverEventRecallComponent, EventPlayback eventPlaybackView) {
        super(parentWidget, LEX.getText("VideoEventChooser.title"), true);
        this.driverEventRecallComponent = driverEventRecallComponent;
        this.eventPlaybackView = eventPlaybackView;
        this.videoEventListEpicenter = BAbsTime.now();
        this.drawEventChooser();
    }

    protected void drawToolbarPane() {
        BGridPane gp = new BGridPane(10);
        BButton pageUpButton = new BButton(this.pageUpCmd, false, true);
        pageUpButton.setButtonStyle(BButtonStyle.toolBar);
        BButton pageDownButton = new BButton(this.pageDownCmd, false, true);
        pageDownButton.setButtonStyle(BButtonStyle.toolBar);
        BButton seekMoreButton = new BButton(this.seekMoreCmd, false, true);
        seekMoreButton.setButtonStyle(BButtonStyle.toolBar);
        BButton pageHomeButton = new BButton(this.pageHomeCmd, false, true);
        pageHomeButton.setButtonStyle(BButtonStyle.toolBar);
        gp.add("pageLabel", (BValue)new BLabel(LEX.getText("VideoEventChooser.Page")));
        gp.add("pageUp", (BValue)pageUpButton);
        gp.add("pageDown", (BValue)pageDownButton);
        gp.add("pageHome", (BValue)pageHomeButton);
        gp.add("seekMore", (BValue)seekMoreButton);
        this.mainEdgePane.setTop((BWidget)new BBorderPane((BWidget)gp, BBorder.groove, BInsets.make((double)1.0)));
    }

    protected void drawEventChooser() {
        this.mainEdgePane = new BEdgePane();
        this.eventTable = new BTable((TableModel)new EventChooserTableModel(), (TableController)new EventChooserTableController());
        this.eventTable.setSelection((TableSelection)new EventChooserTableSelection());
        this.infoLabel = new BLabel(this.LOADING_EVENTS);
        BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.infoLabel));
        scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        scrollPane.setViewportBackground(Theme.button().getControlBackground());
        this.infoPane = new BBorderPane((BWidget)scrollPane);
        this.mainEdgePane.setCenter((BWidget)this.infoPane);
        this.drawToolbarPane();
        this.enableTools(false);
        BGridPane gp1 = new BGridPane(2);
        gp1.add(null, (BValue)new BButton(this.selectCmd));
        gp1.add(null, (BValue)new BButton(this.cancelCmd));
        this.selectCmd.setEnabled(false);
        BEdgePane edgePane2 = new BEdgePane();
        edgePane2.setCenter((BWidget)new BBorderPane((BWidget)this.mainEdgePane));
        edgePane2.setBottom((BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)gp1, BBorder.groove), BInsets.make((double)0.0, (double)10.0, (double)10.0, (double)10.0)));
        this.setContent((BWidget)edgePane2);
    }

    public void updateEventListFailed(String faultCause) {
        this.enableTools(false);
        this.pageHomeCmd.setEnabled(true);
        this.seekMoreCmd.setEnabled(true);
        this.infoLabel.setText(LEX.getText("VideoEventChooser.LoadingEventsError", new Object[]{faultCause}));
        this.mainEdgePane.setCenter((BWidget)this.infoPane);
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    public void updateEventList(BVideoEvent[] updatedEvents) {
        boolean wasEmpty;
        boolean bl = wasEmpty = this.eventTableArray == null;
        if (this.mainEdgePane.getCenter() != this.eventTable) {
            this.mainEdgePane.setCenter((BWidget)this.eventTable);
        }
        this.eventTableArray = updatedEvents;
        if (updatedEvents != null && updatedEvents.length > 0) {
            this.eventTable.getModel().sortByColumn(0, false);
            this.eventTable.getModel().updateTable();
        }
        if (wasEmpty) {
            this.setScreenSizeToPreferredSize();
            this.setBoundsCenteredOnScreen();
        }
        this.enableTools(true);
    }

    protected void enableTools(boolean enabled) {
        this.pageDownCmd.setEnabled(enabled);
        this.pageUpCmd.setEnabled(enabled);
        this.seekMoreCmd.setEnabled(enabled);
        this.pageHomeCmd.setEnabled(enabled);
        if (enabled) {
            if (this.eventTable != null && this.eventTable.getSelection() != null) {
                this.selectCmd.setEnabled(this.eventTable.getSelection().getRow() != -1);
            }
        } else {
            this.selectCmd.setEnabled(false);
        }
    }

    protected void doPageHome() {
        this.enableTools(false);
        this.infoLabel.setText(this.pageHomeCmd.getLabel() + " - " + this.LOADING_EVENTS);
        this.mainEdgePane.setCenter((BWidget)this.infoPane);
        this.retrieveDriverEvents(BAbsTime.now(), -20);
    }

    protected void doPageUp() {
        BAbsTime epicenter = this.mostRecentEpicenter;
        if (this.eventTableArray != null && this.eventTableArray.length > 0) {
            BVideoEvent[] eventTableArraySafe = this.eventTableArray;
            BVideoEvent latestItem = eventTableArraySafe[0];
            if (eventTableArraySafe.length > 1) {
                for (int i = 1; i < eventTableArraySafe.length; ++i) {
                    if (!eventTableArraySafe[i].getTimestamp().isAfter(latestItem.getTimestamp())) continue;
                    latestItem = eventTableArraySafe[i];
                }
            }
            if (latestItem != null) {
                epicenter = latestItem.getTimestamp();
            }
        }
        if (epicenter != null) {
            this.enableTools(false);
            this.infoLabel.setText(this.pageUpCmd.getLabel() + " - " + this.LOADING_EVENTS);
            this.mainEdgePane.setCenter((BWidget)this.infoPane);
            this.retrieveDriverEvents(epicenter, 20);
        }
    }

    protected void doPageDown() {
        BAbsTime epicenter = this.mostRecentEpicenter;
        if (this.eventTableArray != null && this.eventTableArray.length > 0) {
            BVideoEvent[] eventTableArraySafe = this.eventTableArray;
            BVideoEvent earliestItem = eventTableArraySafe[0];
            if (eventTableArraySafe.length > 1) {
                for (int i = 1; i < eventTableArraySafe.length; ++i) {
                    if (!eventTableArraySafe[i].getTimestamp().isBefore(earliestItem.getTimestamp())) continue;
                    earliestItem = eventTableArraySafe[i];
                }
            }
            if (earliestItem != null) {
                epicenter = earliestItem.getTimestamp();
            }
        }
        if (epicenter != null) {
            this.enableTools(false);
            this.infoLabel.setText(this.pageDownCmd.getLabel() + " - " + this.LOADING_EVENTS);
            this.mainEdgePane.setCenter((BWidget)this.infoPane);
            this.retrieveDriverEvents(epicenter, -20);
        }
    }

    protected void retrieveDriverEvents(BAbsTime timestamp, int numEvents) {
        if (timestamp != null) {
            this.mostRecentEpicenter = timestamp;
            this.eventPlaybackView.retrieveDriverEvents(timestamp, numEvents);
        }
    }

    protected void doSelect() {
        int selectedRowIndex = this.eventTable.getSelection().getRow();
        if (selectedRowIndex != -1 && selectedRowIndex < this.eventTableArray.length) {
            this.eventPlaybackView.playEvent(this.eventTableArray[selectedRowIndex]);
        }
    }

    protected void doCancel() {
        this.close();
    }

    protected void doSeekMore() {
        BAbsTime playFrom;
        BAbsTime timeIndex;
        try {
            timeIndex = this.videoEventListEpicenter;
        }
        catch (Exception e) {
            timeIndex = BAbsTime.now();
        }
        try {
            playFrom = (BAbsTime)BWbFieldEditor.dialog((BWidget)this, (String)LEX.getText("VideoPlaybackView.PlayFromTimeIndex.title"), (BObject)timeIndex, (Context)BVideoEvent.EVENT_TIME_STAMP_TO_STRING_FACETS);
            playFrom = playFrom.subtract(BRelTime.makeSeconds((int)1));
        }
        catch (Exception e) {
            playFrom = BAbsTime.NULL;
        }
        if (playFrom != null && !playFrom.isNull()) {
            this.enableTools(false);
            this.infoLabel.setText(this.seekMoreCmd.getLabel() + " - " + this.LOADING_EVENTS);
            this.mainEdgePane.setCenter((BWidget)this.infoPane);
            this.retrieveDriverEvents(playFrom, 20);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public static void main(String[] argv) {
        BVideoEventChooser c = new BVideoEventChooser(null, null, null);
        c.open();
    }

    protected class EventChooserTableModel
    extends TableModel {
        protected EventChooserTableModel() {
        }

        public BImage getRowIcon(int row) {
            if (BVideoEventChooser.this.eventTableArray != null && row < BVideoEventChooser.this.eventTableArray.length) {
                return BImage.make((BIcon)BVideoEventChooser.this.eventTableArray[row].getIcon());
            }
            return BImage.NULL;
        }

        public int getRowCount() {
            if (BVideoEventChooser.this.eventTableArray != null) {
                return BVideoEventChooser.this.eventTableArray.length;
            }
            return 0;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return BVideoEventChooser.this.timeIndexHeader;
            }
            if (col == 1) {
                return BVideoEventChooser.this.msgTextHeader;
            }
            return "";
        }

        public Object getValueAt(int row, int col) {
            if (BVideoEventChooser.this.eventTableArray != null && row < BVideoEventChooser.this.eventTableArray.length) {
                BVideoEvent videoEvent = BVideoEventChooser.this.eventTableArray[row];
                if (col == 0) {
                    return videoEvent.getTimestamp().toString((Context)BVideoEvent.EVENT_TIME_STAMP_TO_STRING_FACETS);
                }
                if (col == 1) {
                    return videoEvent.getDescription();
                }
                return "";
            }
            return "";
        }

        public boolean isColumnSortable(int col) {
            return col == 0 || col == 1;
        }

        public void sortByColumn(int col, boolean ascending) {
            if (BVideoEventChooser.this.eventTableArray != null) {
                Object[] keys;
                if (col == 0) {
                    keys = new BAbsTime[BVideoEventChooser.this.eventTableArray.length];
                    for (int i = 0; i < BVideoEventChooser.this.eventTableArray.length; ++i) {
                        keys[i] = BVideoEventChooser.this.eventTableArray[i].getTimestamp();
                    }
                } else if (col == 1) {
                    keys = new String[BVideoEventChooser.this.eventTableArray.length];
                    for (int i = 0; i < BVideoEventChooser.this.eventTableArray.length; ++i) {
                        keys[i] = BVideoEventChooser.this.eventTableArray[i].getDescription();
                    }
                } else {
                    throw new UnsupportedOperationException();
                }
                SortUtil.sort((Object[])keys, (Object[])BVideoEventChooser.this.eventTableArray, (boolean)ascending);
            }
        }
    }

    protected class EventChooserTableController
    extends TableController {
        protected EventChooserTableController() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BVideoEventChooser.this.doSelect();
            BVideoEventChooser.this.close();
        }
    }

    protected class EventChooserTableSelection
    extends TableSelection {
        protected EventChooserTableSelection() {
        }

        public void updateTable() {
            super.updateTable();
            BVideoEventChooser.this.selectCmd.setEnabled(this.getRow() != -1);
        }
    }

    public static interface EventPlayback {
        public void playEvent(BVideoEvent var1);

        public void retrieveDriverEvents(BAbsTime var1, int var2);
    }
}

