/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.ui;

import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.BIVideoPlayer;
import com.tridium.videoDriver.camera.control.BPlaybackControlInfo;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.enums.BVideoAspectRatioEnum;
import com.tridium.videoDriver.enums.BVideoCompressionEnum;
import com.tridium.videoDriver.enums.BVideoFrameRateEnum;
import com.tridium.videoDriver.enums.BVideoResolutionEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamPaneForView;
import com.tridium.videoDriver.ui.playback.VideoPlaybackSession;
import com.tridium.videoDriver.ui.videoStream.IVideoImagePainter;
import com.tridium.videoDriver.ui.videoStream.decoder.VideoMultistreamDecoder;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="showTimeIndex", type="boolean", defaultValue="true"), @NiagaraProperty(name="throttleRefreshRate", type="int", defaultValue="50", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(25), BFacets.MAX, BInteger.make(1000), BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="videoStreamFox", type="BFoxVideoStreamEnum", defaultValue="BFoxVideoStreamEnum.inherit"), @NiagaraProperty(name="backgroundColor", type="BColor", defaultValue="BColor.black"), @NiagaraProperty(name="aspectRatio", type="BVideoAspectRatioEnum", defaultValue="BVideoAspectRatioEnum.inherit_from_stream"), @NiagaraProperty(name="resolution", type="BVideoResolutionEnum", defaultValue="BVideoResolutionEnum.low"), @NiagaraProperty(name="frameRate", type="BVideoFrameRateEnum", defaultValue="BVideoFrameRateEnum.low"), @NiagaraProperty(name="compression", type="BVideoCompressionEnum", defaultValue="BVideoCompressionEnum.medium"), @NiagaraProperty(name="streamFacets", type="BFacets", defaultValue="BFacets.DEFAULT")})
@NiagaraAction(name="changePlaybackControl", parameterType="BPlaybackControlInfo", defaultValue="new BPlaybackControlInfo()")
@NiagaraTopic(name="reloadVideo", eventType="BPlaybackParams")
public class BVideoPlayer
extends BTransferWidget
implements BIVideoPlayer {
    @Generated
    public static final Property showTimeIndex = BVideoPlayer.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property throttleRefreshRate = BVideoPlayer.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)25), (String)"max", (BIDataValue)BInteger.make((int)1000), (String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    @Generated
    public static final Property videoStreamFox = BVideoPlayer.newProperty((int)0, (BValue)BFoxVideoStreamEnum.inherit, null);
    @Generated
    public static final Property backgroundColor = BVideoPlayer.newProperty((int)0, (BValue)BColor.black, null);
    @Generated
    public static final Property aspectRatio = BVideoPlayer.newProperty((int)0, (BValue)BVideoAspectRatioEnum.inherit_from_stream, null);
    @Generated
    public static final Property resolution = BVideoPlayer.newProperty((int)0, (BValue)BVideoResolutionEnum.low, null);
    @Generated
    public static final Property frameRate = BVideoPlayer.newProperty((int)0, (BValue)BVideoFrameRateEnum.low, null);
    @Generated
    public static final Property compression = BVideoPlayer.newProperty((int)0, (BValue)BVideoCompressionEnum.medium, null);
    @Generated
    public static final Property streamFacets = BVideoPlayer.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    @Generated
    public static final Action changePlaybackControl = BVideoPlayer.newAction((int)0, (BValue)new BPlaybackControlInfo(), null);
    @Generated
    public static final Topic reloadVideo = BVideoPlayer.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BVideoPlayer.class);
    public int myId = vidId++;
    static int vidId = 0;
    protected static BLabel messageLabel = new BLabel();
    protected static BBorderPane messageLabelInsideBorder = new BBorderPane((BWidget)messageLabel, BBorder.none);
    protected BLabel timeIndexLabel = new BLabel();
    protected BBorderPane timeIndexLabelInsideBorder = new BBorderPane((BWidget)this.timeIndexLabel, BBorder.none);
    public static final BBrush TIME_INDEX_TEXT_BRUSH = BBrush.makeSolid((BColor)BColor.make((int)255, (int)255, (int)255, (int)127));
    public static final BBrush TIME_INDEX_BACKGROUND_BRUSH = BBrush.makeSolid((BColor)BColor.make((int)0, (int)0, (int)0, (int)127));
    public static final BBrush MESSAGE_TEXT_BRUSH = BBrush.makeSolid((BColor)BColor.make((int)255, (int)255, (int)255, (int)127));
    public static final BBrush MESSAGE_BACKGROUND_BRUSH = BBrush.makeSolid((BColor)BColor.make((int)3, (int)8, (int)150, (int)127));
    protected BVideoMultistreamPaneForView multistreamPaneForView;
    protected BTransferWidget hostTransferWidget;
    protected static final BIcon icon = BIcon.std((String)"video.png");
    protected BPlaybackParams playBackParams = new BPlaybackParams();
    protected long lastUpdateTicks = 0L;
    protected IVideoDecoder videoDecoder;
    protected String message;
    protected String cameraDescription;
    protected BImage mostRecentImage = DISCONNECTED_IMAGE;
    protected BAbsTime currentTimeIndex;
    public static final BImage DISCONNECTED_IMAGE = BImage.make((BIcon)BIcon.make((String)"module://videoDriver/images/VideoStreamDisconnected.png"));
    public static final String WIDEST_CONNECTING_MESSAGE = " " + VideoPlaybackSession.ESTABLISH_STREAM_MESSAGE + VideoPlaybackSession.DOTS[VideoPlaybackSession.DOTS.length - 1] + " ";
    public static final String TRIMMED_ESTABLISHING_CONNECTION_MESSAGE = VideoPlaybackSession.ESTABLISH_STREAM_MESSAGE.trim();

    @Generated
    public boolean getShowTimeIndex() {
        return this.getBoolean(showTimeIndex);
    }

    @Generated
    public void setShowTimeIndex(boolean v) {
        this.setBoolean(showTimeIndex, v, null);
    }

    @Generated
    public int getThrottleRefreshRate() {
        return this.getInt(throttleRefreshRate);
    }

    @Generated
    public void setThrottleRefreshRate(int v) {
        this.setInt(throttleRefreshRate, v, null);
    }

    @Generated
    public BFoxVideoStreamEnum getVideoStreamFox() {
        return (BFoxVideoStreamEnum)this.get(videoStreamFox);
    }

    @Generated
    public void setVideoStreamFox(BFoxVideoStreamEnum v) {
        this.set(videoStreamFox, (BValue)v, null);
    }

    @Generated
    public BColor getBackgroundColor() {
        return (BColor)this.get(backgroundColor);
    }

    @Generated
    public void setBackgroundColor(BColor v) {
        this.set(backgroundColor, (BValue)v, null);
    }

    @Generated
    public BVideoAspectRatioEnum getAspectRatio() {
        return (BVideoAspectRatioEnum)this.get(aspectRatio);
    }

    @Generated
    public void setAspectRatio(BVideoAspectRatioEnum v) {
        this.set(aspectRatio, (BValue)v, null);
    }

    @Generated
    public BVideoResolutionEnum getResolution() {
        return (BVideoResolutionEnum)this.get(resolution);
    }

    @Generated
    public void setResolution(BVideoResolutionEnum v) {
        this.set(resolution, (BValue)v, null);
    }

    @Generated
    public BVideoFrameRateEnum getFrameRate() {
        return (BVideoFrameRateEnum)this.get(frameRate);
    }

    @Generated
    public void setFrameRate(BVideoFrameRateEnum v) {
        this.set(frameRate, (BValue)v, null);
    }

    @Generated
    public BVideoCompressionEnum getCompression() {
        return (BVideoCompressionEnum)this.get(compression);
    }

    @Generated
    public void setCompression(BVideoCompressionEnum v) {
        this.set(compression, (BValue)v, null);
    }

    @Generated
    public BFacets getStreamFacets() {
        return (BFacets)this.get(streamFacets);
    }

    @Generated
    public void setStreamFacets(BFacets v) {
        this.set(streamFacets, (BValue)v, null);
    }

    @Generated
    public void changePlaybackControl(BPlaybackControlInfo parameter) {
        this.invoke(changePlaybackControl, (BValue)parameter, null);
    }

    @Generated
    public void fireReloadVideo(BPlaybackParams event) {
        this.fire(reloadVideo, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setVideoDecoder(IVideoDecoder videoDecoder) {
        this.videoDecoder = videoDecoder;
    }

    public IVideoDecoder getVideoDecoder() {
        return this.videoDecoder;
    }

    public void updateVideoFrame(VidFrame vf) {
        if (this.videoDecoder != null) {
            BImage newImage = vf.image;
            if (this.videoDecoder instanceof IVideoImagePainter || newImage != null && newImage != this.mostRecentImage) {
                long nowTicks;
                if (newImage != null && newImage != this.mostRecentImage) {
                    this.mostRecentImage = newImage;
                }
                if ((nowTicks = Clock.ticks()) - this.lastUpdateTicks >= (long)this.getThrottleRefreshRate()) {
                    this.repaint();
                    this.lastUpdateTicks = nowTicks;
                }
                this.currentTimeIndex = vf.timeIndex;
                this.getPlaybackParams().setTimeIndex(this.currentTimeIndex);
            }
        }
    }

    public BPlaybackParams getPlaybackParams() {
        this.playBackParams.setResolution(this.getResolution());
        this.playBackParams.setFrameRate(this.getFrameRate());
        this.playBackParams.setCompression(this.getCompression());
        this.playBackParams.setVideoFacets(BFacets.make((BFacets)this.playBackParams.getVideoFacets(), (BFacets)this.getStreamFacets()));
        return this.playBackParams;
    }

    public Topic getReloadVideoTopic() {
        return reloadVideo;
    }

    public void doChangePlaybackControl(BPlaybackControlInfo playbackInfo) {
        this.playBackParams.setPlaybackType(playbackInfo.getPlaybackType());
        this.playBackParams.setPlaybackSpeed(playbackInfo.getPlaybackSpeed());
        this.playBackParams.setTimeIndex(playbackInfo.getTimeIndex());
        this.fireReloadVideo((BPlaybackParams)this.playBackParams.newCopy());
    }

    public void animate() {
        if (this.videoDecoder != null) {
            this.videoDecoder.keepAlive();
        }
        super.animate();
    }

    public void paint(Graphics g) {
        this.paintDefault(g);
        if (this.videoDecoder != null) {
            BBinding[] cameraBindings;
            IVideoDecoder cameraDecoder = this.videoDecoder;
            try {
                cameraDecoder = cameraDecoder.getVideoDecoder();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (cameraDecoder instanceof IVideoImagePainter) {
                IVideoImagePainter videoPainter = (IVideoImagePainter)cameraDecoder;
                videoPainter.paintImage(g, (BWidget)this);
                return;
            }
            if (cameraDecoder instanceof VideoMultistreamDecoder && (cameraBindings = this.getBindings()) != null && cameraBindings.length > 0) {
                cameraDecoder = ((VideoMultistreamDecoder)this.videoDecoder).getVideoDecoder(cameraBindings[0].getOrd());
                try {
                    cameraDecoder = cameraDecoder.getVideoDecoder();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (cameraDecoder instanceof IVideoImagePainter) {
                    IVideoImagePainter videoPainter = (IVideoImagePainter)cameraDecoder;
                    videoPainter.paintImage(g, (BWidget)this);
                    return;
                }
            }
        }
    }

    public void paintDefault(Graphics g) {
        this.paintMostRecentImage(g);
        this.paintMessage(g);
        if (this.mostRecentImage != DISCONNECTED_IMAGE && this.getShowTimeIndex()) {
            this.paintMostRecentImageTime(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintMostRecentImageTime(Graphics g) {
        String timeIndex;
        if (this.videoDecoder != null && this.currentTimeIndex != null && !this.currentTimeIndex.isNull() && (timeIndex = this.currentTimeIndex.toLocalTime().toString((Context)BVideoEvent.EVENT_TIME_STAMP_TO_STRING_FACETS)) != null && timeIndex.length() > 0) {
            try {
                g.push();
                timeIndex = " " + timeIndex + " ";
                double w = this.getWidth();
                int fontSize = 32;
                BFont f = BFont.make((String)Theme.label().getTextFont().getName(), (double)fontSize, (int)1);
                double timeIndexStringPixelWidth = f.width(timeIndex);
                while (timeIndexStringPixelWidth > w - 20.0) {
                    f = BFont.make((String)Theme.label().getTextFont().getName(), (double)(fontSize -= 2), (int)1);
                    timeIndexStringPixelWidth = f.width(timeIndex);
                    if (fontSize > 8) continue;
                }
                g.transform(BTransform.makeTranslate((double)10.0, (double)(10.0 + f.getSize() / 4.0)));
                this.timeIndexLabel.setHalign(BHalign.left);
                this.timeIndexLabel.setValign(BValign.bottom);
                this.timeIndexLabel.setText(timeIndex);
                this.timeIndexLabel.setBackground(BBrush.NULL);
                this.timeIndexLabel.setForeground(TIME_INDEX_TEXT_BRUSH);
                this.timeIndexLabel.setFont(f);
                this.timeIndexLabel.computePreferredSize();
                this.timeIndexLabel.setBounds(2.0, 2.0, this.timeIndexLabel.getPreferredWidth(), this.timeIndexLabel.getPreferredHeight());
                this.timeIndexLabel.doLayout(null);
                g.setBrush(TIME_INDEX_BACKGROUND_BRUSH);
                g.setPen(BPen.make((double)4.0, (int)101, (int)202, null));
                g.strokeRect(0.0, 0.0, this.timeIndexLabel.getPreferredWidth() + 4.0, this.timeIndexLabel.getPreferredHeight() + 4.0);
                g.fillRect(2.0, 2.0, this.timeIndexLabel.getPreferredWidth(), this.timeIndexLabel.getPreferredHeight());
                this.timeIndexLabel.paint(g);
            }
            finally {
                g.pop();
            }
        }
    }

    public boolean receiveInputEvents() {
        return true;
    }

    public void paintMessage(Graphics g) {
        this.paintMessage(g, this.getMessage());
    }

    public void paintMessage(Graphics g, String message) {
        double w = this.getWidth();
        double h = this.getHeight();
        BVideoPlayer.paintMessage(g, message, 10, 40, w, h, MESSAGE_BACKGROUND_BRUSH, MESSAGE_TEXT_BRUSH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintMessage(Graphics g, String message, int fromLeft, int fromBottom, double playerWidth, double playerHeight, BBrush background, BBrush foreground) {
        if (message != null && message.length() > 0) {
            g.push();
            try {
                message = " " + message + " ";
                int fontSize = 20;
                BFont font = BFont.make((String)Theme.label().getTextFont().getName(), (double)fontSize);
                String messageToCheckWidthUpon = message;
                if (message.trim().startsWith(TRIMMED_ESTABLISHING_CONNECTION_MESSAGE)) {
                    messageToCheckWidthUpon = WIDEST_CONNECTING_MESSAGE;
                }
                double messagePixelWidth = font.width(messageToCheckWidthUpon);
                while (messagePixelWidth > playerWidth) {
                    font = BFont.make((String)Theme.label().getTextFont().getName(), (double)(fontSize -= 2));
                    messagePixelWidth = font.width(messageToCheckWidthUpon);
                    if (fontSize > 8) continue;
                }
                messageLabel.setHalign(BHalign.left);
                messageLabel.setValign(BValign.bottom);
                messageLabel.setText(message);
                messageLabel.setBackground(background);
                messageLabel.setForeground(foreground);
                messageLabel.setFont(font);
                messageLabel.computePreferredSize();
                messageLabel.setBounds(2.0, 2.0, messageLabel.getPreferredWidth(), messageLabel.getPreferredHeight());
                messageLabel.doLayout(null);
                if (fromLeft == Integer.MIN_VALUE) {
                    fromLeft = (int)(playerWidth / 2.0) - (int)(messageLabel.getPreferredWidth() / 2.0);
                }
                g.transform(BTransform.makeTranslate((double)fromLeft, (double)(playerHeight - (double)fromBottom)));
                messageLabelInsideBorder.paint(g);
                g.setBrush(background);
                g.setPen(BPen.make((double)4.0, (int)101, (int)202, null));
                g.strokeRect(0.0, 0.0, messageLabel.getPreferredWidth() + 4.0, messageLabel.getPreferredHeight() + 4.0);
            }
            finally {
                g.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintMostRecentImage(Graphics g) {
        try {
            g.push();
            g.setBrush(this.getBackgroundColor().toBrush());
            g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
            double newWidth = this.getWidth();
            double newHeight = this.getHeight();
            double currentAspectRatio = newWidth / newHeight;
            BImage cachedImage = this.mostRecentImage;
            double requiredAspectRatio = this.translateAspectRatioEnumToRatio(this.getAspectRatio(), cachedImage);
            if (currentAspectRatio < requiredAspectRatio) {
                newHeight = newWidth / requiredAspectRatio;
            } else {
                newWidth = newHeight * requiredAspectRatio;
            }
            double x = (this.getWidth() - newWidth) / 2.0;
            double y = (this.getHeight() - newHeight) / 2.0;
            g.translate(x, y);
            double scaleWidth = newWidth / cachedImage.getWidth();
            double scaleHeight = newHeight / cachedImage.getHeight();
            g.transform(BTransform.makeScale((double)scaleWidth, (double)scaleHeight));
            g.drawImage(cachedImage, 0.0, 0.0);
        }
        finally {
            g.pop();
        }
    }

    private double translateAspectRatioEnumToRatio(BVideoAspectRatioEnum aspectRatio, BImage cachedImage) {
        switch (aspectRatio.getOrdinal()) {
            case 0: {
                return cachedImage.getWidth() / cachedImage.getHeight();
            }
            case 1: {
                return this.getWidth() / this.getHeight();
            }
            case 2: {
                return 1.15;
            }
            case 3: {
                return 1.3333333333333333;
            }
            case 4: {
                return 1.43;
            }
            case 5: {
                return 1.5;
            }
            case 6: {
                return 1.618;
            }
            case 7: {
                return 1.6666666666666667;
            }
            case 8: {
                return 1.7777777777777777;
            }
            case 9: {
                return 1.85;
            }
            case 10: {
                return 2.39;
            }
        }
        return this.getWidth() / this.getHeight();
    }

    public void resetImage() {
        this.mostRecentImage = DISCONNECTED_IMAGE;
        this.repaint();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        if (this.isRunning()) {
            this.repaint();
        }
    }

    public void mouseEntered(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        if (shell != null && this.cameraDescription != null) {
            shell.showStatus(this.cameraDescription);
        }
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.mouseEntered(event);
        }
        super.mouseEntered(event);
    }

    public void mouseExited(BMouseEvent event) {
        BWidgetShell shell = this.getShell();
        if (shell != null && this.cameraDescription != null) {
            shell.showStatus("");
        }
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.mouseExited(event);
        }
        super.mouseExited(event);
    }

    public void mouseHover(BMouseEvent event) {
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.mouseHover(event);
        }
        super.mouseHover(event);
    }

    public void mouseReleased(BMouseEvent event) {
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.mouseReleased(event);
        }
        super.mouseReleased(event);
    }

    public String getCameraDescription() {
        return this.cameraDescription;
    }

    public void setCameraDescription(String cameraDescription) {
        this.cameraDescription = cameraDescription;
    }

    public void startDrag(BMouseEvent event, TransferContext context, DragRenderer dragRenderer) {
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.startDrag(event, context, dragRenderer);
        }
    }

    public void startDrag(BMouseEvent event, TransferEnvelope envelope, DragRenderer dragRenderer) {
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.startDrag(event, envelope, dragRenderer);
        }
    }

    public int dragOver(TransferContext cx) {
        if (this.hostTransferWidget != null) {
            return this.hostTransferWidget.dragOver(cx);
        }
        return 0;
    }

    public void dragEnter(TransferContext cx) {
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.dragEnter(cx);
        }
    }

    public void dragExit(TransferContext cx) {
        if (this.hostTransferWidget != null) {
            this.hostTransferWidget.dragExit(cx);
        }
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        if (this.hostTransferWidget != null) {
            return this.hostTransferWidget.drop(cx);
        }
        return null;
    }

    public void setHostTransferWidget(BTransferWidget hostTransferWidget) {
        this.hostTransferWidget = hostTransferWidget;
    }

    public TransferEnvelope getTransferData() throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void setMultistreamPaneForView(BVideoMultistreamPaneForView videoMultistreamPane) {
        this.multistreamPaneForView = videoMultistreamPane;
    }

    public BVideoMultistreamPaneForView getMultistreamPaneForView() {
        return this.multistreamPaneForView;
    }

    public BIcon getIcon() {
        return icon;
    }
}

